/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.browser.driver;

import com.mathworks.mwswing.MJFrame;
import com.mathworks.toolbox.instrument.browser.driver.IVIListSelector;
import com.mathworks.toolbox.instrument.browser.driver.IVITab;
import com.mathworks.toolbox.testmeas.util.TMStringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class IVIHardwareAssetTab
extends IVITab
implements KeyListener,
FocusListener {
    private static final long serialVersionUID = 1L;
    private static final int DESCRIPTION = 0;
    private static final int RESOURCE = 1;
    private IVIListSelector listSelector;
    private JTextField name;
    private JTextArea description;
    private JTextField resource;
    private Hashtable<String, String[]> assets;
    private String selectedItem = "";
    private String originalName = "";
    private boolean isDirty = false;

    public IVIHardwareAssetTab() {
        this.layoutPanel();
    }

    public void updateTable() {
        this.updateTable(this.selectedItem);
    }

    private void updateTable(String string) {
        if (string == null || string.equals("")) {
            return;
        }
        if (!this.assets.containsKey(string)) {
            this.addToTable(string);
            return;
        }
        String[] stringArray = this.assets.get(string);
        if (!stringArray[0].equals(this.description.getText())) {
            this.isDirty = true;
        } else if (!stringArray[1].equals(this.resource.getText())) {
            this.isDirty = true;
        }
        stringArray[0] = this.description.getText();
        stringArray[1] = this.resource.getText();
        this.assets.put(string, stringArray);
    }

    private void addToTable(String string) {
        String[] stringArray = new String[]{this.description.getText(), this.resource.getText()};
        this.assets.put(string, stringArray);
        this.isDirty = true;
    }

    private void removeFromTable(String string) {
        if (string == null || string.equals("")) {
            return;
        }
        this.assets.remove(string);
        this.isDirty = true;
    }

    public boolean isTabDirty() {
        return this.isDirty;
    }

    public void resetIsDirtyFlag() {
        this.isDirty = false;
    }

    private void layoutPanel() {
        this.name = new JTextField();
        this.description = new JTextArea();
        this.resource = new JTextField();
        this.setComponentsEnabled(false);
        JScrollPane jScrollPane = this.configureTextArea(this.description);
        this.description.setFont(this.name.getFont());
        this.name.addKeyListener(this);
        this.name.addFocusListener(this);
        JPanel jPanel = this.add(new JLabel("Name:"), this.name, 2);
        JPanel jPanel2 = this.add(new JLabel("Description:"), jScrollPane, 2);
        JPanel jPanel3 = this.add(new JLabel("IO resource name:"), this.resource, 2);
        JPanel jPanel4 = this.add(jPanel, jPanel2, 4);
        JPanel jPanel5 = this.add(jPanel4, jPanel3, 4);
        JPanel jPanel6 = new JPanel(new BorderLayout(0, 0));
        jPanel6.add((Component)jPanel5, "North");
        this.listSelector = new IVIListSelector(this);
        this.add((Component)this.listSelector, "West");
        this.add((Component)jPanel6, "Center");
    }

    @Override
    public void itemChangedEvent(String string) {
        this.updateTable();
        this.name.setText(string);
        if (this.assets == null || !this.assets.containsKey(string)) {
            this.description.setText("");
            this.resource.setText("");
        } else {
            String[] stringArray = this.assets.get(string);
            this.description.setText(stringArray[0]);
            this.resource.setText(stringArray[1]);
        }
        this.selectedItem = string;
        this.originalName = string;
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        this.listSelector.updateSelectedItemText(this.name.getText());
        this.removeFromTable(this.selectedItem);
        this.postNameChangedEvent("HardwareAsset", this.selectedItem, this.name.getText());
        this.selectedItem = this.name.getText();
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (this.listSelector.getItemCount() == 0) {
            return;
        }
        if (this.listSelector.containsDuplicate(this.name.getText())) {
            TMStringUtil.error((MJFrame)this.getParentFrame(), (String)"Invalid Name", (String)"Duplicate names are not allowed.");
            this.name.setText(this.originalName);
            this.listSelector.updateSelectedItemText(this.name.getText());
            this.postNameChangedEvent("HardwareAsset", this.selectedItem, this.name.getText());
            this.selectedItem = this.name.getText();
            return;
        }
        if (!this.name.getText().equals("")) {
            return;
        }
        TMStringUtil.error((MJFrame)this.getParentFrame(), (String)"Invalid Name", (String)"The Name field cannot be empty.");
        this.name.setText(this.originalName);
        this.keyReleased(null);
    }

    public void setComponentsEnabled(boolean bl) {
        this.name.setEnabled(bl);
        this.description.setEnabled(bl);
        this.resource.setEnabled(bl);
    }

    @Override
    public void addItem(String string) {
        if (this.listSelector.getItemCount() == 1) {
            this.setComponentsEnabled(true);
        }
    }

    @Override
    public void removeItem(String string) {
        this.removeFromTable(string);
        this.selectedItem = "";
        if (this.listSelector.getItemCount() == 1) {
            this.setComponentsEnabled(false);
        }
    }

    protected String[] getAllItems() {
        return this.listSelector.getAllItems();
    }

    public void removeAllElements() {
        this.listSelector.removeAllElements();
        this.setComponentsEnabled(false);
        this.listSelector.enableButtons(false);
    }

    public void updateForNewDriver(Object[] objectArray) {
        this.parse(objectArray);
        this.isDirty = false;
    }

    private void parse(Object[] objectArray) {
        this.assets = new Hashtable();
        this.listSelector.enableButtons(true);
        for (int i = 0; i < objectArray.length; ++i) {
            String[] stringArray = (String[])objectArray[i];
            String string = stringArray[0];
            String[] stringArray2 = new String[]{stringArray[1], stringArray[2]};
            this.assets.put(string, stringArray2);
            this.listSelector.addElement(string);
        }
        if (objectArray.length > 0) {
            this.listSelector.setSelectedIndex(0);
            this.setComponentsEnabled(true);
        }
    }

    public Hashtable<String, String[]> getInfo() {
        return this.assets;
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }
}

