/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.device.drivers.vxipnp;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.types.MLArrayRef;
import com.mathworks.toolbox.instrument.device.Device;
import com.mathworks.toolbox.instrument.device.drivers.ExternalDriver;
import com.mathworks.toolbox.instrument.device.drivers.xml.Parser;
import com.mathworks.toolbox.testmeas.util.TMException;
import java.io.File;

public class VXIPnPDriver
extends ExternalDriver {
    protected int sessionHandle = -1;
    protected String mddFileName;

    public VXIPnPDriver(Parser parser, String string) throws TMException {
        super(parser, string);
        File file = new File(parser.getLogicalName());
        this.mddFileName = file.getName();
    }

    @Override
    protected void validateDriverType() throws TMException {
        if (this.xmlParser.getDriverTypeId() != 1) {
            throw new TMException("The driver must be a MATLAB VXIplug&play instrument driver.");
        }
    }

    @Override
    public Object[] defineConstructorArgs() {
        Object[] objectArray = new Object[]{this.mddFileName, this.resourceName};
        return objectArray;
    }

    @Override
    public int getStatusBasedOnInterface() {
        if (this.sessionHandle == -1) {
            return 0;
        }
        return 1;
    }

    @Override
    public int defineDriverType() {
        return 1;
    }

    @Override
    public String defineConstructor() {
        return "icdevice('" + this.mddFileName + "', '" + this.resourceName + "');";
    }

    @Override
    public String defineConstructorDescription() {
        return "Driver - " + this.mddFileName + ", ResourceName - " + this.resourceName;
    }

    @Override
    public void dispose() throws TMException {
        this.itrArgs[1] = "function unloadLib\nunloadlibrary ('" + this.driverName + "');";
        this.itrArgs[4] = new Integer(0);
        try {
            Object[] objectArray = (Object[])Matlab.mtFeval((String)"instrgate", (Object[])this.itrArgs, (int)1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.dispose();
    }

    @Override
    public void open() throws TMException {
        MLArrayRef mLArrayRef;
        int n = -1;
        String string = this.getOptionString();
        this.itrArgs[1] = string.length() == 0 ? "function [status, session] = init\nrsrc = [double('" + this.resourceName + "') 0];\n" + "InstrumentHandle = libpointer('uint32Ptr' ,0);\n" + "[status, dummy, session] = calllib('" + this.driverName + "', '" + this.driverName + "_init', rsrc, false, false, InstrumentHandle);\n" + "if status < 0 \n" + "[status, dummy, session] = calllib('" + this.driverName + "', '" + this.driverName + "_init', rsrc, false, true, InstrumentHandle);\n" + "end\n" + "session = uint32(InstrumentHandle.Value);" : "function [status, session] = init\nrsrc = [double('" + this.resourceName + "') 0];\n" + "optionString = [double('" + string + "') 0];\n" + "InstrumentHandle = libpointer('uint32Ptr' ,0);\n" + "[status, dummy, session] = calllib('" + this.driverName + "', '" + this.driverName + "_InitWithOptions', rsrc, false, false, optionString, InstrumentHandle);\n" + "if status < 0 \n" + "[status, dummy, session] = calllib('" + this.driverName + "', '" + this.driverName + "_InitWithOptions', rsrc, false, true, optionString, InstrumentHandle);\n" + "end\n" + "session = uint32(InstrumentHandle.Value);";
        this.itrArgs[4] = new Integer(2);
        try {
            mLArrayRef = (MLArrayRef)Matlab.mtFeval((String)"instrgate", (Object[])this.itrArgs, (int)1);
            n = (int)((double[])mLArrayRef[0])[0];
            this.sessionHandle = ((int[])mLArrayRef[1])[0];
        }
        catch (Exception exception) {
            this.sessionHandle = -1;
        }
        if (n != 0) {
            this.sessionHandle = -1;
            mLArrayRef = this.deviceObject.getInterface();
            if (mLArrayRef != Device.USERDATA) {
                mLArrayRef.dispose();
            }
            this.deviceObject.setJInterface(Device.USERDATA);
            throw new TMException("The VXIplug&play driver could not connect to the instrument using the specified resource.");
        }
        if (this.deviceObject.getInterface() != Device.USERDATA) {
            this.deviceObject.getInterface().dispose();
        }
        this.deviceObject.setJInterface(this.initRefWithObject(new Integer(this.sessionHandle)));
    }

    @Override
    public void close() throws TMException {
        this.itrArgs[1] = "function status = close\nsession = get(obj, 'Interface');\nstatus = calllib('" + this.driverName + "', '" + this.driverName + "_close', session);\n";
        this.itrArgs[4] = new Integer(1);
        try {
            Matlab.mtFeval((String)"instrgate", (Object[])this.itrArgs, (int)1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.deviceObject.setJInterface(Device.USERDATA);
        this.sessionHandle = -1;
    }

    @Override
    public String getError() throws TMException {
        String string = "";
        this.itrArgs[1] = "function message = geterror(obj)\nsession = get(obj, 'Interface');\nmessage = libpointer('int8Ptr', repmat(10, 1, 128));\n[status, code] = calllib('" + this.driverName + "', '" + this.driverName + "_error_query', session, 0, message);\n" + "message = strtrim(char(message.Value));\n";
        this.itrArgs[4] = new Integer(1);
        try {
            Object[] objectArray = (Object[])Matlab.mtFeval((String)"instrgate", (Object[])this.itrArgs, (int)1);
            string = (String)objectArray[0];
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    @Override
    public void hwreset() throws TMException {
        this.itrArgs[1] = "function devicereset(obj)\nsession = get(obj, 'Interface');\nstatus = calllib('" + this.driverName + "', '" + this.driverName + "_reset', session);\n";
        this.itrArgs[2] = this.deviceMLObject;
        this.itrArgs[3] = null;
        this.itrArgs[4] = new Integer(0);
        try {
            Matlab.mtFeval((String)"instrgate", (Object[])this.itrArgs, (int)1);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public String selftest() throws TMException {
        String string = "";
        this.itrArgs[1] = "function message = getError(obj)\nsession = get(obj, 'Interface');\nmessage = libpointer('int8Ptr', repmat(10, 1, 128));\nstatus = calllib('" + this.driverName + "', '" + this.driverName + "_self_test', session, 0, message);\n" + "message = strtrim(char(message.Value));\n";
        this.itrArgs[4] = new Integer(1);
        try {
            Object[] objectArray = (Object[])Matlab.mtFeval((String)"instrgate", (Object[])this.itrArgs, (int)1);
            string = (String)objectArray[0];
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    @Override
    public String getInstrumentModel() {
        Object[] objectArray;
        String string = "";
        String string2 = "";
        this.itrArgs[1] = "function AttributeValue = getStringAttribute(obj)\nsession = get(obj, 'Interface');\nAttributeValue = libpointer('int8Ptr', repmat(10, 1, 128));\nRepCapIdentifier = libpointer('int8Ptr',int8('_ATTR_INSTRUMENT_MANUFACTURER'));\nstatus = calllib('" + this.driverName + "', '" + this.driverName + "_GetAttributeViString', session, RepCapIdentifier, 1050511 , 128, AttributeValue);\n" + "AttributeValue = strtrim(char(AttributeValue.Value));\n";
        this.itrArgs[4] = new Integer(1);
        try {
            objectArray = (Object[])Matlab.mtFeval((String)"instrgate", (Object[])this.itrArgs, (int)1);
            string = (String)objectArray[0];
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.itrArgs[1] = "function AttributeValue = getError(obj)\nsession = get(obj, 'Interface');\nAttributeValue = libpointer('int8Ptr', repmat(10, 1, 128));\nRepCapIdentifier = libpointer('int8Ptr',int8('_ATTR_INSTRUMENT_MODEL'));\nstatus = calllib('" + this.driverName + "', '" + this.driverName + "_GetAttributeViString', session, RepCapIdentifier, 1050512 , 128, AttributeValue);\n" + "AttributeValue = strtrim(char(AttributeValue.Value));\n";
        this.itrArgs[4] = new Integer(1);
        try {
            objectArray = (Object[])Matlab.mtFeval((String)"instrgate", (Object[])this.itrArgs, (int)1);
            string2 = (String)objectArray[0];
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string + " " + string2;
    }

    @Override
    public void setDriverName(String string) {
        this.driverName = string;
    }
}

