/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.device.guiutil.midtest;

import com.mathworks.mwswing.MJFrame;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class MIDGlassPane
extends JPanel
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 1L;
    private static final Cursor WAITCURSOR = new Cursor(3);
    private MJFrame parent;
    private Component[] clickableComponents;
    private Cursor oldCursor;

    public MIDGlassPane(MJFrame mJFrame, Component[] componentArray) {
        this.parent = mJFrame;
        this.clickableComponents = componentArray;
        this.setOpaque(false);
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.oldCursor = this.parent.getCursor();
            this.parent.setCursor(WAITCURSOR);
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        } else {
            this.removeMouseListener(this);
            this.removeMouseMotionListener(this);
            this.parent.setCursor(this.oldCursor);
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.handleMouseEvent(mouseEvent);
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.handleMouseEvent(mouseEvent);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.handleMouseEvent(mouseEvent);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.handleMouseEvent(mouseEvent);
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.handleMouseEvent(mouseEvent);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.handleMouseEvent(mouseEvent);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.handleMouseEvent(mouseEvent);
    }

    private void handleMouseEvent(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        int n = mouseEvent.getID();
        Point point2 = SwingUtilities.convertPoint(this, point, this.parent.getContentPane());
        Component component = SwingUtilities.getDeepestComponentAt(this.parent.getContentPane(), point2.x, point2.y);
        if (component == null) {
            return;
        }
        for (int i = 0; i < this.clickableComponents.length; ++i) {
            if (!component.equals(this.clickableComponents[i])) continue;
            Point point3 = SwingUtilities.convertPoint(this, point, component);
            component.dispatchEvent(new MouseEvent(component, n, mouseEvent.getWhen(), mouseEvent.getModifiers(), point3.x, point3.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger()));
        }
    }
}

