/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.device.guiutil.midtest.panel;

import com.mathworks.toolbox.instrument.device.guiutil.midtest.MIDTestToolClient;
import com.mathworks.toolbox.instrument.device.guiutil.midtest.MIDTestToolFileWriter;
import com.mathworks.toolbox.instrument.device.guiutil.midtest.panel.FunctionPanel;
import com.mathworks.toolbox.instrument.device.guiutil.midtest.panel.FunctionSweepPanel;
import com.mathworks.toolbox.instrument.device.guiutil.midtest.panel.MIDStepPanel;
import com.mathworks.toolbox.instrument.device.guiutil.midtest.panel.PropertyGetPanel;
import com.mathworks.toolbox.instrument.device.guiutil.midtest.panel.PropertySetPanel;
import com.mathworks.toolbox.instrument.device.guiutil.midtest.panel.PropertySweepPanel;
import com.mathworks.toolbox.instrument.device.guiutil.midtest.panel.StepInfo;
import com.mathworks.toolbox.testmeas.browser.BrowserTreeNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class StepPanel
extends JPanel
implements ActionListener,
FocusListener {
    private static final long serialVersionUID = 1L;
    public static final String ACTION = "ACTION";
    private static final int NAME = 0;
    private MIDTestToolClient client;
    private BrowserTreeNode browserTreeNode;
    private JTextField nameField;
    private int lowerPanelType = -1;
    private FunctionPanel functionPanel = null;
    private PropertySetPanel propertySetPanel = null;
    private PropertyGetPanel propertyGetPanel = null;
    private PropertySweepPanel propertySweepPanel = null;
    private FunctionSweepPanel functionSweepPanel = null;

    public StepPanel(MIDTestToolClient mIDTestToolClient) {
        this.client = mIDTestToolClient;
        this.layoutPanel();
    }

    public void cleanup() {
    }

    public void update(BrowserTreeNode browserTreeNode) {
        this.browserTreeNode = browserTreeNode;
        int n = this.browserTreeNode.getType();
        if (this.lowerPanelType == -1) {
            this.add((Component)this.getPanel(n), "Center");
            this.lowerPanelType = n;
            this.repaint();
        } else if (this.lowerPanelType != n) {
            this.remove(this.getPanel(this.lowerPanelType));
            this.add((Component)this.getPanel(n), "Center");
            this.lowerPanelType = n;
            this.repaint();
        }
        StepInfo stepInfo = (StepInfo)this.browserTreeNode.getUserData();
        this.nameField.setText(stepInfo.getName());
        ((MIDStepPanel)this.getPanel(n)).update(stepInfo);
    }

    public void updateAfterDriverReload() {
        if (this.propertySetPanel != null) {
            this.propertySetPanel.updatePanelAfterDriverReload();
        }
        if (this.propertyGetPanel != null) {
            this.propertyGetPanel.updatePanelAfterDriverReload();
        }
        if (this.functionPanel != null) {
            this.functionPanel.updatePanelAfterDriverReload();
        }
        if (this.propertySweepPanel != null) {
            this.propertySweepPanel.updatePanelAfterDriverReload();
        }
        if (this.functionSweepPanel != null) {
            this.functionSweepPanel.updatePanelAfterDriverReload();
        }
    }

    public void updateAfterDriverReload(BrowserTreeNode browserTreeNode) {
        ((MIDStepPanel)this.getPanel(browserTreeNode.getType())).update((StepInfo)browserTreeNode.getUserData());
    }

    public void duplicateNode(BrowserTreeNode browserTreeNode, BrowserTreeNode browserTreeNode2) {
        this.cleanupLowerPanel(browserTreeNode2);
        ((MIDStepPanel)this.getPanel(browserTreeNode2.getType())).duplicate((StepInfo)browserTreeNode.getUserData(), (StepInfo)browserTreeNode2.getUserData());
    }

    public void cleanup(BrowserTreeNode browserTreeNode) {
        ((StepInfo)browserTreeNode.getUserData()).setName(this.nameField.getText());
        this.cleanupLowerPanel(browserTreeNode);
    }

    public void cleanupLowerPanel(BrowserTreeNode browserTreeNode) {
        ((MIDStepPanel)this.getPanel(browserTreeNode.getType())).cleanup((StepInfo)browserTreeNode.getUserData());
    }

    private JPanel getPanel(int n) {
        switch (n) {
            case 0: {
                return this.layoutPropertySweepPanel();
            }
            case 1: {
                return this.layoutPropertySetPanel();
            }
            case 2: {
                return this.layoutPropertyGetPanel();
            }
            case 3: {
                return this.layoutFunctionPanel();
            }
            case 4: {
                return this.layoutFunctionSweepPanel();
            }
        }
        return null;
    }

    private void layoutPanel() {
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        JLabel jLabel = new JLabel("Name:");
        this.nameField = new JTextField();
        this.nameField.setName("Name Text Field");
        this.nameField.putClientProperty(ACTION, new Integer(0));
        this.nameField.addActionListener(this);
        this.nameField.addFocusListener(this);
        JPanel jPanel = new JPanel(new BorderLayout(0, 4));
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        jPanel.add((Component)jLabel, "North");
        jPanel.add((Component)this.nameField, "Center");
        this.add((Component)jPanel, "North");
    }

    private JPanel layoutPropertySweepPanel() {
        if (this.propertySweepPanel == null) {
            this.propertySweepPanel = new PropertySweepPanel(this.client);
        }
        return this.propertySweepPanel;
    }

    private JPanel layoutFunctionSweepPanel() {
        if (this.functionSweepPanel == null) {
            this.functionSweepPanel = new FunctionSweepPanel(this.client);
        }
        return this.functionSweepPanel;
    }

    private JPanel layoutPropertySetPanel() {
        if (this.propertySetPanel == null) {
            this.propertySetPanel = new PropertySetPanel(this.client);
        }
        return this.propertySetPanel;
    }

    private JPanel layoutPropertyGetPanel() {
        if (this.propertyGetPanel == null) {
            this.propertyGetPanel = new PropertyGetPanel(this.client);
        }
        return this.propertyGetPanel;
    }

    private JPanel layoutFunctionPanel() {
        if (this.functionPanel == null) {
            this.functionPanel = new FunctionPanel(this.client);
        }
        return this.functionPanel;
    }

    public void save(MIDTestToolFileWriter mIDTestToolFileWriter, Element element, BrowserTreeNode browserTreeNode) {
        StepInfo stepInfo = (StepInfo)browserTreeNode.getUserData();
        ((MIDStepPanel)this.getPanel(browserTreeNode.getType())).save(mIDTestToolFileWriter, element, stepInfo);
    }

    public void load(Node node, BrowserTreeNode browserTreeNode) {
        StepInfo stepInfo = (StepInfo)browserTreeNode.getUserData();
        String string = stepInfo.getName();
        ((MIDStepPanel)this.getPanel(browserTreeNode.getType())).load(node, stepInfo);
        if (!string.equals(stepInfo.getName())) {
            this.client.updateNodeName(browserTreeNode, stepInfo.getName());
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JComponent jComponent = (JComponent)actionEvent.getSource();
        int n = (Integer)jComponent.getClientProperty(ACTION);
        switch (n) {
            case 0: {
                this.updateClientNodeName();
                this.updateStepInfoName();
            }
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        JComponent jComponent = (JComponent)focusEvent.getSource();
        int n = (Integer)jComponent.getClientProperty(ACTION);
        switch (n) {
            case 0: {
                this.updateClientNodeName();
                this.updateStepInfoName();
            }
        }
    }

    private void updateClientNodeName() {
        if (!this.browserTreeNode.getName().equals(this.nameField.getText())) {
            this.client.updateNodeName(this.browserTreeNode, this.nameField.getText());
        }
    }

    public void updateNameField(String string) {
        this.nameField.setText(string);
        this.updateStepInfoName();
    }

    private void updateStepInfoName() {
        ((StepInfo)this.browserTreeNode.getUserData()).setName(this.nameField.getText());
    }

    public String generateCode(BrowserTreeNode browserTreeNode, boolean bl, boolean bl2, int n) {
        StepInfo stepInfo = (StepInfo)browserTreeNode.getUserData();
        return ((MIDStepPanel)this.getPanel(browserTreeNode.getType())).generateCode(stepInfo, bl, bl2, n);
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }
}

