/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.device.guiutil.midtool;

import com.mathworks.toolbox.instrument.device.drivers.xml.property.PropertyConstraint;
import com.mathworks.toolbox.instrument.device.drivers.xml.property.PropertyDefinition;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.DriverDataType;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.DriverGroup;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.event.DriverModelEvent;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.event.DriverModelListener;
import com.mathworks.toolbox.instrument.device.icdevice.ICDevice;
import com.mathworks.toolbox.instrument.device.icdevice.ICDeviceChild;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Vector;

public class DriverProperty
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final int BOOLEAN = 2;
    public static final int DOUBLE = 0;
    public static final int STRING = 1;
    public static final int OBJECT = 3;
    public static final int NONE = 2;
    public static final int BOUNDED = 0;
    public static final int ENUM = 1;
    public static final int sCommandType = 0;
    public static final int sMCodeType = 1;
    private static final String kDefaultFunctionName = "UnknownProperty";
    private static final String sDefaultGetCode = "function propertyValue = getProperty(obj, propertyName)\n% Return a property value.\n%   This function is called to return the device or group object property\n%   value. If the property is a group property, OBJ is the group object. If\n%   the property is a base device property, OBJ is the device object.\n";
    private static final String sDefaultSetCode = "function set(obj, propertyName, propertyValue)\n% Set a property value.\n%   This function is called to set the device or group object property\n%   value. If the property is a group property, OBJ is the group object. If\n%   the property is a base device property, OBJ is the device object.\n";
    protected String fName = "UnknownProperty";
    protected DriverGroup fGroup;
    protected int fType = 0;
    protected String queryCommand = "";
    protected String configureCommand = "";
    protected String readOnly = "never";
    protected String setCode = "function set(obj, propertyName, propertyValue)\n% Set a property value.\n%   This function is called to set the device or group object property\n%   value. If the property is a group property, OBJ is the group object. If\n%   the property is a base device property, OBJ is the device object.\n";
    protected String getCode = "function propertyValue = getProperty(obj, propertyName)\n% Return a property value.\n%   This function is called to return the device or group object property\n%   value. If the property is a group property, OBJ is the group object. If\n%   the property is a base device property, OBJ is the device object.\n";
    protected String description = "";
    protected String defaultValue = "";
    protected Vector<DriverDataType> fPropertyTypes = new Vector();
    private Vector<DriverModelListener> fChangeListeners = new Vector();

    public DriverProperty() {
    }

    public DriverProperty(String string, String string2) {
        this(string, new DriverGroup(string2));
    }

    public DriverProperty(String string, DriverGroup driverGroup) {
        this.fName = string;
        this.setGroup(driverGroup);
        this.setDefaultValue("");
        this.setReadOnly("never");
        this.setGetCodeToEvaluate(sDefaultGetCode);
        this.setSetCodeToEvaluate(sDefaultSetCode);
        this.setDescription("");
        this.fPropertyTypes = new Vector();
    }

    public static DriverProperty createFromPropertyDefinition(PropertyDefinition propertyDefinition) {
        return DriverProperty.createFromPropertyDefinition(propertyDefinition, null);
    }

    public static DriverProperty createFromPropertyDefinition(PropertyDefinition propertyDefinition, DriverGroup driverGroup) {
        PropertyConstraint[] propertyConstraintArray;
        DriverGroup driverGroup2 = driverGroup;
        if (driverGroup2 == null) {
            driverGroup2 = new DriverGroup(propertyDefinition.getLocation());
        }
        DriverProperty driverProperty = propertyDefinition.getName() == null ? new DriverProperty(kDefaultFunctionName, driverGroup2) : new DriverProperty(propertyDefinition.getName(), driverGroup2);
        if (propertyDefinition.getTypeOfProperty() == null || propertyDefinition.getTypeOfProperty().equalsIgnoreCase("InstrumentCommand")) {
            driverProperty.setCodeType(0);
        } else {
            driverProperty.setCodeType(1);
        }
        if (propertyDefinition.getQueryCommand() != null) {
            driverProperty.setQueryCommand(propertyDefinition.getQueryCommand());
        }
        if (propertyDefinition.getConfigureCommand() != null) {
            driverProperty.setConfigureCommand(propertyDefinition.getConfigureCommand());
        }
        if (propertyDefinition.getReadOnly() != null) {
            driverProperty.setReadOnly(propertyDefinition.getReadOnly());
        }
        if (propertyDefinition.getSetMCodeToEvaluate() != null) {
            driverProperty.setSetCodeToEvaluate(propertyDefinition.getSetMCodeToEvaluate());
        }
        if (propertyDefinition.getGetMCodeToEvaluate() != null) {
            driverProperty.setGetCodeToEvaluate(propertyDefinition.getGetMCodeToEvaluate());
        }
        if (propertyDefinition.getDescription() != null) {
            driverProperty.setDescription(propertyDefinition.getDescription());
        }
        if (propertyDefinition.getDefaultValue() != null) {
            driverProperty.setDefaultValue((String)propertyDefinition.getDefaultValue());
        }
        if ((propertyConstraintArray = propertyDefinition.getRawPropertyConstraint()) != null) {
            for (int i = 0; i < propertyConstraintArray.length; ++i) {
                DriverDataType driverDataType = new DriverDataType(propertyConstraintArray[i]);
                driverDataType.setParentProperty(driverProperty);
                driverProperty.addPropertyType(driverDataType);
            }
        }
        return driverProperty;
    }

    public static DriverProperty createFromIviInfo(String string, DriverGroup driverGroup, String string2, String string3, boolean bl, boolean bl2, String[] stringArray, String[] stringArray2) {
        DriverProperty driverProperty = null;
        String string4 = string;
        String[] stringArray3 = driverGroup.isParentGroup() ? ICDevice.BASE_PROPS : ICDeviceChild.BASE_PROPS;
        for (int i = 0; i < stringArray3.length; ++i) {
            if (!stringArray3[i].equalsIgnoreCase(string4)) continue;
            string4 = driverGroup.getName() + string4;
            break;
        }
        if ((driverProperty = new DriverProperty(string4, driverGroup)).addDataTypeForIvi(string3, stringArray2)) {
            driverProperty.setDescription(string2);
            driverProperty.writeCodeForIvi(string, stringArray, bl2, bl);
        }
        return driverProperty;
    }

    public String toString() {
        return this.getName();
    }

    public Object clone() {
        DriverProperty driverProperty = new DriverProperty(this.getName(), this.getGroup());
        driverProperty.setConfigureCommand(new String(this.getConfigureCommand()));
        driverProperty.setQueryCommand(new String(this.getQueryCommand()));
        driverProperty.setDescription(new String(this.getDescription()));
        driverProperty.setReadOnly(new String(this.getReadOnly()));
        driverProperty.setDefaultValue(new String((String)this.getDefaultValue()));
        driverProperty.setCodeType(this.getCodeType());
        driverProperty.setGetCodeToEvaluate(this.getGetCodeToEvaluate());
        driverProperty.setSetCodeToEvaluate(this.getSetCodeToEvaluate());
        Vector<DriverDataType> vector = this.getPropertyTypes();
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                DriverDataType driverDataType = (DriverDataType)vector.get(i).clone();
                driverProperty.addPropertyType(driverDataType);
            }
        }
        return driverProperty;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeUTF(this.fName);
        objectOutputStream.writeInt(this.fType);
        objectOutputStream.writeUTF(this.queryCommand);
        objectOutputStream.writeUTF(this.configureCommand);
        objectOutputStream.writeUTF(this.readOnly);
        objectOutputStream.writeUTF(this.setCode);
        objectOutputStream.writeUTF(this.getCode);
        objectOutputStream.writeUTF(this.description);
        objectOutputStream.writeUTF(this.defaultValue);
        objectOutputStream.writeObject(this.fPropertyTypes);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.fName = objectInputStream.readUTF();
        this.fType = objectInputStream.readInt();
        this.queryCommand = objectInputStream.readUTF();
        this.configureCommand = objectInputStream.readUTF();
        this.readOnly = objectInputStream.readUTF();
        this.setCode = objectInputStream.readUTF();
        this.getCode = objectInputStream.readUTF();
        this.description = objectInputStream.readUTF();
        this.defaultValue = objectInputStream.readUTF();
        this.fPropertyTypes = (Vector)objectInputStream.readObject();
    }

    public int getCodeType() {
        return this.fType;
    }

    public void setCodeType(int n) {
        if (n != this.fType) {
            this.fType = n;
            this.firePropertyChangedEvent();
        }
    }

    public boolean isEnumeratedProperty() {
        for (int i = 0; i < this.fPropertyTypes.size(); ++i) {
            DriverDataType driverDataType = this.fPropertyTypes.get(i);
            if (driverDataType.getConstraintType() != 1) continue;
            return true;
        }
        return false;
    }

    public boolean isBoundedProperty() {
        for (int i = 0; i < this.fPropertyTypes.size(); ++i) {
            DriverDataType driverDataType = this.fPropertyTypes.get(i);
            if (driverDataType.getConstraintType() != 0) continue;
            return true;
        }
        return false;
    }

    public boolean isObjectProperty() {
        for (int i = 0; i < this.fPropertyTypes.size(); ++i) {
            DriverDataType driverDataType = this.fPropertyTypes.get(i);
            if (driverDataType.getConstraintType() != 3) continue;
            return true;
        }
        return false;
    }

    public String getConstraintName() {
        boolean bl = this.isEnumeratedProperty();
        boolean bl2 = this.isBoundedProperty();
        if (bl) {
            if (bl2) {
                return "bounded&enum";
            }
            return "enum";
        }
        if (bl2) {
            return "bounded";
        }
        return "none";
    }

    public String getBounds() {
        for (int i = 0; i < this.fPropertyTypes.size(); ++i) {
            DriverDataType driverDataType = this.fPropertyTypes.get(i);
            if (driverDataType.getConstraintType() != 0) continue;
            return "[" + driverDataType.getRangeMin() + " " + driverDataType.getRangeMax() + "]";
        }
        return "";
    }

    public Object[] getEnums() {
        Vector<Object> vector = new Vector<Object>();
        for (int i = 0; i < this.fPropertyTypes.size(); ++i) {
            int n;
            DriverDataType driverDataType = this.fPropertyTypes.get(i);
            if (driverDataType.getConstraintType() != 1) continue;
            if (driverDataType.getDataType() == 1) {
                for (n = 0; n < driverDataType.getStringEnumKeyCount(); ++n) {
                    vector.add(driverDataType.getStringEnumKey(n));
                }
                continue;
            }
            if (driverDataType.getDataType() != 0) continue;
            for (n = 0; n < driverDataType.getDoubleEnumCount(); ++n) {
                vector.add(driverDataType.getDoubleEnum(n));
            }
        }
        return vector.toArray();
    }

    public Vector<String> getEnumNames() {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < this.fPropertyTypes.size(); ++i) {
            int n;
            DriverDataType driverDataType = this.fPropertyTypes.get(i);
            if (driverDataType.getConstraintType() != 1) continue;
            if (driverDataType.getDataType() == 1) {
                for (n = 0; n < driverDataType.getStringEnumKeyCount(); ++n) {
                    vector.add(driverDataType.getStringEnumKey(n));
                }
                continue;
            }
            if (driverDataType.getDataType() != 0) continue;
            for (n = 0; n < driverDataType.getDoubleEnumCount(); ++n) {
                vector.add(driverDataType.getDoubleEnum(n).toString());
            }
        }
        return vector;
    }

    public Vector<String> getEnumValues() {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < this.fPropertyTypes.size(); ++i) {
            int n;
            DriverDataType driverDataType = this.fPropertyTypes.get(i);
            if (driverDataType.getConstraintType() != 1) continue;
            if (driverDataType.getDataType() == 1) {
                for (n = 0; n < driverDataType.getStringEnumValCount(); ++n) {
                    vector.add(driverDataType.getStringEnumVal(n));
                }
                continue;
            }
            if (driverDataType.getDataType() != 0) continue;
            for (n = 0; n < driverDataType.getDoubleEnumCount(); ++n) {
                vector.add(driverDataType.getDoubleEnum(n).toString());
            }
        }
        return vector;
    }

    public boolean isValidDefaultValue(String string) {
        boolean bl = false;
        boolean bl2 = false;
        double d = 0.0;
        if (string.length() == 0) {
            return true;
        }
        try {
            d = Double.parseDouble(string);
            bl = true;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (string.equalsIgnoreCase("on") || string.equalsIgnoreCase("1") || string.equalsIgnoreCase("off") || string.equalsIgnoreCase("0")) {
            bl2 = true;
        }
        for (int i = 0; i < this.fPropertyTypes.size(); ++i) {
            int n;
            DriverDataType driverDataType = this.fPropertyTypes.get(i);
            if (driverDataType.getDataType() == 1) {
                if (driverDataType.getConstraintType() == 2) {
                    return true;
                }
                if (driverDataType.getConstraintType() != 1) continue;
                for (n = 0; n < driverDataType.getStringEnumValCount(); ++n) {
                    if (!string.equalsIgnoreCase(driverDataType.getStringEnumVal(n))) continue;
                    return true;
                }
                continue;
            }
            if (driverDataType.getDataType() == 0 && bl) {
                if (driverDataType.getConstraintType() == 2) {
                    return true;
                }
                if (driverDataType.getConstraintType() == 1) {
                    for (n = 0; n < driverDataType.getDoubleEnumCount(); ++n) {
                        if (d != driverDataType.getDoubleEnum(n)) continue;
                        return true;
                    }
                    continue;
                }
                if (driverDataType.getConstraintType() != 0 || !(d >= driverDataType.getRangeMin()) || !(d <= driverDataType.getRangeMax())) continue;
                return true;
            }
            if (!bl2) continue;
            return true;
        }
        return false;
    }

    public Vector<DriverDataType> getPropertyTypes() {
        return this.fPropertyTypes;
    }

    public DriverDataType getDataType(int n) {
        return this.fPropertyTypes.get(n);
    }

    public void addPropertyType(DriverDataType driverDataType) {
        if (!this.fPropertyTypes.contains(driverDataType)) {
            driverDataType.setParentProperty(this);
            driverDataType.addDriverModelListener(this.fGroup);
            this.fPropertyTypes.add(driverDataType);
            this.firePropertyChangedEvent();
        }
    }

    public void removePropertyType(int n) {
        DriverDataType driverDataType = this.fPropertyTypes.get(n);
        driverDataType.removeDriverModelListener(this.fGroup);
        this.fPropertyTypes.removeElementAt(n);
        this.firePropertyChangedEvent();
    }

    public String getName() {
        return this.fName;
    }

    public void setName(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        String string2 = this.getName();
        this.fName = string;
        this.firePropertyNameChangedEvent(string2);
    }

    public void setConfigureCommand(String string) {
        if (!string.equals(this.configureCommand)) {
            this.configureCommand = string;
            this.firePropertyChangedEvent();
        }
    }

    public String getConfigureCommand() {
        return this.configureCommand;
    }

    public void setQueryCommand(String string) {
        if (!string.equals(this.queryCommand)) {
            this.queryCommand = string;
            this.firePropertyChangedEvent();
        }
    }

    public String getQueryCommand() {
        return this.queryCommand;
    }

    public void setDefaultValue(String string) {
        if (!string.equals(this.defaultValue)) {
            this.defaultValue = string;
            this.firePropertyChangedEvent();
        }
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDescription(String string) {
        if (!string.equals(this.description)) {
            this.description = string;
            this.firePropertyChangedEvent();
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setGroup(DriverGroup driverGroup) {
        this.fGroup = driverGroup;
    }

    public DriverGroup getGroup() {
        return this.fGroup;
    }

    public void setGetCodeToEvaluate(String string) {
        if (!string.equals(this.getCode)) {
            this.getCode = string;
            this.firePropertyChangedEvent();
        }
    }

    public String getGetCodeToEvaluate() {
        return this.getCode;
    }

    public void appendGetCodeToEvaluate(String string) {
        this.getCode = this.getCode + string;
        this.firePropertyChangedEvent();
    }

    public void setSetCodeToEvaluate(String string) {
        if (!string.equals(this.setCode)) {
            this.setCode = string;
            this.firePropertyChangedEvent();
        }
    }

    public String getSetCodeToEvaluate() {
        return this.setCode;
    }

    public void appendSetCodeToEvaluate(String string) {
        this.setCode = this.setCode + string;
        this.firePropertyChangedEvent();
    }

    public void writeCodeForIvi(String string, String[] stringArray, boolean bl, boolean bl2) {
        String string2;
        this.setCodeType(1);
        if (this.getGroup().isParentGroup()) {
            string2 = "try\n\tcomobj = obj.Interface;\n";
        } else {
            string2 = "try\n\tcomobj = obj.Parent;\n";
            string2 = string2 + "\tcomobj = comobj.Interface;\n";
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("_collection_")) {
                    string2 = string2 + "\tname = comobj.Name(obj.HwIndex);\n";
                    string2 = string2 + "\tcomobj = comobj.Item(name);\n";
                    continue;
                }
                string2 = string2 + "\tcomobj = comobj." + stringArray[i] + ";\n";
            }
        }
        String string3 = string2 + "\tpropertyValue = comobj." + string + ";\ncatch\n\terror('An error occurred while accessing the property');\nend\n";
        this.appendGetCodeToEvaluate(string3);
        String string4 = "";
        if (!bl2) {
            if (this.fPropertyTypes.get(0).getDataType() == 2) {
                string4 = string4 + "if ischar(propertyValue) && strcmpi(propertyValue,'on')\n";
                string4 = string4 + "\tpropertyValue = 1;\nend\n";
                string4 = string4 + "if strcmpi(propertyValue,'off')\n";
                string4 = string4 + "\tpropertyValue = 0;\nend\n\n";
            }
            string4 = string4 + string2 + "\tcomobj." + string + " = propertyValue;\ncatch aException\n\trethrow(aException);\nend";
        } else {
            string4 = "%\tNOTE: This property is defined as read only.";
            this.setReadOnly("always");
        }
        this.appendSetCodeToEvaluate(string4);
    }

    public boolean addDataTypeForIvi(String string, String[] stringArray) {
        DriverDataType driverDataType;
        if (string.equals("bool")) {
            driverDataType = new DriverDataType(2, 2);
        } else if (string.equals("double") || string.equals("single") || string.equals("int8") || string.equals("int16") || string.equals("int32") || string.equals("int64") || string.equals("uint8") || string.equals("uint16") || string.equals("uint32") || string.equals("uint64")) {
            driverDataType = new DriverDataType(0, 2);
        } else if (string.equals("string")) {
            driverDataType = new DriverDataType(1, 2);
        } else if (string.equals("enum")) {
            driverDataType = new DriverDataType(1, 1);
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    driverDataType.addStringEnumKey(stringArray[i]);
                    driverDataType.addStringEnumVal(stringArray[i]);
                }
            }
        } else {
            return false;
        }
        this.addPropertyType(driverDataType);
        return true;
    }

    public void setReadOnly(String string) {
        if (!string.equals(this.readOnly)) {
            this.readOnly = string;
            this.firePropertyChangedEvent();
        }
    }

    public String getReadOnly() {
        return this.readOnly;
    }

    public void addDriverModelListener(DriverModelListener driverModelListener) {
        if (!this.fChangeListeners.contains(driverModelListener)) {
            this.fChangeListeners.add(driverModelListener);
        }
    }

    public void removeDriverModelListener(DriverModelListener driverModelListener) {
        this.fChangeListeners.remove(driverModelListener);
    }

    private void firePropertyChangedEvent() {
        DriverModelEvent driverModelEvent = new DriverModelEvent(this, 9, null, 0);
        for (int i = 0; i < this.fChangeListeners.size(); ++i) {
            this.fChangeListeners.get(i).driverStateChanged(driverModelEvent);
        }
    }

    private void firePropertyNameChangedEvent(String string) {
        DriverModelEvent driverModelEvent = new DriverModelEvent(this, 10, string, 0);
        for (int i = 0; i < this.fChangeListeners.size(); ++i) {
            this.fChangeListeners.get(i).driverStateChanged(driverModelEvent);
        }
    }
}

