/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.device.icdevice;

import com.mathworks.jmi.types.MLArrayRef;
import com.mathworks.toolbox.instrument.device.Device;
import com.mathworks.toolbox.instrument.device.DeviceChild;
import com.mathworks.toolbox.instrument.device.InstrumentDriver;
import com.mathworks.toolbox.instrument.device.PropertyInfo;
import com.mathworks.toolbox.instrument.device.icdevice.ICDeviceChild;
import com.mathworks.toolbox.instrument.device.icdevice.ICDeviceObject;
import com.mathworks.toolbox.testmeas.util.TMException;
import com.mathworks.toolbox.testmeas.util.TMStringUtil;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ICDevice
extends Device {
    public static final String[] BASE_PROPS = new String[]{"ConfirmationFcn", "CreationTime", "DriverData", "DriverName", "DriverType", "InstrumentModel", "Interface", "LogicalName", "Name", "ObjectVisibility", "RsrcName", "Status", "Tag", "Timeout", "Type", "UserData"};
    private Vector<String> propertyGroupNames;
    private Hashtable<String, DeviceChild[]> propertyGroups = new Hashtable();
    private Hashtable<String, MLArrayRef> propertyGroupsML = new Hashtable();
    private Vector<String> deviceSpecificProperties = null;
    private String driverNameWithPath;
    private String variableName = "";
    private Object[] constructorArgs;

    public ICDevice() {
    }

    public ICDevice(String string, InstrumentDriver instrumentDriver, MLArrayRef mLArrayRef) {
        this.driverNameWithPath = string;
        this.interfaceObj = mLArrayRef;
        this.driver = instrumentDriver;
        this.driver.setJDeviceObject(this);
        this.constructorArgs = this.driver.defineConstructorArgs();
        this.driverType = this.driver.defineDriverType();
        this.driverName = this.driver.getDriverName();
        this.displayName = this.driver.getInstrumentType();
        this.type = this.convertDisplayName2Type(this.displayName);
        this.name = this.type + "-" + this.removeExtension(this.driverName);
        this.addPropertyGroups();
        this.status = this.driver.getStatusBasedOnInterface();
    }

    public String getCreateInitializationCode() {
        return this.driver.getCreateInitializationCode();
    }

    public String getConnectInitializationCode() {
        return this.driver.getConnectInitializationCode();
    }

    public String getCleanupCode() {
        return this.driver.getCleanupCode();
    }

    public void setVariableName(String string) {
        this.variableName = string;
    }

    public String getVariableName() {
        return this.variableName;
    }

    private String convertDisplayName2Type(String string) {
        if (string == null) {
            return "unknown instrument";
        }
        if (string.equals("DC Power Supply")) {
            return "dcpower";
        }
        if (string.equals("Digital Multimeter")) {
            return "multimeter";
        }
        if (string.equals("Filter")) {
            return "filter";
        }
        if (string.equals("Function Generator")) {
            return "fcngen";
        }
        if (string.equals("Oscilloscope")) {
            return "scope";
        }
        if (string.equals("Power Meter")) {
            return "pwrmeter";
        }
        if (string.equals("Pulser-Receiver")) {
            return "pulser";
        }
        if (string.equals("Spectrum Analyzer")) {
            return "specanalyzer";
        }
        if (string.equals("Switch")) {
            return "switch";
        }
        return string;
    }

    @Override
    public void display() {
        if (!this.isvalid()) {
            super.display();
            return;
        }
        System.out.println("");
        System.out.println("   Instrument Device Object Using Driver : " + this.driverName);
        System.out.println(" ");
        System.out.println("   Instrument Information");
        System.out.println("      Type:               " + this.displayName);
        System.out.println("      Manufacturer:       " + this.driver.getInstrumentManufacturer());
        System.out.println("      Model:              " + this.driver.getHwInstrumentModel());
        System.out.println(" ");
        System.out.println("   Driver Information");
        System.out.println("      DriverType:         " + DRIVER_TYPE_DISPLAY_NAMES[this.driverType]);
        System.out.println("      DriverName:         " + this.driverName);
        System.out.println("      DriverVersion:      " + this.driver.getDriverVersion());
        System.out.println(" ");
        System.out.println("   Communication State");
        System.out.println("      Status:             " + STATUS_TYPES[this.status]);
        System.out.println("");
    }

    public void setTimeoutFromInterfaceObject(double d) {
        this.timeout = d;
    }

    public void connectFromInterfaceObject() {
        this.status = 1;
    }

    public void disconnectFromInterfaceObject() {
        this.status = 0;
    }

    public void addPropertyGroups() {
        this.propertyGroupNames = this.driver.getPropertyGroups();
        this.propertyGroupNames.removeElement("parent");
        if (this.propertyGroupNames.size() == 0) {
            return;
        }
        for (int i = 0; i < this.propertyGroupNames.size(); ++i) {
            String string = this.propertyGroupNames.elementAt(i);
            String string2 = ICDeviceObject.getChildObjectName();
            this.addGroup(string2, string);
        }
    }

    private void addGroup(String string, String string2) {
        int n = this.driver.getPropertyGroupSize(string2);
        DeviceChild[] deviceChildArray = new DeviceChild[n];
        Object[] objectArray = new Object[2];
        objectArray[1] = new Integer(2);
        for (int i = 0; i < n; ++i) {
            objectArray[0] = new Integer(i + 1);
            deviceChildArray[i] = ICDeviceObject.getChildInstance(this, this.driver, objectArray, string2, string);
            ((ICDeviceChild)deviceChildArray[i]).assignNameValues(string2);
        }
        this.propertyGroups.put(string2, deviceChildArray);
    }

    public void addGroupAfterConnect(String string, String string2) {
        DeviceChild[] deviceChildArray = this.propertyGroups.get(string2);
        int n = this.driver.getPropertyGroupSize(string2);
        DeviceChild[] deviceChildArray2 = new DeviceChild[n];
        for (int i = 0; i < deviceChildArray.length; ++i) {
            deviceChildArray2[i] = deviceChildArray[i];
        }
        Object[] objectArray = new Object[2];
        objectArray[1] = new Integer(2);
        for (int i = deviceChildArray.length; i < n; ++i) {
            objectArray[0] = new Integer(i + 1);
            deviceChildArray2[i] = ICDeviceObject.getChildInstance(this, this.driver, objectArray, string2, string);
            ((ICDeviceChild)deviceChildArray2[i]).assignNameValues(string2);
        }
        this.propertyGroups.put(string2, deviceChildArray2);
    }

    @Override
    public Vector<String> getPropertyGroups() {
        return this.propertyGroupNames;
    }

    public DeviceChild[] getJGroup(String string) {
        return this.propertyGroups.get(string);
    }

    public MLArrayRef getMLGroup(String string) {
        return this.propertyGroupsML.get(string);
    }

    public void assignMATLABGroup(String string, MLArrayRef mLArrayRef, MLArrayRef mLArrayRef2) {
        MLArrayRef mLArrayRef3 = this.propertyGroupsML.get(string);
        if (mLArrayRef3 != null) {
            mLArrayRef3.dispose();
        }
        mLArrayRef3 = mLArrayRef;
        this.propertyGroupsML.put(string, mLArrayRef3);
        DeviceChild[] deviceChildArray = this.propertyGroups.get(string);
        for (int i = 0; i < deviceChildArray.length; ++i) {
            deviceChildArray[i].setMATLABObject(mLArrayRef2.cellAt(i));
        }
        mLArrayRef2.dispose();
    }

    public void setProperty(String string, Object object) throws TMException {
        Object object2;
        if (this.propertyGroupNames.contains(string = this.findPropertyCompleteName(string))) {
            TMStringUtil.error((String)("Changing the '" + string + "' property of device objects is not allowed."));
            return;
        }
        switch (this.getStatus()) {
            case 1: {
                this.driver.setProperty(string, "parent", object);
                break;
            }
            case 0: {
                this.driver.isValidPropertyValue(string, "parent", object);
                this.driver.setCurrentValue(string, "parent", object);
            }
        }
        this.postPropertyChangedEvent(string, object);
        if (this.status == 1 && this.confirmationFcn != CALLBACK && !object.equals(object2 = this.driver.getDisplayValue(string, "parent"))) {
            this.executeConfirmationEvent(Calendar.getInstance(), string, object, object2);
        }
    }

    public Object getProperty(String string) throws TMException {
        if (this.propertyGroupNames.contains(string = this.findPropertyCompleteName(string))) {
            return this.propertyGroupsML.get(string);
        }
        switch (this.getStatus()) {
            case 1: {
                return this.getDisplayValue(this.driver.getProperty(string, "parent"));
            }
            case 0: {
                return this.getDisplayValue(this.driver.getDisplayValue(string, "parent"));
            }
        }
        return null;
    }

    private Object getDisplayValue(Object object) {
        if (!(object instanceof Boolean)) {
            return object;
        }
        if (((Boolean)object).booleanValue()) {
            return "on";
        }
        return "off";
    }

    @Override
    public Vector<String> getDeviceSpecificProperties() {
        if (this.deviceSpecificProperties == null) {
            this.deviceSpecificProperties = this.driver.getProperties("parent");
            if (this.deviceSpecificProperties == null) {
                this.deviceSpecificProperties = new Vector();
            }
            if (this.propertyGroupNames != null) {
                this.deviceSpecificProperties = TMStringUtil.sort(this.deviceSpecificProperties, this.propertyGroupNames);
            }
        }
        return this.deviceSpecificProperties;
    }

    @Override
    public PropertyInfo getDeviceSpecificPropertyInfo(String string) {
        if (this.propertyGroupNames.contains(string)) {
            PropertyInfo propertyInfo = new PropertyInfo(string, "object", "object", null, null, "always", 1, 0);
            return propertyInfo;
        }
        return this.driver.getPropertyInformation(string, "parent");
    }

    @Override
    public void updateObjectSpecificProperties(PropertyInfo[] propertyInfoArray) {
        for (int i = 0; i < propertyInfoArray.length; ++i) {
            String string = propertyInfoArray[i].name;
            if (string.equals("Name")) {
                propertyInfoArray[i].defaultValue = this.type + "-" + this.removeExtension(this.driverName);
                continue;
            }
            if (string.equals("Type")) {
                propertyInfoArray[i].defaultValue = this.type;
                continue;
            }
            if (string.equals("DriverType")) {
                propertyInfoArray[i].defaultValue = DRIVER_TYPE_DISPLAY_NAMES[this.driverType];
                continue;
            }
            if (string.equals("DriverName")) {
                propertyInfoArray[i].defaultValue = this.driverName;
                continue;
            }
            if (string.equals("LogicalName")) {
                propertyInfoArray[i].defaultValue = this.getLogicalName();
                continue;
            }
            if (string.equals("RsrcName")) {
                propertyInfoArray[i].defaultValue = this.getRsrcName();
                continue;
            }
            if (string.equals("Interface")) {
                propertyInfoArray[i].defaultValue = this.interfaceObj;
                continue;
            }
            if (!this.propertyGroupNames.contains(string)) continue;
            propertyInfoArray[i].setDefaultValue(this.getMLGroup(string));
        }
    }

    public Object[] getConstructorArgs() {
        return this.constructorArgs;
    }

    @Override
    public String getConstructor() {
        return this.driver.defineConstructor();
    }

    public String getConstructorDescription() {
        return this.driver.defineConstructorDescription();
    }

    public String getConstructorWithInterfaceConstructor() {
        switch (this.driverType) {
            case 0: {
                String string = this.getConstructor();
                String string2 = this.driver.getInterfaceConstructor();
                return TMStringUtil.strrep((String)string, (String)"HWOBJ", (String)string2.substring(0, string2.length() - 1));
            }
        }
        return this.getConstructor();
    }

    public String getInstrfindArgs() {
        return "('Type', '" + this.type + "', 'DriverName', '" + this.driverName + "', 'Tag', '" + this.tag + "');";
    }

    public String getInterfaceConstructor() {
        return this.driver.getInterfaceConstructor();
    }

    @Override
    public String getPathToDriverName() {
        return this.driverNameWithPath;
    }

    @Override
    public void instrumentOpen(String string) throws TMException {
        this.driver.open();
        if (string.equals("object")) {
            return;
        }
        Vector<String> vector = this.getDeviceSpecificProperties();
        for (int i = 0; i < vector.size(); ++i) {
            String string2 = vector.elementAt(i);
            if (this.propertyGroupNames.contains(string2)) {
                this.open(string2, string);
                continue;
            }
            this.driver.setProperty(string2, "parent", this.driver.getDisplayValue(string2, "parent"));
        }
    }

    private void open(String string, String string2) throws TMException {
        DeviceChild[] deviceChildArray = this.getJGroup(string);
        for (int i = 0; i < deviceChildArray.length; ++i) {
            ((ICDeviceChild)deviceChildArray[0]).open(string2);
        }
    }

    @Override
    public void instrumentClose() throws TMException {
        try {
            this.driver.close();
        }
        catch (TMException tMException) {
            // empty catch block
        }
    }

    public boolean isMethodMCode(String string) throws TMException {
        return this.driver.isMethodMCode(string, "parent");
    }

    public String getMethodMCode(String string) throws TMException {
        return this.driver.getMethodMCode(string, "parent");
    }

    @Override
    public Object[] executeMethod(String string, Object[] objectArray) throws TMException {
        this.verifyObjectState();
        if (!this.isMethod(string)) {
            TMStringUtil.error((String)("Invalid method: " + string + "."));
        }
        return this.driver.executeMethod(string, "parent", objectArray);
    }

    public String isChildMethod(String string) {
        for (int i = 0; i < this.propertyGroupNames.size(); ++i) {
            String string2 = this.propertyGroupNames.elementAt(i);
            if (!this.isMethod(string, string2)) continue;
            return string2.toLowerCase();
        }
        return "";
    }

    public boolean isMethod(String string, String string2) {
        try {
            String[] stringArray = this.driver.getMethods(string2);
            if (stringArray == null) {
                return false;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].toLowerCase().equals(string.toLowerCase())) continue;
                return true;
            }
        }
        catch (TMException tMException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public void instrumentDispose() throws TMException {
        try {
            this.driver.dispose();
        }
        catch (TMException tMException) {
            // empty catch block
        }
        this.disposeGroups();
        this.propertyGroupNames.clear();
        if (this.deviceSpecificProperties != null) {
            this.deviceSpecificProperties.removeAllElements();
        }
        if (this.constructorArgs.length > 1 && this.constructorArgs[1] instanceof MLArrayRef) {
            ((MLArrayRef)this.constructorArgs[1]).dispose();
        }
        for (int i = 0; i < this.constructorArgs.length; ++i) {
            this.constructorArgs[i] = null;
        }
        this.driver = null;
        this.propertyGroupNames = null;
        this.deviceSpecificProperties = null;
        this.constructorArgs = null;
    }

    private void disposeGroups() throws TMException {
        Object object;
        Enumeration<MLArrayRef> enumeration = this.propertyGroupsML.elements();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            object.dispose();
            object = null;
        }
        object = this.propertyGroups.elements();
        while (object.hasMoreElements()) {
            DeviceChild[] deviceChildArray = (DeviceChild[])object.nextElement();
            for (int i = 0; i < deviceChildArray.length; ++i) {
                deviceChildArray[i].dispose();
                deviceChildArray[i] = null;
            }
            deviceChildArray = null;
        }
        object = null;
        enumeration = null;
        this.propertyGroupsML = null;
        this.propertyGroups = null;
    }

    public static void addNotification(String string, MLArrayRef mLArrayRef) throws TMException {
        mlNotifier.addNotification(string, mLArrayRef);
    }

    public static void addNotification(String string, Vector<Object> vector, String[] stringArray, MLArrayRef mLArrayRef) throws TMException {
        mlNotifier.addNotification(string, vector, stringArray, mLArrayRef);
    }

    public InstrumentDriver getDriver() {
        return this.driver;
    }
}

