/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.instrcomm;

import com.mathworks.toolbox.instrument.Instrument;
import com.mathworks.toolbox.instrument.instrcomm.MCode;
import com.mathworks.toolbox.instrument.instrcomm.MCodeBank;
import com.mathworks.toolbox.testmeas.util.TMStringUtil;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Hashtable;
import java.util.Vector;

public class MCodeWriter {
    private RandomAccessFile appendWriter;
    private int numOfObjects = 1;
    private Vector<String> objectsToClose = new Vector();
    private int numOfReads = 1;
    private Hashtable<Instrument, String> objectLookup = new Hashtable();
    private int lastCommandType = -1;
    private String fileText = "";
    private String fileName = "";
    private String functionName = "";

    public void createFile(String string, MCodeBank mCodeBank) {
        try {
            this.fileName = string;
            this.reset();
            this.functionName = this.parseFileName(string);
            this.addComments();
            this.writeDataToFile(mCodeBank);
            this.addCleanupCode();
            File file = new File(this.fileName);
            file.delete();
            this.appendWriter = new RandomAccessFile(file, "rw");
            this.appendWriter.writeBytes(this.fileText + "\n");
            this.appendWriter.close();
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
        }
    }

    public String writeFile(MCodeBank mCodeBank) {
        try {
            this.reset();
            this.writeDataToFile(mCodeBank);
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
        }
        return this.fileText;
    }

    private void reset() {
        this.numOfObjects = 1;
        this.numOfReads = 1;
        this.fileText = "";
        this.objectLookup.clear();
        this.objectsToClose.removeAllElements();
    }

    private void writeDataToFile(MCodeBank mCodeBank) throws IOException {
        Vector<MCode> vector = mCodeBank.getCode();
        for (int i = 0; i < vector.size(); ++i) {
            MCode mCode = vector.elementAt(i);
            Instrument instrument = mCode.getObject();
            if (!mCode.isCodeValid()) continue;
            this.writeCommand(mCode, instrument);
        }
    }

    private void writeCommand(MCode mCode, Instrument instrument) throws IOException {
        String string = "";
        if (instrument == null) {
            return;
        }
        switch (mCode.getType()) {
            case 0: {
                string = this.createObject(instrument);
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                string = this.createObject(instrument);
                if (this.objectsToClose.contains(string)) break;
                this.objectsToClose.addElement(string);
                this.appendToFile("");
                this.appendToFile("% Connect to instrument object, " + string + ".");
                this.appendToFile(TMStringUtil.strrep((String)mCode.getMCode(), (String)"obj", (String)string));
                break;
            }
            case 3: {
                string = this.createObject(instrument);
                if (this.lastCommandType != 3) {
                    this.appendToFile("");
                    this.appendToFile("% Configure instrument object, " + string + ".");
                }
                this.appendToFile(TMStringUtil.strrep((String)mCode.getMCode(), (String)"obj", (String)string));
                break;
            }
            case 4: {
                string = this.createObject(instrument);
                if (this.lastCommandType != 4 && this.lastCommandType != 5 && this.lastCommandType != 7 && this.lastCommandType != 8 && this.lastCommandType != 11) {
                    this.appendToFile("");
                    this.appendToFile("% Communicating with instrument object, " + string + ".");
                }
                this.appendToFile(TMStringUtil.strrep((String)mCode.getMCode(), (String)"obj", (String)string));
                break;
            }
            case 5: {
                string = this.createObject(instrument);
                if (this.lastCommandType != 4 && this.lastCommandType != 5 && this.lastCommandType != 7 && this.lastCommandType != 8 && this.lastCommandType != 11) {
                    this.appendToFile("");
                    this.appendToFile("% Communicating with instrument object, " + string + ".");
                }
                String string2 = "data" + this.numOfReads++;
                String string3 = TMStringUtil.strrep((String)mCode.getMCode(), (String)"obj", (String)string);
                this.appendToFile(string2 + " = " + string3);
                break;
            }
            case 6: {
                string = this.createObject(instrument);
                this.appendToFile("");
                this.appendToFile("% Flush the data in the input buffer.");
                this.appendToFile(TMStringUtil.strrep((String)mCode.getMCode(), (String)"obj", (String)string));
                break;
            }
            case 7: {
                string = this.createObject(instrument);
                if (this.lastCommandType != 4 && this.lastCommandType != 5 && this.lastCommandType != 7 && this.lastCommandType != 8 && this.lastCommandType != 11) {
                    this.appendToFile("");
                    this.appendToFile("% Communicating with instrument object, " + string + ".");
                }
                String string4 = "data" + this.numOfReads++;
                String string5 = TMStringUtil.strrep((String)mCode.getMCode(), (String)"obj", (String)string);
                this.appendToFile(string4 + " = " + string5);
                break;
            }
            case 8: {
                break;
            }
            case 11: {
                break;
            }
            case 9: {
                string = this.createObject(instrument);
                this.objectsToClose.removeElement(string);
                this.appendToFile("");
                this.appendToFile("% Disconnect from instrument object, " + string + ".");
                this.appendToFile(TMStringUtil.strrep((String)mCode.getMCode(), (String)"obj", (String)string));
                break;
            }
            case 10: {
                if (this.objectLookup.get(instrument) == null) break;
                string = this.createObject(instrument);
                this.objectsToClose.removeElement(string);
                this.appendToFile("");
                this.appendToFile("% Delete instrument object, " + string + ".");
                this.appendToFile(TMStringUtil.strrep((String)mCode.getMCode(), (String)"obj", (String)string));
            }
        }
        this.lastCommandType = mCode.getType();
    }

    private String createObject(Instrument instrument) throws IOException {
        String string = this.objectLookup.get(instrument);
        if (string != null) {
            return string;
        }
        this.appendToFile("");
        this.appendToFile("% Find a " + instrument.getDisplayName() + " object.");
        String string2 = "obj" + this.numOfObjects++;
        this.objectLookup.put(instrument, string2);
        this.appendToFile(string2 + " = instrfind" + instrument.getInstrfindArgs());
        this.appendToFile("");
        this.appendToFile("% Create the " + instrument.getDisplayName() + " object if it does not exist");
        this.appendToFile("% otherwise use the object that was found.");
        this.appendToFile("if isempty(" + string2 + ")");
        this.appendToFile("    " + string2 + " = " + instrument.getConstructor());
        this.appendToFile("else");
        this.appendToFile("    fclose(" + string2 + ");");
        this.appendToFile("    " + string2 + " = " + string2 + "(1)");
        this.appendToFile("end");
        if (instrument.getOutputBufferSize() != instrument.getDefaultInputBufferSize()) {
            this.appendToFile("\n% Configure instrument object, " + string2);
            this.appendToFile("\nset(" + string2 + ", 'InputBufferSize', " + instrument.getInputBufferSize() + ");");
        }
        if (instrument.getInputBufferSize() != instrument.getDefaultOutputBufferSize()) {
            this.appendToFile("\n% Configure instrument object, " + string2);
            this.appendToFile("\nset(" + string2 + ", 'OutputBufferSize', " + instrument.getOutputBufferSize() + ");");
        }
        return string2;
    }

    private void appendToFile(String string) {
        this.fileText = this.fileText + string + "\n";
    }

    private String parseFileName(String string) {
        int n = string.lastIndexOf("\\");
        if (n == -1) {
            n = string.lastIndexOf("/");
        }
        if (n != -1) {
            string = string.substring(n + 1);
        }
        if ((n = string.indexOf(".")) != -1) {
            string = string.substring(0, n);
        }
        return string;
    }

    private void addCleanupCode() {
        int n;
        if (this.objectsToClose.size() > 0) {
            this.appendToFile("");
            this.appendToFile("% Disconnect all objects.");
            for (n = 0; n < this.objectsToClose.size(); ++n) {
                this.appendToFile("fclose(" + this.objectsToClose.elementAt(n) + ");");
            }
        }
        this.appendToFile("");
        this.appendToFile("% Clean up all objects.");
        for (n = 1; n < this.numOfObjects; ++n) {
            this.appendToFile("delete(obj" + n + ");");
        }
    }

    private void addComments() throws IOException {
        this.appendToFile("%" + this.functionName.toUpperCase() + " Code for communicating with an instrument.");
        this.appendToFile("%");
        this.appendToFile("%   This is the machine generated representation of an instrument control");
        this.appendToFile("%   session. The instrument control session comprises all the steps you are");
        this.appendToFile("%   likely to take when communicating with your instrument. These steps are:");
        this.appendToFile("%   ");
        this.appendToFile("%       1. Create an instrument object");
        this.appendToFile("%       2. Connect to the instrument");
        this.appendToFile("%       3. Configure properties");
        this.appendToFile("%       4. Write and read data");
        this.appendToFile("%       5. Disconnect from the instrument");
        this.appendToFile("% ");
        this.appendToFile("%   To run the instrument control session, type the name of the file,");
        this.appendToFile("%   " + this.functionName + ", at the MATLAB command prompt.");
        this.appendToFile("% ");
        this.appendToFile("%   The file, " + this.functionName.toUpperCase() + ".M must be on your MATLAB PATH. For additional information ");
        this.appendToFile("%   on setting your MATLAB PATH, type 'help addpath' at the MATLAB command ");
        this.appendToFile("%   prompt.");
        this.appendToFile("% ");
        this.appendToFile("%   Example:");
        this.appendToFile("%       " + this.functionName.toLowerCase() + ";");
        this.appendToFile("% ");
        this.appendToFile("%   See also SERIAL, GPIB, TCPIP, UDP, VISA, BLUETOOTH, I2C, SPI.");
        this.appendToFile("% ");
        this.appendToFile(" ");
        this.appendToFile("%   Creation time: " + TMStringUtil.getDate());
    }
}

