/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tinytree;

import java.util.ArrayList;
import java.util.Arrays;
import net.sf.saxon.Configuration;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.sort.IntArraySet;
import net.sf.saxon.tinytree.CharSlice;
import net.sf.saxon.tinytree.LargeStringBuffer;
import net.sf.saxon.tinytree.TinyAttributeImpl;
import net.sf.saxon.tinytree.TinyCommentImpl;
import net.sf.saxon.tinytree.TinyDocumentImpl;
import net.sf.saxon.tinytree.TinyElementImpl;
import net.sf.saxon.tinytree.TinyNodeImpl;
import net.sf.saxon.tinytree.TinyParentNodeImpl;
import net.sf.saxon.tinytree.TinyProcInstImpl;
import net.sf.saxon.tinytree.TinyTextImpl;
import net.sf.saxon.tinytree.WhitespaceTextImpl;
import net.sf.saxon.tree.LineNumberMap;
import net.sf.saxon.tree.SystemIdMap;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ListType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Whitespace;

public final class TinyTree {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private Configuration config;
    private ArrayList documentList = new ArrayList(5);
    protected int documentNumber;
    protected LargeStringBuffer charBuffer;
    protected FastStringBuffer commentBuffer = null;
    protected int numberOfNodes = 0;
    public byte[] nodeKind;
    protected short[] depth;
    protected int[] next;
    protected int[] alpha;
    protected int[] beta;
    protected int[] nameCode;
    protected int[] prior = null;
    protected int[] typeCodeArray = null;
    private static final int TYPECODE_IDREF = 0x20000000;
    protected int numberOfAttributes = 0;
    protected int[] attParent;
    protected int[] attCode;
    protected CharSequence[] attValue;
    protected int[] attTypeCode;
    protected int numberOfNamespaces = 0;
    protected int[] namespaceParent;
    protected int[] namespaceCode;
    private int[] rootIndex = new int[5];
    protected int rootIndexUsed = 0;
    private LineNumberMap lineNumberMap;
    private SystemIdMap systemIdMap = null;
    protected boolean usesNamespaces = false;
    private static int treesCreated = 5;
    private static double averageNodes = 4000.0;
    private static double averageAttributes = 100.0;
    private static double averageNamespaces = 20.0;
    private static double averageCharacters = 4000.0;

    public TinyTree() {
        this((int)(averageNodes + 1.0), (int)(averageAttributes + 1.0), (int)(averageNamespaces + 1.0), (int)(averageCharacters + 1.0));
    }

    public TinyTree(int nodes, int attributes, int namespaces, int characters) {
        this.nodeKind = new byte[nodes];
        this.depth = new short[nodes];
        this.next = new int[nodes];
        this.alpha = new int[nodes];
        this.beta = new int[nodes];
        this.nameCode = new int[nodes];
        this.numberOfAttributes = 0;
        this.attParent = new int[attributes];
        this.attCode = new int[attributes];
        this.attValue = new String[attributes];
        this.numberOfNamespaces = 0;
        this.namespaceParent = new int[namespaces];
        this.namespaceCode = new int[namespaces];
        this.charBuffer = new LargeStringBuffer(characters, 64000);
    }

    public void setConfiguration(Configuration config) {
        this.config = config;
        this.addNamespace(0, 65537);
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public NamePool getNamePool() {
        return this.config.getNamePool();
    }

    private void ensureNodeCapacity(short kind) {
        if (this.nodeKind.length < this.numberOfNodes + 1) {
            int k = kind == 11 ? this.numberOfNodes + 1 : this.numberOfNodes * 2;
            byte[] nodeKind2 = new byte[k];
            int[] next2 = new int[k];
            short[] depth2 = new short[k];
            int[] alpha2 = new int[k];
            int[] beta2 = new int[k];
            int[] nameCode2 = new int[k];
            System.arraycopy(this.nodeKind, 0, nodeKind2, 0, this.numberOfNodes);
            System.arraycopy(this.next, 0, next2, 0, this.numberOfNodes);
            System.arraycopy(this.depth, 0, depth2, 0, this.numberOfNodes);
            System.arraycopy(this.alpha, 0, alpha2, 0, this.numberOfNodes);
            System.arraycopy(this.beta, 0, beta2, 0, this.numberOfNodes);
            System.arraycopy(this.nameCode, 0, nameCode2, 0, this.numberOfNodes);
            this.nodeKind = nodeKind2;
            this.next = next2;
            this.depth = depth2;
            this.alpha = alpha2;
            this.beta = beta2;
            this.nameCode = nameCode2;
            if (this.typeCodeArray != null) {
                int[] typeCodeArray2 = new int[k];
                System.arraycopy(this.typeCodeArray, 0, typeCodeArray2, 0, this.numberOfNodes);
                this.typeCodeArray = typeCodeArray2;
            }
        }
    }

    private void ensureAttributeCapacity() {
        if (this.attParent.length < this.numberOfAttributes + 1) {
            int k = this.numberOfAttributes * 2;
            if (k == 0) {
                k = 10;
            }
            int[] attParent2 = new int[k];
            int[] attCode2 = new int[k];
            String[] attValue2 = new String[k];
            System.arraycopy(this.attParent, 0, attParent2, 0, this.numberOfAttributes);
            System.arraycopy(this.attCode, 0, attCode2, 0, this.numberOfAttributes);
            System.arraycopy(this.attValue, 0, attValue2, 0, this.numberOfAttributes);
            this.attParent = attParent2;
            this.attCode = attCode2;
            this.attValue = attValue2;
            if (this.attTypeCode != null) {
                int[] attTypeCode2 = new int[k];
                System.arraycopy(this.attTypeCode, 0, attTypeCode2, 0, this.numberOfAttributes);
                this.attTypeCode = attTypeCode2;
            }
        }
    }

    private void ensureNamespaceCapacity() {
        if (this.namespaceParent.length < this.numberOfNamespaces + 1) {
            int k = this.numberOfNamespaces * 2;
            int[] namespaceParent2 = new int[k];
            int[] namespaceCode2 = new int[k];
            System.arraycopy(this.namespaceParent, 0, namespaceParent2, 0, this.numberOfNamespaces);
            System.arraycopy(this.namespaceCode, 0, namespaceCode2, 0, this.numberOfNamespaces);
            this.namespaceParent = namespaceParent2;
            this.namespaceCode = namespaceCode2;
        }
    }

    int addDocumentNode(TinyDocumentImpl doc) {
        this.documentList.add(doc);
        return this.addNode((short)9, 0, this.documentList.size() - 1, 0, -1);
    }

    int addNode(short kind, int depth, int alpha, int beta, int nameCode) {
        this.ensureNodeCapacity(kind);
        this.nodeKind[this.numberOfNodes] = (byte)kind;
        this.depth[this.numberOfNodes] = (short)depth;
        this.alpha[this.numberOfNodes] = alpha;
        this.beta[this.numberOfNodes] = beta;
        this.nameCode[this.numberOfNodes] = nameCode;
        this.next[this.numberOfNodes] = -1;
        if (this.typeCodeArray != null) {
            this.typeCodeArray[this.numberOfNodes] = 630;
        }
        if (this.numberOfNodes == 0) {
            this.documentNumber = this.config.getDocumentNumberAllocator().allocateDocumentNumber();
        }
        if (depth == 0 && kind != 11) {
            if (this.rootIndexUsed == this.rootIndex.length) {
                int[] r2 = new int[this.rootIndexUsed * 2];
                System.arraycopy(this.rootIndex, 0, r2, 0, this.rootIndexUsed);
                this.rootIndex = r2;
            }
            this.rootIndex[this.rootIndexUsed++] = this.numberOfNodes;
        }
        return this.numberOfNodes++;
    }

    void appendChars(CharSequence chars) {
        this.charBuffer.append(chars);
    }

    void condense() {
        int k;
        if (this.rootIndexUsed > 1) {
            return;
        }
        if (this.numberOfNodes * 3 < this.nodeKind.length || this.nodeKind.length - this.numberOfNodes > 20000) {
            k = this.numberOfNodes + 1;
            byte[] nodeKind2 = new byte[k];
            int[] next2 = new int[k];
            short[] depth2 = new short[k];
            int[] alpha2 = new int[k];
            int[] beta2 = new int[k];
            int[] nameCode2 = new int[k];
            System.arraycopy(this.nodeKind, 0, nodeKind2, 0, this.numberOfNodes);
            System.arraycopy(this.next, 0, next2, 0, this.numberOfNodes);
            System.arraycopy(this.depth, 0, depth2, 0, this.numberOfNodes);
            System.arraycopy(this.alpha, 0, alpha2, 0, this.numberOfNodes);
            System.arraycopy(this.beta, 0, beta2, 0, this.numberOfNodes);
            System.arraycopy(this.nameCode, 0, nameCode2, 0, this.numberOfNodes);
            if (this.typeCodeArray != null) {
                int[] type2 = new int[k];
                System.arraycopy(this.typeCodeArray, 0, type2, 0, this.numberOfNodes);
                this.typeCodeArray = type2;
            }
            this.nodeKind = nodeKind2;
            this.next = next2;
            this.depth = depth2;
            this.alpha = alpha2;
            this.beta = beta2;
            this.nameCode = nameCode2;
        }
        if (this.numberOfAttributes * 3 < this.attParent.length || this.attParent.length - this.numberOfAttributes > 1000) {
            k = this.numberOfAttributes;
            if (k == 0) {
                this.attParent = IntArraySet.EMPTY_INT_ARRAY;
                this.attCode = IntArraySet.EMPTY_INT_ARRAY;
                this.attValue = EMPTY_STRING_ARRAY;
                this.attTypeCode = null;
            }
            int[] attParent2 = new int[k];
            int[] attCode2 = new int[k];
            String[] attValue2 = new String[k];
            System.arraycopy(this.attParent, 0, attParent2, 0, this.numberOfAttributes);
            System.arraycopy(this.attCode, 0, attCode2, 0, this.numberOfAttributes);
            System.arraycopy(this.attValue, 0, attValue2, 0, this.numberOfAttributes);
            this.attParent = attParent2;
            this.attCode = attCode2;
            this.attValue = attValue2;
            if (this.attTypeCode != null) {
                int[] attTypeCode2 = new int[k];
                System.arraycopy(this.attTypeCode, 0, attTypeCode2, 0, this.numberOfAttributes);
                this.attTypeCode = attTypeCode2;
            }
        }
        if (this.numberOfNamespaces * 3 < this.namespaceParent.length) {
            k = this.numberOfNamespaces;
            int[] namespaceParent2 = new int[k];
            int[] namespaceCode2 = new int[k];
            System.arraycopy(this.namespaceParent, 0, namespaceParent2, 0, this.numberOfNamespaces);
            System.arraycopy(this.namespaceCode, 0, namespaceCode2, 0, this.numberOfNamespaces);
            this.namespaceParent = namespaceParent2;
            this.namespaceCode = namespaceCode2;
        }
        this.updateStatistics();
    }

    void setElementAnnotation(int nodeNr, int typeCode) {
        if (typeCode != 630) {
            if (this.typeCodeArray == null) {
                this.typeCodeArray = new int[this.nodeKind.length];
                Arrays.fill(this.typeCodeArray, 0, this.nodeKind.length, 630);
            }
            this.typeCodeArray[nodeNr] = typeCode;
        }
    }

    public int getTypeAnnotation(int nodeNr) {
        if (this.typeCodeArray == null) {
            return 630;
        }
        return this.typeCodeArray[nodeNr] & 0xFFFFF;
    }

    public int getNodeKind(int nodeNr) {
        int kind = this.nodeKind[nodeNr];
        return kind == 4 ? 3 : kind;
    }

    public int getNameCode(int nodeNr) {
        return this.nameCode[nodeNr];
    }

    void ensurePriorIndex() {
        if (this.prior == null || this.prior.length < this.numberOfNodes) {
            this.makePriorIndex();
        }
    }

    private synchronized void makePriorIndex() {
        this.prior = new int[this.numberOfNodes];
        Arrays.fill(this.prior, 0, this.numberOfNodes, -1);
        for (int i = 0; i < this.numberOfNodes; ++i) {
            int nextNode = this.next[i];
            if (nextNode <= i) continue;
            this.prior[nextNode] = i;
        }
    }

    void addAttribute(NodeInfo root, int parent, int nameCode, int typeCode, CharSequence attValue, int properties) {
        this.ensureAttributeCapacity();
        this.attParent[this.numberOfAttributes] = parent;
        this.attCode[this.numberOfAttributes] = nameCode;
        this.attValue[this.numberOfAttributes] = attValue;
        if (typeCode == -1) {
            typeCode = 631;
        }
        if (typeCode != 631) {
            this.initializeAttributeTypeCodes();
        }
        if (this.attTypeCode != null) {
            this.attTypeCode[this.numberOfAttributes] = typeCode;
        }
        if (this.alpha[parent] == -1) {
            this.alpha[parent] = this.numberOfAttributes;
        }
        if (root instanceof TinyDocumentImpl) {
            boolean isID = false;
            if ((properties & 0x800) != 0) {
                isID = true;
            } else if ((nameCode & 0xFFFFF) == 388) {
                isID = true;
            } else if (this.config.getTypeHierarchy().isIdCode(typeCode)) {
                isID = true;
            }
            if (isID) {
                String id = Whitespace.trim(attValue);
                if (root.getConfiguration().getNameChecker().isValidNCName(id)) {
                    TinyNodeImpl e = this.getNode(parent);
                    ((TinyDocumentImpl)root).registerID(e, id);
                } else if (this.attTypeCode != null) {
                    this.attTypeCode[this.numberOfAttributes] = 631;
                }
            }
            if ((properties & 0x1000) != 0) {
                this.initializeAttributeTypeCodes();
                this.attTypeCode[this.numberOfAttributes] = typeCode | 0x20000000;
            }
        }
        ++this.numberOfAttributes;
    }

    private void initializeAttributeTypeCodes() {
        if (this.attTypeCode == null) {
            this.attTypeCode = new int[this.attParent.length];
            Arrays.fill(this.attTypeCode, 0, this.numberOfAttributes, 631);
        }
    }

    public void indexIDElement(NodeInfo root, int nodeNr, NameChecker checker) {
        String id = Whitespace.trim(TinyParentNodeImpl.getStringValue(this, nodeNr));
        if (root.getNodeKind() == 9 && checker.isValidNCName(id)) {
            TinyNodeImpl e = this.getNode(nodeNr);
            ((TinyDocumentImpl)root).registerID(e, id);
        }
    }

    void addNamespace(int parent, int nscode) {
        this.ensureNamespaceCapacity();
        this.namespaceParent[this.numberOfNamespaces] = parent;
        this.namespaceCode[this.numberOfNamespaces] = nscode;
        if (this.beta[parent] == -1) {
            this.beta[parent] = this.numberOfNamespaces;
        }
        ++this.numberOfNamespaces;
        if (nscode != 65537) {
            this.usesNamespaces = true;
        }
    }

    public final TinyNodeImpl getNode(int nr) {
        switch (this.nodeKind[nr]) {
            case 9: {
                return (TinyDocumentImpl)this.documentList.get(this.alpha[nr]);
            }
            case 1: {
                return new TinyElementImpl(this, nr);
            }
            case 3: {
                return new TinyTextImpl(this, nr);
            }
            case 4: {
                return new WhitespaceTextImpl(this, nr);
            }
            case 8: {
                return new TinyCommentImpl(this, nr);
            }
            case 7: {
                return new TinyProcInstImpl(this, nr);
            }
            case 12: {
                throw new IllegalArgumentException("Attempting to treat a parent pointer as a node");
            }
        }
        return null;
    }

    AtomicValue getAtomizedValueOfUntypedNode(int nodeNr) {
        switch (this.nodeKind[nodeNr]) {
            case 1: 
            case 9: {
                int next;
                short level = this.depth[nodeNr];
                if (this.depth[next] <= level) {
                    return UntypedAtomicValue.ZERO_LENGTH_UNTYPED;
                }
                if (this.nodeKind[next] == 3 && this.depth[next + 1] <= level) {
                    int length = this.beta[next];
                    int start = this.alpha[next];
                    return new UntypedAtomicValue(this.charBuffer.subSequence(start, start + length));
                }
                if (this.nodeKind[next] == 4 && this.depth[next + 1] <= level) {
                    return new UntypedAtomicValue(WhitespaceTextImpl.getStringValue(this, next));
                }
                FastStringBuffer sb = null;
                for (next = nodeNr + 1; next < this.numberOfNodes && this.depth[next] > level; ++next) {
                    if (this.nodeKind[next] == 3) {
                        if (sb == null) {
                            sb = new FastStringBuffer(1024);
                        }
                        sb.append(TinyTextImpl.getStringValue(this, next));
                        continue;
                    }
                    if (this.nodeKind[next] != 4) continue;
                    if (sb == null) {
                        sb = new FastStringBuffer(1024);
                    }
                    WhitespaceTextImpl.appendStringValue(this, next, sb);
                }
                if (sb == null) {
                    return UntypedAtomicValue.ZERO_LENGTH_UNTYPED;
                }
                return new UntypedAtomicValue(sb.condense());
            }
            case 3: {
                return new UntypedAtomicValue(TinyTextImpl.getStringValue(this, nodeNr));
            }
            case 4: {
                return new UntypedAtomicValue(WhitespaceTextImpl.getStringValue(this, nodeNr));
            }
            case 7: 
            case 8: {
                int start2 = this.alpha[nodeNr];
                int len2 = this.beta[nodeNr];
                if (len2 == 0) {
                    return UntypedAtomicValue.ZERO_LENGTH_UNTYPED;
                }
                char[] dest = new char[len2];
                this.commentBuffer.getChars(start2, start2 + len2, dest, 0);
                return new StringValue(new CharSlice(dest, 0, len2));
            }
        }
        throw new IllegalStateException("Unknown node kind");
    }

    TinyAttributeImpl getAttributeNode(int nr) {
        return new TinyAttributeImpl(this, nr);
    }

    int getAttributeAnnotation(int nr) {
        if (this.attTypeCode == null) {
            return 631;
        }
        return this.attTypeCode[nr] & 0x400FFFFF;
    }

    public boolean isIdrefAttribute(int nr) {
        if (this.attTypeCode == null) {
            return false;
        }
        int tc = this.attTypeCode[nr];
        if ((this.attTypeCode[nr] & 0x20000000) != 0) {
            return true;
        }
        if ((tc &= 0xFFFFF) == 631) {
            return false;
        }
        if (tc == 561) {
            return true;
        }
        if (tc == 562) {
            return true;
        }
        if (tc < 1024) {
            return false;
        }
        SchemaType type = this.getConfiguration().getSchemaType(tc);
        TypeHierarchy th = this.getConfiguration().getTypeHierarchy();
        if (type.isAtomicType()) {
            return th.isSubType((AtomicType)type, BuiltInAtomicType.IDREF);
        }
        if (type instanceof ListType) {
            SimpleType itemType = ((ListType)type).getItemType();
            return itemType.isAtomicType() && th.isSubType((AtomicType)itemType, BuiltInAtomicType.IDREF);
        }
        return false;
    }

    public boolean isIdrefElement(int nr) {
        if (this.typeCodeArray == null) {
            return false;
        }
        int tc = this.typeCodeArray[nr];
        return (tc & 0x20000000) != 0 || this.getConfiguration().getTypeHierarchy().isIdrefsCode(tc & 0xFFFFF);
    }

    void setSystemId(int seq, String uri) {
        if (uri == null) {
            uri = "";
        }
        if (this.systemIdMap == null) {
            this.systemIdMap = new SystemIdMap();
        }
        this.systemIdMap.setSystemId(seq, uri);
    }

    String getSystemId(int seq) {
        if (this.systemIdMap == null) {
            return null;
        }
        return this.systemIdMap.getSystemId(seq);
    }

    int getRootNode(int nodeNr) {
        for (int i = this.rootIndexUsed - 1; i >= 0; --i) {
            if (this.rootIndex[i] > nodeNr) continue;
            return this.rootIndex[i];
        }
        return 0;
    }

    public void setLineNumbering() {
        this.lineNumberMap = new LineNumberMap();
        this.lineNumberMap.setLineNumber(0, 0);
    }

    void setLineNumber(int sequence, int line) {
        if (this.lineNumberMap != null) {
            this.lineNumberMap.setLineNumber(sequence, line);
        }
    }

    int getLineNumber(int sequence) {
        if (this.lineNumberMap != null) {
            return this.lineNumberMap.getLineNumber(sequence);
        }
        return -1;
    }

    public int getDocumentNumber() {
        return this.documentNumber;
    }

    public boolean isNilled(int nodeNr) {
        return this.typeCodeArray != null && (this.typeCodeArray[nodeNr] & 0x20000000) != 0;
    }

    public void diagnosticDump() {
        int i;
        NamePool pool = this.config.getNamePool();
        System.err.println("    node    type   depth    next   alpha    beta    name");
        for (i = 0; i < this.numberOfNodes; ++i) {
            System.err.println(this.n8(i) + this.n8(this.nodeKind[i]) + this.n8(this.depth[i]) + this.n8(this.next[i]) + this.n8(this.alpha[i]) + this.n8(this.beta[i]) + this.n8(this.nameCode[i]) + (this.nameCode[i] == -1 ? "" : " " + pool.getDisplayName(this.nameCode[i])));
        }
        System.err.println("    attr  parent    name    value");
        for (i = 0; i < this.numberOfAttributes; ++i) {
            System.err.println(this.n8(i) + this.n8(this.attParent[i]) + this.n8(this.attCode[i]) + "    " + this.attValue[i]);
        }
        System.err.println("      ns  parent  prefix     uri");
        for (i = 0; i < this.numberOfNamespaces; ++i) {
            System.err.println(this.n8(i) + this.n8(this.namespaceParent[i]) + this.n8(this.namespaceCode[i] >> 16) + this.n8(this.namespaceCode[i] & 0xFFFF));
        }
    }

    public static synchronized void diagnosticDump(NodeInfo node) {
        if (node instanceof TinyNodeImpl) {
            TinyTree tree = ((TinyNodeImpl)node).tree;
            System.err.println("Tree containing node " + ((TinyNodeImpl)node).nodeNr);
            tree.diagnosticDump();
        } else {
            System.err.println("Node is not in a TinyTree");
        }
    }

    private String n8(int val) {
        String s = "        " + val;
        return s.substring(s.length() - 8);
    }

    public void showSize() {
        System.err.println("Tree size: " + this.numberOfNodes + " nodes, " + this.charBuffer.length() + " characters, " + this.numberOfAttributes + " attributes");
    }

    private void updateStatistics() {
        int n1;
        int n0 = treesCreated;
        treesCreated = n1 = treesCreated + 1;
        if ((averageNodes = (averageNodes * (double)n0 + (double)this.numberOfNodes) / (double)n1) < 10.0) {
            averageNodes = 10.0;
        }
        if ((averageAttributes = (averageAttributes * (double)n0 + (double)this.numberOfAttributes) / (double)n1) < 10.0) {
            averageAttributes = 10.0;
        }
        if ((averageNamespaces = (averageNamespaces * (double)n0 + (double)this.numberOfNamespaces) / (double)n1) < 5.0) {
            averageNamespaces = 5.0;
        }
        if ((averageCharacters = (averageCharacters * (double)n0 + (double)this.charBuffer.length()) / (double)n1) < 100.0) {
            averageCharacters = 100.0;
        }
    }

    public int getNumberOfNodes() {
        return this.numberOfNodes;
    }

    public int getNumberOfAttributes() {
        return this.numberOfAttributes;
    }

    public int getNumberOfNamespaces() {
        return this.numberOfNamespaces;
    }

    public byte[] getNodeKindArray() {
        return this.nodeKind;
    }

    public short[] getNodeDepthArray() {
        return this.depth;
    }

    public int[] getNameCodeArray() {
        return this.nameCode;
    }

    public int[] getTypeCodeArray() {
        return this.typeCodeArray;
    }

    public int[] getNextPointerArray() {
        return this.next;
    }

    public int[] getAlphaArray() {
        return this.alpha;
    }

    public int[] getBetaArray() {
        return this.beta;
    }

    public CharSequence getCharacterBuffer() {
        return this.charBuffer;
    }

    public CharSequence getCommentBuffer() {
        return this.commentBuffer;
    }

    public int[] getAttributeNameCodeArray() {
        return this.attCode;
    }

    public int[] getAttributeTypeCodeArray() {
        return this.attTypeCode;
    }

    public int[] getAttributeParentArray() {
        return this.attParent;
    }

    public CharSequence[] getAttributeValueArray() {
        return this.attValue;
    }

    public int[] getNamespaceCodeArray() {
        return this.namespaceCode;
    }

    public int[] getNamespaceParentArray() {
        return this.namespaceParent;
    }
}

