/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mlwidgets.explorer.util.ExplicitColorAndFontProvider;
import com.mathworks.mwswing.ColorUtils;
import com.mathworks.mwswing.FontUtils;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJToolBar;
import com.mathworks.project.impl.BuiltInResources;
import com.mathworks.project.impl.DataTransferSupport;
import com.mathworks.project.impl.desktop.HelpAction;
import com.mathworks.project.impl.filesetui.FileSetEditor;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.model.DynamicTargetAttribute;
import com.mathworks.project.impl.plugin.PluginManager;
import com.mathworks.project.impl.table.PropertyTable;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.tree.TreeUtils;
import com.mathworks.widgets.BusyAffordance;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.UIManager;
import javax.swing.border.Border;

public final class SectionPanel {
    private final Configuration fConfiguration;
    private final MJPanel fComponent;
    private final DataTransferSupport fDataTransferSupport;
    private final List<Section> fSections;
    private final Map<String, Section> fSectionsByKey;
    private final MJScrollPane fScroller;
    private final List<Component> fDropSupportComponents;
    public static final Color APP_BACKGROUND = new Color(240, 240, 241);
    public static final Color APP_INNER_BACKGROUND = new Color(248, 248, 246);
    public static final Color BACKGROUND = ColorUtils.convertToCurrentColorScheme((Color)new Color(251, 251, 251), (Color)UIManager.getColor("MenuBar.background"));
    public static final Color INNER_BACKGROUND = ColorUtils.convertToCurrentColorScheme((Color)new Color(249, 248, 249), (Color)UIManager.getColor("MenuBar.background"));
    private static final Color HEADER_BACKGROUND = new Color(94, 133, 176);
    private static final Color HEADER_FOREGROUND = Color.WHITE;
    private final Color fBackground;
    private final Color fInnerBackground;

    public SectionPanel(DataTransferSupport dataTransferSupport, boolean bl, Configuration configuration) {
        this.fConfiguration = configuration;
        this.fDataTransferSupport = dataTransferSupport;
        this.fComponent = new GroupComponent();
        this.fBackground = bl ? APP_BACKGROUND : BACKGROUND;
        this.fInnerBackground = bl ? APP_INNER_BACKGROUND : INNER_BACKGROUND;
        this.fComponent.setBackground(this.fBackground);
        this.fDropSupportComponents = new LinkedList<Component>();
        this.fSections = new ArrayList<Section>();
        this.fSectionsByKey = new HashMap<String, Section>();
        this.fScroller = new MJScrollPane((Component)this.fComponent);
        this.fScroller.getViewport().setBackground(this.fBackground);
        this.fScroller.setBackground(this.fBackground);
        this.fScroller.setHorizontalScrollBarPolicy(31);
        this.fScroller.setBorder(null);
    }

    public JComponent getComponent() {
        return this.fScroller;
    }

    public void addSection(String string, String string2, String string3, DynamicTargetAttribute dynamicTargetAttribute, FileSetEditor fileSetEditor, Component component) {
        Object object;
        int n;
        this.fComponent.removeAll();
        this.fComponent.revalidate();
        this.fComponent.repaint();
        Section section = new Section(this.fConfiguration, this.fSections.isEmpty(), string2, string3, dynamicTargetAttribute, component);
        if (fileSetEditor != null) {
            this.fDataTransferSupport.installDropSupport(fileSetEditor, section.getComponent());
            this.fDropSupportComponents.add(fileSetEditor.getComponent());
        }
        section.getComponent().setName(string + "$Section");
        this.fSections.add(section);
        this.fSectionsByKey.put(string, section);
        this.fComponent.setLayout((LayoutManager)new GridBagLayout());
        Insets insets = new Insets(0, 0, 0, 0);
        Insets insets2 = new Insets(4, 7, 6, 6);
        Insets insets3 = new Insets(8, 7, 6, 6);
        for (n = 0; n < this.fSections.size(); ++n) {
            object = this.fSections.get(n);
            this.fComponent.add(((Section)object).getComponent(), (Object)new GridBagConstraints(0, n, 1, 1, 1.0, 0.0, 18, 1, n == 0 ? insets3 : insets2, 0, 0));
        }
        object = new MJPanel();
        object.setBackground(this.fBackground);
        this.fComponent.add((Component)object, (Object)new GridBagConstraints(0, n, 1, 1, 1.0, 1.0, 18, 1, insets, 0, 0));
        this.fComponent.revalidate();
        this.fComponent.repaint();
    }

    public void dispose() {
        for (Component component : this.fDropSupportComponents) {
            this.fDataTransferSupport.uninstall(component);
        }
    }

    public void setDisplayName(String string, String string2) {
        this.fSectionsByKey.get(string).setDisplayName(string2);
    }

    public void setToolTip(String string, String string2) {
        this.fSectionsByKey.get(string).setToolTipText(string2);
    }

    public void isBusy(String string, boolean bl) {
        this.fSectionsByKey.get(string).isBusy(bl);
    }

    private static class BelowLabelBorder
    implements Border {
        private final JComponent fLabel;
        private final Color fColor;

        BelowLabelBorder(JComponent jComponent) {
            this.fLabel = jComponent;
            this.fColor = new Color(223, 224, 222);
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.setColor(this.fColor);
            graphics.drawLine(0, this.fLabel.getHeight(), 0, component.getHeight());
            graphics.drawLine(component.getWidth() - 1, this.fLabel.getHeight(), component.getWidth() - 1, component.getHeight());
            graphics.drawLine(0, component.getHeight() - 1, component.getWidth(), component.getHeight() - 1);
            graphics.setColor(HEADER_BACKGROUND);
            graphics.drawLine(0, 0, 0, this.fLabel.getHeight() - 1);
            graphics.drawLine(component.getWidth() - 1, 0, component.getWidth() - 1, this.fLabel.getHeight() - 1);
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return new Insets(0, 1, 1, 1);
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }
    }

    private class GroupComponent
    extends MJPanel
    implements Scrollable,
    ExplicitColorAndFontProvider {
        private Integer fBlockIncrement;
        private Integer fUnitIncrement;

        GroupComponent() {
            this.setBackground(SectionPanel.this.fBackground);
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent componentEvent) {
                    GroupComponent.this.fBlockIncrement = null;
                }
            });
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    for (Component component : TreeUtils.findComponents((Component)((Object)GroupComponent.this), PropertyTable.COMPONENT_PREDICATE)) {
                        PropertyTable propertyTable = (PropertyTable)((JComponent)component).getClientProperty("PropertyTable.Table");
                        propertyTable.stopEditing(false);
                    }
                }
            });
        }

        public Dimension getMinimumSize() {
            return new Dimension(0, (int)super.getMinimumSize().getHeight());
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return new Dimension(0, (int)this.getPreferredSize().getHeight());
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
            if (this.fUnitIncrement == null) {
                FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
                this.fUnitIncrement = fontMetrics.getAscent() + fontMetrics.getDescent();
            }
            return this.fUnitIncrement;
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
            if (this.fBlockIncrement == null) {
                this.fBlockIncrement = rectangle.height - this.getScrollableUnitIncrement(rectangle, n, n2);
            }
            return this.fBlockIncrement;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return this.getParent() != null && this.getParent() instanceof JViewport && (double)this.getParent().getHeight() > this.getPreferredSize().getHeight();
        }
    }

    private static class HeaderLabel
    extends MJPanel
    implements ExplicitColorAndFontProvider {
        private final MJLabel fLabel;
        private final DynamicTargetAttribute fHelpKey;
        private final MJToolBar fToolBar;
        private final Configuration fConfiguration;
        private final BusyAffordance fBusyAffordance;

        HeaderLabel(Configuration configuration, boolean bl, String string, final String string2, final DynamicTargetAttribute dynamicTargetAttribute) {
            this.fLabel = new MJLabel(string);
            this.fConfiguration = configuration;
            this.fHelpKey = dynamicTargetAttribute;
            if (PlatformInfo.isLinux()) {
                this.fLabel.setFont(FontUtils.getSystemUIFont().deriveFont(11.0f));
            } else {
                this.fLabel.setFont(FontUtils.getSystemUIFont());
            }
            this.fLabel.setForeground(HEADER_FOREGROUND);
            this.fToolBar = new MJToolBar(){

                public Dimension getPreferredSize() {
                    return new Dimension((int)super.getPreferredSize().getWidth(), HelpAction.ICON.getIconHeight() + 1);
                }
            };
            this.fToolBar.setFloatable(false);
            this.fToolBar.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.fToolBar.setBackground(HEADER_BACKGROUND);
            if (dynamicTargetAttribute != null) {
                MJAbstractAction mJAbstractAction = new MJAbstractAction(BuiltInResources.getString("button.help"), HelpAction.ICON){

                    public void actionPerformed(ActionEvent actionEvent) {
                        String string = PluginManager.resolveHelpMapPath(string2);
                        String string22 = HeaderLabel.this.fConfiguration.evaluateString(dynamicTargetAttribute);
                        MLHelpServices.cshDisplayTopic((Object)((Object)this), (String)string, (String)string22);
                    }
                };
                JButton jButton = this.fToolBar.add((Action)mJAbstractAction);
                jButton.setName("button.help." + string.replaceAll(" ", "").toLowerCase());
                jButton.setBackground(HEADER_BACKGROUND);
            }
            this.setBackground(HEADER_BACKGROUND);
            this.setForeground(HEADER_FOREGROUND);
            this.fBusyAffordance = new BusyAffordance(BusyAffordance.AffordanceSize.SIZE_16x16, "");
            this.fBusyAffordance.useWhiteDots(true);
            this.rebuild(false);
        }

        private void rebuild(boolean bl) {
            this.setLayout((LayoutManager)new FormLayout("5px, fill:d, 0dlu:grow," + (this.fHelpKey != null ? " fill:d, " : "") + (this.fHelpKey != null && bl ? "3dlu," : "") + (bl ? "fill:d" : "") + (this.fHelpKey == null && bl ? ", 4px" : ""), "1dlu:grow, fill:p, 0dlu:grow"));
            Border border = BorderFactory.createEmptyBorder(0, 4, 0, 0);
            this.setBorder(border);
            this.setOpaque(true);
            CellConstraints cellConstraints = new CellConstraints();
            this.add((Component)this.fLabel, cellConstraints.xy(2, 2));
            if (this.fHelpKey != null) {
                this.add((Component)this.fToolBar, cellConstraints.xy(bl ? 6 : 4, 2));
            }
            if (bl) {
                this.add(this.fBusyAffordance.getComponent(), cellConstraints.xywh(4, 2, 1, 2));
            }
            this.revalidate();
            this.repaint();
        }

        public void setText(String string) {
            this.fLabel.setText(string);
        }

        public void setForeground(Color color) {
            super.setForeground(HEADER_FOREGROUND);
        }

        public void setBackground(Color color) {
            super.setBackground(HEADER_BACKGROUND);
        }

        public void setFont(Font font) {
            super.setFont(font.deriveFont(1));
        }

        public Dimension getPreferredSize() {
            return new Dimension((int)super.getPreferredSize().getWidth(), (int)this.fLabel.getPreferredSize().getHeight() + 8);
        }

        private void startBusyAffordance() {
            this.fBusyAffordance.start();
            this.rebuild(true);
        }

        private void stopBusyAffordance() {
            this.fBusyAffordance.stop();
            this.rebuild(false);
        }
    }

    private class Section {
        private final JComponent fComponent;
        private final HeaderLabel fHeaderLabel;

        Section(Configuration configuration, boolean bl, String string, String string2, DynamicTargetAttribute dynamicTargetAttribute, Component component) {
            if (string == null) {
                this.fComponent = new MJPanel((LayoutManager)new BorderLayout(0, 0));
                this.fComponent.add(component);
                this.fHeaderLabel = null;
            } else {
                this.fHeaderLabel = new HeaderLabel(configuration, bl, string, string2, dynamicTargetAttribute);
                this.fComponent = new MJPanel((LayoutManager)new FormLayout("9px, d:grow", "p, 3dlu, d, 3dlu"));
                this.fComponent.setBackground(SectionPanel.this.fInnerBackground);
                this.fComponent.setBorder(new BelowLabelBorder((JComponent)((Object)this.fHeaderLabel)));
                CellConstraints cellConstraints = new CellConstraints();
                this.fComponent.add((Component)((Object)this.fHeaderLabel), cellConstraints.xyw(1, 1, 2));
                this.fComponent.add(component, cellConstraints.xy(2, 3));
            }
        }

        public void setDisplayName(String string) {
            this.fHeaderLabel.setText(string);
        }

        public void setToolTipText(String string) {
            this.fHeaderLabel.setToolTipText(string);
        }

        public Component getComponent() {
            return this.fComponent;
        }

        public void isBusy(boolean bl) {
            if (bl) {
                this.fHeaderLabel.startBusyAffordance();
            } else {
                this.fHeaderLabel.stopBusyAffordance();
            }
        }
    }
}

