/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.desktop;

import com.mathworks.common.icons.DocumentIcon;
import com.mathworks.project.impl.ProjectGUI;
import com.mathworks.project.impl.desktop.ProjectAction;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.model.ParamSet;
import com.mathworks.project.impl.model.Project;
import com.mathworks.project.impl.settingsui.NewSettingsDialog;
import com.mathworks.project.impl.settingsui.ProjectSettingsDialog;
import java.awt.event.ActionEvent;

public final class ProjectSettingsAction
extends ProjectAction {
    public static final String KEY = "SETTINGS";

    public ProjectSettingsAction() {
        super(KEY, DocumentIcon.PROJECT_SETTINGS.getIcon());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Project project = ProjectGUI.getInstance().getCurrentProject();
        Configuration configuration = project.getConfiguration();
        for (ParamSet paramSet : configuration.getTarget().getParamSets()) {
            if (paramSet.getIcon() == null) continue;
            NewSettingsDialog.invoke();
            return;
        }
        ProjectSettingsDialog.invoke(project);
    }

    @Override
    public boolean isApplicable(Project project) {
        return project != null && !project.getConfiguration().getTarget().getNonWorkflowParamSets().isEmpty();
    }
}

