/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.engine;

import com.mathworks.project.api.Command;
import com.mathworks.project.api.CommandExecutionException;
import com.mathworks.project.api.CommandStatus;
import com.mathworks.project.api.ProcessWrapper;
import com.mathworks.project.api.XmlApi;
import com.mathworks.project.api.XmlLooper;
import com.mathworks.project.api.XmlReader;
import com.mathworks.project.impl.engine.ProcessWrapperImpl;
import com.mathworks.project.impl.util.Matlab;
import com.mathworks.project.impl.util.StringUtils;
import com.mathworks.project.impl.util.SystemCommands;
import com.mathworks.util.FileUtils;
import com.mathworks.util.PlatformInfo;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.IOCase;

public class ZipCommand
implements Command {
    private static final String ARCH = Matlab.arch();
    private static final String ZIP_COMMAND = Matlab.matlabRoot().getAbsolutePath() + File.separator + "bin" + File.separator + ARCH + File.separator + "zip";
    private static final String MWUNZIPSFX = Matlab.matlabRoot().getAbsolutePath() + File.separator + "extern" + File.separator + "lib" + File.separator + ARCH + File.separator + "mwunzipsfx.exe";
    private ProcessWrapper fCopyProcess;
    private ProcessWrapper fZipProcess;
    private File fTarget;
    private List<File> fFiles = new LinkedList<File>();
    private List<String> fFileNames = new LinkedList<String>();

    public ZipCommand(String string) {
        XmlReader xmlReader;
        try {
            xmlReader = XmlApi.getInstance().read(string);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Invalid command XML: " + string, exception);
        }
        this.fTarget = new File(StringUtils.normalizeSpace(xmlReader.readAttribute("target")));
        xmlReader.loop(new XmlLooper(){

            public void iterate(XmlReader xmlReader) {
                if (xmlReader.readText() != null) {
                    boolean bl;
                    String string = StringUtils.normalizeSpace(xmlReader.readText());
                    boolean bl2 = bl = xmlReader.readAttribute("optional") != null && xmlReader.readAttribute("optional").equals("true");
                    if (new File(string).exists() || !bl) {
                        ZipCommand.this.fFiles.add(new File(string));
                        ZipCommand.this.fFileNames.add(new File(string).getName());
                    }
                }
            }
        }, new String[]{"file"});
    }

    public void execute(CommandStatus commandStatus) {
        File file = this.fTarget.getParentFile();
        String string = this.fTarget.getAbsolutePath();
        boolean bl = IOCase.SYSTEM.checkEndsWith(this.fTarget.getName(), ".exe");
        if (bl) {
            string = file.getAbsolutePath() + File.separatorChar + this.fTarget.getName().substring(0, this.fTarget.getName().lastIndexOf(46)) + ".zip";
        }
        File file2 = null;
        try {
            file2 = FileUtils.createUniqueTempDir((boolean)true);
            for (File object2 : this.fFiles) {
                SystemCommands.copy(object2, new File(file2, object2.getName()));
            }
        }
        catch (Exception exception) {
            if (null != file2) {
                ZipCommand.deleteFolder(file2);
                file2 = null;
            }
            commandStatus.failed(new CommandExecutionException((Command)this, new Throwable("Failed to copy package files to temporary directory")));
        }
        if (FileUtils.fileExists((String)string)) {
            new File(string).delete();
        }
        LinkedList linkedList = new LinkedList();
        linkedList.add(ZIP_COMMAND);
        linkedList.addAll(ZipCommand.getZipArgs());
        linkedList.add(string);
        linkedList.addAll(this.fFileNames);
        String string2 = "Failed to create zip archive.";
        this.fZipProcess = new ProcessWrapperImpl(this, linkedList.toArray(new String[linkedList.size()]), commandStatus, string2, null, file2 != null ? file2 : file, false);
        this.fZipProcess.execute();
        if (new File(string).exists() && bl) {
            long l = 0x80000000L;
            if (new File(MWUNZIPSFX).length() + new File(string).length() > l) {
                commandStatus.printErrorLine("The size of the zip archive is greater than the maximum allowed. Self extracting executable cannot be created for this archive. Left the zip archive in the destination folder. Run the _install.bat file to perform the installation steps.");
            } else {
                if (this.fTarget.exists()) {
                    this.fTarget.delete();
                }
                try {
                    this.fTarget.createNewFile();
                    this.fCopyProcess = new ProcessWrapperImpl(this, new String[]{"cmd.exe", "/C", "copy", "/B", "\"" + MWUNZIPSFX + "\"" + "+\"" + string + "\"", this.fTarget.getAbsolutePath()}, commandStatus, string2, null, file2 != null ? file2 : file, false);
                    this.fCopyProcess.execute();
                    this.fZipProcess = new ProcessWrapperImpl(this, new String[]{ZIP_COMMAND, "-A", this.fTarget.getAbsolutePath()}, commandStatus, string2, null, file2 != null ? file2 : file, false);
                    this.fZipProcess.execute();
                    new File(string).delete();
                }
                catch (IOException iOException) {
                    commandStatus.printErrorLine("Failed to create the executable. Left the zip archive in the destination folder.");
                }
            }
        }
        if (null != file2) {
            ZipCommand.deleteFolder(file2);
        }
        commandStatus.finished();
    }

    public static boolean deleteFolder(File file) {
        if (file.exists()) {
            File[] fileArray;
            for (File file2 : fileArray = file.listFiles()) {
                if (file2.isDirectory()) {
                    ZipCommand.deleteFolder(file2);
                    continue;
                }
                file2.delete();
            }
        }
        return file.delete();
    }

    public void cancel() {
        if (this.fCopyProcess != null) {
            this.fCopyProcess.cancel();
        }
        if (this.fZipProcess != null) {
            this.fZipProcess.cancel();
        }
    }

    private static List<String> getZipArgs() {
        LinkedList<String> linkedList = new LinkedList<String>();
        if (PlatformInfo.isWindows()) {
            Collections.addAll(linkedList, "-r", "-q");
        } else if (PlatformInfo.isMacintosh()) {
            Collections.addAll(linkedList, "-r", "-q", "-y", "-MM");
        } else {
            Collections.addAll(linkedList, "-r", "-q");
        }
        return linkedList;
    }
}

