/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.model;

import com.mathworks.mwswing.FilePatternFilter;
import com.mathworks.project.impl.model.FileSetDefinition;
import com.mathworks.project.impl.model.FileSetRule;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.filechooser.FileFilter;

public final class FileSetFilter
extends FileFilter
implements FilePatternFilter {
    private final String fDescription;
    private final List<FileSetRule> fRules;
    private boolean fAllowDirectories;

    public FileSetFilter(String string) {
        assert (string != null);
        this.fDescription = string;
        this.fRules = new ArrayList<FileSetRule>();
    }

    public void addRule(FileSetRule fileSetRule) {
        assert (fileSetRule != null);
        this.fRules.add(fileSetRule);
    }

    public void setAllowDirectories(boolean bl) {
        this.fAllowDirectories = bl;
    }

    @Override
    public boolean accept(File file) {
        return file.exists() && FileSetDefinition.allow(file, this.fRules, this.fAllowDirectories);
    }

    @Override
    public String getDescription() {
        return this.fDescription;
    }

    public String[] getPatterns() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (FileSetRule fileSetRule : this.fRules) {
            if (fileSetRule.getExpression() == null) continue;
            arrayList.add(fileSetRule.getExpression());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

