/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.model;

import com.mathworks.project.api.XmlWriter;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.model.LazyVariableGraphNode;
import com.mathworks.project.impl.model.Param;
import com.mathworks.project.impl.model.ParamSet;
import com.mathworks.project.impl.model.Profile;
import com.mathworks.project.impl.model.ProfileManager;
import com.mathworks.project.impl.model.VariableGraph;
import com.mathworks.util.ParameterRunnable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class LazyVariableGraph
implements VariableGraph,
ProfileManager {
    private final Map<String, LazyVariableGraphNode> fNodes;
    private final Map<String, Set<String>> fProfiles;
    private final PropertyChangeSupport fPropertySupport;
    private final Object fLock;
    private boolean fFrozen;
    private List<LazyVariableGraphNode> fRootLevelNodes;

    public LazyVariableGraph(List<ParamSet> list) {
        this.fPropertySupport = new PropertyChangeSupport(this);
        this.fLock = new Object();
        this.fNodes = new HashMap<String, LazyVariableGraphNode>();
        this.fRootLevelNodes = new LinkedList<LazyVariableGraphNode>();
        this.fProfiles = new HashMap<String, Set<String>>();
        for (ParamSet paramSet : list) {
            for (Param param : paramSet.getParams()) {
                Set<String> set = paramSet.getProfileKeys();
                if (!param.getProfileKeys().isEmpty()) {
                    set = param.getProfileKeys();
                }
                this.fProfiles.put(param.getKey(), set);
            }
        }
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("__selected_profile")) {
                    LazyVariableGraph.this.swapInProfile((Profile)propertyChangeEvent.getNewValue());
                }
            }
        });
    }

    public LazyVariableGraph(LazyVariableGraph lazyVariableGraph, LazyVariableGraphNode lazyVariableGraphNode) {
        this.fProfiles = lazyVariableGraph.fProfiles;
        this.fPropertySupport = null;
        this.fLock = lazyVariableGraph.fLock;
        this.fNodes = new HashMap<String, LazyVariableGraphNode>();
        this.fRootLevelNodes = new LinkedList<LazyVariableGraphNode>();
        HashSet<String> hashSet = new HashSet<String>();
        LazyVariableGraph.getInputs(lazyVariableGraphNode, hashSet);
        for (LazyVariableGraphNode lazyVariableGraphNode2 : lazyVariableGraph.getNodes(hashSet)) {
            this.fNodes.put(lazyVariableGraphNode2.getName(), lazyVariableGraphNode2);
        }
        this.freeze();
    }

    Object getLock() {
        return this.fLock;
    }

    @Override
    public boolean hasVariable(String string) {
        return this.fNodes.containsKey(string);
    }

    @Override
    public Set<String> getKeys() {
        return this.fNodes.keySet();
    }

    @Override
    public void swapInProfile(final Profile profile) {
        this.freeze();
        this.dfs(this.fRootLevelNodes, new HashSet<String>(), new ParameterRunnable<LazyVariableGraphNode>(){

            public void run(LazyVariableGraphNode lazyVariableGraphNode) {
                lazyVariableGraphNode.setProfile(profile);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void freeze() {
        Object object = this.fLock;
        synchronized (object) {
            if (!this.fFrozen) {
                this.fFrozen = true;
                this.fRootLevelNodes = new LinkedList<LazyVariableGraphNode>();
                for (LazyVariableGraphNode lazyVariableGraphNode : this.fNodes.values()) {
                    if (!lazyVariableGraphNode.getInputs().isEmpty()) continue;
                    this.fRootLevelNodes.add(lazyVariableGraphNode);
                }
            }
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.fPropertySupport.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.fPropertySupport.removePropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void setDefaultGenerator(String string, VariableGraph.Generator generator) {
        this.getNode(string).setDefaultGenerator(generator);
    }

    @Override
    public void setSerializer(String string, VariableGraph.XmlSerializer xmlSerializer) {
        this.getNode(string).setSerializer(xmlSerializer);
    }

    @Override
    public void addDependency(String string, String string2) {
        LazyVariableGraphNode lazyVariableGraphNode = this.getNode(string);
        LazyVariableGraphNode lazyVariableGraphNode2 = this.getNode(string2);
        lazyVariableGraphNode.addInput(lazyVariableGraphNode2);
        lazyVariableGraphNode2.addOutput(lazyVariableGraphNode);
    }

    @Override
    public boolean hasDependency(String string, String string2) {
        return this.getNode(string).hasInput(this.getNode(string2));
    }

    @Override
    public Set<String> getDependenciesOf(String string) {
        List<LazyVariableGraphNode> list = this.getNode(string).getInputs();
        return LazyVariableGraph.getNames(list);
    }

    @Override
    public Set<String> getAllAffectedVariables(String string) {
        List<LazyVariableGraphNode> list = this.getNode(string).getOutputs();
        return LazyVariableGraph.getNames(list);
    }

    @Override
    public String getXml(String string) {
        return this.getNode(string).getXml();
    }

    @Override
    public Object getValue(String string) {
        return this.getNode(string).getValue();
    }

    @Override
    public Object getExplicitValue(String string) {
        return this.getNode(string).getExplicitValue();
    }

    @Override
    public boolean isExplicitlySet(String string) {
        return this.getNode(string).isExplicitlySet();
    }

    @Override
    public void notifyPendingAsyncLoad(String string) {
    }

    @Override
    public void setDefaultValue(String string, Object object) {
        this.getNode(string).setDefaultValue(object);
    }

    @Override
    public void lock(String string, Object object) {
        this.getNode(string).lock(object);
    }

    @Override
    public void reset(String string) {
        this.getNode(string).reset();
    }

    public boolean isDormant(String string) {
        return this.getNode(string).isDormant();
    }

    public void forceLoadProfile() {
        Profile profile = (Profile)this.getValue("__selected_profile");
        for (LazyVariableGraphNode lazyVariableGraphNode : this.fNodes.values()) {
            LazyVariableGraphNode lazyVariableGraphNode2 = this.fNodes.get(Configuration.getBaseKey(lazyVariableGraphNode.getName()));
            if (lazyVariableGraphNode2 == null || lazyVariableGraphNode2.isExcludedFromProfile(profile.getKey())) continue;
            lazyVariableGraphNode.getValue();
        }
    }

    @Override
    public void setValue(String string, Object object) {
        this.getNode(string).setExplicitValue(object);
    }

    @Override
    public VariableGraph.Generator getDefaultGenerator(String string) {
        LazyVariableGraphNode lazyVariableGraphNode = this.fNodes.get(string);
        return lazyVariableGraphNode == null ? null : lazyVariableGraphNode.getDefaultGenerator();
    }

    @Override
    public Object getDefaultValue(String string, boolean bl) {
        if (!bl) {
            return this.getNode(string).getDefaultValueIfLoaded();
        }
        return this.getNode(string).getDefaultValue();
    }

    @Override
    public void writeAllXml(XmlWriter xmlWriter) {
        for (String string : this.getKeys()) {
            String string2 = this.getXml(string);
            if (string2 == null) continue;
            xmlWriter.writeXML(string2);
        }
    }

    @Override
    public void generateDefaults(Set<String> set) {
        List<LazyVariableGraphNode> list = this.getNodes(set);
        for (LazyVariableGraphNode lazyVariableGraphNode : list) {
            lazyVariableGraphNode.updateDefault(false, true);
        }
    }

    private LazyVariableGraphNode getNode(String string) {
        LazyVariableGraphNode lazyVariableGraphNode = this.fNodes.get(string);
        if (lazyVariableGraphNode == null) {
            if (this.fFrozen) {
                throw new IllegalStateException("Node not configured: " + string);
            }
            lazyVariableGraphNode = new LazyVariableGraphNode(this, string, this.fProfiles.get(string));
            this.fNodes.put(string, lazyVariableGraphNode);
        }
        return lazyVariableGraphNode;
    }

    void firePropertyChange(String string, Object object, Object object2) {
        this.fPropertySupport.firePropertyChange(string, object, object2);
    }

    void checkFrozen() {
        if (this.fFrozen) {
            throw new IllegalStateException();
        }
    }

    private static Set<String> getNames(Collection<LazyVariableGraphNode> collection) {
        HashSet<String> hashSet = new HashSet<String>();
        for (LazyVariableGraphNode lazyVariableGraphNode : collection) {
            hashSet.add(lazyVariableGraphNode.getName());
        }
        return hashSet;
    }

    private List<LazyVariableGraphNode> getNodes(Collection<String> collection) {
        LinkedList<LazyVariableGraphNode> linkedList = new LinkedList<LazyVariableGraphNode>();
        for (String string : collection) {
            linkedList.add(this.getNode(string));
        }
        return linkedList;
    }

    private void dfs(List<LazyVariableGraphNode> list, Set<String> set, ParameterRunnable<LazyVariableGraphNode> parameterRunnable) {
        for (LazyVariableGraphNode lazyVariableGraphNode : list) {
            if (set.add(lazyVariableGraphNode.getName())) {
                this.dfs(lazyVariableGraphNode.getOutputs(), set, parameterRunnable);
            }
            parameterRunnable.run((Object)lazyVariableGraphNode);
        }
    }

    private static void getInputs(LazyVariableGraphNode lazyVariableGraphNode, Set<String> set) {
        for (LazyVariableGraphNode lazyVariableGraphNode2 : lazyVariableGraphNode.getInputs()) {
            set.add(lazyVariableGraphNode2.getName());
            LazyVariableGraph.getInputs(lazyVariableGraphNode2, set);
        }
    }

    @Override
    public void loadingFinished() {
        Profile profile = (Profile)this.getValue("__selected_profile");
        if (profile != null) {
            this.swapInProfile(profile);
        }
    }

    @Override
    public boolean hasAnyProfileSupport(Param param) {
        return !this.fProfiles.get(param.getKey()).isEmpty();
    }

    @Override
    public boolean hasProfileSupport(Profile profile, Param param) {
        return this.fProfiles.get(param.getKey()).contains(profile.getKey());
    }

    @Override
    public boolean hasProfileValue(Profile profile, Param param) {
        return this.fNodes.get(param.getKey()).hasProfileValue(profile.getKey());
    }

    @Override
    public Object getProfileValue(Profile profile, Param param) {
        return this.fNodes.get(param.getKey()).getProfileValue(profile.getKey());
    }

    @Override
    public void setProfileValue(Profile profile, Param param, Object object) {
        this.fNodes.get(param.getKey()).restoreProfileValue(profile.getKey(), object);
    }

    @Override
    public Set<String> getVariablesWithPendingAsyncLoads() {
        return Collections.emptySet();
    }
}

