/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.model;

import com.mathworks.project.api.ReadableConfiguration;
import com.mathworks.project.api.XmlReader;
import com.mathworks.project.impl.model.DynamicTargetAttribute;
import com.mathworks.project.impl.model.EnumOptionExpression;
import com.mathworks.project.impl.model.FileSetFilter;
import com.mathworks.project.impl.model.InvalidParameterValueException;
import com.mathworks.project.impl.model.MatlabExpression;
import com.mathworks.project.impl.model.ParamType;
import com.mathworks.project.impl.model.Project;
import com.mathworks.project.impl.model.ProjectManager;
import com.mathworks.project.impl.model.ResourceStringProvider;
import com.mathworks.project.impl.model.XmlGenerationContext;
import com.mathworks.project.impl.model.XmlGenerationFlag;
import com.mathworks.project.impl.model.XslInput;
import com.mathworks.project.impl.settingsui.validation.ValidationRule;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public final class Param {
    private final ResourceStringProvider fResourceProvider;
    private final String fKey;
    private final String fName;
    private final String fDescription;
    private final String fDetailedDescriptionHtml;
    private final String fInstanceKey;
    private final String fInstanceName;
    private final String fMoreInfoLinkText;
    private final String fMoreInfoLinkCallback;
    private final ParamType fType;
    private final boolean fExcludeFromChecksum;
    private final boolean fLoadOptionsOnDemand;
    private final EnumOptionExpression fOptionExpression;
    private final MatlabExpression fDefaultValueExpression;
    private final boolean fShouldSaveUnsetValue;
    private final Map<String, String> fOptions;
    private final List<FileSetFilter> fFileFilters;
    private final String fCustomWidgetClass;
    private final boolean fExperimental;
    private final Map<String, String> fExtraAttributes;
    private final Map<String, String> fInfrastructureAttributes;
    private final Set<String> fProfileKeys;
    private final Set<String> fDependentKeys;
    private DynamicTargetAttribute fDefaultValue;
    private DynamicTargetAttribute fVisible;
    private DynamicTargetAttribute fEnabled;
    private DynamicTargetAttribute fSyntax;
    private DynamicTargetAttribute fMoreInfoLinkVisible;
    private ValidationRule fValidationRule;
    private String fToolboxToEnable;
    private boolean fFrozen;

    public Param(ParamType paramType, ResourceStringProvider resourceStringProvider, String string, String string2, String string3, String string4, String string5, String string6, DynamicTargetAttribute dynamicTargetAttribute, boolean bl, boolean bl2, String string7, String string8, EnumOptionExpression enumOptionExpression, MatlabExpression matlabExpression, DynamicTargetAttribute dynamicTargetAttribute2, Map<String, String> map, List<FileSetFilter> list, String string9, boolean bl3, DynamicTargetAttribute dynamicTargetAttribute3, DynamicTargetAttribute dynamicTargetAttribute4, DynamicTargetAttribute dynamicTargetAttribute5, ValidationRule validationRule, boolean bl4, Set<String> set, Map<String, String> map2, Map<String, String> map3, Set<String> set2) {
        this.fResourceProvider = resourceStringProvider;
        this.fKey = string;
        this.fName = string2;
        this.fDescription = string3;
        this.fDetailedDescriptionHtml = string4;
        this.fMoreInfoLinkText = string5;
        this.fMoreInfoLinkCallback = string6;
        this.fMoreInfoLinkVisible = dynamicTargetAttribute;
        this.fExcludeFromChecksum = bl;
        this.fLoadOptionsOnDemand = bl2;
        this.fInstanceKey = string7;
        this.fInstanceName = string8;
        this.fDefaultValueExpression = matlabExpression;
        this.fOptionExpression = enumOptionExpression;
        this.fType = paramType;
        this.fFileFilters = list == null ? new ArrayList<FileSetFilter>(0) : new ArrayList<FileSetFilter>(list);
        this.fOptions = map == null ? new LinkedHashMap<String, String>() : new LinkedHashMap<String, String>(map);
        this.fDefaultValue = dynamicTargetAttribute2;
        this.fCustomWidgetClass = string9;
        this.fVisible = dynamicTargetAttribute3;
        this.fShouldSaveUnsetValue = bl3;
        this.fEnabled = dynamicTargetAttribute4;
        this.fSyntax = dynamicTargetAttribute5;
        this.fValidationRule = validationRule;
        this.fExperimental = bl4;
        this.fExtraAttributes = new TreeMap<String, String>(map3);
        this.fInfrastructureAttributes = new TreeMap<String, String>(map2);
        this.fProfileKeys = new TreeSet<String>(set);
        this.fDependentKeys = new HashSet<String>(set2);
    }

    public void freeze() {
        this.fFrozen = true;
    }

    public ResourceStringProvider getResourceProvider() {
        return this.fResourceProvider;
    }

    public void setToolboxToEnable(String string) {
        if (this.fFrozen) {
            throw new IllegalStateException();
        }
        this.fToolboxToEnable = string;
    }

    public String getToolboxToEnable() {
        return this.fToolboxToEnable;
    }

    public void setDefaultValueAttribute(DynamicTargetAttribute dynamicTargetAttribute) {
        if (this.fFrozen) {
            throw new IllegalStateException();
        }
        this.fDefaultValue = dynamicTargetAttribute;
    }

    public DynamicTargetAttribute getDefaultValueAttribute() {
        return this.fDefaultValue;
    }

    public Set<String> getProfileKeys() {
        return new TreeSet<String>(this.fProfileKeys);
    }

    public boolean isExperimental() {
        return this.fExperimental;
    }

    public String getInstanceKey() {
        return this.fInstanceKey;
    }

    public String getInstanceName() {
        return this.fInstanceName;
    }

    public String getCustomWidgetClassName() {
        return this.fCustomWidgetClass;
    }

    public ParamType getType() {
        return this.fType;
    }

    public EnumOptionExpression getOptionExpression() {
        return this.fOptionExpression;
    }

    public MatlabExpression getDefaultValueExpression() {
        return this.fDefaultValueExpression;
    }

    public void setVisibleAttribute(DynamicTargetAttribute dynamicTargetAttribute) {
        if (this.fFrozen) {
            throw new IllegalStateException();
        }
        this.fVisible = dynamicTargetAttribute;
    }

    public DynamicTargetAttribute getVisibleAttribute() {
        return this.fVisible;
    }

    public void setEnabledAttribute(DynamicTargetAttribute dynamicTargetAttribute) {
        if (this.fFrozen) {
            throw new IllegalStateException();
        }
        this.fEnabled = dynamicTargetAttribute;
    }

    public DynamicTargetAttribute getEnabledAttribute() {
        return this.fEnabled;
    }

    public void setSyntax(DynamicTargetAttribute dynamicTargetAttribute) {
        if (this.fFrozen) {
            throw new IllegalStateException();
        }
        this.fSyntax = dynamicTargetAttribute;
    }

    public DynamicTargetAttribute getSyntax() {
        return this.fSyntax;
    }

    public ValidationRule getValidationRule() {
        return this.fValidationRule;
    }

    public boolean shouldSaveUnsetValue() {
        return this.fShouldSaveUnsetValue;
    }

    public boolean shouldLoadOptionsOnDemand() {
        return this.fLoadOptionsOnDemand;
    }

    public String getKey() {
        return this.fKey;
    }

    public String getName() {
        return this.fName;
    }

    public String getDescription() {
        return this.fDescription;
    }

    public String getDetailedDescriptionHtml() {
        return this.fDetailedDescriptionHtml;
    }

    public String getMoreInfoLinkText() {
        return this.fMoreInfoLinkText;
    }

    public String getMoreInfoLinkCallback() {
        return this.fMoreInfoLinkCallback;
    }

    public DynamicTargetAttribute getMoreInfoLinkVisible() {
        return this.fMoreInfoLinkVisible;
    }

    public boolean isExcludedFromChecksum() {
        return this.fExcludeFromChecksum;
    }

    public List<FileSetFilter> getFileFilters() {
        return new ArrayList<FileSetFilter>(this.fFileFilters);
    }

    public Map<String, String> getExtraAttributes() {
        return new TreeMap<String, String>(this.fExtraAttributes);
    }

    public Map<String, String> getInfrastructureAttributes() {
        return new TreeMap<String, String>(this.fInfrastructureAttributes);
    }

    public LinkedHashMap<String, String> getOptions() {
        return new LinkedHashMap<String, String>(this.fOptions);
    }

    public Object evaluate(Project project) {
        return this.evaluate(project, new XmlGenerationContext(new XmlGenerationFlag[0]));
    }

    public Object evaluate(Project project, XmlGenerationContext xmlGenerationContext) {
        Object object = project.getConfiguration().getSetParameterValue(this.fKey);
        if (object != null) {
            return object;
        }
        return this.evaluateDefault(project, xmlGenerationContext);
    }

    public Object evaluateDefault(Project project) {
        return this.evaluateDefault(project, new XmlGenerationContext(new XmlGenerationFlag[0]));
    }

    public Object evaluateDefault(Project project, XmlGenerationContext xmlGenerationContext) {
        if (this.fDefaultValue != null) {
            XmlReader xmlReader = null;
            try {
                XmlGenerationContext xmlGenerationContext2 = new XmlGenerationContext(xmlGenerationContext, this.fKey).withFlags(XmlGenerationFlag.EXCLUDE_BUILD_DELIVERABLES);
                String string = ProjectManager.configurationToXslInput(project, xmlGenerationContext2);
                xmlReader = this.fDefaultValue.evaluate(new XslInput((ReadableConfiguration)project.getConfiguration(), string));
                return this.fType.deserialize(project, this, xmlReader);
            }
            catch (InvalidParameterValueException invalidParameterValueException) {
                throw new IllegalStateException("The default parameter XSL for " + this.fKey + " generated the unacceptable result: " + xmlReader.getXML());
            }
        }
        return this.fType.getDefaultValue(this);
    }

    public String toString() {
        return this.fName;
    }

    public Set<String> getDependentKeys() {
        return this.fDependentKeys;
    }

    public Param stripMoreInfoCallback() {
        return new Param(this.fType, this.fResourceProvider, this.fKey, this.fName, this.fDescription, this.fDetailedDescriptionHtml, null, null, null, this.fExcludeFromChecksum, this.fLoadOptionsOnDemand, this.fInstanceKey, this.fInstanceName, this.fOptionExpression, this.fDefaultValueExpression, this.fDefaultValue, this.fOptions, this.fFileFilters, this.fCustomWidgetClass, this.fShouldSaveUnsetValue, this.fVisible, this.fEnabled, this.fSyntax, this.fValidationRule, this.fExperimental, this.fProfileKeys, this.fInfrastructureAttributes, this.fExtraAttributes, this.fDependentKeys);
    }
}

