/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.model;

import com.mathworks.project.api.ParamWidget;
import com.mathworks.project.api.ValidationMessage;
import com.mathworks.project.api.WarningState;
import com.mathworks.project.api.XmlReader;
import com.mathworks.project.api.XmlWriter;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.model.InvalidParameterValueException;
import com.mathworks.project.impl.model.Param;
import com.mathworks.project.impl.model.Project;
import com.mathworks.project.impl.model.ProjectManager;
import com.mathworks.project.impl.model.XmlGenerationContext;
import com.mathworks.project.impl.model.XmlGenerationFlag;
import com.mathworks.project.impl.settingsui.BooleanWidget;
import com.mathworks.project.impl.settingsui.DecimalToStringAdapter;
import com.mathworks.project.impl.settingsui.DirListWidget;
import com.mathworks.project.impl.settingsui.DirWidget;
import com.mathworks.project.impl.settingsui.EnumWidget;
import com.mathworks.project.impl.settingsui.EnumWidgetStyle;
import com.mathworks.project.impl.settingsui.FileListWidget;
import com.mathworks.project.impl.settingsui.FileOrDirWidget;
import com.mathworks.project.impl.settingsui.IntWidget;
import com.mathworks.project.impl.settingsui.ParamUtils;
import com.mathworks.project.impl.settingsui.StringListWidget;
import com.mathworks.project.impl.settingsui.StringWidget;
import com.mathworks.project.impl.settingsui.StringWidgetStyle;
import com.mathworks.project.impl.settingsui.WarningsWidget;
import com.mathworks.project.impl.settingsui.WatermarkedStringWidget;
import com.mathworks.project.impl.settingsui.validation.BasicTextValidator;
import com.mathworks.project.impl.settingsui.validation.NumericRule;
import java.awt.Component;
import java.io.File;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.event.ChangeListener;

public enum ParamType {
    BOOLEAN{

        @Override
        protected ParamWidget<?> createDefaultWidget(Param param, Project project, boolean bl) {
            return new BooleanWidget(param, project, bl);
        }

        @Override
        protected Boolean getDefaultValue(Param param) {
            return false;
        }

        @Override
        protected Object deserialize(Project project, Param param, XmlReader xmlReader) throws InvalidParameterValueException {
            String string = (String)super.deserialize(project, param, xmlReader);
            if (!string.equals("true") && !string.equals("false")) {
                throw new InvalidParameterValueException(param.getKey(), xmlReader);
            }
            return Boolean.valueOf(string);
        }
    }
    ,
    INT{

        @Override
        protected ParamWidget<?> createDefaultWidget(Param param, Project project, boolean bl) {
            int n = ParamUtils.getIntParamMin(param);
            int n2 = ParamUtils.getIntParamMax(param);
            return new IntWidget(param, project, n, n2);
        }

        @Override
        protected Integer getDefaultValue(Param param) {
            return 0;
        }

        @Override
        protected Object deserialize(Project project, Param param, XmlReader xmlReader) throws InvalidParameterValueException {
            String string = (String)super.deserialize(project, param, xmlReader);
            try {
                return new Integer(string);
            }
            catch (Exception exception) {
                throw new InvalidParameterValueException(param.getKey(), xmlReader);
            }
        }
    }
    ,
    DECIMAL{

        @Override
        protected ParamWidget<?> createDefaultWidget(Param param, Project project, boolean bl) {
            int n = ParamUtils.getIntParamMin(param);
            int n2 = ParamUtils.getIntParamMax(param);
            StringWidget stringWidget = new StringWidget(param.getKey(), param.getDescription(), 1, ParamUtils.getStringParamColumns(param), false, true, param, project);
            new BasicTextValidator(stringWidget.getField(), new NumericRule(n, n2, true, null));
            return new DecimalToStringAdapter(stringWidget);
        }

        @Override
        protected BigDecimal getDefaultValue(Param param) {
            return BigDecimal.ZERO;
        }

        @Override
        protected Object deserialize(Project project, Param param, XmlReader xmlReader) throws InvalidParameterValueException {
            String string = (String)super.deserialize(project, param, xmlReader);
            try {
                return new BigDecimal(string);
            }
            catch (Exception exception) {
                throw new InvalidParameterValueException(param.getKey(), xmlReader);
            }
        }
    }
    ,
    STRING{

        @Override
        protected ParamWidget<?> createDefaultWidget(Param param, Project project, boolean bl) {
            int n = ParamUtils.getStringParamLines(param);
            int n2 = ParamUtils.getStringParamColumns(param);
            boolean bl2 = Configuration.isAlwaysDisabled(param);
            if (!bl2) {
                StringWidgetStyle stringWidgetStyle = ParamUtils.getStringWidgetStyle(param);
                if (stringWidgetStyle == StringWidgetStyle.FILE_SELECTOR) {
                    return new StringWidgetWrapper(new FileOrDirWidget(param, project, param.getFileFilters()));
                }
                if (stringWidgetStyle == StringWidgetStyle.DIR_SELECTOR) {
                    return new StringWidgetWrapper(new FileOrDirWidget(param, project, true));
                }
                if (stringWidgetStyle == StringWidgetStyle.WATERMARK) {
                    return new WatermarkedStringWidget(param.getKey(), param.getDescription(), n, n2, bl2, bl, param, project);
                }
            }
            return new StringWidget(param.getKey(), param.getDescription(), n, n2, bl2, bl, param, project);
        }

        @Override
        protected String getDefaultValue(Param param) {
            return ParamUtils.getStringWidgetStyle(param) == StringWidgetStyle.WATERMARK ? "" : null;
        }
    }
    ,
    STRING_LIST{

        @Override
        protected ParamWidget<?> createDefaultWidget(Param param, Project project, boolean bl) {
            StringWidgetStyle stringWidgetStyle = ParamUtils.getStringWidgetStyle(param);
            if (stringWidgetStyle == StringWidgetStyle.FILE_SELECTOR) {
                return new StringListWidgetWrapper(new FileListWidget(param, project));
            }
            if (stringWidgetStyle == StringWidgetStyle.DIR_SELECTOR) {
                return new StringListWidgetWrapper(new DirListWidget(param, project));
            }
            return new StringListWidget(param, project);
        }

        @Override
        protected List<String> getDefaultValue(Param param) {
            return new ArrayList<String>(0);
        }

        @Override
        protected void serialize(Project project, Param param, Object object, XmlWriter xmlWriter, boolean bl) {
            xmlWriter.writeText("item", ((Collection)object).toArray());
        }

        @Override
        protected Object deserialize(Project project, Param param, XmlReader xmlReader) throws InvalidParameterValueException {
            return Arrays.asList(xmlReader.readTextList("item"));
        }
    }
    ,
    ENUM{

        @Override
        protected ParamWidget<?> createDefaultWidget(Param param, Project project, boolean bl) {
            EnumWidgetStyle enumWidgetStyle = ParamUtils.getEnumWidgetStyle(param);
            return new EnumWidget(enumWidgetStyle, param, bl, project);
        }

        @Override
        protected Object getDefaultValue(Param param) {
            return !param.getOptions().isEmpty() ? param.getOptions().keySet().iterator().next() : null;
        }

        @Override
        protected Object deserialize(Project project, Param param, XmlReader xmlReader) throws InvalidParameterValueException {
            String string = (String)super.deserialize(project, param, xmlReader);
            if (param.getOptionExpression() != null) {
                return string;
            }
            for (Map.Entry<String, String> entry : param.getOptions().entrySet()) {
                if (!entry.getKey().equals(string)) continue;
                return entry.getKey();
            }
            throw new InvalidParameterValueException(param.getKey(), xmlReader);
        }
    }
    ,
    FILE{

        @Override
        protected ParamWidget<?> createDefaultWidget(Param param, Project project, boolean bl) {
            return new FileOrDirWidget(param, project, param.getFileFilters());
        }

        @Override
        protected void serialize(Project project, Param param, Object object, XmlWriter xmlWriter, boolean bl) {
            xmlWriter.writeText((Object)ProjectManager.fileToRelativeLocation(project.getFile(), (File)object, bl ? new XmlGenerationContext(XmlGenerationFlag.USE_FILE_ALIASES) : new XmlGenerationContext(new XmlGenerationFlag[0])));
        }

        @Override
        protected Object deserialize(Project project, Param param, XmlReader xmlReader) throws InvalidParameterValueException {
            String string = (String)super.deserialize(project, param, xmlReader);
            return ProjectManager.relativeLocationToFile(project.getFile(), string);
        }
    }
    ,
    FILE_LIST{

        @Override
        protected ParamWidget<?> createDefaultWidget(Param param, Project project, boolean bl) {
            return new FileListWidget(param, project);
        }

        @Override
        protected Object getDefaultValue(Param param) {
            return new ArrayList(0);
        }

        @Override
        protected void serialize(Project project, Param param, Object object, XmlWriter xmlWriter, boolean bl) {
            for (Object e : (List)object) {
                xmlWriter.createElement("file").writeText((Object)ProjectManager.fileToRelativeLocation(project.getFile(), (File)e, bl ? new XmlGenerationContext(XmlGenerationFlag.USE_FILE_ALIASES) : new XmlGenerationContext(new XmlGenerationFlag[0])));
            }
        }

        @Override
        protected Object deserialize(Project project, Param param, XmlReader xmlReader) throws InvalidParameterValueException {
            ArrayList<File> arrayList = new ArrayList<File>();
            for (String string : xmlReader.readTextList("file")) {
                arrayList.add(ProjectManager.relativeLocationToFile(project.getFile(), string));
            }
            return arrayList;
        }
    }
    ,
    DIR{

        @Override
        protected ParamWidget<?> createDefaultWidget(Param param, Project project, boolean bl) {
            return new FileOrDirWidget(param, project, true);
        }

        @Override
        protected void serialize(Project project, Param param, Object object, XmlWriter xmlWriter, boolean bl) {
            FILE.serialize(project, param, object, xmlWriter, bl);
        }

        @Override
        protected Object deserialize(Project project, Param param, XmlReader xmlReader) throws InvalidParameterValueException {
            return FILE.deserialize(project, param, xmlReader);
        }
    }
    ,
    OUT_DIR{

        @Override
        protected ParamWidget<?> createDefaultWidget(Param param, Project project, boolean bl) {
            return new DirWidget(param, project, true);
        }

        @Override
        protected void serialize(Project project, Param param, Object object, XmlWriter xmlWriter, boolean bl) {
            FILE.serialize(project, param, object, xmlWriter, bl);
        }

        @Override
        protected Object deserialize(Project project, Param param, XmlReader xmlReader) throws InvalidParameterValueException {
            return FILE.deserialize(project, param, xmlReader);
        }
    }
    ,
    DIR_LIST{

        @Override
        protected ParamWidget<?> createDefaultWidget(Param param, Project project, boolean bl) {
            return new DirListWidget(param, project);
        }

        @Override
        protected Object getDefaultValue(Param param) {
            return FILE_LIST.getDefaultValue(param);
        }

        @Override
        protected void serialize(Project project, Param param, Object object, XmlWriter xmlWriter, boolean bl) {
            FILE_LIST.serialize(project, param, object, xmlWriter, bl);
        }

        @Override
        protected Object deserialize(Project project, Param param, XmlReader xmlReader) throws InvalidParameterValueException {
            return FILE_LIST.deserialize(project, param, xmlReader);
        }
    }
    ,
    WARNINGS{

        @Override
        protected ParamWidget<?> createDefaultWidget(Param param, Project project, boolean bl) {
            String string = param.getInfrastructureAttributes().get("desc");
            if (string != null) {
                string = param.getResourceProvider().getResource(string);
            }
            return new WarningsWidget(param.getKey(), string, param.getOptions(), (Map)param.evaluateDefault(project));
        }

        @Override
        protected Object getDefaultValue(Param param) {
            LinkedHashMap<String, WarningState> linkedHashMap = new LinkedHashMap<String, WarningState>();
            for (String string : param.getOptions().keySet()) {
                linkedHashMap.put(string, WarningState.ON);
            }
            return linkedHashMap;
        }

        @Override
        protected void serialize(Project project, Param param, Object object, XmlWriter xmlWriter, boolean bl) {
            for (Map.Entry entry : ((Map)object).entrySet()) {
                xmlWriter.createElement(entry.getKey().toString()).writeText((Object)entry.getValue().toString().toLowerCase(Locale.ENGLISH));
            }
        }

        @Override
        protected Object deserialize(Project project, Param param, XmlReader xmlReader) throws InvalidParameterValueException {
            Map map = (Map)this.getDefaultValue(param);
            XmlReader xmlReader2 = xmlReader.getChild(new String[0]);
            while (xmlReader2.isPresent()) {
                String string = xmlReader2.getCurrentElementName();
                String string2 = xmlReader2.readText().trim();
                if (string == null || !param.getOptions().containsKey(string)) {
                    throw new InvalidParameterValueException(param.getKey(), xmlReader);
                }
                try {
                    WarningState warningState = WarningState.ON;
                    if (string2.trim().length() > 0) {
                        warningState = WarningState.valueOf((String)string2.toUpperCase(Locale.ENGLISH));
                    }
                    map.put(string, warningState);
                }
                catch (Exception exception) {
                    throw new InvalidParameterValueException(param.getKey(), xmlReader);
                }
                xmlReader2 = xmlReader2.next();
            }
            return map;
        }

        @Override
        public boolean isEqual(Object object, Object object2) {
            assert (object instanceof Map);
            assert (object2 instanceof Map);
            return new TreeMap((Map)object).equals(new TreeMap((Map)object2));
        }
    }
    ,
    VERSION{

        @Override
        protected ParamWidget<?> createDefaultWidget(Param param, Project project, boolean bl) {
            return null;
        }
    }
    ,
    CUSTOM{

        @Override
        protected ParamWidget<?> createDefaultWidget(Param param, Project project, boolean bl) {
            throw new IllegalStateException("A param of type 'custom' must have a custom widget class.");
        }

        @Override
        public boolean isEqual(Object object, Object object2) {
            assert (object instanceof XmlReader);
            assert (object2 instanceof XmlReader);
            return ((XmlReader)object).getXML().equals(((XmlReader)object2).getXML());
        }

        @Override
        protected void serialize(Project project, Param param, Object object, XmlWriter xmlWriter, boolean bl) {
            if (object == null) {
                xmlWriter.writeText((Object)"");
            } else {
                xmlWriter.writeXML(((XmlReader)object).getXML());
            }
        }

        @Override
        protected Object deserialize(Project project, Param param, XmlReader xmlReader) throws InvalidParameterValueException {
            return xmlReader.getChild(new String[0]);
        }
    };


    public ParamWidget<?> createWidget(Param param, Project project, boolean bl) {
        if (param.getCustomWidgetClassName() != null) {
            return ParamType.createCustomWidget(param, project);
        }
        return this.createDefaultWidget(param, project, bl);
    }

    protected abstract ParamWidget<?> createDefaultWidget(Param var1, Project var2, boolean var3);

    protected Object getDefaultValue(Param param) {
        return null;
    }

    protected void serialize(Project project, Param param, Object object, XmlWriter xmlWriter, boolean bl) {
        xmlWriter.writeText(object);
    }

    protected Object deserialize(Project project, Param param, XmlReader xmlReader) throws InvalidParameterValueException {
        String string = xmlReader.readText();
        if (string == null) {
            throw new InvalidParameterValueException(param.getKey(), xmlReader);
        }
        return string.trim();
    }

    public boolean isEqual(Object object, Object object2) {
        return object == null && object2 == null || object != null && object2 != null && object.equals(object2);
    }

    private static ParamWidget<?> createCustomWidget(Param param, Project project) {
        try {
            Object obj;
            Class<?> clazz = Class.forName(param.getCustomWidgetClassName());
            try {
                Constructor<?> constructor = clazz.getConstructor(Param.class, Project.class);
                obj = constructor.newInstance(param, project);
            }
            catch (Exception exception) {
                obj = clazz.newInstance();
            }
            if (!(obj instanceof ParamWidget)) {
                throw new IllegalArgumentException("Custom widget class does not implement ParamWidget: " + param.getCustomWidgetClassName());
            }
            return (ParamWidget)obj;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException("Custom widget class does not exist: " + param.getCustomWidgetClassName(), classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalArgumentException("Custom widget class could not be instantiated: " + param.getCustomWidgetClassName(), instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException("Custom widget class could not be accessed: " + param.getCustomWidgetClassName(), illegalAccessException);
        }
    }

    public boolean isSimple() {
        switch (this) {
            case BOOLEAN: 
            case INT: 
            case STRING: 
            case ENUM: 
            case FILE: 
            case DIR: 
            case DECIMAL: {
                return true;
            }
            case STRING_LIST: 
            case FILE_LIST: 
            case OUT_DIR: 
            case DIR_LIST: 
            case WARNINGS: 
            case CUSTOM: {
                return false;
            }
        }
        throw new IllegalStateException("Type not accounted for: " + (Object)((Object)this));
    }

    public boolean isFinite() {
        switch (this) {
            case BOOLEAN: {
                return true;
            }
            case ENUM: {
                return true;
            }
        }
        return false;
    }

    private static class StringListWidgetWrapper
    extends WidgetWrapper<List<File>, List<String>> {
        StringListWidgetWrapper(ParamWidget<List<File>> paramWidget) {
            super(paramWidget);
        }

        public List<String> getData() {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (File file : (List)this.fRealWidget.getData()) {
                arrayList.add(file.toString());
            }
            return arrayList;
        }

        public void setData(List<String> list) {
            ArrayList<File> arrayList = new ArrayList<File>();
            for (String string : list) {
                arrayList.add(new File(string));
            }
            this.fRealWidget.setData(arrayList);
        }
    }

    private static class StringWidgetWrapper
    extends WidgetWrapper<File, String> {
        StringWidgetWrapper(ParamWidget<File> paramWidget) {
            super(paramWidget);
        }

        public String getData() {
            File file = (File)this.fRealWidget.getData();
            return file == null ? null : file.toString();
        }

        public void setData(String string) {
            this.fRealWidget.setData((Object)(string == null ? null : new File(string)));
        }
    }

    protected static abstract class WidgetWrapper<WrappedType, ExposedType>
    implements ParamWidget<ExposedType> {
        protected final ParamWidget<WrappedType> fRealWidget;

        WidgetWrapper(ParamWidget<WrappedType> paramWidget) {
            this.fRealWidget = paramWidget;
        }

        public void setEnabled(boolean bl) {
            this.fRealWidget.setEnabled(bl);
        }

        public boolean isExternalLabelRequired() {
            return this.fRealWidget.isExternalLabelRequired();
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.fRealWidget.addChangeListener(changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.fRealWidget.removeChangeListener(changeListener);
        }

        public boolean showValidationMessage(ValidationMessage validationMessage) {
            return this.fRealWidget.showValidationMessage(validationMessage);
        }

        public void clearValidationMessage() {
            this.fRealWidget.clearValidationMessage();
        }

        public Component getComponent() {
            return this.fRealWidget.getComponent();
        }

        public void dispose() {
            this.fRealWidget.dispose();
        }
    }
}

