/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.settingsui;

import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RescaleOp;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public final class SettingsPaintingUtils {
    private SettingsPaintingUtils() {
    }

    public static Icon rotate(GeneralPath generalPath, Color color, double d, boolean bl, boolean bl2) {
        Rectangle rectangle = generalPath.getBounds();
        int n = (int)rectangle.getWidth();
        int n2 = (int)rectangle.getHeight();
        if (bl2) {
            int n3;
            n = n3 = (int)Math.sqrt(rectangle.getWidth() * rectangle.getWidth() + rectangle.getHeight() * rectangle.getHeight()) + 1;
            n2 = n3;
        }
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setTransform(AffineTransform.getRotateInstance(d, rectangle.getWidth() / 2.0, rectangle.getHeight() / 2.0));
        graphics2D.setColor(color);
        if (bl) {
            graphics2D.fill(generalPath);
        } else {
            graphics2D.draw(generalPath);
        }
        graphics2D.dispose();
        return new ImageIcon(bufferedImage);
    }

    public static String trim(Graphics2D graphics2D, String string, int n) {
        String string2 = string;
        Font font = graphics2D.getFont();
        for (int i = 1; i <= string.length() && font.getStringBounds(string2, graphics2D.getFontRenderContext()).getWidth() >= (double)n; ++i) {
            string2 = string.substring(0, string.length() - i) + "...";
        }
        return string2;
    }

    public static Rectangle2D[] splitVertically(Rectangle2D rectangle2D) {
        return new Rectangle2D[]{new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight() / 2.0), new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY() + rectangle2D.getHeight() / 2.0, rectangle2D.getWidth(), rectangle2D.getHeight() / 2.0)};
    }

    public static void gradientFill(Graphics2D graphics2D, Rectangle2D rectangle2D, Color color, Color color2, Color color3, Color color4) {
        Rectangle2D[] rectangle2DArray = SettingsPaintingUtils.splitVertically(rectangle2D);
        graphics2D.setPaint(new GradientPaint(new Point2D.Double(0.0, rectangle2DArray[0].getY()), color, new Point2D.Double(0.0, rectangle2DArray[0].getY() + rectangle2DArray[0].getHeight() - 1.0), color2));
        graphics2D.fill(rectangle2DArray[0]);
        graphics2D.setPaint(new GradientPaint(new Point2D.Double(0.0, rectangle2DArray[1].getY()), color3, new Point2D.Double(0.0, rectangle2DArray[1].getY() + rectangle2DArray[1].getHeight() - 1.0), color4));
        graphics2D.fill(rectangle2DArray[1]);
    }

    public static void drawBorder(Graphics2D graphics2D, Rectangle2D rectangle2D, Color color, boolean bl) {
        graphics2D.setColor(color);
        Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getX() - 1.0, bl ? rectangle2D.getY() : rectangle2D.getY() - 1.0, rectangle2D.getWidth() + 2.0, bl ? rectangle2D.getHeight() - 1.0 : rectangle2D.getHeight());
        graphics2D.draw(double_);
    }

    public static Icon makeDarkIcon(Icon icon) {
        BufferedImage bufferedImage = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        BufferedImage bufferedImage2 = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        icon.paintIcon(null, graphics2D, 0, 0);
        graphics2D.dispose();
        RescaleOp rescaleOp = new RescaleOp(new float[]{0.6f, 0.6f, 0.6f, 1.0f}, new float[4], null);
        Graphics2D graphics2D2 = bufferedImage2.createGraphics();
        graphics2D2.drawImage(bufferedImage, rescaleOp, 0, 0);
        graphics2D2.dispose();
        return new ImageIcon(bufferedImage2);
    }
}

