/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.table;

import com.mathworks.mwswing.ComponentUtils;
import com.mathworks.mwswing.FontUtils;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.project.api.ProjectComponent;
import com.mathworks.project.impl.ProjectGUI;
import com.mathworks.project.impl.table.CellPredicate;
import com.mathworks.project.impl.table.ClickSensitiveCellEditor;
import com.mathworks.project.impl.table.DefaultPropertyTablePainter;
import com.mathworks.project.impl.table.MacPropertyTablePainter;
import com.mathworks.project.impl.table.MutablePaintContext;
import com.mathworks.project.impl.table.PropertyTableCellEditor;
import com.mathworks.project.impl.table.PropertyTableCellEditorFactory;
import com.mathworks.project.impl.table.PropertyTableColumn;
import com.mathworks.project.impl.table.PropertyTableColumnModel;
import com.mathworks.project.impl.table.PropertyTableContextMenuCustomizer;
import com.mathworks.project.impl.table.PropertyTableDecorator;
import com.mathworks.project.impl.table.PropertyTableHighlighter;
import com.mathworks.project.impl.table.PropertyTableModel;
import com.mathworks.project.impl.table.PropertyTablePainter;
import com.mathworks.project.impl.table.SelectionModel;
import com.mathworks.project.impl.table.VirtualComponentManager;
import com.mathworks.project.impl.textfield.FormatTip;
import com.mathworks.project.impl.textfield.FormattedTextField;
import com.mathworks.project.impl.util.StringUtils;
import com.mathworks.util.Converter;
import com.mathworks.util.Holder;
import com.mathworks.util.Pair;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.Predicate;
import com.mathworks.util.RequestFilter;
import com.mathworks.util.tree.TreeUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.Scrollable;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.RowSorterEvent;
import javax.swing.event.RowSorterListener;
import javax.swing.table.JTableHeader;
import javax.swing.text.JTextComponent;

public final class PropertyTable<T>
implements ProjectComponent {
    private final PropertyTableModel<T> fModel;
    private final PropertyTablePainter<T> fPainter;
    private final PropertyTableCellEditorFactory<T> fCellEditorFactory;
    private final TableComponent fTable;
    private final PropertyTableColumnModel<T> fColumnModel;
    private final Map<PropertyTableHighlighter<T>, Double> fHighlighters;
    private final List<DataChange> fDataChanges;
    private final JTableHeader fHeader;
    private final MJScrollPane fScrollPane;
    private final VirtualComponentManager fVirtualComponentManager;
    private final PropertyChangeListener fFocusOwnerListener;
    private final KeyboardFocusManager fKeyboardFocusManager;
    private final SelectionModel fSelectionModel;
    private Timer fDataChangeTimer;
    private PropertyTableContextMenuCustomizer fContextMenuCustomizer;
    private CellPredicate fDefaultPredicate;
    private ParameterRunnable<Integer> fDeleteHandler;
    private ParameterRunnable<T> fClickAction;
    private JTable fProxyTable;
    private boolean fSortable;
    private boolean fVetoStopEditing;
    private boolean fDividerLocationsInitialized;
    private boolean fFoldInLastColumnWhenInitialized;
    private boolean fAllowSelectingExpandableRows;
    private boolean fKeepEditorAlive;
    private boolean fAutoSelectEditableCell;
    private boolean fEnabled = true;
    private boolean fNotifyingStructureChanged;
    private boolean fRowAsExpander;
    private double[] fColumnWeights;
    private int fPressedExpanderRow = -1;
    private int fMovingExpanderPhase;
    private int fMovingExpanderRow = -1;
    private int fCurrentDividerIndex = -1;
    private int fScrollPaneAdjustment;
    private int fActiveAdjustmentIndex;
    private Integer fLastLineHeight;
    private Integer fPreferredWidth;
    private Integer fLastLineCount;
    private PropertyTableCellEditor<T> fCurrentCellEditor;
    private T fCurrentEditingValue;
    private int fCurrentEditingRow;
    private int fCurrentEditingColumn;
    private int fLeftDragLimit;
    private int fRightDragLimit;
    private boolean fPreferToShowAllRows;
    private PropertyTableColumnModel<T> fTemporaryColumnModel;
    private boolean fOverrideStopEditingOnFocusLost;
    private ParameterRunnable<KeyEvent> fCopyAction;
    private ParameterRunnable<KeyEvent> fPasteAction;
    private static final String NO_STRETCH_PROPERTY = "SettingsTable.NoStretch";
    public static final String CELL_EDITOR_DIALOG = "PropertyTable-cell-editor-dialog";
    private static final int MIN_WIDTH = 100;
    public static final String TABLE_CLIENT_PROPERTY = "PropertyTable.Table";
    public static final Predicate<Component> COMPONENT_PREDICATE = TreeUtils.instanceOf(TableComponent.class);
    public static final Predicate<Component> NO_STRETCH_COMPONENT_PREDICATE = new Predicate<Component>(){

        public boolean accept(Component component) {
            return COMPONENT_PREDICATE.accept((Object)component) && ((JComponent)component).getClientProperty(PropertyTable.NO_STRETCH_PROPERTY) == Boolean.TRUE;
        }
    };

    public PropertyTable(PropertyTableModel<T> propertyTableModel) {
        this(propertyTableModel, new PropertyTableCellEditorFactory<T>(){

            @Override
            public PropertyTableCellEditor<T> createWidget(PropertyTable<T> propertyTable, int n, int n2, T t) {
                return null;
            }
        });
    }

    public PropertyTable(PropertyTableModel<T> propertyTableModel, PropertyTableCellEditorFactory<T> propertyTableCellEditorFactory) {
        this.fModel = propertyTableModel;
        this.fSelectionModel = new SelectionModel(new Predicate<Integer>(){

            public boolean accept(Integer n) {
                return PropertyTable.this.isRowSelectable(n);
            }
        });
        this.fDataChanges = new ArrayList<DataChange>();
        this.fPainter = PlatformInfo.isMacintosh() ? new MacPropertyTablePainter() : new DefaultPropertyTablePainter();
        this.fCellEditorFactory = propertyTableCellEditorFactory;
        this.fAutoSelectEditableCell = true;
        this.fTable = new TableComponent();
        this.fHighlighters = new LinkedHashMap<PropertyTableHighlighter<T>, Double>();
        this.fColumnModel = new PropertyTableColumnModel<T>(this, propertyTableModel.getColumns(), (JComponent)((Object)this.fTable));
        this.fVirtualComponentManager = new VirtualComponentManager((JComponent)((Object)this.fTable));
        this.initializeMetrics();
        this.fProxyTable = new JTable(1, this.fModel.getColumnCount());
        this.fProxyTable.setColumnModel(this.fColumnModel);
        this.fHeader = this.fProxyTable.getTableHeader();
        this.fColumnModel.setHeader(this.fHeader);
        this.fHeader.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (!PlatformInfo.isMacintosh()) {
                    this.handleMenu(mouseEvent);
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (PlatformInfo.isMacintosh()) {
                    this.handleMenu(mouseEvent);
                }
            }

            private void handleMenu(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 1 && !SwingUtilities.isLeftMouseButton(mouseEvent) && PropertyTable.this.fContextMenuCustomizer != null) {
                    int n = PropertyTable.this.getColumnAtPoint(mouseEvent.getPoint());
                    MJPopupMenu mJPopupMenu = new MJPopupMenu();
                    mJPopupMenu.setName("PropertyTable.contextMenu");
                    int n2 = mJPopupMenu.getComponentCount();
                    PropertyTable.this.fContextMenuCustomizer.customize(mJPopupMenu, -1, n);
                    if (mJPopupMenu.getComponentCount() > n2) {
                        mJPopupMenu.show((Component)PropertyTable.this.fHeader, mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            }
        });
        this.fColumnWeights = new double[this.fModel.getColumnCount() - 1];
        Arrays.fill(this.fColumnWeights, 1.0 / (double)this.fModel.getColumnCount());
        this.fScrollPane = new MJScrollPane((Component)((Object)this.fTable)){

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                return new Dimension((int)(dimension.getWidth() + (double)PropertyTable.this.fScrollPaneAdjustment), (int)dimension.getHeight());
            }
        };
        this.fScrollPane.setBorder(null);
        this.fScrollPane.setColumnHeaderView((Component)this.fHeader);
        this.fScrollPane.setCorner("UPPER_RIGHT_CORNER", (Component)((Object)new CornerComponent()));
        this.fKeyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        this.fFocusOwnerListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (PropertyTable.this.isFocusOutOfTable()) {
                    Timer timer = new Timer(500, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            if (!PropertyTable.this.fOverrideStopEditingOnFocusLost && PropertyTable.this.isFocusOutOfTable() && !PropertyTable.this.fKeepEditorAlive) {
                                PropertyTable.this.stopEditing(false, false);
                                PropertyTable.this.fTable.revalidate();
                                PropertyTable.this.fTable.repaint();
                            }
                        }
                    });
                    timer.setRepeats(false);
                    timer.start();
                }
            }
        };
        this.fTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                PropertyTable.this.fTable.requestFocus();
                int n = PropertyTable.this.getRowAtPoint(mouseEvent.getPoint());
                int n2 = PropertyTable.this.getColumnAtPoint(mouseEvent.getPoint());
                JComponent jComponent = null;
                if (n >= 0 && n < PropertyTable.this.fModel.getRowCount()) {
                    if (PropertyTable.this.isOnExpander(mouseEvent.getPoint(), n)) {
                        if (PlatformInfo.isMacintosh()) {
                            PropertyTable.this.fPressedExpanderRow = n;
                            PropertyTable.this.fTable.revalidate();
                            PropertyTable.this.fTable.repaint();
                        } else {
                            PropertyTable.this.startExpandOrCollapse(n);
                        }
                    } else {
                        if (n >= 0 && n2 >= 0 && (jComponent = PropertyTable.this.fModel.getColumnLink(n, n2)) != null && jComponent.isEnabled() && jComponent.getBounds().contains(mouseEvent.getPoint())) {
                            jComponent.dispatchEvent(mouseEvent);
                            return;
                        }
                        if (PropertyTable.this.isRowSelectable(n) && (PropertyTable.this.fPainter.getGridLineWidth() == 0 || PropertyTable.this.getDividerIndex(mouseEvent.getX()) == -1)) {
                            if (PropertyTable.this.fCurrentCellEditor != null && PropertyTable.this.fCurrentEditingValue != PropertyTable.this.fModel.getValue(n, n2)) {
                                PropertyTable.this.stopEditing(false);
                            }
                            if (mouseEvent.getButton() != 1) {
                                if (PropertyTable.this.fSelectionModel.getSelectedRowCount() <= 1) {
                                    PropertyTable.this.fSelectionModel.select(n);
                                }
                            } else {
                                PropertyTable.this.fSelectionModel.mousePressed(n, PropertyTable.this.isControlDown(mouseEvent), mouseEvent.isShiftDown());
                            }
                            if (!(PlatformInfo.isMacintosh() || mouseEvent.getButton() != 1 || PropertyTable.this.isControlDown(mouseEvent) || mouseEvent.isShiftDown())) {
                                int n3 = n2;
                                if (!PropertyTable.this.fModel.isColumnEditable(n3) && PropertyTable.this.fAutoSelectEditableCell) {
                                    ++n3;
                                }
                                if (n2 >= 0 && n3 < PropertyTable.this.getActiveColumnModel().getColumnCount() && PropertyTable.this.fModel.isColumnEditable(n3) && PropertyTable.this.isEnabled(n, n3)) {
                                    Point point = mouseEvent.getPoint();
                                    SwingUtilities.convertPointToScreen(point, (Component)mouseEvent.getSource());
                                    PropertyTable.this.startEditing(n, n3, point, !PropertyTable.this.fModel.isColumnEditable(n2));
                                }
                            }
                        }
                    }
                }
                if (PlatformInfo.isMacintosh() && mouseEvent.getButton() == 1) {
                    PropertyTable.this.showMacValueDropdownIfApplicable(n, PropertyTable.this.getColumnAtPoint(mouseEvent.getPoint()));
                } else if (PlatformInfo.isMacintosh() && mouseEvent.getClickCount() == 1 && PropertyTable.this.fContextMenuCustomizer != null && n > -1 && n2 > -1) {
                    this.handleContextMenu(mouseEvent, n, n2);
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                int n = PropertyTable.this.getRowAtPoint(mouseEvent.getPoint());
                if (PlatformInfo.isMacintosh() && n >= 0 && n < PropertyTable.this.fModel.getRowCount() && PropertyTable.this.isOnExpander(mouseEvent.getPoint(), n)) {
                    PropertyTable.this.fPressedExpanderRow = -1;
                    PropertyTable.this.fTable.revalidate();
                    PropertyTable.this.fTable.repaint();
                    PropertyTable.this.startExpandOrCollapse(n);
                }
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                Serializable serializable;
                int n = PropertyTable.this.getRowAtPoint(mouseEvent.getPoint());
                int n2 = PropertyTable.this.getColumnAtPoint(mouseEvent.getPoint());
                if (n >= 0 && n2 >= 0 && PropertyTable.this.fModel.getColumnLink(n, n2) != null && (serializable = PropertyTable.this.fModel.getColumnLink(n, n2)).getBounds().contains(mouseEvent.getPoint())) {
                    return;
                }
                if (n >= 0 && PlatformInfo.isMacintosh() && mouseEvent.getClickCount() == 2 && PropertyTable.this.fModel.isColumnEditable(n2) && PropertyTable.this.isEnabled(n, n2)) {
                    serializable = mouseEvent.getPoint();
                    SwingUtilities.convertPointToScreen((Point)serializable, (Component)mouseEvent.getSource());
                    PropertyTable.this.startEditing(n, n2, (Point)serializable, false);
                } else if (!PlatformInfo.isMacintosh() && mouseEvent.getClickCount() == 1 && !SwingUtilities.isLeftMouseButton(mouseEvent) && PropertyTable.this.fContextMenuCustomizer != null && n > -1 && n2 > -1) {
                    this.handleContextMenu(mouseEvent, n, n2);
                } else if (mouseEvent.getClickCount() == 1 && SwingUtilities.isLeftMouseButton(mouseEvent) && PropertyTable.this.fClickAction != null && n >= 0 && !PropertyTable.this.fModel.isPrimaryGroupHeader(n) && n2 >= 0) {
                    PropertyTable.this.fClickAction.run(PropertyTable.this.fModel.getValue(n, n2));
                }
            }

            private void handleContextMenu(MouseEvent mouseEvent, int n, int n2) {
                MJPopupMenu mJPopupMenu = new MJPopupMenu();
                mJPopupMenu.setName("PropertyTable.contextMenu");
                int n3 = mJPopupMenu.getComponentCount();
                PropertyTable.this.fContextMenuCustomizer.customize(mJPopupMenu, n, n2);
                if (mJPopupMenu.getComponentCount() > n3) {
                    mJPopupMenu.show((Component)((Object)PropertyTable.this.fTable), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        this.fTable.setFocusable(true);
        if (this.fPainter.getGridLineWidth() > 0) {
            this.addColumnDragSupport((JComponent)((Object)this.fTable));
        }
        this.addVirtualComponentSupport((JComponent)((Object)this.fTable));
        final RequestFilter requestFilter = new RequestFilter(new Runnable(){

            @Override
            public void run() {
                MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        PropertyTable.this.fTable.revalidate();
                        PropertyTable.this.fTable.repaint();
                        if (ProjectGUI.getInstance().getCurrentClient() != null) {
                            ProjectGUI.getInstance().getCurrentClient().getComponent().revalidate();
                            ProjectGUI.getInstance().getCurrentClient().getComponent().repaint();
                        }
                        if (PropertyTable.this.fCurrentCellEditor != null && PropertyTable.this.fCurrentEditingRow < PropertyTable.this.fModel.getRowCount() && PropertyTable.this.fCurrentEditingColumn < PropertyTable.this.fModel.getColumnCount()) {
                            PropertyTable.this.fCurrentCellEditor.loadData(PropertyTable.this.fModel.getValue(PropertyTable.this.fCurrentEditingRow, PropertyTable.this.fCurrentEditingColumn), PropertyTable.this.fModel.getColumnText(PropertyTable.this.fCurrentEditingRow, PropertyTable.this.fCurrentEditingColumn));
                        }
                    }
                });
            }
        });
        propertyTableModel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                PropertyTable.this.fNotifyingStructureChanged = true;
                PropertyTable.this.fSelectionModel.structureChanged(PropertyTable.this.fModel.getRowCount());
                PropertyTable.this.fNotifyingStructureChanged = false;
                PropertyTable.this.fVirtualComponentManager.reset();
                Dimension dimension = PropertyTable.this.fTable.getPreferredSize();
                PropertyTable.this.fLastLineCount = PropertyTable.this.fModel.getRowCount();
                PropertyTable.this.fTable.firePropertyChange("preferredSize", dimension, PropertyTable.this.fTable.getPreferredSize());
                requestFilter.request();
            }
        });
        this.fTable.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                PropertyTable.this.fVirtualComponentManager.reset();
                if (PropertyTable.this.fCurrentCellEditor != null) {
                    PropertyTable.this.updateCellEditorBounds();
                    PropertyTable.this.fTable.revalidate();
                    PropertyTable.this.fTable.repaint();
                }
            }
        });
        this.fTable.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                PropertyTable.this.fTable.revalidate();
                PropertyTable.this.fTable.repaint();
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                PropertyTable.this.fTable.revalidate();
                PropertyTable.this.fTable.repaint();
            }
        });
        this.fSelectionModel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                int n = PropertyTable.this.fSelectionModel.getFocusedRow();
                if (!PropertyTable.this.fNotifyingStructureChanged && n >= 0 && n < PropertyTable.this.fModel.getRowCount()) {
                    PropertyTable.this.fTable.scrollRectToVisible(PropertyTable.this.getRowRect(n));
                }
                PropertyTable.this.fTable.revalidate();
                PropertyTable.this.fTable.repaint();
            }
        });
        this.fCopyAction = new ParameterRunnable<KeyEvent>(){

            public void run(KeyEvent keyEvent) {
                PropertyTable.this.delegateCopyOrPasteToEditor(keyEvent);
            }
        };
        this.fPasteAction = new ParameterRunnable<KeyEvent>(){

            public void run(KeyEvent keyEvent) {
                PropertyTable.this.delegateCopyOrPasteToEditor(keyEvent);
            }
        };
        ToolTipManager.sharedInstance().registerComponent((JComponent)((Object)this.fTable));
    }

    public void setName(String string) {
        this.fTable.setName(string);
    }

    public String getName() {
        return this.fTable.getName();
    }

    public void updateCellEditorBounds() {
        this.fVirtualComponentManager.reset();
        if (this.fCurrentCellEditor == null) {
            return;
        }
        Rectangle rectangle = this.getCellRect(this.fCurrentEditingRow, this.fCurrentEditingColumn);
        if (this.fCurrentEditingColumn == 0) {
            int n = this.fModel.getNestLevel(this.fCurrentEditingRow);
            if (n == 1) {
                ((Rectangle2D)rectangle).setRect(((RectangularShape)rectangle).getX() + 16.0, ((RectangularShape)rectangle).getY(), ((RectangularShape)rectangle).getWidth() - 16.0, ((RectangularShape)rectangle).getHeight());
            } else {
                MutablePaintContext mutablePaintContext = new MutablePaintContext();
                mutablePaintContext.rowIndex = this.fCurrentEditingRow;
                mutablePaintContext.nestLevel = n;
                mutablePaintContext.rowRect = rectangle;
                Rectangle2D rectangle2D = this.fPainter.getExpanderRect(mutablePaintContext.getRowContext());
                ((Rectangle2D)rectangle).setRect(rectangle2D.getX() + rectangle2D.getWidth() + 8.0, ((RectangularShape)rectangle).getY(), ((RectangularShape)rectangle).getX() + ((RectangularShape)rectangle).getWidth() - (rectangle2D.getX() + rectangle2D.getWidth()) - 8.0, ((RectangularShape)rectangle).getHeight());
            }
        }
        this.fCurrentCellEditor.getComponent().setBounds((int)((RectangularShape)rectangle).getX() - (PlatformInfo.isMacintosh() ? 2 : 0), (int)((RectangularShape)rectangle).getY(), (int)((RectangularShape)rectangle).getWidth(), (int)((RectangularShape)rectangle).getHeight());
        this.fCurrentCellEditor.getComponent().revalidate();
    }

    public void setClipboardActions(ParameterRunnable<KeyEvent> parameterRunnable, ParameterRunnable<KeyEvent> parameterRunnable2) {
        this.fCopyAction = parameterRunnable;
        this.fPasteAction = parameterRunnable2;
    }

    public void setContextMenuCustomizer(PropertyTableContextMenuCustomizer propertyTableContextMenuCustomizer) {
        this.fContextMenuCustomizer = propertyTableContextMenuCustomizer;
    }

    public void setDefaultPredicate(CellPredicate cellPredicate) {
        this.fDefaultPredicate = cellPredicate;
    }

    public CellPredicate getDefaultPredicate() {
        return this.fDefaultPredicate;
    }

    public void setDeleteHandler(ParameterRunnable<Integer> parameterRunnable) {
        this.fDeleteHandler = parameterRunnable;
    }

    public void setClickAction(ParameterRunnable<T> parameterRunnable) {
        this.fClickAction = parameterRunnable;
    }

    public void setSortable(boolean bl) {
        this.fSortable = bl;
        if (bl && this.fProxyTable.getRowSorter() == null) {
            this.fProxyTable.setAutoCreateRowSorter(bl);
            this.fProxyTable.getRowSorter().addRowSorterListener(new RowSorterListener(){

                @Override
                public void sorterChanged(RowSorterEvent rowSorterEvent) {
                    List<RowSorter.SortKey> list = PropertyTable.this.fProxyTable.getRowSorter().getSortKeys();
                    if (list != null && !list.isEmpty()) {
                        PropertyTable.this.fModel.sort(list.get(0).getColumn(), list.get(0).getSortOrder() == SortOrder.DESCENDING, true);
                    }
                }
            });
        }
    }

    public void setAllowSelectingExpandableRows(boolean bl) {
        this.fAllowSelectingExpandableRows = bl;
    }

    public void setRowAsExpander(boolean bl) {
        this.fRowAsExpander = bl;
    }

    private void initializeMetrics() {
        this.fPreferredWidth = 0;
        BufferedImage bufferedImage = new BufferedImage(1, 1, 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setFont(PropertyTable.getTableFont());
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        this.fLastLineHeight = fontMetrics.getAscent() + fontMetrics.getDescent() + (PlatformInfo.isLinux() ? 6 : 5);
        this.fLastLineCount = this.fModel.getRowCount();
        for (int i = 0; i < this.fModel.getColumnCount(); ++i) {
            int n = (int)(fontMetrics.getStringBounds(this.fModel.getColumnName(i), graphics2D).getWidth() * (i == 0 ? 3.2 : 2.5));
            for (int j = 0; j < this.fModel.getRowCount(); ++j) {
                String string = this.fModel.getColumnText(j, i);
                n = Math.max(n, (int)fontMetrics.getStringBounds(string, graphics2D).getWidth());
            }
            this.fPreferredWidth = this.fPreferredWidth + n;
        }
        this.fPreferredWidth = Math.max(350, this.fPreferredWidth);
        graphics2D.dispose();
    }

    public void setAutoSelectEditableCell(boolean bl) {
        this.fAutoSelectEditableCell = bl;
    }

    public void setKeepEditorAlive(boolean bl) {
        this.fKeepEditorAlive = bl;
    }

    public boolean isKeepingEditorAlive() {
        return this.fKeepEditorAlive;
    }

    public void setEnabled(boolean bl) {
        this.fEnabled = bl;
    }

    public boolean isEnabled() {
        return this.fEnabled;
    }

    public boolean isEnabled(int n, int n2) {
        return this.fEnabled && this.fModel.isEnabled(n, n2);
    }

    public void setSearchText(String string) {
        this.fTable.removeAll();
        this.fModel.setSearchText(string);
        this.fTable.revalidate();
        this.fTable.repaint();
    }

    public void setHeaderVisible(boolean bl) {
        this.fScrollPane.setColumnHeaderView((Component)(bl ? this.fHeader : null));
    }

    public void setNoStretch(boolean bl) {
        this.fTable.putClientProperty(NO_STRETCH_PROPERTY, bl);
    }

    public void setColumnWeights(double[] dArray) {
        if (this.fDividerLocationsInitialized) {
            throw new IllegalStateException("The column weights must be set at initialization time");
        }
        this.fColumnWeights = (double[])dArray.clone();
    }

    public void addHighlighter(PropertyTableHighlighter<T> propertyTableHighlighter) {
        this.animateHighlighterTransition(propertyTableHighlighter, true, false);
    }

    public void removeHighlighter(PropertyTableHighlighter<T> propertyTableHighlighter) {
        this.animateHighlighterTransition(propertyTableHighlighter, false, false);
    }

    public void swapHighlighter(PropertyTableHighlighter<T> propertyTableHighlighter, PropertyTableHighlighter<T> propertyTableHighlighter2) {
        if (propertyTableHighlighter == null) {
            this.addHighlighter(propertyTableHighlighter2);
        } else if (propertyTableHighlighter2 == null) {
            this.removeHighlighter(propertyTableHighlighter);
        } else {
            this.animateHighlighterTransition(propertyTableHighlighter, false, true);
            this.animateHighlighterTransition(propertyTableHighlighter2, true, true);
        }
    }

    public PropertyTableModel<T> getModel() {
        return this.fModel;
    }

    public JComponent getComponent() {
        return this.fScrollPane;
    }

    public Component getTableComponent() {
        return this.fTable;
    }

    public void repaint() {
        this.fTable.revalidate();
        this.fTable.repaint();
    }

    public void dispose() {
        ToolTipManager.sharedInstance().unregisterComponent((JComponent)((Object)this.fTable));
        this.fModel.dispose();
        if (this.fCurrentCellEditor != null) {
            this.fCurrentCellEditor.dispose();
        }
        this.fContextMenuCustomizer = null;
        this.fDefaultPredicate = null;
        this.fKeyboardFocusManager.removePropertyChangeListener("focusOwner", this.fFocusOwnerListener);
    }

    public int getRowAtPoint(Point point) {
        int n = (int)(point.getY() / (double)(this.fLastLineHeight + this.fPainter.getGridLineHeight()));
        return n > this.fModel.getRowCount() ? -1 : n;
    }

    public int getColumnAtPoint(Point point) {
        return this.getActiveColumnModel().getColumnIndexAtX((int)point.getX());
    }

    public boolean isRowVisible(int n) {
        return this.fTable.getVisibleRect().contains(this.getRowRect(n));
    }

    public void scrollRowToVisible(int n) {
        this.fTable.scrollRectToVisible(this.getRowRect(n));
    }

    public boolean isRowSelectable(int n) {
        return !this.fModel.isPrimaryGroupHeader(n);
    }

    public void clearSelection() {
        this.fSelectionModel.clearSelection();
    }

    public SelectionModel getSelectionModel() {
        return this.fSelectionModel;
    }

    public List<T> getSelectedValues(int n) {
        LinkedList<T> linkedList = new LinkedList<T>();
        for (int n2 : this.fSelectionModel.getSelectedRows()) {
            T t = this.fModel.getValue(n2, n);
            if (t == null) continue;
            linkedList.add(t);
        }
        return linkedList;
    }

    public Rectangle getRowRect(int n) {
        return new Rectangle(0, n * (this.fPainter.getGridLineHeight() + this.fLastLineHeight), this.fTable.getWidth(), this.fLastLineHeight);
    }

    public Rectangle getVisibleRect() {
        return this.fTable.getVisibleRect();
    }

    public Rectangle getCellRect(int n, int n2) {
        Rectangle rectangle = this.getRowRect(n);
        if (n2 == 0) {
            rectangle.width = this.getActiveColumnModel().getDividerLocation(0);
        } else {
            int n3 = 1 + this.fPainter.getGridLineWidth();
            rectangle.x = this.getActiveColumnModel().getDividerLocation(n2 - 1) + n3;
            rectangle.width = n2 < this.getActiveColumnModel().getColumnCount() - 1 ? this.getActiveColumnModel().getDividerLocation(n2) - rectangle.x + n3 : this.fTable.getWidth() - rectangle.x;
        }
        return rectangle;
    }

    public void showPopupMenu(JPopupMenu jPopupMenu, int n, int n2) {
        Rectangle rectangle = this.getRowRect(n);
        jPopupMenu.show((Component)((Object)this.fTable), this.getActiveColumnModel().getDividerLocation(n2 - 1), (int)((RectangularShape)rectangle).getY());
    }

    public void convertPointToScreen(Point point) {
        SwingUtilities.convertPointToScreen(point, (Component)((Object)this.fTable));
    }

    public void foldInLastColumn(boolean bl) {
        int n = -(this.fTable.getWidth() - this.fScrollPaneAdjustment - this.fColumnModel.getDividerLocation(this.fModel.getColumnCount() - 2));
        if (bl) {
            if (this.fTable.getWidth() == 0 || !this.fDividerLocationsInitialized) {
                this.fFoldInLastColumnWhenInitialized = true;
                return;
            }
            this.fScrollPaneAdjustment = n;
            this.fScrollPane.revalidate();
            this.fScrollPane.repaint();
            ((JComponent)this.fScrollPane.getParent()).revalidate();
            this.fScrollPane.getParent().repaint();
        } else {
            this.animateScrollPaneAdjustment(n);
        }
        List<PropertyTableColumn<T>> list = this.fModel.getColumns();
        list.remove(list.size() - 1);
        this.fTemporaryColumnModel = new PropertyTableColumnModel<T>(this, list, (JComponent)((Object)this.fTable));
        for (int i = 0; i < list.size() - 1; ++i) {
            this.fTemporaryColumnModel.setDividerLocation(i, this.fColumnModel.getDividerLocation(i));
        }
        this.fProxyTable = new JTable(1, list.size());
        if (this.fSortable) {
            this.fProxyTable.setAutoCreateRowSorter(true);
        }
        this.fProxyTable.setColumnModel(this.fTemporaryColumnModel);
        JTableHeader jTableHeader = this.fProxyTable.getTableHeader();
        this.fTemporaryColumnModel.setHeader(jTableHeader);
        this.fScrollPane.setColumnHeaderView((Component)jTableHeader);
    }

    public void foldOutLastColumn() {
        this.animateScrollPaneAdjustment(0);
    }

    public void animateDataChange(Runnable runnable, Runnable runnable2) {
        int n;
        int n2;
        HashSet<Pair<Integer, Integer>> hashSet = new HashSet<Pair<Integer, Integer>>();
        String[][] stringArray = new String[this.fModel.getRowCount()][this.fModel.getColumnCount()];
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            for (n = 0; n < stringArray[n2].length; ++n) {
                stringArray[n2][n] = this.fModel.getColumnText(n2, n);
            }
        }
        runnable.run();
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            for (n = 0; n < stringArray[n2].length; ++n) {
                String string = this.fModel.getColumnText(n2, n);
                if (string.equals(stringArray[n2][n])) continue;
                hashSet.add((Pair<Integer, Integer>)new Pair((Object)n2, (Object)n));
            }
        }
        runnable2.run();
        this.fDataChanges.add(new DataChange(runnable, hashSet));
        if (this.fDataChangeTimer == null) {
            this.fDataChangeTimer = new Timer(50, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    for (DataChange dataChange : new ArrayList(PropertyTable.this.fDataChanges)) {
                        if (dataChange.step()) {
                            PropertyTable.this.fTable.revalidate();
                            PropertyTable.this.fTable.repaint();
                            continue;
                        }
                        PropertyTable.this.fDataChanges.remove(dataChange);
                    }
                    if (PropertyTable.this.fDataChanges.isEmpty()) {
                        PropertyTable.this.fDataChangeTimer.stop();
                        PropertyTable.this.fDataChangeTimer = null;
                    }
                }
            });
            this.fDataChangeTimer.start();
        }
    }

    public double getDataChangePhase(int n, int n2) {
        for (DataChange dataChange : this.fDataChanges) {
            if (!dataChange.isAffected(n, n2)) continue;
            return dataChange.getPhase();
        }
        return 1.0;
    }

    public void setPreferToShowAllRows(boolean bl) {
        this.fPreferToShowAllRows = bl;
    }

    public boolean isEditor(Component component) {
        return this.fCurrentCellEditor != null && ComponentUtils.isChild((Component)component, (Component)this.fCurrentCellEditor.getComponent());
    }

    public boolean isEditing() {
        return this.fCurrentCellEditor != null;
    }

    public T getEditingValue() {
        return this.fCurrentEditingValue;
    }

    public void startEditing(int n, int n2, boolean bl) {
        this.startEditing(n, n2, null, bl);
    }

    public void startEditing(int n, int n2, Point point, final boolean bl) {
        this.fOverrideStopEditingOnFocusLost = false;
        this.fKeepEditorAlive = false;
        T t = this.fModel.getValue(n, n2);
        if (t == null) {
            return;
        }
        PropertyTableCellEditor<T> propertyTableCellEditor = this.fCellEditorFactory.createWidget(this, n, n2, t);
        if (propertyTableCellEditor == null) {
            return;
        }
        if (propertyTableCellEditor instanceof ClickSensitiveCellEditor) {
            ((ClickSensitiveCellEditor)propertyTableCellEditor).setInitialClickPoint(point);
        }
        if (this.fCurrentCellEditor != null) {
            this.stopEditing(false);
        }
        this.fVetoStopEditing = true;
        propertyTableCellEditor.loadData(t, this.fModel.getColumnText(n, n2));
        this.fCurrentEditingValue = t;
        this.fCurrentEditingRow = n;
        this.fCurrentEditingColumn = n2;
        this.fCurrentCellEditor = propertyTableCellEditor;
        this.fTable.removeAll();
        Rectangle rectangle = this.getCellRect(n, n2);
        JComponent jComponent = this.fCurrentCellEditor.getComponent();
        if (jComponent != null) {
            this.fTable.add(this.fCurrentCellEditor.getComponent());
            this.updateCellEditorBounds();
            this.fTable.revalidate();
            this.fTable.repaint();
            Timer timer = new Timer(50, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (PropertyTable.this.fCurrentCellEditor != null) {
                        PropertyTable.this.fCurrentCellEditor.getComponent().requestFocus();
                        PropertyTable.this.fOverrideStopEditingOnFocusLost = false;
                        PropertyTable.this.fVetoStopEditing = false;
                        if (!bl) {
                            PropertyTable.this.fCurrentCellEditor.activate();
                        }
                    }
                }
            });
            timer.setRepeats(false);
            timer.start();
        } else {
            this.fVetoStopEditing = false;
        }
        this.fKeyboardFocusManager.removePropertyChangeListener("focusOwner", this.fFocusOwnerListener);
        this.fKeyboardFocusManager.addPropertyChangeListener("focusOwner", this.fFocusOwnerListener);
    }

    public void commitEditedValue() {
        if (this.fCurrentCellEditor != null) {
            this.fCurrentCellEditor.commitData();
            this.fTable.revalidate();
            this.fTable.repaint();
        }
    }

    public void stopEditing(boolean bl) {
        this.stopEditing(bl, true);
    }

    public void stopEditing(boolean bl, boolean bl2) {
        if (this.fCurrentCellEditor != null && !this.fVetoStopEditing) {
            if (!bl) {
                this.commitEditedValue();
            }
            this.fTable.removeAll();
            this.fTable.revalidate();
            this.fTable.repaint();
            if (this.fCurrentCellEditor != null) {
                this.fCurrentCellEditor.dispose();
            }
            this.fCurrentCellEditor = null;
            this.fKeyboardFocusManager.removePropertyChangeListener("focusOwner", this.fFocusOwnerListener);
            if (bl2) {
                this.fTable.requestFocus();
            }
        }
    }

    public void setOverrideStopEditingOnFocusLost(boolean bl) {
        this.fOverrideStopEditingOnFocusLost = bl;
    }

    public Font getFont() {
        return PropertyTable.getTableFont();
    }

    public void requestFocus() {
        this.fTable.requestFocus();
    }

    public static Font getTableFont() {
        return FontUtils.getSystemUIFont().deriveFont(PlatformInfo.isMacintosh() ? 11.0f : 12.0f);
    }

    public PropertyTableColumnModel<T> getActiveColumnModel() {
        return this.fTemporaryColumnModel == null ? this.fColumnModel : this.fTemporaryColumnModel;
    }

    private boolean isFocusOutOfTable() {
        Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
        if (component == null) {
            component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        }
        boolean bl = component != null && !FormatTip.isInstance(SwingUtilities.windowForComponent(component)) && !this.isCellEditorDialog(SwingUtilities.windowForComponent(component)) && !ComponentUtils.isChild((Component)component, (Component)((Object)this.fTable)) && (this.fCurrentCellEditor == null || !ComponentUtils.isChild((Component)component, (Component)this.fCurrentCellEditor.getComponent()));
        return bl;
    }

    private boolean isCellEditorDialog(Window window) {
        if (!(window instanceof JDialog)) {
            return false;
        }
        Container container = ((JDialog)window).getContentPane();
        if (container instanceof JComponent) {
            Object object = ((JComponent)container).getClientProperty(CELL_EDITOR_DIALOG);
            return object == this;
        }
        return false;
    }

    private void animateScrollPaneAdjustment(final int n) {
        final Holder holder = new Holder();
        final int n2 = ++this.fActiveAdjustmentIndex;
        holder.set((Object)new Timer(20, new ActionListener(){
            private double iIncrement;
            {
                this.iIncrement = n < 0 ? -2.0 : 2.0;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (PropertyTable.this.fActiveAdjustmentIndex != n2) {
                    ((Timer)holder.get()).stop();
                    return;
                }
                PropertyTable.this.fScrollPaneAdjustment = (int)((double)PropertyTable.this.fScrollPaneAdjustment + this.iIncrement);
                this.iIncrement *= 1.5;
                PropertyTable.this.fScrollPaneAdjustment = n < 0 ? Math.max(n, PropertyTable.this.fScrollPaneAdjustment) : Math.min(n, PropertyTable.this.fScrollPaneAdjustment);
                ((JComponent)PropertyTable.this.fScrollPane.getParent()).revalidate();
                PropertyTable.this.fScrollPane.getParent().repaint();
                if (PropertyTable.this.fScrollPaneAdjustment == n) {
                    ((Timer)holder.get()).stop();
                    if (n == 0) {
                        if (PropertyTable.this.fTemporaryColumnModel != null) {
                            for (int i = 0; i < PropertyTable.this.fModel.getColumnCount() - 2; ++i) {
                                PropertyTable.this.fColumnModel.setDividerLocation(i, PropertyTable.this.fTemporaryColumnModel.getDividerLocation(i));
                            }
                            PropertyTable.this.fTemporaryColumnModel.dispose();
                            PropertyTable.this.fTemporaryColumnModel = null;
                        }
                        PropertyTable.this.fScrollPane.setColumnHeaderView((Component)PropertyTable.this.fHeader);
                    }
                }
            }
        }));
        ((Timer)holder.get()).setRepeats(true);
        ((Timer)holder.get()).start();
    }

    private void startExpandOrCollapse(final int n) {
        if (n < 0) {
            return;
        }
        if (this.isEditing()) {
            this.stopEditing(false);
        }
        if (this.fPainter.getCollapsedPhaseIndex() < 2) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PropertyTable.this.fModel.setExpanded(n, !PropertyTable.this.fModel.isExpanded(n));
                    PropertyTable.this.fTable.revalidate();
                    PropertyTable.this.fTable.repaint();
                }
            });
        } else {
            this.fMovingExpanderPhase = this.fModel.isExpanded(n) ? 0 : this.fPainter.getCollapsedPhaseIndex();
            this.fMovingExpanderRow = n;
            final int n2 = this.fMovingExpanderPhase == 0 ? 1 : -1;
            final Holder holder = new Holder();
            holder.set((Object)new Timer(10, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PropertyTable.this.fMovingExpanderPhase += n2;
                    PropertyTable.this.fTable.revalidate();
                    PropertyTable.this.fTable.repaint();
                    if (PropertyTable.this.fMovingExpanderPhase == 0 || PropertyTable.this.fMovingExpanderPhase == PropertyTable.this.fPainter.getCollapsedPhaseIndex()) {
                        PropertyTable.this.fModel.setExpanded(PropertyTable.this.fMovingExpanderRow, PropertyTable.this.fMovingExpanderPhase == 0);
                        PropertyTable.this.fMovingExpanderRow = -1;
                        ((Timer)holder.get()).stop();
                    }
                }
            }));
            ((Timer)holder.get()).setRepeats(true);
            ((Timer)holder.get()).start();
        }
    }

    private void animateHighlighterTransition(final PropertyTableHighlighter<T> propertyTableHighlighter, final boolean bl, final boolean bl2) {
        if (bl) {
            this.fHighlighters.put(propertyTableHighlighter, bl2 ? 0.5 : 0.0);
        }
        if (!bl && this.fHighlighters.get(propertyTableHighlighter) != null && this.fHighlighters.get(propertyTableHighlighter) < 1.0) {
            this.fHighlighters.remove(propertyTableHighlighter);
            return;
        }
        if (bl && !this.fTable.isShowing()) {
            this.fHighlighters.put(propertyTableHighlighter, 1.0);
            this.fTable.revalidate();
            this.fTable.repaint();
            return;
        }
        final Holder holder = new Holder();
        final double d = bl ? 0.1 : -0.1;
        holder.set((Object)new Timer(50, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Double d2 = (Double)PropertyTable.this.fHighlighters.get(propertyTableHighlighter);
                if (d2 == null) {
                    ((Timer)holder.get()).stop();
                    return;
                }
                d2 = d2 + d;
                d2 = Math.max(0.0, Math.min(1.0, d2));
                PropertyTable.this.fHighlighters.put(propertyTableHighlighter, d2);
                if (d2 <= 0.6 && !bl && bl2 || d2 == 0.0 && !bl || bl && d2 >= 1.0) {
                    ((Timer)holder.get()).stop();
                    if (!bl) {
                        PropertyTable.this.fHighlighters.remove(propertyTableHighlighter);
                    }
                    return;
                }
                PropertyTable.this.fTable.revalidate();
                PropertyTable.this.fTable.repaint();
            }
        }));
        ((Timer)holder.get()).start();
    }

    private boolean isOnExpander(Point point, int n) {
        MutablePaintContext mutablePaintContext = new MutablePaintContext();
        mutablePaintContext.rowIndex = n;
        mutablePaintContext.nestLevel = this.fModel.getNestLevel(n);
        mutablePaintContext.rowRect = this.getRowRect(n);
        return this.fModel.isExpandable(n) && (this.fRowAsExpander ? mutablePaintContext.rowRect.contains(point) : this.fPainter.getExpanderRect(mutablePaintContext.getRowContext()).contains(point));
    }

    private void showMacValueDropdownIfApplicable(int n, int n2) {
        if (this.fModel.isColumnEditable(n2) && this.isEnabled(n, n2) && this.fModel.isFinite(n, n2)) {
            this.startEditing(n, n2, false);
        }
    }

    private boolean isControlDown(InputEvent inputEvent) {
        return PlatformInfo.isMacintosh() && inputEvent.isMetaDown() || !PlatformInfo.isMacintosh() && inputEvent.isControlDown();
    }

    private void startMacEditingIfNoDropdown(int n, int n2) {
        if (this.fModel.isColumnEditable(n2) && this.isEnabled(n, n2) && !this.fModel.isFinite(n, n2) && this.fModel.getValue(n, n2) != null) {
            this.startEditing(n, n2, false);
        }
    }

    private void delegateCopyOrPasteToEditor(KeyEvent keyEvent) {
        if (this.fModel.isColumnEditable(1) && this.fSelectionModel.getSelectedRowCount() == 1) {
            int n = this.fSelectionModel.getSelectedRow();
            T t = this.fModel.getValue(n, 1);
            if (t == null) {
                return;
            }
            PropertyTableCellEditor<T> propertyTableCellEditor = this.fCellEditorFactory.createWidget(this, n, 1, t);
            propertyTableCellEditor.loadData(t, this.fModel.getColumnText(n, 1));
            Object object = TreeUtils.findComponent((Component)propertyTableCellEditor.getComponent(), JTextComponent.class);
            if (object == null) {
                FormattedTextField.TextComponent textComponent = (FormattedTextField.TextComponent)((Object)TreeUtils.findComponent((Component)propertyTableCellEditor.getComponent(), FormattedTextField.TextComponent.class));
                if (textComponent != null) {
                    textComponent.getOwner().selectAll();
                    object = textComponent;
                }
            } else {
                ((JTextComponent)object).selectAll();
            }
            if (object != null) {
                object.dispatchEvent(keyEvent);
            }
            if (keyEvent.getKeyCode() == 86) {
                propertyTableCellEditor.commitData();
            }
            propertyTableCellEditor.dispose();
        }
    }

    private int getDividerIndex(int n) {
        PropertyTableColumnModel<T> propertyTableColumnModel = this.getActiveColumnModel();
        for (int i = 0; i < propertyTableColumnModel.getColumnCount() - 1; ++i) {
            if (n < propertyTableColumnModel.getDividerLocation(i) - 1 || n > propertyTableColumnModel.getDividerLocation(i) + 1) continue;
            return i;
        }
        return -1;
    }

    private void addColumnDragSupport(final JComponent jComponent) {
        jComponent.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                PropertyTable.this.fCurrentDividerIndex = PropertyTable.this.getDividerIndex(mouseEvent.getX());
                PropertyTable.this.fLeftDragLimit = 32;
                PropertyTable.this.fRightDragLimit = jComponent.getWidth() - 16;
                if (PropertyTable.this.fCurrentDividerIndex > 0) {
                    PropertyTable.this.fLeftDragLimit = PropertyTable.this.getActiveColumnModel().getDividerLocation(PropertyTable.this.fCurrentDividerIndex - 1) + 10;
                }
                if (PropertyTable.this.fCurrentDividerIndex >= 0 && PropertyTable.this.fCurrentDividerIndex < PropertyTable.this.getActiveColumnModel().getColumnCount() - 2) {
                    PropertyTable.this.fRightDragLimit = PropertyTable.this.getActiveColumnModel().getDividerLocation(PropertyTable.this.fCurrentDividerIndex + 1) - 10;
                }
            }
        });
        jComponent.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                if (PropertyTable.this.fCurrentDividerIndex != -1 && mouseEvent.getX() >= PropertyTable.this.fLeftDragLimit && mouseEvent.getY() <= PropertyTable.this.fRightDragLimit) {
                    PropertyTable.this.getActiveColumnModel().setDividerLocation(PropertyTable.this.fCurrentDividerIndex, mouseEvent.getX());
                    PropertyTable.this.fTable.revalidate();
                    PropertyTable.this.fTable.repaint();
                    jComponent.revalidate();
                    jComponent.repaint();
                }
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                int n = PropertyTable.this.getDividerIndex(mouseEvent.getX());
                if (n > -1) {
                    jComponent.setCursor(Cursor.getPredefinedCursor(11));
                } else {
                    JComponent jComponent2;
                    int n2 = PropertyTable.this.getRowAtPoint(mouseEvent.getPoint());
                    int n3 = PropertyTable.this.getColumnAtPoint(mouseEvent.getPoint());
                    if (n2 > -1 && n3 > -1 && PropertyTable.this.fModel.getColumnLink(n2, n3) != null && (jComponent2 = PropertyTable.this.fModel.getColumnLink(n2, n3)).getBounds().contains(mouseEvent.getX(), mouseEvent.getY())) {
                        jComponent.setCursor(jComponent2.getCursor());
                        return;
                    }
                    jComponent.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
    }

    private void addVirtualComponentSupport(JComponent jComponent) {
        jComponent.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                if (PropertyTable.this.fVirtualComponentManager.hasAnyComponents()) {
                    int n = PropertyTable.this.getRowAtPoint(mouseEvent.getPoint());
                    int n2 = PropertyTable.this.getColumnAtPoint(mouseEvent.getPoint());
                    PropertyTable.this.fVirtualComponentManager.mouseMove(n, n2, mouseEvent.getPoint());
                }
            }
        });
    }

    private void initializeDividerLocationsIfNecessary() {
        if (!this.fDividerLocationsInitialized) {
            for (int i = 0; i < this.fModel.getColumnCount() - 1; ++i) {
                this.getActiveColumnModel().setDividerLocation(i, (int)((double)this.fTable.getWidth() * this.fColumnWeights[i] + (double)(i == 0 ? 0 : this.getActiveColumnModel().getDividerLocation(i - 1))));
            }
            this.fDividerLocationsInitialized = true;
            if (this.fFoldInLastColumnWhenInitialized) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PropertyTable.this.foldInLastColumn(true);
                    }
                });
            }
            this.fTable.revalidate();
            this.fTable.repaint();
            this.fHeader.revalidate();
            this.fHeader.repaint();
        }
    }

    private class TableComponent
    extends MJPanel
    implements Scrollable {
        TableComponent() {
            this.setLayout(null);
            this.setName("PropertyTable");
            this.putClientProperty(PropertyTable.TABLE_CLIENT_PROPERTY, PropertyTable.this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getToolTipText(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            if (point != null) {
                String string;
                int n = PropertyTable.this.getRowAtPoint(point);
                int n2 = PropertyTable.this.getColumnAtPoint(point);
                if (n >= 0 && n2 >= 0 && (string = PropertyTable.this.fModel.getColumnText(n, n2)) != null && !string.isEmpty()) {
                    Rectangle rectangle = PropertyTable.this.getCellRect(n, n2);
                    MutablePaintContext mutablePaintContext = new MutablePaintContext();
                    BufferedImage bufferedImage = new BufferedImage(1, 1, 2);
                    Graphics2D graphics2D = bufferedImage.createGraphics();
                    graphics2D.setFont(PropertyTable.getTableFont());
                    mutablePaintContext.rowIndex = n;
                    mutablePaintContext.columnIndex = n2;
                    mutablePaintContext.column = PropertyTable.this.fModel.getColumn(n2);
                    mutablePaintContext.graphics = graphics2D;
                    mutablePaintContext.cellRect = rectangle;
                    mutablePaintContext.nestLevel = PropertyTable.this.fModel.getNestLevel(n);
                    mutablePaintContext.link = PropertyTable.this.fModel.getColumnLink(n, n2);
                    mutablePaintContext.text = string;
                    mutablePaintContext.isFiniteValue = PropertyTable.this.fModel.isColumnEditable(n2) && PropertyTable.this.fModel.isFinite(n, n2);
                    try {
                        if (!PropertyTable.this.fPainter.canFitText(mutablePaintContext.getCellContext())) {
                            String string2 = StringUtils.createWordWrappedHtml(string, 75);
                            return string2;
                        }
                    }
                    finally {
                        graphics2D.dispose();
                    }
                }
            }
            return null;
        }

        public void firePropertyChange(String string, Object object, Object object2) {
            super.firePropertyChange(string, object, object2);
        }

        public Dimension getPreferredSize() {
            return new Dimension(0, (PropertyTable.this.fLastLineHeight + PropertyTable.this.fPainter.getGridLineHeight()) * Math.max(1, PropertyTable.this.fLastLineCount));
        }

        private int getPageCount(int n, int n2) {
            Rectangle rectangle;
            int n3;
            int n4 = 0;
            Rectangle rectangle2 = this.getVisibleRect();
            for (n3 = n + n2; n3 >= 0 && n3 < PropertyTable.this.fModel.getRowCount() && rectangle2.contains(rectangle = PropertyTable.this.getRowRect(n3)); n3 += n2) {
                ++n4;
            }
            if (n4 == 0) {
                int n5 = 0;
                while (n3 >= 0 && n3 < PropertyTable.this.fModel.getRowCount()) {
                    Rectangle rectangle3 = PropertyTable.this.getRowRect(n3);
                    if (n5 + rectangle3.height > rectangle2.height) break;
                    n5 += rectangle3.height;
                    ++n4;
                    n3 += n2;
                }
            }
            return n4;
        }

        protected void processKeyEvent(KeyEvent keyEvent) {
            if (keyEvent.getID() == 401) {
                if (keyEvent.getKeyCode() == 65 && PropertyTable.this.isControlDown(keyEvent)) {
                    PropertyTable.this.fSelectionModel.selectAll(PropertyTable.this.fModel.getRowCount());
                    return;
                }
                if (keyEvent.getKeyCode() == 33) {
                    int n = this.getPageCount(PropertyTable.this.fSelectionModel.getFocusedRow(), -1);
                    PropertyTable.this.fSelectionModel.navigationKeyPressed(PropertyTable.this.fModel.getRowCount(), -n, PropertyTable.this.isControlDown(keyEvent), keyEvent.isShiftDown());
                    return;
                }
                if (keyEvent.getKeyCode() == 34) {
                    int n = this.getPageCount(PropertyTable.this.fSelectionModel.getFocusedRow(), 1);
                    PropertyTable.this.fSelectionModel.navigationKeyPressed(PropertyTable.this.fModel.getRowCount(), n, PropertyTable.this.isControlDown(keyEvent), keyEvent.isShiftDown());
                    return;
                }
                if (keyEvent.getKeyCode() == 38) {
                    PropertyTable.this.fSelectionModel.navigationKeyPressed(PropertyTable.this.fModel.getRowCount(), -1, PropertyTable.this.isControlDown(keyEvent), keyEvent.isShiftDown());
                    return;
                }
                if (keyEvent.getKeyCode() == 40) {
                    PropertyTable.this.fSelectionModel.navigationKeyPressed(PropertyTable.this.fModel.getRowCount(), 1, PropertyTable.this.isControlDown(keyEvent), keyEvent.isShiftDown());
                    return;
                }
                if (keyEvent.getKeyCode() == 36) {
                    PropertyTable.this.fSelectionModel.navigationKeyPressed(PropertyTable.this.fModel.getRowCount(), -PropertyTable.this.fSelectionModel.getFocusedRow(), PropertyTable.this.isControlDown(keyEvent), keyEvent.isShiftDown());
                    return;
                }
                if (keyEvent.getKeyCode() == 35) {
                    PropertyTable.this.fSelectionModel.navigationKeyPressed(PropertyTable.this.fModel.getRowCount(), PropertyTable.this.fModel.getRowCount() - 1 - PropertyTable.this.fSelectionModel.getFocusedRow(), PropertyTable.this.isControlDown(keyEvent), keyEvent.isShiftDown());
                    return;
                }
                if (PlatformInfo.isMacintosh() && keyEvent.getKeyCode() == 32 && PropertyTable.this.fSelectionModel.getSelectedRowCount() == 1) {
                    PropertyTable.this.showMacValueDropdownIfApplicable(PropertyTable.this.fSelectionModel.getSelectedRow(), 1);
                } else if (PlatformInfo.isMacintosh() && keyEvent.getKeyCode() == 10 && PropertyTable.this.fSelectionModel.getSelectedRowCount() == 1) {
                    PropertyTable.this.startMacEditingIfNoDropdown(PropertyTable.this.fSelectionModel.getSelectedRow(), 1);
                } else if (!(PlatformInfo.isMacintosh() || PropertyTable.this.fSelectionModel.getSelectedRowCount() != 1 || keyEvent.getKeyCode() != 32 && keyEvent.getKeyCode() != 113)) {
                    for (int i = 1; i < PropertyTable.this.getActiveColumnModel().getColumnCount(); ++i) {
                        if (!PropertyTable.this.fModel.isColumnEditable(i)) continue;
                        PropertyTable.this.startEditing(PropertyTable.this.fSelectionModel.getSelectedRow(), i, false);
                        break;
                    }
                } else if ((keyEvent.getKeyCode() == 67 || keyEvent.getKeyCode() == 86) && (keyEvent.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0) {
                    if (keyEvent.getKeyCode() == 67) {
                        PropertyTable.this.fCopyAction.run((Object)keyEvent);
                    } else {
                        PropertyTable.this.fPasteAction.run((Object)keyEvent);
                    }
                } else if (keyEvent.getKeyCode() == 37 && PropertyTable.this.fSelectionModel.getSelectedRowCount() == 1 && PropertyTable.this.fModel.isExpandable(PropertyTable.this.fSelectionModel.getSelectedRow())) {
                    PropertyTable.this.fModel.setExpanded(PropertyTable.this.fSelectionModel.getSelectedRow(), false);
                    PropertyTable.this.fTable.revalidate();
                    PropertyTable.this.fTable.repaint();
                } else if (keyEvent.getKeyCode() == 39 && PropertyTable.this.fSelectionModel.getSelectedRowCount() == 1 && PropertyTable.this.fModel.isExpandable(PropertyTable.this.fSelectionModel.getSelectedRow())) {
                    PropertyTable.this.fModel.setExpanded(PropertyTable.this.fSelectionModel.getSelectedRow(), true);
                    PropertyTable.this.fTable.revalidate();
                    PropertyTable.this.fTable.repaint();
                } else if (keyEvent.getKeyCode() == 127 && PropertyTable.this.fDeleteHandler != null) {
                    int n = 0;
                    for (int n2 : PropertyTable.this.fSelectionModel.getSelectedRows()) {
                        int n3 = PropertyTable.this.fModel.getRowCount();
                        PropertyTable.this.fDeleteHandler.run((Object)(n2 - n));
                        if (PropertyTable.this.fModel.getRowCount() == n3) continue;
                        ++n;
                    }
                }
            }
            super.processKeyEvent(keyEvent);
        }

        public void reshape(int n, int n2, int n3, int n4) {
            if (n3 >= 100) {
                super.reshape(n, n2, n3, n4);
                PropertyTable.this.initializeMetrics();
                PropertyTable.this.initializeDividerLocationsIfNecessary();
            } else {
                super.reshape(n, n2, 0, 0);
            }
        }

        public void paintComponent(Graphics graphics) {
            Rectangle rectangle = graphics.getClipBounds();
            if (rectangle == null) {
                rectangle = this.getBounds();
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics.setFont(PropertyTable.getTableFont());
            if (PropertyTable.this.fLastLineCount == 0) {
                graphics2D.setColor(PropertyTable.this.fScrollPane.getViewport().getBackground());
                graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            if (PropertyTable.this.fLastLineCount.intValue() != PropertyTable.this.fModel.getRowCount()) {
                PropertyTable.this.fLastLineCount = PropertyTable.this.fModel.getRowCount();
                this.revalidate();
                this.repaint();
            }
            int n = 0;
            int n2 = 0;
            LinkedList<Runnable> linkedList = new LinkedList<Runnable>();
            for (int i = 0; i < PropertyTable.this.fModel.getRowCount(); ++i) {
                int n3;
                Color color;
                final MutablePaintContext object = new MutablePaintContext();
                object.graphics = graphics2D;
                object.component = PropertyTable.this.fTable;
                object.rowIndex = i;
                object.matchesSearch = PropertyTable.this.fModel.matchesSearch(i);
                object.searchText = PropertyTable.this.fModel.getSearchText();
                object.columnCount = PropertyTable.this.getActiveColumnModel().getColumnCount();
                object.rowRect = PropertyTable.this.getRowRect(i);
                if (object.rowRect.getY() + object.rowRect.getHeight() < (double)(rectangle.y - 10)) {
                    n += PropertyTable.this.fLastLineHeight + PropertyTable.this.fPainter.getGridLineHeight();
                    n2 += PropertyTable.this.fModel.isPrimaryGroupHeader(i) ? 0 : 1;
                    continue;
                }
                if (object.rowRect.getY() > rectangle.getY() + rectangle.getHeight() + 10.0) break;
                object.isSelected = PropertyTable.this.fSelectionModel.isSelected(i) && !PropertyTable.this.fModel.isPrimaryGroupHeader(i);
                object.isExpandable = PropertyTable.this.fModel.isExpandable(i);
                object.isSelectingExpandableRowsAllowed = PropertyTable.this.fAllowSelectingExpandableRows;
                object.nestLevel = PropertyTable.this.fModel.getNestLevel(i);
                object.highlighters = PropertyTable.this.fHighlighters;
                object.cellRects = new Converter<Integer, Rectangle2D>(){

                    public Rectangle2D convert(Integer n) {
                        return PropertyTable.this.getCellRect(object.rowIndex, n);
                    }
                };
                if (PropertyTable.this.fModel.isPrimaryGroupHeader(i)) {
                    color = PropertyTable.this.fPainter.paintGroupBackground(object.getRowContext());
                } else if (object.isSelected.booleanValue()) {
                    object.isFocused = this.hasFocus() || PropertyTable.this.fCurrentCellEditor != null;
                    object.value = PropertyTable.this.fModel.getValue(i, 0);
                    object.markedRowIndex = n2++;
                    color = PropertyTable.this.fPainter.paintSelectedBackground(object.getRowContext());
                } else {
                    object.value = PropertyTable.this.fModel.getValue(i, 0);
                    object.markedRowIndex = n2++;
                    color = PropertyTable.this.fPainter.paintNormalBackground(object.getRowContext());
                }
                if (object.isExpandable.booleanValue()) {
                    object.isExpanded = PropertyTable.this.fModel.isExpanded(i);
                    object.isPressed = i == PropertyTable.this.fPressedExpanderRow;
                    int n4 = n3 = PropertyTable.this.fModel.isExpanded(i) ? 0 : PropertyTable.this.fPainter.getCollapsedPhaseIndex();
                    if (i == PropertyTable.this.fMovingExpanderRow) {
                        n3 = PropertyTable.this.fMovingExpanderPhase;
                    }
                    object.expansionPhase = n3;
                    PropertyTable.this.fPainter.paintExpander(object.getRowContext());
                }
                for (n3 = 0; n3 < PropertyTable.this.getActiveColumnModel().getColumnCount(); ++n3) {
                    JComponent jComponent;
                    object.value = PropertyTable.this.fModel.getValue(i, n3);
                    object.link = jComponent = PropertyTable.this.fModel.getColumnLink(i, n3);
                    object.columnIndex = n3;
                    object.highlighters = PropertyTable.this.fHighlighters;
                    object.lineHeight = PropertyTable.this.fLastLineHeight;
                    object.isLeaf = PropertyTable.this.fModel.isLeaf(i);
                    object.isDisabled = !PropertyTable.this.isEnabled(i, n3) && !PropertyTable.this.fModel.isPrimaryGroupHeader(i);
                    object.isNonDefault = object.value != null && PropertyTable.this.fDefaultPredicate != null && !PropertyTable.this.fDefaultPredicate.accept(i, n3);
                    object.cellRect = PropertyTable.this.getCellRect(i, n3);
                    object.isFiniteValue = PropertyTable.this.fModel.isColumnEditable(n3) && PropertyTable.this.fModel.isFinite(i, n3);
                    object.text = PropertyTable.this.fModel.getColumnText(i, n3);
                    object.dataChangePhase = PropertyTable.this.getDataChangePhase(i, n3);
                    object.column = PropertyTable.this.fModel.getColumn(n3);
                    Color color2 = Color.BLACK;
                    PropertyTableDecorator propertyTableDecorator = PropertyTable.this.fModel.getColumnDecorator(n3);
                    if (propertyTableDecorator == null || propertyTableDecorator.shouldPaintText(object.value)) {
                        color2 = PropertyTable.this.fPainter.paintText(object.getCellContext());
                    }
                    if (object.isDisabled.booleanValue() && jComponent != null) {
                        jComponent.setBounds(0, 0, 0, 0);
                    }
                    if (propertyTableDecorator != null) {
                        propertyTableDecorator.paintDecoration(object.getCellContext(), graphics2D, PropertyTable.this.fVirtualComponentManager, color, color2);
                    }
                    Rectangle2D.Double double_ = new Rectangle2D.Double(object.cellRect.getX() + object.cellRect.getWidth() - (double)PropertyTable.this.fPainter.getGridLineWidth() - (double)(n3 != 0 ? 1 : 0), n, PropertyTable.this.fPainter.getGridLineWidth(), object.cellRect.getHeight());
                    PropertyTable.this.fPainter.paintGridLine(graphics2D, double_);
                }
                Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, n += PropertyTable.this.fLastLineHeight.intValue(), object.rowRect.getWidth(), n + PropertyTable.this.fPainter.getGridLineHeight());
                PropertyTable.this.fPainter.paintGridLine(graphics2D, double_);
                n += PropertyTable.this.fPainter.getGridLineHeight();
                if (object.deferredCode == null) continue;
                linkedList.add(object.deferredCode);
            }
            for (Runnable runnable : linkedList) {
                runnable.run();
            }
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            if (PropertyTable.this.fLastLineHeight != null) {
                int n = Math.max(1, Math.min(8, PropertyTable.this.fLastLineCount));
                if (PropertyTable.this.fPreferToShowAllRows) {
                    n = PropertyTable.this.fLastLineCount;
                }
                Dimension dimension = new Dimension(PropertyTable.this.fPreferredWidth, (PropertyTable.this.fLastLineHeight + PropertyTable.this.fPainter.getGridLineHeight()) * n);
                return dimension;
            }
            return new Dimension(0, 0);
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
            return PropertyTable.this.fLastLineHeight + PropertyTable.this.fPainter.getGridLineHeight();
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
            if (n == 1) {
                return (int)(rectangle.getHeight() - (double)(PropertyTable.this.fLastLineHeight / 2));
            }
            return (int)(rectangle.getWidth() - 5.0);
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return false;
        }
    }

    private static class CornerComponent
    extends MJPanel {
        CornerComponent() {
            this.setLayout(new BorderLayout(0, 0));
            Component component = new JTableHeader().getDefaultRenderer().getTableCellRendererComponent(null, "", false, false, -1, 0);
            ((JComponent)component).setOpaque(false);
            this.add(component, "Center");
        }
    }

    private class DataChange {
        private final Runnable fChanger;
        private final Set<Pair<Integer, Integer>> fAffectedCells;
        private double fPhase;
        private double fIncrement;

        DataChange(Runnable runnable, Set<Pair<Integer, Integer>> set) {
            this.fChanger = runnable;
            this.fAffectedCells = set;
            this.fPhase = 0.9;
            this.fIncrement = -0.1;
        }

        public boolean step() {
            this.fPhase += this.fIncrement;
            if (this.fPhase <= 0.0) {
                this.fChanger.run();
                this.fIncrement = 0.1;
                this.fPhase = 0.1;
            }
            return this.fPhase < 1.0;
        }

        public double getPhase() {
            return this.fPhase;
        }

        public boolean isAffected(int n, int n2) {
            return this.fAffectedCells.contains(new Pair((Object)n, (Object)n2));
        }
    }
}

