/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.workflowui;

import com.mathworks.common.icons.CommonIcon;
import com.mathworks.common.icons.ProjectIcon;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJTree;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.TreeUtils;
import com.mathworks.project.api.DeploymentProcess;
import com.mathworks.project.api.DeploymentProcessMonitor;
import com.mathworks.project.api.SubProcessType;
import com.mathworks.project.impl.BuiltInResources;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.model.Workflow;
import com.mathworks.project.impl.model.WorkflowStep;
import com.mathworks.project.impl.model.WorkflowStepResult;
import com.mathworks.project.impl.plugin.PluginManager;
import com.mathworks.project.impl.workflowui.WorkflowDialog;
import com.mathworks.project.impl.workflowui.WorkflowModel;
import com.mathworks.project.impl.workflowui.WorkflowTreeModel;
import com.mathworks.util.Converter;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.widgets.BusyAffordance;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.util.Iterator;
import java.util.Stack;
import java.util.zip.CRC32;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public final class WorkflowTree {
    private final MJTree fTree;
    private final Configuration fConfiguration;
    private final WorkflowModel fModel;
    private final BusyAffordance fBusyAffordance;
    private final JPopupMenu fContextMenu;
    private final MJAbstractAction fResetStepAction;
    private final MJAbstractAction fRunToStepAction;
    private final MJAbstractAction fRunAction;
    private final MJAbstractAction fHelpAction;
    private final Converter<WorkflowStep, DeploymentProcess> fRunner;
    private final ParameterRunnable<WorkflowStep> fResetter;
    private final Runnable fResizeHandler;
    private Timer fRefreshTimer;
    private boolean fWalkThroughStepsWhileRunning;
    private boolean fAutoSelection;
    private int fContextMenuRow;
    private TreeSelectionListener fTreeSelectionListener;
    private MouseAdapter fMouseAdapter;
    private ChangeListener fModelChangeListener;
    private long fLastChecksum;

    public WorkflowTree(Configuration configuration, WorkflowModel workflowModel, final ParameterRunnable<WorkflowStep> parameterRunnable, Converter<WorkflowStep, DeploymentProcess> converter, ParameterRunnable<WorkflowStep> parameterRunnable2, Runnable runnable) {
        this.fConfiguration = configuration;
        this.fModel = workflowModel;
        this.fBusyAffordance = new BusyAffordance(BusyAffordance.AffordanceSize.SIZE_16x16);
        this.fBusyAffordance.getComponent().setSize(16, 16);
        this.fRunner = converter;
        this.fResetter = parameterRunnable2;
        this.fResizeHandler = runnable;
        WorkflowTreeModel workflowTreeModel = new WorkflowTreeModel(configuration, this.fModel);
        this.fTree = new Tree(workflowTreeModel);
        this.fTree.setName(this.getClass().getSimpleName());
        this.fTree.setShowsRootHandles(this.isHierarchical());
        this.fTree.setCellRenderer((TreeCellRenderer)new Renderer());
        this.fLastChecksum = this.createChecksum();
        this.fTreeSelectionListener = new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                if (!WorkflowTree.this.fAutoSelection) {
                    WorkflowTree.this.fWalkThroughStepsWhileRunning = false;
                }
                if (WorkflowTree.this.fTree.getSelectionPath() != null) {
                    WorkflowStep workflowStep = (WorkflowStep)WorkflowTree.this.fTree.getSelectionPath().getLastPathComponent();
                    if (workflowStep.getSubSteps().isEmpty()) {
                        WorkflowTree.this.fRunAction.putValue("SmallIcon", (Object)WorkflowDialog.RUN_STEP_ICON);
                    } else {
                        WorkflowTree.this.fRunAction.putValue("SmallIcon", (Object)WorkflowDialog.RUN_MULTI_STEP_ICON);
                    }
                    parameterRunnable.run((Object)workflowStep);
                }
            }
        };
        this.fTree.addTreeSelectionListener(this.fTreeSelectionListener);
        this.fTree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
                WorkflowTree.this.fWalkThroughStepsWhileRunning = false;
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
                WorkflowTree.this.fWalkThroughStepsWhileRunning = false;
            }
        });
        this.fContextMenu = new JPopupMenu();
        this.fRunAction = new MJAbstractAction(BuiltInResources.getString("context.run"), CommonIcon.DOWN.getIcon()){

            public void actionPerformed(ActionEvent actionEvent) {
                WorkflowStep workflowStep = WorkflowTree.this.getContextMenuStep();
                if (workflowStep != null) {
                    WorkflowTree.this.run(workflowStep, false);
                }
            }
        };
        this.fRunAction.setComponentName("context.run");
        this.fContextMenu.add((Action)this.fRunAction);
        this.fRunToStepAction = new MJAbstractAction(BuiltInResources.getString("context.runToStep"), CommonIcon.REDO.getIcon()){

            public void actionPerformed(ActionEvent actionEvent) {
                WorkflowStep workflowStep = WorkflowTree.this.getContextMenuStep();
                if (workflowStep != null) {
                    WorkflowTree.this.run(workflowStep, true);
                }
            }
        };
        this.fRunToStepAction.setComponentName("context.runToStep");
        this.fContextMenu.add((Action)this.fRunToStepAction);
        this.fContextMenu.addSeparator();
        this.fResetStepAction = new MJAbstractAction(BuiltInResources.getString("context.resetStep"), CommonIcon.REFRESH.getIcon()){

            public void actionPerformed(ActionEvent actionEvent) {
                WorkflowStep workflowStep = WorkflowTree.this.getContextMenuStep();
                if (workflowStep != null) {
                    WorkflowTree.this.reset(workflowStep);
                }
            }
        };
        this.fResetStepAction.setComponentName("context.resetStep");
        this.fContextMenu.add((Action)this.fResetStepAction);
        this.fContextMenu.addSeparator();
        this.fHelpAction = new MJAbstractAction(BuiltInResources.getString("context.help"), CommonIcon.HELP.getIcon()){

            public void actionPerformed(ActionEvent actionEvent) {
                WorkflowStep workflowStep = WorkflowTree.this.getContextMenuStep();
                String string = PluginManager.resolveHelpMapPath(WorkflowTree.this.fConfiguration.getTarget().getHelpMapPath());
                MLHelpServices.cshDisplayTopic((Object)WorkflowTree.this.fTree.getParent(), (String)string, (String)workflowStep.getHelpKey());
            }
        };
        this.fHelpAction.setComponentName("context.help");
        this.fContextMenu.add((Action)this.fHelpAction);
        this.fMouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                super.mousePressed(mouseEvent);
                this.handlePopUp(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                super.mouseReleased(mouseEvent);
                this.handlePopUp(mouseEvent);
            }

            private void handlePopUp(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    WorkflowTree.this.fContextMenuRow = WorkflowTree.this.fTree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                    if (WorkflowTree.this.fContextMenuRow > -1) {
                        WorkflowStep workflowStep = WorkflowTree.this.getContextMenuStep();
                        WorkflowTree.this.fResetStepAction.setEnabled(WorkflowTree.this.fModel.isResettable(workflowStep));
                        WorkflowTree.this.fRunAction.setEnabled(WorkflowTree.this.fModel.isRunnable(workflowStep));
                        WorkflowTree.this.fRunToStepAction.setEnabled(WorkflowTree.this.fModel.getCurrentProcess() == null);
                        WorkflowTree.this.fTree.setSelectionRow(WorkflowTree.this.fContextMenuRow);
                        WorkflowTree.this.fContextMenu.getSubElements()[WorkflowTree.this.fContextMenu.getSubElements().length - 2].getComponent().setVisible(workflowStep.getHelpKey() != null);
                        WorkflowTree.this.fContextMenu.getSubElements()[WorkflowTree.this.fContextMenu.getSubElements().length - 1].getComponent().setVisible(workflowStep.getHelpKey() != null);
                        WorkflowTree.this.fContextMenu.show((Component)WorkflowTree.this.fTree, mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            }
        };
        this.fTree.addMouseListener((MouseListener)this.fMouseAdapter);
        this.fTree.setRootVisible(false);
        TreeUtils.expandAllNodes((JTree)this.fTree);
        if (this.fTree.getRowCount() > 0) {
            this.fTree.setSelectionRow(0);
        }
        this.fModelChangeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (WorkflowTree.this.fModel.getCurrentProcess() == null && WorkflowTree.this.fRefreshTimer != null) {
                    WorkflowTree.this.fRefreshTimer.stop();
                    WorkflowTree.this.fRefreshTimer = null;
                    WorkflowTree.this.fBusyAffordance.stop();
                } else if (WorkflowTree.this.fModel.getCurrentProcess() != null && WorkflowTree.this.fRefreshTimer == null) {
                    WorkflowTree.this.fRefreshTimer = new Timer(100, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            WorkflowTree.this.fTree.revalidate();
                            WorkflowTree.this.fTree.repaint();
                        }
                    });
                    WorkflowTree.this.fRefreshTimer.setRepeats(true);
                    WorkflowTree.this.fRefreshTimer.start();
                    WorkflowTree.this.fBusyAffordance.start();
                }
                long l = WorkflowTree.this.createChecksum();
                if (l != WorkflowTree.this.fLastChecksum) {
                    WorkflowTree.this.fTree.updateUI();
                    TreeUtils.expandAllNodes((JTree)WorkflowTree.this.fTree);
                    WorkflowTree.this.fLastChecksum = l;
                }
                WorkflowTree.this.fTree.revalidate();
                WorkflowTree.this.fTree.repaint();
            }
        };
        this.fModel.addChangeListener(this.fModelChangeListener);
    }

    private boolean isHierarchical() {
        Workflow workflow = this.fConfiguration.getTarget().getWorkflow();
        for (WorkflowStep workflowStep : workflow.getSteps()) {
            if (workflowStep.getSubSteps().isEmpty()) continue;
            return true;
        }
        return false;
    }

    private long createChecksum() {
        CRC32 cRC32 = new CRC32();
        this.addToChecksum(cRC32, this.fTree.getModel().getRoot());
        return cRC32.getValue();
    }

    private void addToChecksum(CRC32 cRC32, Object object) {
        cRC32.update(object.toString().getBytes());
        int n = this.fTree.getModel().getChildCount(object);
        for (int i = 0; i < n; ++i) {
            this.addToChecksum(cRC32, this.fTree.getModel().getChild(object, i));
        }
    }

    public JComponent getComponent() {
        return this.fTree;
    }

    public void repaint() {
        this.getComponent().repaint();
    }

    public void dispose() {
        this.fTree.removeTreeSelectionListener(this.fTreeSelectionListener);
        this.fModel.removeChangeListener(this.fModelChangeListener);
        this.fTree.removeMouseListener((MouseListener)this.fMouseAdapter);
        this.fTree.setCellRenderer(null);
        this.fBusyAffordance.stop();
        if (this.fRefreshTimer != null) {
            this.fRefreshTimer.stop();
            this.fRefreshTimer = null;
        }
    }

    public void run(WorkflowStep workflowStep, boolean bl) {
        if (!bl && workflowStep.isRunnable() && workflowStep.isLeaf()) {
            this.fModel.resetBeforeRun(workflowStep, this.fResetter);
            DeploymentProcess deploymentProcess = (DeploymentProcess)this.fRunner.convert((Object)workflowStep);
            if (deploymentProcess != null) {
                deploymentProcess.start();
            }
            return;
        }
        this.fWalkThroughStepsWhileRunning = true;
        final Iterator<WorkflowStep> iterator = bl ? this.fModel.getRunToIterator(workflowStep, this.fResetter) : this.fModel.getRunGroupIterator(workflowStep, this.fResetter);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                DeploymentProcess deploymentProcess;
                WorkflowStep workflowStep = null;
                if (iterator.hasNext()) {
                    workflowStep = (WorkflowStep)iterator.next();
                }
                if (workflowStep == null) {
                    WorkflowTree.this.fWalkThroughStepsWhileRunning = false;
                    return;
                }
                if (WorkflowTree.this.fWalkThroughStepsWhileRunning) {
                    WorkflowTree.this.fAutoSelection = true;
                    WorkflowTree.this.selectStep(workflowStep);
                    WorkflowTree.this.fAutoSelection = false;
                }
                if ((deploymentProcess = (DeploymentProcess)WorkflowTree.this.fRunner.convert((Object)workflowStep)) != null) {
                    final 9 var3_3 = this;
                    deploymentProcess.addMonitor(new DeploymentProcessMonitor(){

                        public void finished() {
                            MJUtilities.runOnEventDispatchThread((Runnable)var3_3);
                        }

                        public void subProcessStarted(SubProcessType subProcessType) {
                        }

                        public void commandStarted(String string) {
                        }

                        public void commandOutput(String string) {
                        }

                        public void commandError(String string) {
                        }

                        public void failed() {
                        }

                        public void canceled() {
                        }
                    });
                    deploymentProcess.start();
                }
            }
        };
        runnable.run();
    }

    private WorkflowStep getContextMenuStep() {
        TreePath treePath = this.fTree.getPathForRow(this.fContextMenuRow);
        return treePath != null ? (WorkflowStep)treePath.getLastPathComponent() : null;
    }

    public void reset(WorkflowStep workflowStep) {
        this.reset(workflowStep, false);
    }

    public void reset(WorkflowStep workflowStep, boolean bl) {
        this.fModel.reset(workflowStep, bl ? null : this.fResetter);
    }

    public void selectStep(WorkflowStep workflowStep) {
        Stack<WorkflowStep> stack = new Stack<WorkflowStep>();
        while (workflowStep != null) {
            stack.push(workflowStep);
            workflowStep = workflowStep.getParent();
        }
        Object[] objectArray = new Object[1 + stack.size()];
        objectArray[0] = this.fTree.getModel().getRoot();
        for (int i = 1; i < objectArray.length; ++i) {
            objectArray[i] = stack.pop();
        }
        this.fTree.setSelectionPath(new TreePath(objectArray));
    }

    private class Tree
    extends MJTree {
        private boolean fHover;
        private double fCollapseRatio;
        private Timer fHoverTimer;
        private Timer fCollapseTimer;
        private final int fExpanderWidth;
        private final int fExpanderHeight;

        Tree(TreeModel treeModel) {
            super(treeModel);
            this.fExpanderHeight = 28;
            this.fExpanderWidth = 8;
            this.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseMoved(MouseEvent mouseEvent) {
                    if (Tree.this.isOverExpander(mouseEvent.getPoint())) {
                        Tree.this.fHover = true;
                        Tree.this.revalidate();
                        Tree.this.repaint();
                        Tree.this.startHoverTimer();
                    }
                }
            });
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() == 1 && Tree.this.isOverExpander(mouseEvent.getPoint())) {
                        if (Tree.this.fCollapseRatio == 1.0) {
                            Tree.this.expand();
                        } else {
                            Tree.this.collapse();
                        }
                    }
                }
            });
        }

        private void collapse() {
            if (this.fCollapseTimer == null) {
                this.fCollapseRatio = 0.1;
                this.fCollapseTimer = new Timer(10, new ActionListener(){
                    double increment = 0.05;

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        this.increment *= 1.3;
                        Tree.this.fCollapseRatio += this.increment;
                        if (Tree.this.fCollapseRatio >= 1.0) {
                            Tree.this.fCollapseRatio = 1.0;
                            Tree.this.fCollapseTimer.stop();
                            Tree.this.fCollapseTimer = null;
                        }
                        Tree.this.revalidate();
                        Tree.this.repaint();
                        WorkflowTree.this.fResizeHandler.run();
                    }
                });
                this.fCollapseTimer.setRepeats(true);
                this.fCollapseTimer.start();
            }
        }

        private void expand() {
            if (this.fCollapseTimer == null) {
                this.fCollapseTimer = new Timer(10, new ActionListener(){
                    double increment = 0.05;

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        this.increment *= 1.3;
                        Tree.this.fCollapseRatio -= this.increment;
                        if (Tree.this.fCollapseRatio <= 0.0) {
                            Tree.this.fCollapseRatio = 0.0;
                            Tree.this.fCollapseTimer.stop();
                            Tree.this.fCollapseTimer = null;
                        }
                        Tree.this.revalidate();
                        Tree.this.repaint();
                        WorkflowTree.this.fResizeHandler.run();
                    }
                });
                this.fCollapseTimer.setRepeats(true);
                this.fCollapseTimer.start();
            }
        }

        private boolean isOverExpander(Point point) {
            if (this.fCollapseRatio == 1.0) {
                return new Rectangle2D.Double(0.0, 0.0, this.getWidth(), this.getHeight()).contains(point);
            }
            return new Rectangle2D.Double(this.getWidth() - this.fExpanderWidth - 1, this.getHeight() / 2 - this.fExpanderHeight / 2 - 1, this.fExpanderWidth + 2, this.fExpanderHeight + 2).contains(point);
        }

        public void stopHoverTimer() {
            if (this.fHoverTimer != null) {
                this.fHoverTimer.stop();
                this.fHoverTimer = null;
            }
        }

        private void startHoverTimer() {
            if (this.fHoverTimer == null) {
                this.fHoverTimer = new Timer(10, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        PointerInfo pointerInfo = MouseInfo.getPointerInfo();
                        if (pointerInfo != null) {
                            Point point = pointerInfo.getLocation();
                            SwingUtilities.convertPointFromScreen(point, (Component)((Object)Tree.this));
                            if (Tree.this.isOverExpander(point)) {
                                return;
                            }
                        }
                        Tree.this.fHover = false;
                        Tree.this.stopHoverTimer();
                        Tree.this.revalidate();
                        Tree.this.repaint();
                    }
                });
                this.fHoverTimer.setRepeats(true);
                this.fHoverTimer.start();
            }
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            if (this.fCollapseRatio == 0.0) {
                return dimension;
            }
            int n = (int)dimension.getWidth();
            int n2 = n - this.fExpanderWidth - 2;
            return new Dimension((int)((double)n - (double)n2 * this.fCollapseRatio), (int)dimension.getHeight());
        }

        public void paintComponent(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (this.fCollapseRatio == 1.0 && this.fHover) {
                graphics2D.setColor(Color.WHITE);
                graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
            } else if (this.fCollapseRatio > 0.0) {
                graphics2D.setColor(UIManager.getColor("control"));
                graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
            } else {
                super.paintComponent(graphics);
            }
            int n = 16;
            if (this.fCollapseRatio != 1.0) {
                RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(this.getWidth() - this.fExpanderWidth, this.getHeight() / 2 - this.fExpanderHeight / 2, this.fExpanderWidth + 10, this.fExpanderHeight, 10.0, 10.0);
                if (this.fHover) {
                    graphics2D.setColor(new Color(255, 255, 255));
                } else {
                    graphics2D.setColor(UIManager.getColor("control"));
                }
                graphics2D.fill(double_);
                graphics2D.setColor(new Color(130, 135, 144));
                graphics2D.draw(double_);
            }
            graphics2D.setColor(new Color(30, 30, 30));
            if (this.fCollapseRatio == 1.0) {
                graphics2D.draw(new Line2D.Double(3.0, this.getHeight() / 2 - n / 2 + 4, this.fExpanderWidth - 2, this.getHeight() / 2));
                graphics2D.draw(new Line2D.Double(3.0, this.getHeight() / 2 + n / 2 - 4, this.fExpanderWidth - 2, this.getHeight() / 2));
            } else {
                graphics2D.draw(new Line2D.Double(this.getWidth() - 2, this.getHeight() / 2 - n / 2 + 4, this.getWidth() - this.fExpanderWidth + 2, this.getHeight() / 2));
                graphics2D.draw(new Line2D.Double(this.getWidth() - 2, this.getHeight() / 2 + n / 2 - 4, this.getWidth() - this.fExpanderWidth + 2, this.getHeight() / 2));
            }
            graphics2D.dispose();
        }
    }

    private class Renderer
    extends DefaultTreeCellRenderer {
        private final BufferedImage iBusyImage = new BufferedImage(16, 16, 2);

        private Renderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            if (!(object instanceof WorkflowStep)) {
                return super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            }
            WorkflowStep workflowStep = (WorkflowStep)object;
            boolean bl5 = WorkflowTree.this.fModel.isEnabled(workflowStep);
            Component component = super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            WorkflowStepResult workflowStepResult = WorkflowTree.this.fModel.getResult(workflowStep);
            if (workflowStepResult != null) {
                this.setIcon(workflowStepResult.getIcon());
            } else {
                this.setIcon(ProjectIcon.WORKFLOW_STEP.getIcon());
            }
            if (WorkflowTree.this.fModel.getRunningStep() != null && workflowStep.equals(WorkflowTree.this.fModel.getRunningStep())) {
                Graphics2D graphics2D = (Graphics2D)this.iBusyImage.getGraphics();
                graphics2D.setColor(WorkflowTree.this.fTree.getBackground());
                graphics2D.fillRect(0, 0, 16, 16);
                WorkflowTree.this.fBusyAffordance.paintAffordance(graphics2D);
                graphics2D.dispose();
                this.setIcon(new ImageIcon(this.iBusyImage));
            } else if (!bl5) {
                this.setIcon(this.getDisabledIcon());
            }
            return component;
        }
    }
}

