/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.matchers;

import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.matchers.AbstractMatcherEditor;
import ca.odell.glazedlists.matchers.Matcher;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThresholdMatcherEditor<E>
extends AbstractMatcherEditor<E> {
    public static final MatchOperation GREATER_THAN = new MatchOperation(1, false);
    public static final MatchOperation GREATER_THAN_OR_EQUAL = new MatchOperation(1, true);
    public static final MatchOperation LESS_THAN = new MatchOperation(-1, false);
    public static final MatchOperation LESS_THAN_OR_EQUAL = new MatchOperation(-1, true);
    public static final MatchOperation EQUAL = new MatchOperation(0, true);
    public static final MatchOperation NOT_EQUAL = new MatchOperation(0, false);
    private MatchOperation currentMatcher = null;
    private Comparator<E> comparator = null;
    private MatchOperation operation = null;
    private E threshold = null;

    public ThresholdMatcherEditor() {
        this(null, null, null);
    }

    public ThresholdMatcherEditor(E threshold) {
        this(threshold, null, null);
    }

    public ThresholdMatcherEditor(E threshold, MatchOperation operation) {
        this(threshold, operation, null);
    }

    public ThresholdMatcherEditor(E threshold, MatchOperation operation, Comparator<E> comparator) {
        if (operation == null) {
            operation = GREATER_THAN;
        }
        if (comparator == null) {
            comparator = GlazedLists.comparableComparator();
        }
        this.operation = operation;
        this.comparator = comparator;
        this.threshold = threshold;
        this.currentMatcher = operation.instance(comparator, threshold);
        this.fireConstrained(this.currentMatcher);
    }

    public synchronized void setThreshold(E threshold) {
        this.threshold = threshold;
        this.rebuildMatcher();
    }

    public synchronized E getThreshold() {
        return this.threshold;
    }

    public synchronized void setMatchOperation(MatchOperation operation) {
        if (operation == null) {
            throw new IllegalArgumentException("Operation cannot be null");
        }
        this.operation = operation;
        this.rebuildMatcher();
    }

    public synchronized MatchOperation getMatchOperation() {
        return this.operation;
    }

    public synchronized void setComparator(Comparator<E> comparator) {
        if (comparator == null) {
            comparator = GlazedLists.comparableComparator();
        }
        this.comparator = comparator;
        this.rebuildMatcher();
    }

    public synchronized Comparator<E> getComparator() {
        return this.comparator;
    }

    private void rebuildMatcher() {
        MatchOperation newMatcher = this.operation.instance(this.comparator, this.threshold);
        boolean moreStrict = newMatcher.isMoreStrict(this.currentMatcher);
        boolean lessStrict = this.currentMatcher.isMoreStrict(newMatcher);
        if (!moreStrict && !lessStrict) {
            return;
        }
        this.currentMatcher = newMatcher;
        if (moreStrict && lessStrict) {
            this.fireChanged(this.currentMatcher);
        } else if (moreStrict) {
            this.fireConstrained(this.currentMatcher);
        } else if (lessStrict) {
            this.fireRelaxed(this.currentMatcher);
        }
    }

    private static class MatchOperation
    implements Matcher {
        protected final Comparator comparator;
        protected final Object threshold;
        private final int polarity;
        private final boolean inclusive;

        private MatchOperation(Comparator comparator, Object threshold, int polarity, boolean inclusive) {
            this.comparator = comparator;
            this.threshold = threshold;
            this.polarity = polarity;
            this.inclusive = inclusive;
        }

        private MatchOperation(int polarity, boolean inclusive) {
            this(null, null, polarity, inclusive);
        }

        private MatchOperation instance(Comparator comparator, Object threshold) {
            return new MatchOperation(comparator, threshold, this.polarity, this.inclusive);
        }

        boolean isMoreStrict(MatchOperation other) {
            if (other.polarity != this.polarity) {
                return true;
            }
            if (other.comparator != this.comparator) {
                return true;
            }
            if (this.threshold == other.threshold) {
                if (this.polarity == 0) {
                    return this.inclusive != other.inclusive;
                }
                return !this.inclusive && other.inclusive;
            }
            if (this.polarity == 0) {
                return true;
            }
            return !this.matches(other.threshold);
        }

        public boolean matches(Object item) {
            int compareResult = this.comparator.compare(item, this.threshold);
            if (compareResult == 0) {
                return this.inclusive;
            }
            if (this.polarity == 0) {
                return !this.inclusive;
            }
            return compareResult < 0 == this.polarity < 0;
        }
    }
}

