/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.storage.provider;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;

public final class StorageURI {
    private final URI fURI;

    public StorageURI(String string) throws URISyntaxException {
        this(new URI(string));
    }

    public StorageURI(URI uRI) {
        if (!uRI.isAbsolute()) {
            throw new IllegalArgumentException("URI must be absolute.");
        }
        if (uRI.getPath() == null || uRI.getPath().isEmpty()) {
            throw new IllegalArgumentException("URI must contain a path.");
        }
        if (uRI.isOpaque()) {
            throw new IllegalArgumentException("Opaque URIs are not supported at this time");
        }
        this.fURI = uRI;
    }

    public StorageURI(StorageURI storageURI, String string) {
        String string2 = new File(storageURI.getPath(), string).getPath();
        string2 = StorageURI.fixSeparator(string2);
        try {
            this.fURI = new URI(storageURI.getScheme(), storageURI.getAuthority(), string2, storageURI.getQuery(), storageURI.getFragment());
        }
        catch (URISyntaxException uRISyntaxException) {
            throw StorageURI.handleImpossibleURISyntaxException(uRISyntaxException);
        }
    }

    public String getScheme() {
        return this.fURI.getScheme();
    }

    public String getAuthority() {
        return this.fURI.getAuthority();
    }

    public String getPath() {
        return this.fURI.getPath();
    }

    public String getQuery() {
        return this.fURI.getQuery();
    }

    public String getFragment() {
        return this.fURI.getFragment();
    }

    public String getName() {
        File file = new File(this.getPath());
        if (file.getParentFile() != null) {
            return file.getName();
        }
        return StorageURI.fixSeparator(file.getPath());
    }

    public boolean hasParent() {
        return new File(this.getPath()).getParentFile() != null;
    }

    public StorageURI getRoot() {
        try {
            return new StorageURI(new URI(this.fURI.getScheme(), this.fURI.getAuthority(), "/", this.fURI.getQuery(), this.fURI.getFragment()));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw StorageURI.handleImpossibleURISyntaxException(uRISyntaxException);
        }
    }

    public StorageURI getParent() {
        if (!this.hasParent()) {
            throw new IllegalStateException("URI '" + this.fURI + "' has no parent.");
        }
        String string = new File(this.getPath()).getParent();
        string = StorageURI.fixSeparator(string);
        try {
            return new StorageURI(new URI(this.fURI.getScheme(), this.fURI.getAuthority(), string, this.fURI.getQuery(), this.fURI.getFragment()));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw StorageURI.handleImpossibleURISyntaxException(uRISyntaxException);
        }
    }

    public String toString() {
        return this.fURI.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        StorageURI storageURI = (StorageURI)object;
        return this.fURI.equals(storageURI.fURI);
    }

    public int hashCode() {
        return this.fURI.hashCode();
    }

    private static String fixSeparator(String string) {
        if (!"/".equals(File.separator)) {
            return string.replace(File.separator, "/");
        }
        return string;
    }

    private static ImpossibleURISyntaxException handleImpossibleURISyntaxException(URISyntaxException uRISyntaxException) {
        String string = "Unexpected (and impossible) URISyntaxException when parsing URI: " + uRISyntaxException.getInput();
        assert (false) : string;
        return new ImpossibleURISyntaxException(string, uRISyntaxException);
    }

    private static class ImpossibleURISyntaxException
    extends RuntimeException {
        private ImpossibleURISyntaxException(String string, URISyntaxException uRISyntaxException) {
            super(string, uRISyntaxException);
        }
    }
}

