/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.storage.provider.motwsupport;

import com.mathworks.storage.provider.StorageURI;
import com.mathworks.storage.provider.motwsupport.FolderListener;
import com.mathworks.storage.provider.motwsupport.ListenableAndInvalidatableProvider;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;

public abstract class AbstractListenableAndInvalidatableProvider
implements ListenableAndInvalidatableProvider {
    private final List<FolderListener> fListeners = new CopyOnWriteArrayList<FolderListener>();
    private final Executor fListenerExecutor;

    public AbstractListenableAndInvalidatableProvider(Executor executor) {
        this.fListenerExecutor = executor;
    }

    protected void fireFolderCreated(StorageURI storageURI) {
        for (FolderListener folderListener : this.fListeners) {
            this.fListenerExecutor.execute(new FireFolderCreated(folderListener, storageURI));
        }
    }

    protected void fireFolderRemoved(StorageURI storageURI) {
        for (FolderListener folderListener : this.fListeners) {
            this.fListenerExecutor.execute(new FireFolderRemoved(folderListener, storageURI));
        }
    }

    @Override
    public void addFolderListener(FolderListener folderListener) {
        this.fListeners.add(folderListener);
    }

    @Override
    public void removeFolderListener(FolderListener folderListener) {
        this.fListeners.remove(folderListener);
    }

    private static class FireFolderRemoved
    extends FireFolderListener {
        private FireFolderRemoved(FolderListener folderListener, StorageURI storageURI) {
            super(folderListener, storageURI);
        }

        @Override
        public void run() {
            this.fListener.folderRemoved(this.fPath);
        }
    }

    private static class FireFolderCreated
    extends FireFolderListener {
        private FireFolderCreated(FolderListener folderListener, StorageURI storageURI) {
            super(folderListener, storageURI);
        }

        @Override
        public void run() {
            this.fListener.folderCreated(this.fPath);
        }
    }

    private static abstract class FireFolderListener
    implements Runnable {
        protected final FolderListener fListener;
        protected final StorageURI fPath;

        private FireFolderListener(FolderListener folderListener, StorageURI storageURI) {
            this.fPath = storageURI;
            this.fListener = folderListener;
        }
    }
}

