/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.parallel.util.concurrent;

import com.mathworks.toolbox.parallel.util.concurrent.SignalingAtomicBoolean;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;

public abstract class EasyFuture<V>
implements Future<V> {
    private final SignalingAtomicBoolean fIsDoneOrCancelled = new SignalingAtomicBoolean(false);
    private final AtomicBoolean fIsDone = new AtomicBoolean(false);
    private final AtomicBoolean fIsCancelled = new AtomicBoolean(false);
    private final AtomicReference<V> fResult = new AtomicReference();
    private final AtomicReference<Throwable> fThrowable = new AtomicReference();

    @Override
    public boolean cancel(boolean bl) {
        this.fIsCancelled.set(true);
        this.fIsDoneOrCancelled.set(true);
        if (!this.fIsDone.get()) {
            this.fThrowable.set(this.performCancellation(bl));
        }
        return !this.fIsDone.get();
    }

    protected abstract Exception performCancellation(boolean var1);

    @Override
    public boolean isCancelled() {
        return this.fIsCancelled.get();
    }

    @Override
    public boolean isDone() {
        return this.fIsDone.get();
    }

    private V throwOrGet() throws ExecutionException {
        Throwable throwable = this.fThrowable.get();
        if (throwable != null) {
            throw new ExecutionException(throwable);
        }
        return this.fResult.get();
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        this.fIsDoneOrCancelled.awaitTrue();
        return this.throwOrGet();
    }

    @Override
    public V get(long l, @NotNull TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        if (!this.fIsDoneOrCancelled.awaitTrue(l, timeUnit)) {
            throw new TimeoutException("Timed out after " + l + " " + (Object)((Object)timeUnit));
        }
        return this.throwOrGet();
    }

    public void done() {
        this.fIsDone.set(true);
        this.fIsDoneOrCancelled.set(true);
    }

    public void set(V v) {
        this.fResult.set(v);
        this.done();
    }

    public void setException(Throwable throwable) {
        this.fThrowable.set(throwable);
        this.done();
    }
}

