/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.common.task;

import com.mathworks.matlabserver.common.marfile.MARFile;
import com.mathworks.matlabserver.common.task.MatlabServerSessionID;
import com.mathworks.matlabserver.common.task.TaskIDGenerator;
import java.io.Serializable;

public final class TaskInput
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String fVersion = "";
    private ServiceType fServiceType = ServiceType.EVALC;
    private ExecutionType fExecutionType = ExecutionType.STATELESS;
    private String fFixedAppName = "";
    private String[] fInputs = new String[]{""};
    private Serializable[] fJavaInputs = new Serializable[0];
    private String fID = TaskIDGenerator.getUniqueTaskID();
    private MatlabServerSessionID fSessionID;
    private String fIPAddress;
    private MARFile fMARFile;

    private TaskInput(MatlabServerSessionID sessionID) {
        this.fSessionID = sessionID;
    }

    public static TaskInput newInstance() {
        return new TaskInput(MatlabServerSessionID.newInstance("dummyID"));
    }

    public static TaskInput newInstance(MatlabServerSessionID sessionID) {
        return new TaskInput(sessionID);
    }

    public void setVersion(String v) {
        this.fVersion = v;
    }

    public String getVersion() {
        return this.fVersion;
    }

    public void setServiceType(ServiceType t) {
        this.fServiceType = t;
    }

    public ServiceType getServiceType() {
        return this.fServiceType;
    }

    public String getServiceTypeAsString() {
        return this.fServiceType.toString();
    }

    public void setExecutionType(ExecutionType t) {
        this.fExecutionType = t;
    }

    public ExecutionType getExecutionype() {
        return this.fExecutionType;
    }

    public String getExecutionTypeAsString() {
        return this.fExecutionType.toString();
    }

    public void setFixedAppName(String a2) {
        this.fFixedAppName = a2;
    }

    public String getFixedAppName() {
        return this.fFixedAppName;
    }

    public void setJavaInputs(Serializable[] argin) {
        this.fJavaInputs = argin;
    }

    public Serializable[] getJavaInputs() {
        return this.fJavaInputs;
    }

    public byte[] getBytes(int ind) {
        if (ind < this.fJavaInputs.length && this.fJavaInputs[ind] instanceof byte[]) {
            return (byte[])this.fJavaInputs[ind];
        }
        return new byte[0];
    }

    public void setInputs(String[] in) {
        this.fInputs = in;
    }

    public String[] getInputs() {
        return this.fInputs;
    }

    public void setMARFile(MARFile marFile) {
        this.fMARFile = marFile;
    }

    public MARFile getMARFile() {
        return this.fMARFile;
    }

    public void setIPAddress(String ip) {
        this.fIPAddress = ip;
    }

    public String getIPAddress() {
        return this.fIPAddress;
    }

    public String getID() {
        return this.fID;
    }

    public MatlabServerSessionID getSessionID() {
        return this.fSessionID;
    }

    public static enum ExecutionType {
        STATELESS,
        PSEUDO_PERSISTENT,
        PERSISTENT;

    }

    public static enum ServiceType {
        EVALC,
        FIXED;

    }
}

