/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.fileservices.impl;

import com.mathworks.matlabserver.fileservices.decorator.FileServiceAbstractDecorator;
import com.mathworks.matlabserver.internalservices.faults.MLSException;
import com.mathworks.matlabserver.internalservices.file.FileInfoDO;
import com.mathworks.matlabserver.internalservices.file.FileService;
import com.mathworks.matlabserver.internalservices.file.IncrementalFileService;
import com.mathworks.matlabserver.internalservices.security.UserTokenDO;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;

public class IncrementalFileServiceAdapter
extends FileServiceAbstractDecorator
implements IncrementalFileService {
    private static final Logger logger = Logger.getLogger(IncrementalFileServiceAdapter.class.getName());

    public IncrementalFileServiceAdapter(FileService decoratedFileService) {
        this.decoratedFileService = decoratedFileService;
        logger.info("Using the IncrementalFileServiceAdapter. This is an inefficient implementation for incremental operations!");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void readIncremental(UserTokenDO userToken, FileInfoDO fileInfo, ByteBuffer data, int size, int offset) {
        InputStream contentsStream = this.decoratedFileService.readContent(userToken, fileInfo);
        if (contentsStream != null) {
            try {
                contentsStream.skip(offset);
                byte[] bytes = new byte[size];
                int pos = contentsStream.read(bytes);
                data.put(bytes);
                if (pos <= 0) return;
                data.position(pos);
                return;
            }
            catch (IOException e2) {
                logger.log(Level.SEVERE, "Error reading byte stream.", e2);
                throw new MLSException("FileService.IOError", "Error reading byte stream: " + fileInfo.toString(), e2);
            }
            finally {
                IOUtils.closeQuietly(contentsStream);
            }
        } else {
            logger.log(Level.SEVERE, "Underlying fileService.readContent() returned null InputStream for: ", fileInfo.toString());
        }
    }

    @Override
    public void updateIncremental(UserTokenDO userToken, FileInfoDO fileInfo, ByteBuffer data, int size, int offset) {
        block8: {
            block7: {
                InputStream fileStream = this.decoratedFileService.readContent(userToken, fileInfo);
                ByteArrayInputStream newFileStream = null;
                if (fileStream == null) break block7;
                try {
                    byte[] newBytes;
                    byte[] originalBytes = IOUtils.toByteArray(fileStream);
                    if (originalBytes.length < offset + size) {
                        logger.finest("new number of bytes is greater than existing: " + originalBytes.length + "<" + (offset + size));
                        newBytes = new byte[offset + size];
                        System.arraycopy(originalBytes, 0, newBytes, 0, offset);
                    } else {
                        logger.finest("old number of bytes is greater than existing: " + originalBytes.length + ">" + (offset + size));
                        newBytes = originalBytes;
                    }
                    for (int i2 = 0; i2 < size; ++i2) {
                        newBytes[i2 + offset] = data.get();
                    }
                    newFileStream = new ByteArrayInputStream(newBytes);
                    this.decoratedFileService.updateContent(userToken, fileInfo, newFileStream);
                    data.position(size);
                }
                catch (IOException e2) {
                    try {
                        logger.log(Level.SEVERE, "Error updating the file: ", e2);
                        throw new MLSException("FileService.IOError", "Error updating the file: " + fileInfo.toString(), e2);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(newFileStream);
                        IOUtils.closeQuietly(fileStream);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly(newFileStream);
                IOUtils.closeQuietly(fileStream);
                break block8;
            }
            logger.log(Level.SEVERE, "Underlying fileService.readContent() returned null InputStream for: ", fileInfo.toString());
        }
    }
}

