/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.fileservices.util;

import com.mathworks.matlabserver.common.fileservice.FileUtils;
import com.mathworks.matlabserver.fileservices.util.FilenameConverter;
import com.mathworks.matlabserver.internalservices.faults.MLSException;
import com.mathworks.matlabserver.internalservices.file.FileInfoDO;
import com.mathworks.matlabserver.internalservices.security.UserTokenDO;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FilenameUtils;

public class FilenameConverterDirect
implements FilenameConverter {
    private static final Logger logger = Logger.getLogger(FilenameConverterDirect.class.getName());
    private static final String adminId = "admin";
    private final String mountPoint;

    public FilenameConverterDirect(String mountPoint, String matlabRoot) throws IOException {
        this(new File(mountPoint).getCanonicalPath());
    }

    public FilenameConverterDirect(String mountPoint, String matlabRoot, String fileSeparator) {
        this(mountPoint);
    }

    public FilenameConverterDirect(String mountPoint) {
        this.mountPoint = mountPoint.endsWith(File.separator) ? mountPoint : mountPoint + File.separator;
    }

    @Override
    public String getServerFilename(UserTokenDO userToken, FileInfoDO fileInfo) {
        String filepath = this.ensureNotNullString(fileInfo.getLocation());
        String filename = this.ensureNotNullString(fileInfo.getName());
        if (filepath.length() != 0 && !filepath.endsWith(File.separator)) {
            filepath = filepath + File.separator;
        }
        return this.getAbsoluteAndValidatedFilename(userToken, filepath + filename);
    }

    private String getAbsoluteAndValidatedFilename(UserTokenDO userToken, String filename) {
        String prefix = FilenameUtils.getPrefix(filename = this.validateFileName(userToken, filename));
        if (prefix == null || prefix.length() == 0) {
            filename = userToken.getName().equals(adminId) ? this.getServerMountPoint() + filename : this.getServerMountPoint(userToken) + File.separator + filename;
        }
        if (!filename.equals(prefix) && filename.endsWith(this.getWorkerFileSeparator())) {
            filename = filename.substring(0, filename.length() - this.getWorkerFileSeparator().length());
        }
        return filename;
    }

    private String validateFileName(UserTokenDO userToken, String filename) throws MLSException {
        String normalizedFileName = FilenameUtils.normalize(filename);
        if (normalizedFileName == null) {
            String message = "Illegal file access attempt by user: " + userToken.getName() + " trying to get at file: " + filename;
            logger.log(Level.WARNING, message);
            throw new MLSException("FileService.IOError", message);
        }
        if (!FileUtils.isValidFileName(normalizedFileName)) {
            String message = "Invalid file name: " + normalizedFileName;
            logger.log(Level.WARNING, message);
            throw new MLSException("FileService.IOError", message);
        }
        return normalizedFileName;
    }

    @Override
    public String getWorkerFilename(UserTokenDO userToken, FileInfoDO fileInfo) {
        return this.getServerFilename(userToken, fileInfo);
    }

    @Override
    public String convertFilenameFromWorkerToServer(UserTokenDO userToken, String filename) {
        return this.getAbsoluteAndValidatedFilename(userToken, filename);
    }

    @Override
    public String convertFilenameFromServerToWorker(UserTokenDO userToken, String filename) {
        return this.getAbsoluteAndValidatedFilename(userToken, filename);
    }

    @Override
    public String getWorkerMountPoint() {
        return this.mountPoint;
    }

    @Override
    public String getWorkerMountPoint(UserTokenDO userToken) {
        return this.mountPoint + userToken.getName();
    }

    @Override
    public String getServerMountPoint() {
        return this.mountPoint;
    }

    @Override
    public String getServerMountPoint(UserTokenDO userToken) {
        return this.mountPoint + userToken.getName();
    }

    @Override
    public String getWorkerFileSeparator() {
        return File.separator;
    }

    @Override
    public String getServerFileSeparator() {
        return File.separator;
    }

    @Override
    public boolean filenameNeedsConversion(String filename) {
        String normalizedFilename = FilenameUtils.normalize(filename);
        return normalizedFilename != null && normalizedFilename.length() != 0;
    }

    private String ensureNotNullString(String s) {
        return s == null ? "" : s;
    }

    @Override
    public boolean folderCanMove(String source, String currentFolder) {
        return true;
    }
}

