/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.fileservices.util;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.mathworks.matlabserver.internalservices.faults.MLSException;
import com.mathworks.matlabserver.internalservices.security.UserTokenDO;
import com.mathworks.webservices.client.core.MathWorksClientException;
import com.mathworks.webservices.client.core.MathWorksServiceException;
import com.mathworks.webservices.gds.GDSClient;
import com.mathworks.webservices.gds.model.GDSErrorCode;
import com.mathworks.webservices.gds.model.authentication.LoginRequest;
import com.mathworks.webservices.gds.model.authentication.LogoutRequest;
import java.util.EnumSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;

public class FileserviceActionGds {
    private static final Logger logger = Logger.getLogger(FileserviceActionGds.class.getName());
    private static FileserviceActionGds instance;
    private static final long EXECUTION_TIMEOUT_MILLIS = 4000L;
    private static final long SESSION_CACHE_EXPIRATION_SECONDS = 120L;
    private static final EnumSet<GDSErrorCode> sessionErrors;
    private final ExecutorService asyncExecutor = Executors.newCachedThreadPool();
    private UserTokenDO userToken;
    private LoadingCache<UserData, String> sessionCache;
    private RemovalListener<UserData, String> gdsSessionRemover = new RemovalListener<UserData, String>(){

        @Override
        public void onRemoval(RemovalNotification<UserData, String> removalNotif) {
            logger.fine("onRemoval called for userId=" + (removalNotif == null ? "null" : removalNotif.getKey()) + " for sessionData=" + (removalNotif == null ? "null" : removalNotif.getValue()));
            Preconditions.checkArgument(removalNotif != null, "onRemoval() was called with a null removalNotif");
            if (removalNotif.getKey() != null) {
                GDSClient gdsClient = removalNotif.getKey().gdsClient;
                FileserviceActionGds.this.logoutFromGds(gdsClient);
            }
        }
    };

    public static FileserviceActionGds getInstance() {
        if (instance == null) {
            instance = new FileserviceActionGds();
        }
        return instance;
    }

    private FileserviceActionGds() {
        this.sessionCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(120L, TimeUnit.SECONDS).removalListener(this.gdsSessionRemover).build(new CacheLoader<UserData, String>(){

            @Override
            public String load(UserData userData) throws MLSException {
                GDSClient gdsClient = userData.gdsClient;
                FileserviceActionGds.this.login(gdsClient, userData.mwaToken);
                return gdsClient.getSessionId();
            }
        });
    }

    public synchronized <T> T execute(FileAction<T> action) throws MLSException {
        Preconditions.checkArgument(action != null, "execute() was called with a null action");
        Preconditions.checkArgument(action.getUserToken() != null, "execute() was called with a null user token for action " + action.getClass());
        Preconditions.checkArgument(action.getGdsClient() != null, "execute() was called with a null gdsClient for action " + action.getClass());
        T result = null;
        try {
            String gdsSession = this.sessionCache.get(new UserData(action.getUserToken().getName(), action.getUserToken().getMwaToken(), action.getGdsClient()));
            action.getGdsClient().setSessionId(gdsSession);
        }
        catch (ExecutionException ex) {
            throw new MLSException("FileService.IOError", "Failed to establish fileserviceSession for action: " + action.getClass());
        }
        boolean isRetry = false;
        do {
            if (isRetry) {
                this.sessionCache.invalidate(action.getUserToken().getName());
                try {
                    this.sessionCache.get(new UserData(action.getUserToken().getName(), action.getUserToken().getMwaToken(), action.getGdsClient()));
                }
                catch (ExecutionException ex) {
                    throw new MLSException("FileService.IOError", "Failed to establish fileserviceSession for action: " + action.getClass());
                }
            }
            try {
                Future<T> future = this.asyncExecutor.submit(action);
                result = future.get(4000L, TimeUnit.MILLISECONDS);
                isRetry = false;
            }
            catch (TimeoutException toex) {
                throw new MLSException("FileService.IOError", "Execution timed out for action: " + action.getClass());
            }
            catch (InterruptedException intex) {
                throw new MLSException("FileService.IOError", "Execution interrupted for action: " + action.getClass());
            }
            catch (ExecutionException exc) {
                Throwable rootEx;
                logger.warning("ExecutionException thrown: " + exc);
                if (isRetry) {
                    logger.severe("Operation " + action.getClass() + " failed on retry.");
                    throw new MLSException("FileService.IOError", "Execution exception thrown with the message: " + exc.getMessage());
                }
                if (exc != null && (rootEx = exc.getCause()) != null) {
                    if (rootEx instanceof MathWorksServiceException) {
                        if (!isRetry && this.isSessionError((RuntimeException)((MathWorksServiceException)rootEx))) {
                            isRetry = true;
                            continue;
                        }
                        throw new MLSException("FileService.IOError", "GDS service error: " + rootEx + "; error code: " + ((MathWorksServiceException)rootEx).getErrorCode(), rootEx);
                    }
                    if (rootEx instanceof MathWorksClientException) {
                        if (!isRetry && this.isSessionError((RuntimeException)((MathWorksClientException)rootEx))) {
                            isRetry = true;
                            continue;
                        }
                        throw new MLSException("FileService.IOError", "GDS client error: " + rootEx + "; error code: " + ((MathWorksClientException)rootEx).getErrorCode(), rootEx);
                    }
                    throw new MLSException("FileService.IOError", "Execution exception thrown: " + rootEx, rootEx);
                }
                throw new MLSException("FileService.IOError", "Execution exception thrown: " + exc);
            }
        } while (isRetry);
        return result;
    }

    private void login(GDSClient gdsClient, String token) throws MLSException {
        Preconditions.checkArgument(!token.isEmpty(), "login() was called with an empty token");
        LoginRequest loginRequest = new LoginRequest();
        long start = System.nanoTime();
        try {
            gdsClient.login(loginRequest.withToken(token));
            String operationName = "GDSlogin";
            logger.info("SLA_GDSlogin:" + TimeUnit.MILLISECONDS.convert(System.nanoTime() - start, TimeUnit.NANOSECONDS));
        }
        catch (MathWorksServiceException mwse) {
            logger.severe("GDS login service error: " + mwse.getErrorCode());
            String operationName = "GDSfailedLogin";
            logger.info("SLA_GDSfailedLogin:" + TimeUnit.MILLISECONDS.convert(System.nanoTime() - start, TimeUnit.NANOSECONDS));
            throw new MLSException("GDS login service error: " + mwse.getErrorCode(), (Throwable)mwse);
        }
        catch (MathWorksClientException mwce) {
            logger.severe("GDS login service error: " + mwce.getErrorCode());
            String operationName = "GDSfailedLogin";
            logger.info("SLA_GDSfailedLogin:" + TimeUnit.MILLISECONDS.convert(System.nanoTime() - start, TimeUnit.NANOSECONDS));
            throw new MLSException("GDS login client error: " + mwce.getErrorCode(), (Throwable)mwce);
        }
    }

    public void logout(String userId, GDSClient gdsClient) throws MLSException {
        Preconditions.checkArgument(gdsClient != null, "logout() called with a null GdsClient instance");
        long start = System.nanoTime();
        try {
            this.sessionCache.invalidate(new UserData(userId, null, gdsClient));
            String operationName = "FileServiceActionGDSlogout";
            logger.info("SLA_FileServiceActionGDSlogout:" + TimeUnit.MILLISECONDS.convert(System.nanoTime() - start, TimeUnit.NANOSECONDS));
        }
        catch (MathWorksServiceException mwse) {
            logger.severe("GDS logout service error: " + mwse.getErrorCode());
            String operationName = "FileServiceActionGDSfailedLogout";
            logger.info("SLA_FileServiceActionGDSfailedLogout:" + TimeUnit.MILLISECONDS.convert(System.nanoTime() - start, TimeUnit.NANOSECONDS));
            throw new MLSException("GDS login service error: " + mwse.getErrorCode(), (Throwable)mwse);
        }
        catch (MathWorksClientException mwce) {
            logger.severe("GDS logout service error: " + mwce.getErrorCode());
            String operationName = "FileServiceActionGDSfailedLogout";
            logger.info("SLA_FileServiceActionGDSfailedLogout:" + TimeUnit.MILLISECONDS.convert(System.nanoTime() - start, TimeUnit.NANOSECONDS));
            throw new MLSException("GDS logout client error: " + mwce.getErrorCode(), (Throwable)mwce);
        }
    }

    private void logoutFromGds(GDSClient gdsClient) throws MLSException {
        Preconditions.checkArgument(gdsClient != null, "logout() called with a null GdsClient instance");
        LogoutRequest logoutRequest = new LogoutRequest();
        long start = System.nanoTime();
        try {
            gdsClient.logout(logoutRequest);
            String operationName = "GDSlogout";
            logger.info("SLA_GDSlogout:" + TimeUnit.MILLISECONDS.convert(System.nanoTime() - start, TimeUnit.NANOSECONDS));
        }
        catch (MathWorksServiceException mwse) {
            logger.severe("GDS logout service error: " + mwse.getErrorCode());
            String operationName = "GDSfailedLogout";
            logger.info("SLA_GDSfailedLogout:" + TimeUnit.MILLISECONDS.convert(System.nanoTime() - start, TimeUnit.NANOSECONDS));
            throw new MLSException("GDS login service error: " + mwse.getErrorCode(), (Throwable)mwse);
        }
        catch (MathWorksClientException mwce) {
            logger.severe("GDS logout service error: " + mwce.getErrorCode());
            String operationName = "GDSfailedLogout";
            logger.info("SLA_GDSfailedLogout:" + TimeUnit.MILLISECONDS.convert(System.nanoTime() - start, TimeUnit.NANOSECONDS));
            throw new MLSException("GDS logout client error: " + mwce.getErrorCode(), (Throwable)mwce);
        }
    }

    private boolean isSessionError(RuntimeException mwce) {
        Preconditions.checkArgument(mwce != null, "isSessionError() was called with a null exception instance");
        return this.isGdsClientErrorInSet(mwce, sessionErrors);
    }

    private boolean isGdsClientErrorInSet(RuntimeException mwe, EnumSet<GDSErrorCode> errorsSet) {
        Preconditions.checkArgument(mwe != null, "isGdsClientErrorInSet() was called with a null exception instance");
        Preconditions.checkArgument(mwe instanceof MathWorksClientException || mwe instanceof MathWorksServiceException, "isGdsClientErrorInSet() called with an exception of non-gds error class: " + mwe.getClass().getName());
        boolean result = false;
        String codeStr = "";
        try {
            codeStr = mwe instanceof MathWorksClientException ? ((MathWorksClientException)((Object)mwe)).getErrorCode() : ((MathWorksServiceException)((Object)mwe)).getErrorCode();
            GDSErrorCode gdsCode = GDSErrorCode.valueOf((String)codeStr);
            if (errorsSet.contains(gdsCode)) {
                result = true;
            }
        }
        catch (Exception ex) {
            logger.warning("Failed checking if the GDS returned error: \"" + mwe + "\", error code: \"" + codeStr + "\" is in the set: " + errorsSet + " : " + ex.getMessage());
        }
        return result;
    }

    public UserTokenDO getUserToken() {
        return this.userToken;
    }

    public void setUserToken(UserTokenDO userToken) {
        this.userToken = userToken;
    }

    static {
        sessionErrors = EnumSet.of(GDSErrorCode.AUTHENTICATION_ERROR, GDSErrorCode.SESSION_ID_CANNOT_BE_EMPTY, GDSErrorCode.SESSION_EXPIRED, GDSErrorCode.SESSION_NOT_FOUND);
    }

    public static abstract class FileAction<T>
    implements Callable<T> {
        protected UserTokenDO userToken;
        protected GDSClient gdsClient;

        @Override
        public abstract T call();

        public void setUserToken(UserTokenDO userToken) {
            this.userToken = userToken;
        }

        public UserTokenDO getUserToken() {
            return this.userToken;
        }

        public GDSClient getGdsClient() {
            return this.gdsClient;
        }

        public void setGdsClient(GDSClient gdsClient) {
            this.gdsClient = gdsClient;
        }
    }

    private static class UserData {
        String userId;
        String mwaToken;
        GDSClient gdsClient;

        UserData(String userId, String mwaToken, GDSClient gdsClient) {
            this.userId = userId;
            this.mwaToken = mwaToken;
            this.gdsClient = gdsClient;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof UserData)) {
                return false;
            }
            UserData that = (UserData)obj;
            return this.userId.equals(that.userId);
        }

        public int hashCode() {
            return this.userId.hashCode();
        }
    }
}

