/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.fileservices.versioning;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.mathworks.matlabserver.fileservices.util.FilenameConverter;
import com.mathworks.matlabserver.fileservices.util.FileserviceActionGds;
import com.mathworks.matlabserver.internalservices.faults.MLSException;
import com.mathworks.matlabserver.internalservices.file.FileDO;
import com.mathworks.matlabserver.internalservices.file.FileInfoDO;
import com.mathworks.matlabserver.internalservices.file.FileVersionAttributesDO;
import com.mathworks.matlabserver.internalservices.file.VersionService;
import com.mathworks.matlabserver.internalservices.security.UserTokenDO;
import com.mathworks.webservices.client.core.ClientConfiguration;
import com.mathworks.webservices.client.core.MathWorksClientException;
import com.mathworks.webservices.client.core.MathWorksServiceException;
import com.mathworks.webservices.gds.FileAccess;
import com.mathworks.webservices.gds.GDSClientImpl;
import com.mathworks.webservices.gds.Versioning;
import com.mathworks.webservices.gds.impl.VersioningImpl;
import com.mathworks.webservices.gds.model.Resource;
import com.mathworks.webservices.gds.model.fileaccess.FileReadRequest;
import com.mathworks.webservices.gds.model.fileaccess.FileReadResponse;
import com.mathworks.webservices.gds.model.versioning.VersionListRequest;
import com.mathworks.webservices.gds.model.versioning.VersionListResponse;
import com.mathworks.webservices.gds.model.versioning.VersionRestoreRequest;
import com.mathworks.webservices.gds.model.versioning.VersionRestoreResponse;
import com.mathworks.webservices.gds.model.versioning.VersionSummary;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public class VersionServiceGdsImpl
implements VersionService {
    private static final Logger logger = Logger.getLogger(VersionServiceGdsImpl.class.getName());
    private FilenameConverter filenameConverter;
    private GDSClientImpl gdsClient;
    FileAccess fileAccessor;
    private FileserviceActionGds fileActionExecutor;
    private static final String CLIENT_LOCALE = "en-US";
    private static final String CLIENT_NAME = "MOTW";
    private static final int CONNECTION_TIMEOUT = 60000;
    private static final int SOCKET_TIMEOUT = 30000;

    public VersionServiceGdsImpl(FilenameConverter filenameConverter, String gdsEndpoint) {
        logger.fine("Creating VersionServiceGdsImpl instance with filenameConverter=" + filenameConverter.getClass() + " and gdsEndpoint=" + gdsEndpoint);
        this.filenameConverter = filenameConverter;
        ClientConfiguration clientConfig = new ClientConfiguration();
        clientConfig.setConnectionTimeout(60000);
        clientConfig.setSocketTimeout(30000);
        this.gdsClient = new GDSClientImpl(clientConfig);
        this.gdsClient.setEndpoint(gdsEndpoint);
        this.gdsClient.setClientString(CLIENT_NAME);
        this.gdsClient.setLocale(CLIENT_LOCALE);
        this.fileAccessor = this.gdsClient.getFileAccess();
        this.fileActionExecutor = FileserviceActionGds.getInstance();
    }

    @Override
    public FileInfoDO[] getVersionHistory(UserTokenDO userToken, FileInfoDO fileInfo) throws MLSException {
        logger.info("Entering getVersionHistory for userToken=" + userToken + " and fileInfo=" + fileInfo);
        Preconditions.checkArgument(userToken != null, "getVersionHistory() was called with a null token");
        Preconditions.checkArgument(fileInfo != null, "getVersionHistory() was called with a null fileInfo");
        ListVersions fileVersionsListAction = new ListVersions(fileInfo, this.gdsClient, userToken);
        FileInfoDO[] versionsArray = this.fileActionExecutor.execute(fileVersionsListAction);
        logger.info("Returning from getVersionHistory: " + versionsArray);
        return versionsArray;
    }

    @Override
    public FileInfoDO[] listDeleted(UserTokenDO userToken, FileInfoDO folder) throws MLSException {
        throw new MLSException("VersionService.Error", "Listing deleted files isn't supported yet.");
    }

    @Override
    public FileInfoDO restoreVersion(UserTokenDO userToken, FileInfoDO fileInfo) throws MLSException {
        logger.info("Entering restoreVersion for userToken=" + userToken + " and fileInfo=" + fileInfo);
        Preconditions.checkArgument(userToken != null, "restoreVersion() was called with a null token");
        Preconditions.checkArgument(fileInfo != null, "restoreVersion() was called with a null fileInfo");
        Preconditions.checkArgument(fileInfo.getVersion() != null, "restoreVersion() was called with a fileInfo that has a null VersionAttributesDO");
        Preconditions.checkArgument(fileInfo.getVersion().getVersionNumber() != null, "restoreVersion() was called with a fileInfo that has a null version string");
        Preconditions.checkArgument(!fileInfo.getVersion().getVersionNumber().isEmpty(), "restoreVersion() was called with a fileInfo that has an empty version string");
        if (fileInfo.getVersion() == null) {
            throw new MLSException("VersionService.Error", "No version information specified.");
        }
        VersionRestore fileVersionRestoreAction = new VersionRestore(fileInfo, this.gdsClient, userToken);
        FileInfoDO newFileInfo = this.fileActionExecutor.execute(fileVersionRestoreAction);
        logger.info("Returning from restoreVersion: " + newFileInfo);
        return newFileInfo;
    }

    @Override
    public FileDO readVersion(UserTokenDO userToken, FileInfoDO fileInfo) throws MLSException {
        logger.info("Entering readVersion for userToken=" + userToken + " and fileInfo=" + fileInfo);
        Preconditions.checkArgument(userToken != null, "readVersion() was called with a null token");
        Preconditions.checkArgument(fileInfo != null, "readVersion() was called with a null fileInfo");
        Preconditions.checkArgument(fileInfo.getVersion() != null, "readVersion() was called with a fileInfo that has a null VersionAttributesDO");
        Preconditions.checkArgument(fileInfo.getVersion().getVersionNumber() != null, "readVersion() was called with a fileInfo that has a null version string");
        Preconditions.checkArgument(!fileInfo.getVersion().getVersionNumber().isEmpty(), "readVersion() was called with a fileInfo that has an empty version string");
        if (fileInfo.getVersion() == null) {
            throw new MLSException("VersionService.Error", "No version information specified.");
        }
        VersionRead fileVersionReadAction = new VersionRead(fileInfo, this.gdsClient, userToken);
        FileDO newFileDO = this.fileActionExecutor.execute(fileVersionReadAction);
        logger.info("Returning from readVersion; version: " + newFileDO.getFileInfo().getVersion() + "; contents: " + newFileDO.getContent());
        return newFileDO;
    }

    private class VersionRead
    extends FileserviceActionGds.FileAction<FileDO> {
        private FileInfoDO fileInfoDO;
        private Versioning gdsVersioningHandler;

        VersionRead(FileInfoDO fileInfoDO, GDSClientImpl gdsClient, UserTokenDO userToken) {
            this.fileInfoDO = fileInfoDO;
            this.gdsClient = gdsClient;
            this.userToken = userToken;
            this.gdsVersioningHandler = new VersioningImpl(gdsClient);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public FileDO call() throws MathWorksServiceException, MathWorksClientException {
            FileReadResponse fileReadResponse;
            String path = VersionServiceGdsImpl.this.filenameConverter.getServerFilename(this.userToken, this.fileInfoDO);
            Resource fileResource = new Resource().withPath(path);
            long start = System.nanoTime();
            try {
                fileReadResponse = VersionServiceGdsImpl.this.fileAccessor.readFile(((FileReadRequest)new FileReadRequest().withResource(fileResource)).withVersionLabel(Integer.valueOf(this.fileInfoDO.getVersion().getVersionNumber())));
            }
            finally {
                String operationName = "GDSreadVersion";
                logger.info("SLA_GDSreadVersion:" + TimeUnit.MILLISECONDS.convert(System.nanoTime() - start, TimeUnit.NANOSECONDS));
            }
            byte[] fileContentsBytes = fileReadResponse.getResponseBody();
            FileDO fileDO = new FileDO();
            fileDO.setFileInfo(this.fileInfoDO);
            fileDO.setData(fileContentsBytes);
            logger.info("Returning from readVersion; version contents: " + fileContentsBytes);
            return fileDO;
        }
    }

    private class VersionRestore
    extends FileserviceActionGds.FileAction<FileInfoDO> {
        private FileInfoDO fileInfoDO;
        private Versioning gdsVersioningHandler;

        VersionRestore(FileInfoDO fileInfoDO, GDSClientImpl gdsClient, UserTokenDO userToken) {
            this.fileInfoDO = fileInfoDO;
            this.gdsClient = gdsClient;
            this.userToken = userToken;
            this.gdsVersioningHandler = new VersioningImpl(gdsClient);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public FileInfoDO call() throws MathWorksServiceException, MathWorksClientException {
            VersionRestoreResponse restoreResponse;
            String path = VersionServiceGdsImpl.this.filenameConverter.getServerFilename(this.userToken, this.fileInfoDO);
            Resource fileResource = new Resource().withPath(path);
            VersionRestoreRequest restoreRequest = new VersionRestoreRequest().withResource(fileResource).withVersionLabel(Integer.valueOf(this.fileInfoDO.getVersion().getVersionNumber())).withCreateNewVersion(Boolean.valueOf(true));
            long start = System.nanoTime();
            try {
                restoreResponse = this.gdsVersioningHandler.restoreVersion(restoreRequest);
            }
            finally {
                String operationName = "GDSrestoreVersion";
                logger.info("SLA_GDSrestoreVersion:" + TimeUnit.MILLISECONDS.convert(System.nanoTime() - start, TimeUnit.NANOSECONDS));
            }
            FileInfoDO newFileInfo = new FileInfoDO();
            newFileInfo.setName(this.fileInfoDO.getName());
            newFileInfo.setLocation(this.fileInfoDO.getLocation());
            FileVersionAttributesDO version = new FileVersionAttributesDO();
            version.setVersionNumber(restoreResponse.getVersionLabel().toString());
            return newFileInfo;
        }
    }

    private class ListVersions
    extends FileserviceActionGds.FileAction<FileInfoDO[]> {
        private FileInfoDO fileInfoDO;
        private Versioning gdsVersioningHandler;

        ListVersions(FileInfoDO fileInfoDO, GDSClientImpl gdsClient, UserTokenDO userToken) {
            this.fileInfoDO = fileInfoDO;
            this.gdsClient = gdsClient;
            this.userToken = userToken;
            this.gdsVersioningHandler = new VersioningImpl(gdsClient);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public FileInfoDO[] call() throws MathWorksServiceException, MathWorksClientException {
            VersionListResponse listResponse;
            String path = VersionServiceGdsImpl.this.filenameConverter.getServerFilename(this.userToken, this.fileInfoDO);
            Resource fileResource = new Resource().withPath(path);
            VersionListRequest listRequest = new VersionListRequest().withResource(fileResource);
            long start = System.nanoTime();
            try {
                listResponse = this.gdsVersioningHandler.listVersions(listRequest);
            }
            finally {
                String operationName = "GDSlistVersions";
                logger.info("SLA_GDSlistVersions:" + TimeUnit.MILLISECONDS.convert(System.nanoTime() - start, TimeUnit.NANOSECONDS));
            }
            List<VersionSummary> versions = Lists.reverse(listResponse.getVersions());
            ArrayList<FileInfoDO> versionList = new ArrayList<FileInfoDO>();
            for (VersionSummary versionInfo : versions) {
                FileInfoDO versionDO = new FileInfoDO();
                versionDO.setName(this.fileInfoDO.getName());
                versionDO.setLocation(this.fileInfoDO.getLocation());
                FileVersionAttributesDO version = new FileVersionAttributesDO();
                version.setVersionNumber(versionInfo.getVersionLabel().toString());
                Date modifiedDate = versionInfo.getCreatedDate();
                version.setVersionDate(modifiedDate);
                versionDO.setModified(modifiedDate);
                versionDO.setVersion(version);
                versionList.add(versionDO);
            }
            return versionList.toArray(new FileInfoDO[versionList.size()]);
        }
    }
}

