/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.internalservices.common;

import com.mathworks.matlabserver.internalservices.annotations.ExposeClass;
import com.mathworks.matlabserver.internalservices.message.MLSMessage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@ExposeClass
public class MessageContainerDO
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<Class<?>, List<MLSMessage>> messages = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void addMessage(Class<T> messageClass, MLSMessage messageInstance) {
        Map<Class<?>, List<MLSMessage>> map = this.messages;
        synchronized (map) {
            List<Object> messageList = null;
            if (this.messages.get(messageClass) == null) {
                messageList = new ArrayList();
                this.messages.put(messageClass, messageList);
            } else {
                messageList = this.messages.get(messageClass);
            }
            messageList.add(messageInstance);
        }
    }

    public <T> void addMessages(Class<T> messageClass, Collection<? extends MLSMessage> messageInstances) {
        for (MLSMessage mLSMessage : messageInstances) {
            this.addMessage(messageClass, mLSMessage);
        }
    }

    public <T> T getAndConsumeMessage(Class<T> messageClass) {
        T retval = null;
        retval = this.getMessage(messageClass);
        this.consumeMessage(messageClass);
        return retval;
    }

    public <T> List<T> getAndConsumeMessages(Class<T> messageClass) {
        List<T> retval = this.getMessages(messageClass);
        this.consumeMessages(messageClass);
        return retval;
    }

    public <T> T getMessage(Class<T> messageClass) {
        T retval = null;
        List<MLSMessage> messageList = this.messages.get(messageClass);
        if (messageList != null && messageList.size() > 0) {
            retval = messageClass.cast(messageList.get(0));
        }
        return retval;
    }

    public <T> List<T> getMessages(Class<T> messageClass) {
        ArrayList<T> retval = new ArrayList<T>();
        List<MLSMessage> messageList = this.messages.get(messageClass);
        if (messageList != null && messageList.size() > 0) {
            for (MLSMessage message : messageList) {
                retval.add(messageClass.cast(message));
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void consumeMessage(Class<T> messageClass) {
        Map<Class<?>, List<MLSMessage>> map = this.messages;
        synchronized (map) {
            List<MLSMessage> messageList = this.messages.get(messageClass);
            if (messageList != null) {
                if (messageList.size() > 0) {
                    messageList.remove(0);
                }
                if (messageList.size() == 0) {
                    this.messages.remove(messageClass);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void consumeMessages(Class<T> messageClass) {
        Map<Class<?>, List<MLSMessage>> map = this.messages;
        synchronized (map) {
            List<MLSMessage> messageList = this.messages.get(messageClass);
            if (messageList != null) {
                this.messages.remove(messageClass);
            }
        }
    }

    public Collection<MLSMessage> getAllMessages() {
        ArrayList<MLSMessage> allMessages = new ArrayList<MLSMessage>();
        for (List<MLSMessage> messageList : this.messages.values()) {
            allMessages.addAll(messageList);
        }
        return allMessages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<MLSMessage> getAndConsumeAllMessages() {
        Collection<MLSMessage> allMessages;
        Map<Class<?>, List<MLSMessage>> map = this.messages;
        synchronized (map) {
            allMessages = this.getAllMessages();
            this.messages.clear();
        }
        return allMessages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAllMessages(Collection<MLSMessage> allMessages) {
        Map<Class<?>, List<MLSMessage>> map = this.messages;
        synchronized (map) {
            for (MLSMessage message : allMessages) {
                this.addMessage(message.getClass(), message);
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MessageContainerDO other = (MessageContainerDO)obj;
        Collection<MLSMessage> otherMessages = other.getAllMessages();
        return otherMessages.containsAll(this.getAllMessages()) && this.getAllMessages().containsAll(otherMessages);
    }

    public int hashCode() {
        int hash = 7;
        hash = 73 * hash + (this.messages != null ? ((Object)this.messages).hashCode() : 0);
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MessageContainerDO");
        sb.append("{messages=");
        for (MLSMessage message : this.getAllMessages()) {
            sb.append(message.toString()).append(",");
        }
        sb.append('}');
        return sb.toString();
    }
}

