/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.jsonconverter.impl;

import com.mathworks.matlabserver.internalservices.common.MessageContainerDO;
import com.mathworks.matlabserver.internalservices.compute.ComputeTokenDO;
import com.mathworks.matlabserver.internalservices.faults.MessageFaultDO;
import com.mathworks.matlabserver.internalservices.message.MLSMessage;
import com.mathworks.matlabserver.jsonconverter.ClassLookupService;
import com.mathworks.matlabserver.jsonconverter.JsonConverterService;
import com.mathworks.matlabserver.jsonconverter.JsonRequestPayload;
import com.mathworks.matlabserver.jsonconverter.JsonResponsePayload;
import com.mathworks.matlabserver.jsonconverter.JsonSchemaGenerator;
import com.mathworks.matlabserver.jsonconverter.impl.ClassLookupServiceImpl;
import com.mathworks.matlabserver.jsonconverter.impl.JsonConverterServiceImpl;
import java.util.Iterator;
import java.util.logging.Logger;

public class JsonSchemaGeneratorImpl
implements JsonSchemaGenerator {
    private static final Logger logger = Logger.getLogger(JsonSchemaGeneratorImpl.class.getName());
    private final ClassLookupService classLookupService;
    private final JsonConverterService converter;

    public JsonSchemaGeneratorImpl(ClassLookupService classLookupService, JsonConverterService converter) {
        this.converter = converter;
        this.classLookupService = classLookupService;
    }

    @Override
    public String createJSONSchema() {
        Iterator<Class> classIt = this.classLookupService.getRequestClasses().iterator();
        StringBuilder jsonDoc = new StringBuilder();
        jsonDoc.append("\n\n\nRequest Schema:\n\n");
        jsonDoc.append(this.createRequestSchema(classIt));
        jsonDoc.append("\n\n\nResponse Schema:\n\n");
        jsonDoc.append(this.createResponseSchema(this.classLookupService.getResponseClasses().iterator()));
        return jsonDoc.toString();
    }

    private String createRequestSchema(Iterator<Class> classIt) {
        JsonRequestPayload requestPayload = new JsonRequestPayload();
        requestPayload.setUuid("correlationId");
        ComputeTokenDO computeToken = new ComputeTokenDO();
        computeToken.setComputeSessionId("sometokenid");
        requestPayload.setComputeToken(computeToken);
        MessageContainerDO messageContainer = this.createMessageContainer(classIt);
        requestPayload.setMessages(messageContainer);
        return this.converter.convertRequestPayloadToJson(requestPayload);
    }

    private String createResponseSchema(Iterator<Class> classIt) {
        JsonResponsePayload responsePayload = new JsonResponsePayload();
        responsePayload.setUuid("correlationId");
        MessageContainerDO messageContainer = this.createMessageContainer(classIt);
        responsePayload.setMessages(messageContainer);
        MessageFaultDO fault = new MessageFaultDO();
        fault.setFaultCode("someFaultCode");
        fault.setMessage("some debug message");
        responsePayload.setFault(fault);
        return this.converter.convertResponsePayloadToJson(responsePayload);
    }

    private MessageContainerDO createMessageContainer(Iterator<Class> classIt) {
        MessageContainerDO messageContainer = new MessageContainerDO();
        while (classIt.hasNext()) {
            Class clazz = classIt.next();
            try {
                MLSMessage instance = (MLSMessage)clazz.newInstance();
                messageContainer.addMessage(clazz, instance);
            }
            catch (Exception e2) {
                logger.warning(e2.getMessage());
            }
        }
        return messageContainer;
    }

    public static void main(String[] args) {
        ClassLookupServiceImpl classLookupService = new ClassLookupServiceImpl();
        JsonConverterServiceImpl converter = new JsonConverterServiceImpl(classLookupService);
        JsonSchemaGeneratorImpl jsonSchemaGenerator = new JsonSchemaGeneratorImpl(classLookupService, converter);
        String doc = jsonSchemaGenerator.createJSONSchema();
        logger.info(doc);
    }
}

