/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.jsonconverter.impl.file;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mathworks.matlabserver.internalservices.file.FileInfoDO;
import com.mathworks.matlabserver.internalservices.file.ListFileRequestMessageDO;
import com.mathworks.matlabserver.internalservices.file.ListFileResponseMessageDO;
import java.lang.reflect.Type;

public class ListFileConverter
implements JsonDeserializer,
JsonSerializer {
    public JsonElement serialize(Object o2, Type type, JsonSerializationContext jsonSerializationContext) {
        JsonObject jsonObject = new JsonObject();
        if (o2 instanceof ListFileResponseMessageDO) {
            ListFileResponseMessageDO response = (ListFileResponseMessageDO)o2;
            FileInfoDO[] fileInfoArray = response.getFileInfoArray();
            FileInfoDO folder = response.getFolder();
            JsonElement element = fileInfoArray != null ? jsonSerializationContext.serialize(fileInfoArray, fileInfoArray.getClass()) : new JsonObject();
            jsonObject.add("folderContents", element);
            JsonElement elementFolder = folder != null ? jsonSerializationContext.serialize(folder, folder.getClass()) : new JsonObject();
            jsonObject.add("folder", elementFolder);
            JsonElement elementFaults = jsonSerializationContext.serialize(response.getMessageFaults(), response.getMessageFaults().getClass());
            jsonObject.add("messageFaults", elementFaults);
        }
        return jsonObject;
    }

    public Object deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        ListFileRequestMessageDO retval = null;
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        if (type == ListFileRequestMessageDO.class) {
            ListFileRequestMessageDO request = new ListFileRequestMessageDO();
            request.setFileInfo(this.getFileInfo(jsonObject));
            request.setUuid(this.getUuid(jsonObject));
            retval = request;
        }
        return retval;
    }

    private String getUuid(JsonObject jsonObject) {
        String retval = null;
        JsonElement element = jsonObject.get("uuid");
        if (element != null) {
            retval = element.getAsString();
        }
        return retval;
    }

    private FileInfoDO getFileInfo(JsonObject jsonObject) {
        String path;
        FileInfoDO fileInfo = null;
        JsonElement element = jsonObject.get("path");
        if (element != null && (path = element.getAsString()) != null) {
            fileInfo = new FileInfoDO(path);
        }
        return fileInfo;
    }
}

