/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.jsonconverter.impl.util;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.mathworks.matlabserver.internalservices.faults.MessageFaultDO;
import com.mathworks.matlabserver.internalservices.file.FileInfoDO;
import com.mathworks.matlabserver.internalservices.message.AbstractMessageDO;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class JsonConverterUtil {
    public static final String SEPARATOR = "/";
    public static final String JSON_TAG_EMPTY = "";
    public static final String JSON_TAG_MESSAGE_FAULTS = "messageFaults";
    public static final String JSON_TAG_FAULT = "fault";
    public static final String JSON_TAG_UUID = "uuid";
    public static final String JSON_TAG_PATH = "path";
    public static final String JSON_TAG_FOLDER = "folder";
    public static final String JSON_TAG_FOLDER_CONTENTS = "folderContents";
    public static final String JSON_TAG_FILE_INFO = "fileInfo";
    public static final String JSON_TAG_FILE_CONTENT = "content";
    public static final String JSON_TAG_SOURCE_PATH = "srcPath";
    public static final String JSON_TAG_DESTINATION_PATH = "destPath";
    public static final String JSON_TAG_EVAL_RESULTS = "results";
    public static final String JSON_TAG_EVAL_ERROR = "isError";
    public static final String JSON_TAG_VERSION = "version";

    public static <T> JsonElement getField(JsonSerializationContext context, T object) {
        return context.serialize(object, object.getClass());
    }

    public static <T> JsonElement getEmptyJsonFieldifNull(JsonSerializationContext context, T object) {
        JsonElement elm = null;
        if (object != null) {
            elm = context.serialize(object, object.getClass());
        }
        return elm == null || elm.isJsonNull() ? JsonConverterUtil.getField(context, JSON_TAG_EMPTY) : elm;
    }

    public static <T> T getField(JsonDeserializationContext context, JsonElement object, Class<T> clazz) {
        return context.deserialize(object, clazz);
    }

    public static <T extends JsonElement, MessageType> MessageType getEmptyFieldifNull(JsonDeserializationContext context, T object, Class<MessageType> clazz) {
        if (object == null) {
            return JsonConverterUtil.getField(context, new JsonNull(), clazz);
        }
        return JsonConverterUtil.getField(context, object, clazz);
    }

    public static JsonElement getUuid(JsonSerializationContext context, AbstractMessageDO message) {
        return context.serialize(message != null ? JsonConverterUtil.getEmptyJsonFieldifNull(context, message.getUuid()).getAsString() : JSON_TAG_EMPTY, (Type)((Object)String.class));
    }

    public static String getUuid(JsonDeserializationContext context, JsonObject jsonObject) {
        return jsonObject == null || !jsonObject.has(JSON_TAG_UUID) ? JSON_TAG_EMPTY : JsonConverterUtil.getEmptyFieldifNull(context, jsonObject.get(JSON_TAG_UUID), String.class);
    }

    public static FileInfoDO getFileInfo(JsonObject jsonObject, String fieldName) {
        JsonElement element;
        FileInfoDO fileInfo = null;
        JsonElement jsonElement = element = jsonObject.has(fieldName) ? jsonObject.get(fieldName) : null;
        if (element != null) {
            String path = element.getAsString();
            fileInfo = new FileInfoDO(path);
        }
        return fileInfo;
    }

    public static List<MessageFaultDO> getMessageFaults(JsonObject jsonObject, JsonDeserializationContext context) {
        JsonElement faultElement = jsonObject.get(JSON_TAG_MESSAGE_FAULTS);
        ArrayList<MessageFaultDO> faults = new ArrayList<MessageFaultDO>();
        if (faultElement != null && faultElement.isJsonArray()) {
            for (JsonElement element : faultElement.getAsJsonArray()) {
                faults.add((MessageFaultDO)context.deserialize(element, (Type)((Object)MessageFaultDO.class)));
            }
        }
        return faults;
    }

    public static <MessageType extends FileInfoDO> JsonElement populateFromFileInfo(MessageType message, JsonObject jsonObject, JsonSerializationContext context, AbstractMessageDO obj) {
        String path = message != null ? (message.getLocation() + SEPARATOR).replace("//", SEPARATOR) + message.getName() : JSON_TAG_EMPTY;
        String version = message != null && message.getVersion() != null ? message.getVersion().getVersionNumber() : JSON_TAG_EMPTY;
        jsonObject.add(JSON_TAG_PATH, JsonConverterUtil.getField(context, path.length() > SEPARATOR.length() && path.endsWith(SEPARATOR) ? path.substring(0, path.length() - SEPARATOR.length()) : path));
        jsonObject.add(JSON_TAG_VERSION, JsonConverterUtil.getField(context, version));
        jsonObject.add(JSON_TAG_UUID, JsonConverterUtil.getUuid(context, obj));
        return jsonObject;
    }
}

