/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.rest.client.jersey;

import com.mathworks.matlabserver.common.rest.RestClientConfig;
import com.mathworks.matlabserver.rest.client.jersey.BaseJerseyRestClient;
import com.mathworks.matlabserver.rest.client.jersey.LabelledThreadFactory;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.client.non.blocking.NonBlockingClient;
import com.sun.jersey.client.non.blocking.NonBlockingClientHandler;
import com.sun.jersey.client.non.blocking.config.DefaultNonBlockingClientConfig;
import com.sun.jersey.client.urlconnection.HTTPSProperties;
import com.sun.jersey.core.impl.provider.entity.StringProvider;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.codehaus.jackson.jaxrs.JacksonJsonProvider;

public class NonBlockingBaseJerseyClient
extends BaseJerseyRestClient {
    private static final Logger logger = Logger.getLogger(NonBlockingBaseJerseyClient.class.getName());
    private final Client asyncClient;

    public NonBlockingBaseJerseyClient(RestClientConfig clientConfig) {
        super(clientConfig);
        this.asyncClient = this.setupAsyncClient(clientConfig);
    }

    public Client getAsyncClient() {
        return this.asyncClient;
    }

    @Override
    public Client getClient() {
        logger.info("Getting BaseJerseyRestClient");
        return super.getClient();
    }

    private Client setupAsyncClient(RestClientConfig clientConfig) {
        DefaultNonBlockingClientConfig jerseyClientConfig = new DefaultNonBlockingClientConfig();
        jerseyClientConfig.getProperties().put("com.sun.jersey.client.property.connectTimeout", clientConfig.getConnectTimeoutMillis());
        jerseyClientConfig.getProperties().put("com.sun.jersey.client.property.readTimeout", clientConfig.getReadTimeoutMillis());
        jerseyClientConfig.getClasses().add(JacksonJsonProvider.class);
        jerseyClientConfig.getClasses().add(StringProvider.class);
        jerseyClientConfig.getFeatures().put("com.sun.jersey.api.json.POJOMappingFeature", Boolean.TRUE);
        logger.info("Generating jersey client thread-pool labelled:" + clientConfig.getThreadPoolLabel());
        jerseyClientConfig.getProperties().put("com.sun.jersey.impl.client.non.blocking.executorService", Executors.newCachedThreadPool(new LabelledThreadFactory(clientConfig.getThreadPoolLabel())));
        TrustManager[] tm = this.createTrustManagers();
        SSLContext sslContext = this.createSSLContext(tm);
        HostnameVerifier hostNameVerifier = this.createHostNameVerifier();
        try {
            jerseyClientConfig.getProperties().put("com.sun.jersey.client.impl.urlconnection.httpsProperties", new HTTPSProperties(hostNameVerifier, sslContext));
        }
        catch (Exception e2) {
            logger.log(Level.SEVERE, "Error setting HTTPS properties for Non-blocking REST client", e2);
        }
        NonBlockingClientHandler clientHandler = new NonBlockingClientHandler((ClientConfig)jerseyClientConfig);
        return new NonBlockingClient(clientHandler, (ClientConfig)jerseyClientConfig);
    }
}

