/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.worker.service.breakpoint.impl13b;

import com.mathworks.matlab.api.editor.actions.DebuggerActions;
import com.mathworks.matlabserver.workercommon.client.ClientServiceRegistryFactory;
import com.mathworks.mde.editor.EditorStartup;
import com.mathworks.mde.editor.MFilePathUtil;
import com.mathworks.messageservice.Message;
import com.mathworks.messageservice.MessageService;
import com.mathworks.messageservice.MessageServiceFactory;
import com.mathworks.messageservice.Subscriber;
import com.mathworks.mlservices.MatlabDebugAdapter;
import com.mathworks.mlservices.MatlabDebugObserver;
import com.mathworks.mlservices.MatlabDebugServices;
import com.mathworks.mlwidgets.debug.MatlabDebuggerActions;
import com.mathworks.util.AbsoluteFile;
import com.mathworks.widgets.debug.DebuggerManager;
import java.io.File;
import java.util.HashMap;
import javax.swing.Action;

public class DebuggerInstaller {
    private MessageService fMessageService;
    private static final String DEBUGGER_STATE_CHANGE = "/editor/debugger/debugger-state-change";
    private static final String DEBUGGER_STATE_REQUEST = "/editor/debugger/debugger-state-request";
    private static final String DEBUG_CONTINUE = "/editor/debugger/debug-continue";
    private static final String DEBUG_STEP = "/editor/debugger/debug-step";
    private static final String DEBUG_STEP_IN = "/editor/debugger/debug-step-in";
    private static final String DEBUG_STEP_OUT = "/editor/debugger/debug-step-out";
    private static final String DEBUG_EXIT = "/editor/debugger/debug-exit";
    private final DebuggerManager.DebuggerManagerStateListener fDebuggerManagerStateListener = this.createDebuggerManagerStateListener();
    private final MatlabDebugObserver fDebugStateListener = new DebugStateListener();
    private boolean fInitialized;
    private Subscriber fDebuggerStateRequestSubscriber = this.debuggerStateRequestSubscriber();
    private Subscriber fDebugContinueSubscriber = this.createDebuggerActionSubscriber(DebuggerManager.getInstance().getContinueAction());
    private Subscriber fDebugStepSubscriber = this.createDebuggerActionSubscriber(DebuggerManager.getInstance().getStepAction());
    private Subscriber fDebugStepInSubscriber = this.createDebuggerActionSubscriber(DebuggerManager.getInstance().getStepInAction());
    private Subscriber fDebugStepOutSubscriber = this.createDebuggerActionSubscriber(DebuggerManager.getInstance().getStepOutAction());
    private Subscriber fDebugExitSubscriber = this.createDebuggerActionSubscriber(DebuggerManager.getInstance().getExitDebugAction());

    public DebuggerInstaller() {
        this.initializeListeners();
    }

    private void initializeListeners() {
        if (!this.fInitialized) {
            this.fMessageService = MessageServiceFactory.getMessageService();
            DebuggerManager.addDebugManagerStateListener((DebuggerManager.DebuggerManagerStateListener)this.fDebuggerManagerStateListener);
            MatlabDebugServices.addDefaultObserverListener((MatlabDebugObserver)this.fDebugStateListener);
            this.fMessageService.subscribe(DEBUGGER_STATE_REQUEST, this.fDebuggerStateRequestSubscriber);
            this.fMessageService.subscribe(DEBUG_CONTINUE, this.fDebugContinueSubscriber);
            this.fMessageService.subscribe(DEBUG_STEP, this.fDebugStepSubscriber);
            this.fMessageService.subscribe(DEBUG_STEP_IN, this.fDebugStepInSubscriber);
            this.fMessageService.subscribe(DEBUG_STEP_OUT, this.fDebugStepOutSubscriber);
            this.fMessageService.subscribe(DEBUG_EXIT, this.fDebugExitSubscriber);
            this.publishDebuggerChange();
            this.fInitialized = true;
        }
    }

    private Subscriber debuggerStateRequestSubscriber() {
        return new Subscriber(){

            @Override
            public void handle(Message message) {
                DebuggerInstaller.this.publishDebuggerChange();
            }
        };
    }

    private void publishDebuggerChange() {
        HashMap<String, Boolean> debuggerData = new HashMap<String, Boolean>();
        debuggerData.put("isDebugging", DebuggerManager.isDebugging() || EditorStartup.getInDebugMode());
        this.fMessageService.publish(DEBUGGER_STATE_CHANGE, debuggerData);
    }

    private DebuggerManager.DebuggerManagerStateListener createDebuggerManagerStateListener() {
        return new DebuggerManager.DebuggerManagerStateListener(){

            public void stateUpdated(DebuggerManager.DebuggerTransition transition, Class<? extends DebuggerActions> debuggerType) {
                if (MatlabDebuggerActions.class.equals(debuggerType)) {
                    return;
                }
                DebuggerInstaller.this.publishDebuggerChange();
            }
        };
    }

    private Subscriber createDebuggerActionSubscriber(final Action debugAction) {
        return new Subscriber(){

            @Override
            public void handle(Message message) {
                debugAction.actionPerformed(null);
            }
        };
    }

    public void dispose() {
        MatlabDebugServices.removeDefaultObserverListener((MatlabDebugObserver)this.fDebugStateListener);
        DebuggerManager.removeDebugManagerStateListener((DebuggerManager.DebuggerManagerStateListener)this.fDebuggerManagerStateListener);
        this.fMessageService.unsubscribe(DEBUGGER_STATE_REQUEST, this.fDebuggerStateRequestSubscriber);
        this.fMessageService.unsubscribe(DEBUGGER_STATE_REQUEST, this.fDebuggerStateRequestSubscriber);
        this.fMessageService.unsubscribe(DEBUG_CONTINUE, this.fDebugContinueSubscriber);
        this.fMessageService.unsubscribe(DEBUG_STEP, this.fDebugStepSubscriber);
        this.fMessageService.unsubscribe(DEBUG_STEP_IN, this.fDebugStepInSubscriber);
        this.fMessageService.unsubscribe(DEBUG_STEP_OUT, this.fDebugStepOutSubscriber);
        this.fMessageService.unsubscribe(DEBUG_EXIT, this.fDebugExitSubscriber);
        this.fInitialized = false;
    }

    private void openFile(String fileName) {
        File file = new File(fileName);
        AbsoluteFile absoluteFile = MFilePathUtil.accountForPFilesAndMakeAbsolute((File)file);
        if (absoluteFile.exists()) {
            ClientServiceRegistryFactory.getClientServiceRegistryFacade().getEditorService().createOrOpenFile(absoluteFile.getPath());
        }
    }

    private class DebugStateListener
    extends MatlabDebugAdapter {
        private DebugStateListener() {
        }

        public void doDebugMode(boolean debugMode) {
            DebuggerInstaller.this.publishDebuggerChange();
        }

        public void doDBStop(String fileName, int lineNumber) {
            DebuggerInstaller.this.openFile(fileName);
        }

        public void doDbupDbdownChange(String fileName, int lineNumber) {
            DebuggerInstaller.this.openFile(fileName);
        }
    }
}

