/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.worker_config_management;

import com.mathworks.matlabserver.common.rest.RestClientConfig;
import com.mathworks.matlabserver.config_management.config.ConfigService;
import com.mathworks.matlabserver.config_management.config.ConfigServiceFactory;
import com.mathworks.matlabserver.worker_config_management.MatlabServerConfigBean;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

public final class MatlabServerConfigLoadWorkerProperties {
    private static final Logger sLogger = Logger.getLogger(MatlabServerConfigBean.class.getName());
    private static final String DEFAULT_PROPERTIES_FILE = "worker-default.properties";
    private static final String RMIHOSTNAME = "rmiHostName";
    private static final String RMIPORT = "rmiPort";
    private static final String RMISERVERNAME = "rmiServerName";
    private static final String MDCS_JOBMANAGERNAME = "mdcsJobManagerName";
    private static final String MDCS_JOBMANAGERHOST = "mdcsJobManagerHost";
    private static final String FILESERVICE = "fileService";
    private static final String SERVER_MOUNTPOINT = "serverMountPoint";
    private static final String WORKER_MOUNTPOINT = "matlabWorkerMountPoint";
    private static final String ENABLE_FILESERVICE_LOGGING = "enableFileServiceLogging";
    private static final String UNIQUE_FILENAMES = "uniqueFilenames";
    private static final String MOUNT_PERMISSIONS = "mountPermissions";
    private static final String DISABLE_FIELSYSTEMCACHE_FORSHAREDFOLDERS = "disableFileSystemCacheForSharedFolders";
    private static final String RMI_LOCAL_ENABLE_WORKER_RMI_SERVER = "rmiLocalEnableWorkerRMIServer";
    private static final String RMI_LOCAL_ENABLE_FILESYSTEM_RMI_SERVER = "rmiLocalEnableFilesystemRMIServer";
    private static final String RMI_MCG_PORT = "rmiMatlabClientGatewayPort";
    private static final String RMI_LOCAL_REGISTRY_PORT = "rmiLocalRegistryPort";
    private static final String RMI_LOCAL_WORKER_PORT = "rmiLocalWorkerPort";
    private static final String RMI_LOCAL_WORKER_NAME = "rmiLocalWorkerName";
    private static final String RMI_LOCAL_FILESYSTEM_PORT = "rmiLocalFileSystemPort";
    private static final String RMI_LOCAL_FILESYSTEM_NAME = "rmiLocalFileSystemName";
    private static final String RMILocalFileSystemCacheManagerPort = "rmiLocalFileSystemCacheManagerPort";
    private static final String RMILocalFileSystemCacheManagerName = "rmiLocalFileSystemCacheManagerName";
    private static final String CACHE_MANAGER_INITIAL_DELAY_MS = "cacheManagerInitialDelayMS";
    private static final String CACHE_MANGER_CYCLE_TIME_MS = "cacheManagerCycleTimeMS";
    private static final String GDS_MOUNT_TIMEOUT_S = "gdsMountTimeoutS";
    private static final String ENABLE_AUTOSUGGEST = "enableAutoSuggest";
    private static final String ENABLE_MCG = "enableMatlabClientGateway";
    private static final String MCG_TIMEOUT = "matlabClientGatewayTimeout";
    private static final String ENABLE_MCG_RESTART = "enableMatlabClientGatewayRestart";
    private static final String MATLAB_VERSION = "matlabVersion";
    private static final String ENABLE_CLIENTGATEWAY_WEBSERVER = "enableClientGatewayWebServer";
    private static final String WEB_SERVER_CONFIGFILE = "webServerConfigFile";
    private static final String WORKER_GATEWAY_WEB_SERVER_PORT = "workerGatewayWebServerPort";
    private static final String ENABLE_ASYNC_PUSH_MGG = "enableAsyncPushForMGG";
    private static final String WORKER_FILE_SYSTEM_MODE = "workerFileSystemMode";
    private static final String GDS_MOUNT_COMMAND = "gdsMountCommand";
    private static final String GDS_USE_ASYNC_FILE_VERSIONING = "useGdsAsyncVersioning";
    private static final String GDS_ENDPOINT = "gdsEndpoint";
    private static final String MATLAB_ROOT_DIRECTORY = "matlabRootDirectory";
    private static final String ENABLE_CONSOLE_LOGGING = "enableConsoleLogging";
    private static final String LOG_FILE_NAME = "logFileName";
    private static final String LOG_FILE_FORMAT = "logFileFormat";
    private static final String USE_MRM_REST_API = "useMrmRestApi";
    private static final String MRM_API_ENDPOINT = "mrmApiEndpoint";
    private static final String MRM_CLIENT_CONNECT_TIMEOUT_MILLIS = "mrmClientConnectTimeoutMillis";
    private static final String MRM_CLIENT_READ_TIMEOUT_MILLIS = "mrmClientReadTimeoutMillis";
    private static final String MRM_CLIENT_HTTP_PROXY_HOST = "mrmClientHttpProxyHost";
    private static final String MRM_CLIENT_HTTP_PROXY_PORT = "mrmClientHttpProxyPort";
    private static final String WORKER_GATEWAY_WEB_APP_ENABLED = "workerGatewayWebappEnabled";
    private static final String MAX_LOAD_SESSION_RETRY_COUNT = "maxLoadSessionRetryCount";
    private static final String MAX_DELAY_BETWEEN_LOAD_SESSION_RETRIES_SECONDS = "maxDelayBetweenLoadSessionRetriesSeconds";
    private static final String CHECKPOINT_FILE_DIRECTORY = "checkpointFileDirectory";
    private static final String WORKER_HEARTBEAT_INTERVAL_SEC = "workerHeartbeatIntervalSec";
    private static final String MVM_EVAL_REQUEST_TIMEOUT = "mvmEvalRequestTimeout";

    static MatlabServerConfigBean loadProperties(String overrideFile) {
        try {
            return MatlabServerConfigLoadWorkerProperties.loadPropertiesHelper(overrideFile);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            sLogger.severe(e2.toString());
            return null;
        }
    }

    static MatlabServerConfigBean loadPropertiesHelper(String overrideFile) throws Exception {
        String mrmApiEndpoint;
        String useMrmRestApi;
        String logFileFormat;
        String logFileName;
        String enableConsoleLogging;
        MatlabServerConfigBean bean = MatlabServerConfigBean.newInstance();
        ConfigService configServ = ConfigServiceFactory.createFromFile((String)DEFAULT_PROPERTIES_FILE, (String)overrideFile);
        bean.setRMIHostName(configServ.getValue(RMIHOSTNAME));
        bean.setRMIPort(MatlabServerConfigLoadWorkerProperties.toInt(configServ.getValue(RMIPORT)));
        bean.setRMIName(configServ.getValue(RMISERVERNAME));
        bean.setDCEJobManagerHost(configServ.getValue(MDCS_JOBMANAGERHOST));
        bean.setDCEJobManagerName(configServ.getValue(MDCS_JOBMANAGERNAME));
        bean.setFileServiceClass(configServ.getValue(FILESERVICE));
        bean.setWorkerMountPoint(configServ.getValue(WORKER_MOUNTPOINT));
        bean.setServerMountPoint(configServ.getValue(SERVER_MOUNTPOINT));
        String fileServiceLogging = configServ.getValue(ENABLE_FILESERVICE_LOGGING);
        bean.setUniqueFilenames(MatlabServerConfigLoadWorkerProperties.toBoolean(configServ.getValue(UNIQUE_FILENAMES)));
        bean.setMountPermissions(MatlabServerConfigLoadWorkerProperties.toBoolean(configServ.getValue(MOUNT_PERMISSIONS)));
        bean.setDisableFileSystemCacheForSharedFolders(MatlabServerConfigLoadWorkerProperties.toBoolean(configServ.getValue(DISABLE_FIELSYSTEMCACHE_FORSHAREDFOLDERS)));
        bean.setRMILocalEnableWorkerRMIServer(MatlabServerConfigLoadWorkerProperties.toBoolean(configServ.getValue(RMI_LOCAL_ENABLE_WORKER_RMI_SERVER)));
        bean.setRMILocalEnableFilesystemRMIServer(MatlabServerConfigLoadWorkerProperties.toBoolean(configServ.getValue(RMI_LOCAL_ENABLE_FILESYSTEM_RMI_SERVER)));
        bean.setRMILocalRegistryPort(MatlabServerConfigLoadWorkerProperties.toInt(configServ.getValue(RMI_LOCAL_REGISTRY_PORT)));
        bean.setRMILocalWorkerPort(MatlabServerConfigLoadWorkerProperties.toInt(configServ.getValue(RMI_LOCAL_WORKER_PORT)));
        bean.setRMILocalWorkerName(configServ.getValue(RMI_LOCAL_WORKER_NAME));
        bean.setRMILocalFileSystemPort(MatlabServerConfigLoadWorkerProperties.toInt(configServ.getValue(RMI_LOCAL_FILESYSTEM_PORT)));
        bean.setRMILocalFileSystemName(configServ.getValue(RMI_LOCAL_FILESYSTEM_NAME));
        bean.setRMILocalFileSystemCacheManagerPort(MatlabServerConfigLoadWorkerProperties.toInt(configServ.getValue(RMILocalFileSystemCacheManagerPort)));
        bean.setRMILocalFileSystemCacheManagerName(configServ.getValue(RMILocalFileSystemCacheManagerName));
        bean.setCacheManagerInitialDelayMS(MatlabServerConfigLoadWorkerProperties.toLong(configServ.getValue(CACHE_MANAGER_INITIAL_DELAY_MS)));
        bean.setCacheManagerCycleTimeMS(MatlabServerConfigLoadWorkerProperties.toLong(configServ.getValue(CACHE_MANGER_CYCLE_TIME_MS)));
        bean.setGdsMountTimeoutS(MatlabServerConfigLoadWorkerProperties.toInt(configServ.getValue(GDS_MOUNT_TIMEOUT_S)));
        bean.setIsMatlabClientGateway(MatlabServerConfigLoadWorkerProperties.toBoolean(configServ.getValue(ENABLE_MCG)));
        bean.setMatlabClientGatewayTimeout(MatlabServerConfigLoadWorkerProperties.toInt(configServ.getValue(MCG_TIMEOUT)));
        bean.setRMIMatlabClientGatewayPort(MatlabServerConfigLoadWorkerProperties.toInt(configServ.getValue(RMI_MCG_PORT)));
        bean.setIsMatlabClientGatewayRestartEnabled(MatlabServerConfigLoadWorkerProperties.toBoolean(configServ.getValue(ENABLE_MCG_RESTART)));
        bean.setMatlabVersion(configServ.getValue(MATLAB_VERSION));
        bean.setMaxLoadSessionRetryCount(MatlabServerConfigLoadWorkerProperties.toInt(configServ.getValue(MAX_LOAD_SESSION_RETRY_COUNT)));
        bean.setMaxDelayBetweenLoadSessionRetriesSeconds(MatlabServerConfigLoadWorkerProperties.toInt(configServ.getValue(MAX_DELAY_BETWEEN_LOAD_SESSION_RETRIES_SECONDS)));
        bean.setCheckpointFileDirectory(configServ.getValue(CHECKPOINT_FILE_DIRECTORY));
        String enableWebServer = configServ.getValue(ENABLE_CLIENTGATEWAY_WEBSERVER);
        if (enableWebServer != null) {
            bean.setEnableClientGatewayWebServer(MatlabServerConfigLoadWorkerProperties.toBoolean(enableWebServer));
        }
        bean.setWebServerConfigFile(configServ.getValue(WEB_SERVER_CONFIGFILE));
        bean.setWorkerGatewayWebappEnabled(MatlabServerConfigLoadWorkerProperties.toBoolean(configServ.getValue(WORKER_GATEWAY_WEB_APP_ENABLED)));
        bean.setWorkerGatewayWebServerPort(MatlabServerConfigLoadWorkerProperties.toInt(configServ.getValue(WORKER_GATEWAY_WEB_SERVER_PORT)));
        bean.setWorkerOverridingConfigFile(overrideFile);
        bean.setEnableAutoSuggest(MatlabServerConfigLoadWorkerProperties.toBoolean(configServ.getValue(ENABLE_AUTOSUGGEST)));
        bean.setEnableAsyncPushForMGG(MatlabServerConfigLoadWorkerProperties.toBoolean(configServ.getValue(ENABLE_ASYNC_PUSH_MGG)));
        bean.setWorkerFileSystemMode(configServ.getValue(WORKER_FILE_SYSTEM_MODE));
        bean.setUseGdsAsyncVersioning(MatlabServerConfigLoadWorkerProperties.toBoolean(configServ.getValue(GDS_USE_ASYNC_FILE_VERSIONING)));
        bean.setGdsMountCommand(configServ.getValue(GDS_MOUNT_COMMAND));
        bean.setGdsEndpoint(configServ.getValue(GDS_ENDPOINT));
        bean.setMatlabRootDirectory(configServ.getValue(MATLAB_ROOT_DIRECTORY));
        if (fileServiceLogging != null) {
            bean.setFileServiceLogging(MatlabServerConfigLoadWorkerProperties.toBoolean(fileServiceLogging));
        }
        if ((enableConsoleLogging = configServ.getValue(ENABLE_CONSOLE_LOGGING)) != null) {
            bean.setIsEnableConsoleLogging(MatlabServerConfigLoadWorkerProperties.toBoolean(enableConsoleLogging));
        }
        if ((logFileName = configServ.getValue(LOG_FILE_NAME)) != null) {
            bean.setLogFileName(logFileName);
        }
        if ((logFileFormat = configServ.getValue(LOG_FILE_FORMAT)) != null) {
            bean.setLogFileFormat(logFileFormat);
        }
        if (!StringUtils.isEmpty(useMrmRestApi = configServ.getValue(USE_MRM_REST_API))) {
            bean.setUseMrmRestApi(Boolean.parseBoolean(useMrmRestApi));
        }
        if (!StringUtils.isEmpty(mrmApiEndpoint = configServ.getValue(MRM_API_ENDPOINT))) {
            bean.setMrmApiEndpoint(mrmApiEndpoint);
        }
        RestClientConfig mrmRestClientConfig = new RestClientConfig(configServ.getValue(MRM_CLIENT_CONNECT_TIMEOUT_MILLIS) != null ? Integer.parseInt(configServ.getValue(MRM_CLIENT_CONNECT_TIMEOUT_MILLIS)) : 0, configServ.getValue(MRM_CLIENT_READ_TIMEOUT_MILLIS) != null ? Integer.parseInt(configServ.getValue(MRM_CLIENT_READ_TIMEOUT_MILLIS)) : 0, configServ.getValue(MRM_CLIENT_HTTP_PROXY_HOST) != null ? configServ.getValue(MRM_CLIENT_HTTP_PROXY_HOST) : "", configServ.getValue(MRM_CLIENT_HTTP_PROXY_PORT) != null ? Integer.parseInt(configServ.getValue(MRM_CLIENT_HTTP_PROXY_PORT)) : 0);
        bean.setMrmRestClientConfig(mrmRestClientConfig);
        bean.setWorkerHeartbeatIntervalSec(Integer.parseInt(configServ.getValue(WORKER_HEARTBEAT_INTERVAL_SEC)));
        bean.setMvmEvalRequestTimeout(Long.parseLong(configServ.getValue(MVM_EVAL_REQUEST_TIMEOUT)));
        return bean;
    }

    private static int toInt(String str) {
        return Integer.parseInt(str);
    }

    private static long toLong(String str) {
        return Long.parseLong(str);
    }

    private static boolean toBoolean(String str) {
        return Boolean.parseBoolean(str);
    }
}

