/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.attachments.utils;

import java.util.Arrays;

public class ByteSearch {
    public static int skipSearch(byte[] pattern, boolean direction, byte[] buffer, int start, int end, short[] skip) {
        int patternLength = pattern.length;
        if (patternLength > end - start) {
            return -1;
        }
        if (direction) {
            int k2 = 0;
            for (k2 = start + patternLength - 1; k2 < end; k2 += skip[buffer[k2] & 0xFF]) {
                if (!ByteSearch.isEqual(pattern, buffer, k2 - patternLength + 1, end)) continue;
                return k2 - patternLength + 1;
            }
        } else {
            for (int k3 = end - patternLength; k3 <= start; k3 -= skip[buffer[k3] & 0xFF]) {
                if (!ByteSearch.isEqual(pattern, buffer, k3, end)) continue;
                return k3;
            }
        }
        return -1;
    }

    public static short[] getSkipArray(byte[] pattern, boolean direction) {
        short[] skip = new short[256];
        Arrays.fill(skip, (short)pattern.length);
        if (direction) {
            for (int k2 = 0; k2 < pattern.length - 1; ++k2) {
                skip[pattern[k2] & 0xFF] = (short)(pattern.length - k2 - 1);
            }
        } else {
            for (int k3 = pattern.length - 2; k3 >= 0; --k3) {
                skip[pattern[k3] & 0xFF] = (short)(pattern.length - k3 - 1);
            }
        }
        return skip;
    }

    public static boolean isEqual(byte[] pattern, byte[] buffer, int start, int end) {
        if (pattern.length > end - start) {
            return false;
        }
        for (int j2 = 0; j2 < pattern.length; ++j2) {
            if (pattern[j2] == buffer[start + j2]) continue;
            return false;
        }
        return true;
    }

    public static int search(byte[] search, byte[] bytes, int start, int end, boolean direction) {
        int idx = -1;
        if (search == null || search.length == 0 || bytes == null || bytes.length == 0 || start < 0 || end <= 0) {
            return idx;
        }
        if (direction) {
            for (int i2 = start; idx < 0 && i2 < end; ++i2) {
                if (bytes[i2] != search[0]) continue;
                boolean found = true;
                for (int i22 = 1; found && i22 < search.length; ++i22) {
                    found = i2 + i22 >= end ? false : bytes[i2 + i22] == search[i22];
                }
                if (!found) continue;
                idx = i2;
            }
        } else {
            for (int i3 = end - 1; idx < 0 && i3 >= start; --i3) {
                if (bytes[i3] != search[0]) continue;
                boolean found = true;
                for (int i2 = 1; found && i2 < search.length; ++i2) {
                    found = i3 + i2 >= end ? false : bytes[i3 + i2] == search[i2];
                }
                if (!found) continue;
                idx = i3;
            }
        }
        return idx;
    }
}

