/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.bzip2;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public abstract class BZip2Utils {
    private static final Map uncompressSuffix = new HashMap();

    private BZip2Utils() {
    }

    public static boolean isCompressedFilename(String filename) {
        String lower = filename.toLowerCase(Locale.ENGLISH);
        int n2 = lower.length();
        for (int i2 = 3; i2 <= 5 && i2 < n2; ++i2) {
            if (!uncompressSuffix.containsKey(lower.substring(n2 - i2))) continue;
            return true;
        }
        return false;
    }

    public static String getUncompressedFilename(String filename) {
        String lower = filename.toLowerCase(Locale.ENGLISH);
        int n2 = lower.length();
        for (int i2 = 3; i2 <= 5 && i2 < n2; ++i2) {
            Object suffix = uncompressSuffix.get(lower.substring(n2 - i2));
            if (suffix == null) continue;
            return filename.substring(0, n2 - i2) + suffix;
        }
        return filename;
    }

    public static String getCompressedFilename(String filename) {
        return filename + ".bz2";
    }

    static {
        uncompressSuffix.put(".tbz2", ".tar");
        uncompressSuffix.put(".tbz", ".tar");
        uncompressSuffix.put(".bz2", "");
        uncompressSuffix.put(".bz", "");
    }
}

