/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.pattern;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.helpers.Loader;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.pattern.ClassNamePatternConverter;
import org.apache.log4j.pattern.DatePatternConverter;
import org.apache.log4j.pattern.FileDatePatternConverter;
import org.apache.log4j.pattern.FileLocationPatternConverter;
import org.apache.log4j.pattern.FormattingInfo;
import org.apache.log4j.pattern.FullLocationPatternConverter;
import org.apache.log4j.pattern.IntegerPatternConverter;
import org.apache.log4j.pattern.LevelPatternConverter;
import org.apache.log4j.pattern.LineLocationPatternConverter;
import org.apache.log4j.pattern.LineSeparatorPatternConverter;
import org.apache.log4j.pattern.LiteralPatternConverter;
import org.apache.log4j.pattern.LoggerPatternConverter;
import org.apache.log4j.pattern.MessagePatternConverter;
import org.apache.log4j.pattern.MethodLocationPatternConverter;
import org.apache.log4j.pattern.NDCPatternConverter;
import org.apache.log4j.pattern.PatternConverter;
import org.apache.log4j.pattern.PropertiesPatternConverter;
import org.apache.log4j.pattern.RelativeTimePatternConverter;
import org.apache.log4j.pattern.SequenceNumberPatternConverter;
import org.apache.log4j.pattern.ThreadPatternConverter;
import org.apache.log4j.pattern.ThrowableInformationPatternConverter;

public final class PatternParser {
    private static final char ESCAPE_CHAR = '%';
    private static final int LITERAL_STATE = 0;
    private static final int CONVERTER_STATE = 1;
    private static final int DOT_STATE = 3;
    private static final int MIN_STATE = 4;
    private static final int MAX_STATE = 5;
    private static final Map PATTERN_LAYOUT_RULES;
    private static final Map FILENAME_PATTERN_RULES;

    private PatternParser() {
    }

    public static Map getPatternLayoutRules() {
        return PATTERN_LAYOUT_RULES;
    }

    public static Map getFileNamePatternRules() {
        return FILENAME_PATTERN_RULES;
    }

    private static int extractConverter(char lastChar, String pattern, int i2, StringBuffer convBuf, StringBuffer currentLiteral) {
        convBuf.setLength(0);
        if (!Character.isUnicodeIdentifierStart(lastChar)) {
            return i2;
        }
        convBuf.append(lastChar);
        while (i2 < pattern.length() && Character.isUnicodeIdentifierPart(pattern.charAt(i2))) {
            convBuf.append(pattern.charAt(i2));
            currentLiteral.append(pattern.charAt(i2));
            ++i2;
        }
        return i2;
    }

    private static int extractOptions(String pattern, int i2, List options) {
        int end;
        while (i2 < pattern.length() && pattern.charAt(i2) == '{' && (end = pattern.indexOf(125, i2)) != -1) {
            String r = pattern.substring(i2 + 1, end);
            options.add(r);
            i2 = end + 1;
        }
        return i2;
    }

    public static void parse(String pattern, List patternConverters, List formattingInfos, Map converterRegistry, Map rules) {
        if (pattern == null) {
            throw new NullPointerException("pattern");
        }
        StringBuffer currentLiteral = new StringBuffer(32);
        int patternLength = pattern.length();
        int state = 0;
        int i2 = 0;
        FormattingInfo formattingInfo = FormattingInfo.getDefault();
        while (i2 < patternLength) {
            char c2 = pattern.charAt(i2++);
            block0 : switch (state) {
                case 0: {
                    if (i2 == patternLength) {
                        currentLiteral.append(c2);
                        break;
                    }
                    if (c2 == '%') {
                        switch (pattern.charAt(i2)) {
                            case '%': {
                                currentLiteral.append(c2);
                                ++i2;
                                break block0;
                            }
                        }
                        if (currentLiteral.length() != 0) {
                            patternConverters.add(new LiteralPatternConverter(currentLiteral.toString()));
                            formattingInfos.add(FormattingInfo.getDefault());
                        }
                        currentLiteral.setLength(0);
                        currentLiteral.append(c2);
                        state = 1;
                        formattingInfo = FormattingInfo.getDefault();
                        break;
                    }
                    currentLiteral.append(c2);
                    break;
                }
                case 1: {
                    currentLiteral.append(c2);
                    switch (c2) {
                        case '-': {
                            formattingInfo = new FormattingInfo(true, formattingInfo.getMinLength(), formattingInfo.getMaxLength());
                            break block0;
                        }
                        case '.': {
                            state = 3;
                            break block0;
                        }
                    }
                    if (c2 >= '0' && c2 <= '9') {
                        formattingInfo = new FormattingInfo(formattingInfo.isLeftAligned(), c2 - 48, formattingInfo.getMaxLength());
                        state = 4;
                        break;
                    }
                    i2 = PatternParser.finalizeConverter(c2, pattern, i2, currentLiteral, formattingInfo, converterRegistry, rules, patternConverters, formattingInfos);
                    state = 0;
                    formattingInfo = FormattingInfo.getDefault();
                    currentLiteral.setLength(0);
                    break;
                }
                case 4: {
                    currentLiteral.append(c2);
                    if (c2 >= '0' && c2 <= '9') {
                        formattingInfo = new FormattingInfo(formattingInfo.isLeftAligned(), formattingInfo.getMinLength() * 10 + (c2 - 48), formattingInfo.getMaxLength());
                        break;
                    }
                    if (c2 == '.') {
                        state = 3;
                        break;
                    }
                    i2 = PatternParser.finalizeConverter(c2, pattern, i2, currentLiteral, formattingInfo, converterRegistry, rules, patternConverters, formattingInfos);
                    state = 0;
                    formattingInfo = FormattingInfo.getDefault();
                    currentLiteral.setLength(0);
                    break;
                }
                case 3: {
                    currentLiteral.append(c2);
                    if (c2 >= '0' && c2 <= '9') {
                        formattingInfo = new FormattingInfo(formattingInfo.isLeftAligned(), formattingInfo.getMinLength(), c2 - 48);
                        state = 5;
                        break;
                    }
                    LogLog.error("Error occured in position " + i2 + ".\n Was expecting digit, instead got char \"" + c2 + "\".");
                    state = 0;
                    break;
                }
                case 5: {
                    currentLiteral.append(c2);
                    if (c2 >= '0' && c2 <= '9') {
                        formattingInfo = new FormattingInfo(formattingInfo.isLeftAligned(), formattingInfo.getMinLength(), formattingInfo.getMaxLength() * 10 + (c2 - 48));
                        break;
                    }
                    i2 = PatternParser.finalizeConverter(c2, pattern, i2, currentLiteral, formattingInfo, converterRegistry, rules, patternConverters, formattingInfos);
                    state = 0;
                    formattingInfo = FormattingInfo.getDefault();
                    currentLiteral.setLength(0);
                }
            }
        }
        if (currentLiteral.length() != 0) {
            patternConverters.add(new LiteralPatternConverter(currentLiteral.toString()));
            formattingInfos.add(FormattingInfo.getDefault());
        }
    }

    private static PatternConverter createConverter(String converterId, StringBuffer currentLiteral, Map converterRegistry, Map rules, List options) {
        String converterName = converterId;
        Object converterObj = null;
        for (int i2 = converterId.length(); i2 > 0 && converterObj == null; --i2) {
            converterName = converterName.substring(0, i2);
            if (converterRegistry != null) {
                converterObj = converterRegistry.get(converterName);
            }
            if (converterObj != null || rules == null) continue;
            converterObj = rules.get(converterName);
        }
        if (converterObj == null) {
            LogLog.error("Unrecognized format specifier [" + converterId + "]");
            return null;
        }
        Class converterClass = null;
        if (converterObj instanceof Class) {
            converterClass = converterObj;
        } else if (converterObj instanceof String) {
            try {
                converterClass = Loader.loadClass(converterObj);
            }
            catch (ClassNotFoundException ex) {
                LogLog.warn("Class for conversion pattern %" + converterName + " not found", ex);
                return null;
            }
        } else {
            LogLog.warn("Bad map entry for conversion pattern %" + converterName + ".");
            return null;
        }
        try {
            Method factory = converterClass.getMethod("newInstance", Class.forName("[Ljava.lang.String;"));
            String[] optionsArray = new String[options.size()];
            optionsArray = options.toArray(optionsArray);
            Object newObj = factory.invoke(null, new Object[]{optionsArray});
            if (newObj instanceof PatternConverter) {
                currentLiteral.delete(0, currentLiteral.length() - (converterId.length() - converterName.length()));
                return (PatternConverter)newObj;
            }
            LogLog.warn("Class " + converterClass.getName() + " does not extend PatternConverter.");
        }
        catch (Exception ex) {
            LogLog.error("Error creating converter for " + converterId, ex);
            try {
                PatternConverter pc = (PatternConverter)converterClass.newInstance();
                currentLiteral.delete(0, currentLiteral.length() - (converterId.length() - converterName.length()));
                return pc;
            }
            catch (Exception ex2) {
                LogLog.error("Error creating converter for " + converterId, ex2);
            }
        }
        return null;
    }

    private static int finalizeConverter(char c2, String pattern, int i2, StringBuffer currentLiteral, FormattingInfo formattingInfo, Map converterRegistry, Map rules, List patternConverters, List formattingInfos) {
        StringBuffer convBuf = new StringBuffer();
        i2 = PatternParser.extractConverter(c2, pattern, i2, convBuf, currentLiteral);
        String converterId = convBuf.toString();
        ArrayList options = new ArrayList();
        i2 = PatternParser.extractOptions(pattern, i2, options);
        PatternConverter pc = PatternParser.createConverter(converterId, currentLiteral, converterRegistry, rules, options);
        if (pc == null) {
            StringBuffer msg;
            if (converterId == null || converterId.length() == 0) {
                msg = new StringBuffer("Empty conversion specifier starting at position ");
            } else {
                msg = new StringBuffer("Unrecognized conversion specifier [");
                msg.append(converterId);
                msg.append("] starting at position ");
            }
            msg.append(Integer.toString(i2));
            msg.append(" in conversion pattern.");
            LogLog.error(msg.toString());
            patternConverters.add(new LiteralPatternConverter(currentLiteral.toString()));
            formattingInfos.add(FormattingInfo.getDefault());
        } else {
            patternConverters.add(pc);
            formattingInfos.add(formattingInfo);
            if (currentLiteral.length() > 0) {
                patternConverters.add(new LiteralPatternConverter(currentLiteral.toString()));
                formattingInfos.add(FormattingInfo.getDefault());
            }
        }
        currentLiteral.setLength(0);
        return i2;
    }

    static {
        HashMap<String, Class> rules = new HashMap<String, Class>(17);
        rules.put("c", LoggerPatternConverter.class);
        rules.put("logger", LoggerPatternConverter.class);
        rules.put("C", ClassNamePatternConverter.class);
        rules.put("class", ClassNamePatternConverter.class);
        rules.put("d", DatePatternConverter.class);
        rules.put("date", DatePatternConverter.class);
        rules.put("F", FileLocationPatternConverter.class);
        rules.put("file", FileLocationPatternConverter.class);
        rules.put("l", FullLocationPatternConverter.class);
        rules.put("L", LineLocationPatternConverter.class);
        rules.put("line", LineLocationPatternConverter.class);
        rules.put("m", MessagePatternConverter.class);
        rules.put("message", MessagePatternConverter.class);
        rules.put("n", LineSeparatorPatternConverter.class);
        rules.put("M", MethodLocationPatternConverter.class);
        rules.put("method", MethodLocationPatternConverter.class);
        rules.put("p", LevelPatternConverter.class);
        rules.put("level", LevelPatternConverter.class);
        rules.put("r", RelativeTimePatternConverter.class);
        rules.put("relative", RelativeTimePatternConverter.class);
        rules.put("t", ThreadPatternConverter.class);
        rules.put("thread", ThreadPatternConverter.class);
        rules.put("x", NDCPatternConverter.class);
        rules.put("ndc", NDCPatternConverter.class);
        rules.put("X", PropertiesPatternConverter.class);
        rules.put("properties", PropertiesPatternConverter.class);
        rules.put("sn", SequenceNumberPatternConverter.class);
        rules.put("sequenceNumber", SequenceNumberPatternConverter.class);
        rules.put("throwable", ThrowableInformationPatternConverter.class);
        PATTERN_LAYOUT_RULES = new ReadOnlyMap(rules);
        HashMap<String, Class> fnameRules = new HashMap<String, Class>(4);
        fnameRules.put("d", FileDatePatternConverter.class);
        fnameRules.put("date", FileDatePatternConverter.class);
        fnameRules.put("i", IntegerPatternConverter.class);
        fnameRules.put("index", IntegerPatternConverter.class);
        FILENAME_PATTERN_RULES = new ReadOnlyMap(fnameRules);
    }

    private static class ReadOnlyMap
    implements Map {
        private final Map map;

        public ReadOnlyMap(Map src) {
            this.map = src;
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public boolean containsKey(Object key) {
            return this.map.containsKey(key);
        }

        public boolean containsValue(Object value) {
            return this.map.containsValue(value);
        }

        public Set entrySet() {
            return this.map.entrySet();
        }

        public Object get(Object key) {
            return this.map.get(key);
        }

        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        public Set keySet() {
            return this.map.keySet();
        }

        public Object put(Object key, Object value) {
            throw new UnsupportedOperationException();
        }

        public void putAll(Map t) {
            throw new UnsupportedOperationException();
        }

        public Object remove(Object key) {
            throw new UnsupportedOperationException();
        }

        public int size() {
            return this.map.size();
        }

        public Collection values() {
            return this.map.values();
        }
    }
}

