/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server;

import java.io.BufferedReader;
import java.io.IOException;
import java.text.ParseException;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerTransport;
import org.cometd.common.AbstractTransport;
import org.cometd.common.JSONContext;
import org.cometd.server.BayeuxServerImpl;
import org.eclipse.jetty.util.IO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractServerTransport
extends AbstractTransport
implements ServerTransport {
    public static final String TIMEOUT_OPTION = "timeout";
    public static final String INTERVAL_OPTION = "interval";
    public static final String MAX_INTERVAL_OPTION = "maxInterval";
    public static final String MAX_LAZY_OPTION = "maxLazyTimeout";
    public static final String META_CONNECT_DELIVERY_OPTION = "metaConnectDeliverOnly";
    public static final String MAX_QUEUE_OPTION = "maxQueue";
    protected final Logger _logger = LoggerFactory.getLogger(this.getClass().getName());
    private final BayeuxServerImpl _bayeux;
    private long _interval = 0L;
    private long _maxInterval = 10000L;
    private long _timeout = 30000L;
    private long _maxLazyTimeout = 5000L;
    private boolean _metaConnectDeliveryOnly = false;
    private JSONContext.Server jsonContext;
    private Object _advice;

    protected AbstractServerTransport(BayeuxServerImpl bayeux, String name) {
        super(name, bayeux.getOptions());
        this._bayeux = bayeux;
    }

    public Object getAdvice() {
        return this._advice;
    }

    public long getInterval() {
        return this._interval;
    }

    public long getMaxInterval() {
        return this._maxInterval;
    }

    public long getMaxLazyTimeout() {
        return this._maxLazyTimeout;
    }

    public long getTimeout() {
        return this._timeout;
    }

    public boolean isMetaConnectDeliveryOnly() {
        return this._metaConnectDeliveryOnly;
    }

    public void setMetaConnectDeliveryOnly(boolean meta) {
        this._metaConnectDeliveryOnly = meta;
    }

    protected void init() {
        this._interval = this.getOption(INTERVAL_OPTION, this._interval);
        this._maxInterval = this.getOption(MAX_INTERVAL_OPTION, this._maxInterval);
        this._timeout = this.getOption(TIMEOUT_OPTION, this._timeout);
        this._maxLazyTimeout = this.getOption(MAX_LAZY_OPTION, this._maxLazyTimeout);
        this._metaConnectDeliveryOnly = this.getOption(META_CONNECT_DELIVERY_OPTION, this._metaConnectDeliveryOnly);
        this.jsonContext = (JSONContext.Server)this.getOption("jsonContext");
    }

    protected void destroy() {
    }

    protected ServerMessage.Mutable[] parseMessages(BufferedReader reader, boolean jsonDebug) throws ParseException, IOException {
        if (jsonDebug) {
            return this.parseMessages(IO.toString(reader));
        }
        return (ServerMessage.Mutable[])this.jsonContext.parse(reader);
    }

    protected ServerMessage.Mutable[] parseMessages(String json) throws ParseException {
        return (ServerMessage.Mutable[])this.jsonContext.parse(json);
    }

    public BayeuxServerImpl getBayeux() {
        return this._bayeux;
    }

    public void setInterval(long interval) {
        this._interval = interval;
    }

    public void setMaxInterval(long maxInterval) {
        this._maxInterval = maxInterval;
    }

    public void setTimeout(long timeout) {
        this._timeout = timeout;
    }

    public void setMaxLazyTimeout(long maxLazyTimeout) {
        this._maxLazyTimeout = maxLazyTimeout;
    }

    public void setAdvice(Object advice) {
        this._advice = advice;
    }

    protected void sweep() {
    }

    protected void debug(String format, Object ... args) {
        if (this._bayeux.getLogLevel() >= 3) {
            this._logger.info(format, args);
        } else {
            this._logger.debug(format, args);
        }
    }

    public static interface OneTimeScheduler
    extends Scheduler {
    }

    public static interface Scheduler {
        public void cancel();

        public void schedule();
    }
}

