/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.PathMap;
import org.eclipse.jetty.server.AsyncContinuation;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class ContextHandlerCollection
extends HandlerCollection {
    private static final Logger LOG = Log.getLogger(ContextHandlerCollection.class);
    private volatile PathMap _contextMap;
    private Class<? extends ContextHandler> _contextClass = ContextHandler.class;

    public ContextHandlerCollection() {
        super(true);
    }

    public void mapContexts() {
        PathMap contextMap = new PathMap();
        Handler[] branches = this.getHandlers();
        for (int b2 = 0; branches != null && b2 < branches.length; ++b2) {
            Handler[] handlers = null;
            if (branches[b2] instanceof ContextHandler) {
                handlers = new Handler[]{branches[b2]};
            } else {
                if (!(branches[b2] instanceof HandlerContainer)) continue;
                handlers = ((HandlerContainer)((Object)branches[b2])).getChildHandlersByClass(ContextHandler.class);
            }
            for (int i2 = 0; i2 < handlers.length; ++i2) {
                HashMap hosts;
                ContextHandler handler = (ContextHandler)handlers[i2];
                String contextPath = handler.getContextPath();
                if (contextPath == null || contextPath.indexOf(44) >= 0 || contextPath.startsWith("*")) {
                    throw new IllegalArgumentException("Illegal context spec:" + contextPath);
                }
                if (!contextPath.startsWith("/")) {
                    contextPath = '/' + contextPath;
                }
                if (contextPath.length() > 1) {
                    if (contextPath.endsWith("/")) {
                        contextPath = contextPath + "*";
                    } else if (!contextPath.endsWith("/*")) {
                        contextPath = contextPath + "/*";
                    }
                }
                Object contexts = contextMap.get(contextPath);
                String[] vhosts = handler.getVirtualHosts();
                if (vhosts != null && vhosts.length > 0) {
                    if (contexts instanceof Map) {
                        hosts = (Map)contexts;
                    } else {
                        hosts = new HashMap();
                        hosts.put("*", contexts);
                        contextMap.put(contextPath, hosts);
                    }
                    for (int j2 = 0; j2 < vhosts.length; ++j2) {
                        String vhost = vhosts[j2];
                        contexts = hosts.get(vhost);
                        contexts = LazyList.add(contexts, branches[b2]);
                        hosts.put(vhost, contexts);
                    }
                    continue;
                }
                if (contexts instanceof Map) {
                    hosts = (HashMap)contexts;
                    contexts = hosts.get("*");
                    contexts = LazyList.add(contexts, branches[b2]);
                    hosts.put("*", contexts);
                    continue;
                }
                contexts = LazyList.add(contexts, branches[b2]);
                contextMap.put(contextPath, contexts);
            }
        }
        this._contextMap = contextMap;
    }

    @Override
    public void setHandlers(Handler[] handlers) {
        this._contextMap = null;
        super.setHandlers(handlers);
        if (this.isStarted()) {
            this.mapContexts();
        }
    }

    @Override
    protected void doStart() throws Exception {
        this.mapContexts();
        super.doStart();
    }

    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ContextHandler context;
        Handler[] handlers = this.getHandlers();
        if (handlers == null || handlers.length == 0) {
            return;
        }
        AsyncContinuation async = baseRequest.getAsyncContinuation();
        if (async.isAsync() && (context = async.getContextHandler()) != null) {
            context.handle(target, baseRequest, request, response);
            return;
        }
        PathMap map = this._contextMap;
        if (map != null && target != null && target.startsWith("/")) {
            Object contexts = map.getLazyMatches(target);
            for (int i2 = 0; i2 < LazyList.size(contexts); ++i2) {
                Map.Entry entry = (Map.Entry)LazyList.get(contexts, i2);
                Object list = entry.getValue();
                if (list instanceof Map) {
                    Handler handler;
                    int j2;
                    Map hosts = (Map)list;
                    String host = this.normalizeHostname(request.getServerName());
                    list = hosts.get(host);
                    for (j2 = 0; j2 < LazyList.size(list); ++j2) {
                        handler = (Handler)LazyList.get(list, j2);
                        handler.handle(target, baseRequest, request, response);
                        if (!baseRequest.isHandled()) continue;
                        return;
                    }
                    list = hosts.get("*." + host.substring(host.indexOf(".") + 1));
                    for (j2 = 0; j2 < LazyList.size(list); ++j2) {
                        handler = (Handler)LazyList.get(list, j2);
                        handler.handle(target, baseRequest, request, response);
                        if (!baseRequest.isHandled()) continue;
                        return;
                    }
                    list = hosts.get("*");
                    for (j2 = 0; j2 < LazyList.size(list); ++j2) {
                        handler = (Handler)LazyList.get(list, j2);
                        handler.handle(target, baseRequest, request, response);
                        if (!baseRequest.isHandled()) continue;
                        return;
                    }
                    continue;
                }
                for (int j3 = 0; j3 < LazyList.size(list); ++j3) {
                    Handler handler = (Handler)LazyList.get(list, j3);
                    handler.handle(target, baseRequest, request, response);
                    if (!baseRequest.isHandled()) continue;
                    return;
                }
            }
        } else {
            for (int i3 = 0; i3 < handlers.length; ++i3) {
                handlers[i3].handle(target, baseRequest, request, response);
                if (!baseRequest.isHandled()) continue;
                return;
            }
        }
    }

    public ContextHandler addContext(String contextPath, String resourceBase) {
        try {
            ContextHandler context = this._contextClass.newInstance();
            context.setContextPath(contextPath);
            context.setResourceBase(resourceBase);
            this.addHandler(context);
            return context;
        }
        catch (Exception e2) {
            LOG.debug(e2);
            throw new Error(e2);
        }
    }

    public Class getContextClass() {
        return this._contextClass;
    }

    public void setContextClass(Class contextClass) {
        if (contextClass == null || !ContextHandler.class.isAssignableFrom(contextClass)) {
            throw new IllegalArgumentException();
        }
        this._contextClass = contextClass;
    }

    private String normalizeHostname(String host) {
        if (host == null) {
            return null;
        }
        if (host.endsWith(".")) {
            return host.substring(0, host.length() - 1);
        }
        return host;
    }
}

