/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class StringMap
extends AbstractMap
implements Externalizable {
    public static final boolean CASE_INSENSTIVE = true;
    protected static final int __HASH_WIDTH = 17;
    protected int _width = 17;
    protected Node _root = new Node();
    protected boolean _ignoreCase = false;
    protected NullEntry _nullEntry = null;
    protected Object _nullValue = null;
    protected HashSet _entrySet = new HashSet(3);
    protected Set _umEntrySet = Collections.unmodifiableSet(this._entrySet);

    public StringMap() {
    }

    public StringMap(boolean ignoreCase) {
        this();
        this._ignoreCase = ignoreCase;
    }

    public StringMap(boolean ignoreCase, int width) {
        this();
        this._ignoreCase = ignoreCase;
        this._width = width;
    }

    public void setIgnoreCase(boolean ic) {
        if (this._root._children != null) {
            throw new IllegalStateException("Must be set before first put");
        }
        this._ignoreCase = ic;
    }

    public boolean isIgnoreCase() {
        return this._ignoreCase;
    }

    public void setWidth(int width) {
        this._width = width;
    }

    public int getWidth() {
        return this._width;
    }

    @Override
    public Object put(Object key, Object value) {
        if (key == null) {
            return this.put(null, value);
        }
        return this.put(key.toString(), value);
    }

    @Override
    public Object put(String key, Object value) {
        if (key == null) {
            Object oldValue = this._nullValue;
            this._nullValue = value;
            if (this._nullEntry == null) {
                this._nullEntry = new NullEntry();
                this._entrySet.add(this._nullEntry);
            }
            return oldValue;
        }
        Node node = this._root;
        int ni = -1;
        Node prev = null;
        Node parent = null;
        block0: for (int i2 = 0; i2 < key.length(); ++i2) {
            char c2 = key.charAt(i2);
            if (ni == -1) {
                parent = node;
                prev = null;
                ni = 0;
                Node node2 = node = node._children == null ? null : node._children[c2 % this._width];
            }
            while (node != null) {
                if (node._char[ni] == c2 || this._ignoreCase && node._ochar[ni] == c2) {
                    prev = null;
                    if (++ni != node._char.length) continue block0;
                    ni = -1;
                    continue block0;
                }
                if (ni == 0) {
                    prev = node;
                    node = node._next;
                    continue;
                }
                node.split(this, ni);
                --i2;
                ni = -1;
                continue block0;
            }
            node = new Node(this._ignoreCase, key, i2);
            if (prev != null) {
                prev._next = node;
                break;
            }
            if (parent != null) {
                if (parent._children == null) {
                    parent._children = new Node[this._width];
                }
                parent._children[c2 % this._width] = node;
                int oi = node._ochar[0] % this._width;
                if (node._ochar == null || node._char[0] % this._width == oi) break;
                if (parent._children[oi] == null) {
                    parent._children[oi] = node;
                    break;
                }
                Node n2 = parent._children[oi];
                while (n2._next != null) {
                    n2 = n2._next;
                }
                n2._next = node;
                break;
            }
            this._root = node;
            break;
        }
        if (node != null) {
            if (ni > 0) {
                node.split(this, ni);
            }
            Object old = node._value;
            node._key = key;
            node._value = value;
            this._entrySet.add(node);
            return old;
        }
        return null;
    }

    @Override
    public Object get(Object key) {
        if (key == null) {
            return this._nullValue;
        }
        if (key instanceof String) {
            return this.get((String)key);
        }
        return this.get(key.toString());
    }

    public Object get(String key) {
        if (key == null) {
            return this._nullValue;
        }
        Map.Entry entry = this.getEntry(key, 0, key.length());
        if (entry == null) {
            return null;
        }
        return entry.getValue();
    }

    public Map.Entry getEntry(String key, int offset, int length) {
        if (key == null) {
            return this._nullEntry;
        }
        Node node = this._root;
        int ni = -1;
        block0: for (int i2 = 0; i2 < length; ++i2) {
            char c2 = key.charAt(offset + i2);
            if (ni == -1) {
                ni = 0;
                Node node2 = node = node._children == null ? null : node._children[c2 % this._width];
            }
            while (node != null) {
                if (node._char[ni] == c2 || this._ignoreCase && node._ochar[ni] == c2) {
                    if (++ni != node._char.length) continue block0;
                    ni = -1;
                    continue block0;
                }
                if (ni > 0) {
                    return null;
                }
                node = node._next;
            }
            return null;
        }
        if (ni > 0) {
            return null;
        }
        if (node != null && node._key == null) {
            return null;
        }
        return node;
    }

    public Map.Entry getEntry(char[] key, int offset, int length) {
        if (key == null) {
            return this._nullEntry;
        }
        Node node = this._root;
        int ni = -1;
        block0: for (int i2 = 0; i2 < length; ++i2) {
            char c2 = key[offset + i2];
            if (ni == -1) {
                ni = 0;
                Node node2 = node = node._children == null ? null : node._children[c2 % this._width];
            }
            while (node != null) {
                if (node._char[ni] == c2 || this._ignoreCase && node._ochar[ni] == c2) {
                    if (++ni != node._char.length) continue block0;
                    ni = -1;
                    continue block0;
                }
                if (ni > 0) {
                    return null;
                }
                node = node._next;
            }
            return null;
        }
        if (ni > 0) {
            return null;
        }
        if (node != null && node._key == null) {
            return null;
        }
        return node;
    }

    public Map.Entry getBestEntry(byte[] key, int offset, int maxLength) {
        if (key == null) {
            return this._nullEntry;
        }
        Node node = this._root;
        int ni = -1;
        block0: for (int i2 = 0; i2 < maxLength; ++i2) {
            char c2 = (char)key[offset + i2];
            if (ni == -1) {
                Node child;
                ni = 0;
                Node node2 = child = node._children == null ? null : node._children[c2 % this._width];
                if (child == null && i2 > 0) {
                    return node;
                }
                node = child;
            }
            while (node != null) {
                if (node._char[ni] == c2 || this._ignoreCase && node._ochar[ni] == c2) {
                    if (++ni != node._char.length) continue block0;
                    ni = -1;
                    continue block0;
                }
                if (ni > 0) {
                    return null;
                }
                node = node._next;
            }
            return null;
        }
        if (ni > 0) {
            return null;
        }
        if (node != null && node._key == null) {
            return null;
        }
        return node;
    }

    @Override
    public Object remove(Object key) {
        if (key == null) {
            return this.remove(null);
        }
        return this.remove(key.toString());
    }

    public Object remove(String key) {
        if (key == null) {
            Object oldValue = this._nullValue;
            if (this._nullEntry != null) {
                this._entrySet.remove(this._nullEntry);
                this._nullEntry = null;
                this._nullValue = null;
            }
            return oldValue;
        }
        Node node = this._root;
        int ni = -1;
        block0: for (int i2 = 0; i2 < key.length(); ++i2) {
            char c2 = key.charAt(i2);
            if (ni == -1) {
                ni = 0;
                Node node2 = node = node._children == null ? null : node._children[c2 % this._width];
            }
            while (node != null) {
                if (node._char[ni] == c2 || this._ignoreCase && node._ochar[ni] == c2) {
                    if (++ni != node._char.length) continue block0;
                    ni = -1;
                    continue block0;
                }
                if (ni > 0) {
                    return null;
                }
                node = node._next;
            }
            return null;
        }
        if (ni > 0) {
            return null;
        }
        if (node != null && node._key == null) {
            return null;
        }
        Object old = node._value;
        this._entrySet.remove(node);
        node._value = null;
        node._key = null;
        return old;
    }

    @Override
    public Set entrySet() {
        return this._umEntrySet;
    }

    @Override
    public int size() {
        return this._entrySet.size();
    }

    @Override
    public boolean isEmpty() {
        return this._entrySet.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            return this._nullEntry != null;
        }
        return this.getEntry(key.toString(), 0, key == null ? 0 : key.toString().length()) != null;
    }

    @Override
    public void clear() {
        this._root = new Node();
        this._nullEntry = null;
        this._nullValue = null;
        this._entrySet.clear();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        HashMap map = new HashMap(this);
        out.writeBoolean(this._ignoreCase);
        out.writeObject(map);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        boolean ic = in.readBoolean();
        HashMap map = (HashMap)in.readObject();
        this.setIgnoreCase(ic);
        this.putAll(map);
    }

    private class NullEntry
    implements Map.Entry {
        private NullEntry() {
        }

        public Object getKey() {
            return null;
        }

        public Object getValue() {
            return StringMap.this._nullValue;
        }

        public Object setValue(Object o2) {
            Object old = StringMap.this._nullValue;
            StringMap.this._nullValue = o2;
            return old;
        }

        public String toString() {
            return "[:null=" + StringMap.this._nullValue + "]";
        }
    }

    private static class Node
    implements Map.Entry {
        char[] _char;
        char[] _ochar;
        Node _next;
        Node[] _children;
        String _key;
        Object _value;

        Node() {
        }

        Node(boolean ignoreCase, String s, int offset) {
            int l2 = s.length() - offset;
            this._char = new char[l2];
            this._ochar = new char[l2];
            for (int i2 = 0; i2 < l2; ++i2) {
                char c2;
                this._char[i2] = c2 = s.charAt(offset + i2);
                if (!ignoreCase) continue;
                char o2 = c2;
                if (Character.isUpperCase(c2)) {
                    o2 = Character.toLowerCase(c2);
                } else if (Character.isLowerCase(c2)) {
                    o2 = Character.toUpperCase(c2);
                }
                this._ochar[i2] = o2;
            }
        }

        Node split(StringMap map, int offset) {
            Node split = new Node();
            int sl = this._char.length - offset;
            char[] tmp = this._char;
            this._char = new char[offset];
            split._char = new char[sl];
            System.arraycopy(tmp, 0, this._char, 0, offset);
            System.arraycopy(tmp, offset, split._char, 0, sl);
            if (this._ochar != null) {
                tmp = this._ochar;
                this._ochar = new char[offset];
                split._ochar = new char[sl];
                System.arraycopy(tmp, 0, this._ochar, 0, offset);
                System.arraycopy(tmp, offset, split._ochar, 0, sl);
            }
            split._key = this._key;
            split._value = this._value;
            this._key = null;
            this._value = null;
            if (map._entrySet.remove(this)) {
                map._entrySet.add(split);
            }
            split._children = this._children;
            this._children = new Node[map._width];
            this._children[split._char[0] % map._width] = split;
            if (split._ochar != null && this._children[split._ochar[0] % map._width] != split) {
                this._children[split._ochar[0] % map._width] = split;
            }
            return split;
        }

        public Object getKey() {
            return this._key;
        }

        public Object getValue() {
            return this._value;
        }

        public Object setValue(Object o2) {
            Object old = this._value;
            this._value = o2;
            return old;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            this.toString(buf);
            return buf.toString();
        }

        private void toString(StringBuilder buf) {
            int i2;
            buf.append("{[");
            if (this._char == null) {
                buf.append('-');
            } else {
                for (i2 = 0; i2 < this._char.length; ++i2) {
                    buf.append(this._char[i2]);
                }
            }
            buf.append(':');
            buf.append(this._key);
            buf.append('=');
            buf.append(this._value);
            buf.append(']');
            if (this._children != null) {
                for (i2 = 0; i2 < this._children.length; ++i2) {
                    buf.append('|');
                    if (this._children[i2] != null) {
                        this._children[i2].toString(buf);
                        continue;
                    }
                    buf.append("-");
                }
            }
            buf.append('}');
            if (this._next != null) {
                buf.append(",\n");
                this._next.toString(buf);
            }
        }
    }
}

