/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class TypeUtil {
    private static final Logger LOG = Log.getLogger(TypeUtil.class);
    public static int CR = 13;
    public static int LF = 10;
    private static final HashMap<String, Class<?>> name2Class = new HashMap();
    private static final HashMap<Class<?>, String> class2Name;
    private static final HashMap<Class<?>, Method> class2Value;

    public static <T> List<T> asList(T[] a2) {
        if (a2 == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(a2);
    }

    public static Class<?> fromName(String name) {
        return name2Class.get(name);
    }

    public static String toName(Class<?> type) {
        return class2Name.get(type);
    }

    public static Object valueOf(Class<?> type, String value) {
        block8: {
            try {
                if (type.equals(String.class)) {
                    return value;
                }
                Method m2 = class2Value.get(type);
                if (m2 != null) {
                    return m2.invoke(null, value);
                }
                if (type.equals(Character.TYPE) || type.equals(Character.class)) {
                    return new Character(value.charAt(0));
                }
                Constructor<?> c2 = type.getConstructor(String.class);
                return c2.newInstance(value);
            }
            catch (NoSuchMethodException e2) {
            }
            catch (IllegalAccessException e3) {
            }
            catch (InstantiationException e4) {
            }
            catch (InvocationTargetException e5) {
                if (!(e5.getTargetException() instanceof Error)) break block8;
                throw (Error)e5.getTargetException();
            }
        }
        return null;
    }

    public static Object valueOf(String type, String value) {
        return TypeUtil.valueOf(TypeUtil.fromName(type), value);
    }

    public static int parseInt(String s, int offset, int length, int base) throws NumberFormatException {
        int value = 0;
        if (length < 0) {
            length = s.length() - offset;
        }
        for (int i2 = 0; i2 < length; ++i2) {
            char c2 = s.charAt(offset + i2);
            int digit = TypeUtil.convertHexDigit(c2);
            if (digit < 0 || digit >= base) {
                throw new NumberFormatException(s.substring(offset, offset + length));
            }
            value = value * base + digit;
        }
        return value;
    }

    public static int parseInt(byte[] b2, int offset, int length, int base) throws NumberFormatException {
        int value = 0;
        if (length < 0) {
            length = b2.length - offset;
        }
        for (int i2 = 0; i2 < length; ++i2) {
            char c2 = (char)(0xFF & b2[offset + i2]);
            int digit = c2 - 48;
            if (!(digit >= 0 && digit < base && digit < 10 || (digit = 10 + c2 - 65) >= 10 && digit < base)) {
                digit = 10 + c2 - 97;
            }
            if (digit < 0 || digit >= base) {
                throw new NumberFormatException(new String(b2, offset, length));
            }
            value = value * base + digit;
        }
        return value;
    }

    public static byte[] parseBytes(String s, int base) {
        byte[] bytes = new byte[s.length() / 2];
        for (int i2 = 0; i2 < s.length(); i2 += 2) {
            bytes[i2 / 2] = (byte)TypeUtil.parseInt(s, i2, 2, base);
        }
        return bytes;
    }

    public static String toString(byte[] bytes, int base) {
        StringBuilder buf = new StringBuilder();
        for (byte b2 : bytes) {
            int bi = 0xFF & b2;
            int c2 = 48 + bi / base % base;
            if (c2 > 57) {
                c2 = 97 + (c2 - 48 - 10);
            }
            buf.append((char)c2);
            c2 = 48 + bi % base;
            if (c2 > 57) {
                c2 = 97 + (c2 - 48 - 10);
            }
            buf.append((char)c2);
        }
        return buf.toString();
    }

    public static byte convertHexDigit(byte c2) {
        byte b2 = (byte)((c2 & 0x1F) + (c2 >> 6) * 25 - 16);
        if (b2 < 0 || b2 > 15) {
            throw new IllegalArgumentException("!hex " + c2);
        }
        return b2;
    }

    public static int convertHexDigit(int c2) {
        int d2 = (c2 & 0x1F) + (c2 >> 6) * 25 - 16;
        if (d2 < 0 || d2 > 15) {
            throw new NumberFormatException("!hex " + c2);
        }
        return d2;
    }

    public static void toHex(byte b2, Appendable buf) {
        try {
            int d2 = 0xF & (0xF0 & b2) >> 4;
            buf.append((char)((d2 > 9 ? 55 : 48) + d2));
            d2 = 0xF & b2;
            buf.append((char)((d2 > 9 ? 55 : 48) + d2));
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    public static void toHex(int value, Appendable buf) throws IOException {
        int d2 = 0xF & (0xF0000000 & value) >> 28;
        buf.append((char)((d2 > 9 ? 55 : 48) + d2));
        d2 = 0xF & (0xF000000 & value) >> 24;
        buf.append((char)((d2 > 9 ? 55 : 48) + d2));
        d2 = 0xF & (0xF00000 & value) >> 20;
        buf.append((char)((d2 > 9 ? 55 : 48) + d2));
        d2 = 0xF & (0xF0000 & value) >> 16;
        buf.append((char)((d2 > 9 ? 55 : 48) + d2));
        d2 = 0xF & (0xF000 & value) >> 12;
        buf.append((char)((d2 > 9 ? 55 : 48) + d2));
        d2 = 0xF & (0xF00 & value) >> 8;
        buf.append((char)((d2 > 9 ? 55 : 48) + d2));
        d2 = 0xF & (0xF0 & value) >> 4;
        buf.append((char)((d2 > 9 ? 55 : 48) + d2));
        d2 = 0xF & value;
        buf.append((char)((d2 > 9 ? 55 : 48) + d2));
        Integer.toString(0, 36);
    }

    public static void toHex(long value, Appendable buf) throws IOException {
        TypeUtil.toHex((int)(value >> 32), buf);
        TypeUtil.toHex((int)value, buf);
    }

    public static String toHexString(byte b2) {
        return TypeUtil.toHexString(new byte[]{b2}, 0, 1);
    }

    public static String toHexString(byte[] b2) {
        return TypeUtil.toHexString(b2, 0, b2.length);
    }

    public static String toHexString(byte[] b2, int offset, int length) {
        StringBuilder buf = new StringBuilder();
        for (int i2 = offset; i2 < offset + length; ++i2) {
            int bi = 0xFF & b2[i2];
            int c2 = 48 + bi / 16 % 16;
            if (c2 > 57) {
                c2 = 65 + (c2 - 48 - 10);
            }
            buf.append((char)c2);
            c2 = 48 + bi % 16;
            if (c2 > 57) {
                c2 = 97 + (c2 - 48 - 10);
            }
            buf.append((char)c2);
        }
        return buf.toString();
    }

    public static byte[] fromHexString(String s) {
        if (s.length() % 2 != 0) {
            throw new IllegalArgumentException(s);
        }
        byte[] array = new byte[s.length() / 2];
        for (int i2 = 0; i2 < array.length; ++i2) {
            int b2 = Integer.parseInt(s.substring(i2 * 2, i2 * 2 + 2), 16);
            array[i2] = (byte)(0xFF & b2);
        }
        return array;
    }

    public static void dump(Class<?> c2) {
        System.err.println("Dump: " + c2);
        TypeUtil.dump(c2.getClassLoader());
    }

    public static void dump(ClassLoader cl) {
        System.err.println("Dump Loaders:");
        while (cl != null) {
            System.err.println("  loader " + cl);
            cl = cl.getParent();
        }
    }

    public static byte[] readLine(InputStream in) throws IOException {
        byte[] old_buf;
        byte[] buf = new byte[256];
        int i2 = 0;
        int loops = 0;
        int ch = 0;
        while ((ch = in.read()) >= 0) {
            if (++loops == 1 && ch == LF) continue;
            if (ch == CR || ch == LF) break;
            if (i2 >= buf.length) {
                old_buf = buf;
                buf = new byte[old_buf.length + 256];
                System.arraycopy(old_buf, 0, buf, 0, old_buf.length);
            }
            buf[i2++] = (byte)ch;
        }
        if (ch == -1 && i2 == 0) {
            return null;
        }
        if (ch == CR && in.available() >= 1 && in.markSupported()) {
            in.mark(1);
            ch = in.read();
            if (ch != LF) {
                in.reset();
            }
        }
        old_buf = buf;
        buf = new byte[i2];
        System.arraycopy(old_buf, 0, buf, 0, i2);
        return buf;
    }

    public static URL jarFor(String className) {
        try {
            className = className.replace('.', '/') + ".class";
            URL url = Loader.getResource(null, className, false);
            String s = url.toString();
            if (s.startsWith("jar:file:")) {
                return new URL(s.substring(4, s.indexOf("!/")));
            }
        }
        catch (Exception e2) {
            LOG.ignore(e2);
        }
        return null;
    }

    public static Object call(Class<?> oClass, String method, Object obj, Object[] arg) throws InvocationTargetException, NoSuchMethodException {
        Method[] methods = oClass.getMethods();
        for (int c2 = 0; methods != null && c2 < methods.length; ++c2) {
            if (!methods[c2].getName().equals(method) || methods[c2].getParameterTypes().length != arg.length || Modifier.isStatic(methods[c2].getModifiers()) != (obj == null) || obj == null && methods[c2].getDeclaringClass() != oClass) continue;
            try {
                return methods[c2].invoke(obj, arg);
            }
            catch (IllegalAccessException e2) {
                LOG.ignore(e2);
                continue;
            }
            catch (IllegalArgumentException e3) {
                LOG.ignore(e3);
            }
        }
        throw new NoSuchMethodException(method);
    }

    static {
        name2Class.put("boolean", Boolean.TYPE);
        name2Class.put("byte", Byte.TYPE);
        name2Class.put("char", Character.TYPE);
        name2Class.put("double", Double.TYPE);
        name2Class.put("float", Float.TYPE);
        name2Class.put("int", Integer.TYPE);
        name2Class.put("long", Long.TYPE);
        name2Class.put("short", Short.TYPE);
        name2Class.put("void", Void.TYPE);
        name2Class.put("java.lang.Boolean.TYPE", Boolean.TYPE);
        name2Class.put("java.lang.Byte.TYPE", Byte.TYPE);
        name2Class.put("java.lang.Character.TYPE", Character.TYPE);
        name2Class.put("java.lang.Double.TYPE", Double.TYPE);
        name2Class.put("java.lang.Float.TYPE", Float.TYPE);
        name2Class.put("java.lang.Integer.TYPE", Integer.TYPE);
        name2Class.put("java.lang.Long.TYPE", Long.TYPE);
        name2Class.put("java.lang.Short.TYPE", Short.TYPE);
        name2Class.put("java.lang.Void.TYPE", Void.TYPE);
        name2Class.put("java.lang.Boolean", Boolean.class);
        name2Class.put("java.lang.Byte", Byte.class);
        name2Class.put("java.lang.Character", Character.class);
        name2Class.put("java.lang.Double", Double.class);
        name2Class.put("java.lang.Float", Float.class);
        name2Class.put("java.lang.Integer", Integer.class);
        name2Class.put("java.lang.Long", Long.class);
        name2Class.put("java.lang.Short", Short.class);
        name2Class.put("Boolean", Boolean.class);
        name2Class.put("Byte", Byte.class);
        name2Class.put("Character", Character.class);
        name2Class.put("Double", Double.class);
        name2Class.put("Float", Float.class);
        name2Class.put("Integer", Integer.class);
        name2Class.put("Long", Long.class);
        name2Class.put("Short", Short.class);
        name2Class.put(null, Void.TYPE);
        name2Class.put("string", String.class);
        name2Class.put("String", String.class);
        name2Class.put("java.lang.String", String.class);
        class2Name = new HashMap();
        class2Name.put(Boolean.TYPE, "boolean");
        class2Name.put(Byte.TYPE, "byte");
        class2Name.put(Character.TYPE, "char");
        class2Name.put(Double.TYPE, "double");
        class2Name.put(Float.TYPE, "float");
        class2Name.put(Integer.TYPE, "int");
        class2Name.put(Long.TYPE, "long");
        class2Name.put(Short.TYPE, "short");
        class2Name.put(Void.TYPE, "void");
        class2Name.put(Boolean.class, "java.lang.Boolean");
        class2Name.put(Byte.class, "java.lang.Byte");
        class2Name.put(Character.class, "java.lang.Character");
        class2Name.put(Double.class, "java.lang.Double");
        class2Name.put(Float.class, "java.lang.Float");
        class2Name.put(Integer.class, "java.lang.Integer");
        class2Name.put(Long.class, "java.lang.Long");
        class2Name.put(Short.class, "java.lang.Short");
        class2Name.put(null, "void");
        class2Name.put(String.class, "java.lang.String");
        class2Value = new HashMap();
        try {
            Class[] s = new Class[]{String.class};
            class2Value.put(Boolean.TYPE, Boolean.class.getMethod("valueOf", s));
            class2Value.put(Byte.TYPE, Byte.class.getMethod("valueOf", s));
            class2Value.put(Double.TYPE, Double.class.getMethod("valueOf", s));
            class2Value.put(Float.TYPE, Float.class.getMethod("valueOf", s));
            class2Value.put(Integer.TYPE, Integer.class.getMethod("valueOf", s));
            class2Value.put(Long.TYPE, Long.class.getMethod("valueOf", s));
            class2Value.put(Short.TYPE, Short.class.getMethod("valueOf", s));
            class2Value.put(Boolean.class, Boolean.class.getMethod("valueOf", s));
            class2Value.put(Byte.class, Byte.class.getMethod("valueOf", s));
            class2Value.put(Double.class, Double.class.getMethod("valueOf", s));
            class2Value.put(Float.class, Float.class.getMethod("valueOf", s));
            class2Value.put(Integer.class, Integer.class.getMethod("valueOf", s));
            class2Value.put(Long.class, Long.class.getMethod("valueOf", s));
            class2Value.put(Short.class, Short.class.getMethod("valueOf", s));
        }
        catch (Exception e2) {
            throw new Error(e2);
        }
    }
}

