/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets;

import com.mathworks.html.HtmlPanel;
import com.mathworks.jmi.MatlabMCR;
import com.mathworks.mlservices.MatlabDesktopServices;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJCheckBox;
import com.mathworks.mwswing.MJDialog;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJTextField;
import com.mathworks.mwswing.MJTextPane;
import com.mathworks.services.Prefs;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.StringUtils;
import com.mathworks.widgets.HyperlinkTextLabel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.SwingUtilities;
import org.apache.commons.lang.SystemUtils;

public class FeedbackDialog
extends MJDialog {
    private MJTextPane fFeedbackField;
    private MJTextField fEmailAddress;
    private static Frame sParentFrame;
    private MJTextField fSubjectLine;
    private static FeedbackDialog sDialog;
    private static final MatlabMCR MATLABMCR;
    private static final String BETA_SHAREPOINT_PAGE = "<a href=\"http://sharepoint/dev/ltc/toolstrip/beta/default.aspx\">Toolstrip Beta SharePoint page</a>";
    private static final String BETA_SHAREPOINT_LINK = "http://sharepoint/dev/ltc/toolstrip/beta/default.aspx";
    private static final String EMAIL_PREF_KEY = "ToolstripBetaEmailAddr";
    private static final String EMAIL_TO = "toolstrip-beta@mathworks.com";
    private static final String DIALOG_TITLE = "Feedback for Toolstrip Internal Beta";
    private static final String DEFAULT_SUBJECT = "Internal Beta Feedback";
    private static final String CHECKBOX_LABEL = "Send snapshot of entire desktop";
    private static final String SUBJECT_LABEL = "Subject Line:";
    private static final String FEEDBACK_LABEL = "Enter feedback about your Desktop and Doc Center usage: ";
    private static final String INFO_PANEL_LABEL = "Information:";
    private static final String EMAIL_LABEL = "Email:";
    private static final String SEND_BUTTON_LABEL = "&Send";
    private static final String CANCEL_BUTTON_LABEL = "Cancel";
    private static final String ERR_BLANK_FEEDBACK = "Please enter your feedback";
    private static final String BLANK_FEEDBACK_LABEL = "Empty feedback field";
    private static final String ERR_BLANK_EMAIL = "Please enter your email address";
    private static final String BLANK_EMAIL_LABEL = "Email address";

    private FeedbackDialog() {
        super((Frame)MatlabDesktopServices.getDesktop().getMainFrame(), DIALOG_TITLE, false);
        sParentFrame = MatlabDesktopServices.getDesktop().getMainFrame();
        MJPanel mJPanel = new MJPanel((LayoutManager)new BorderLayout(0, 0));
        mJPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        MJLabel mJLabel = new MJLabel(SUBJECT_LABEL);
        this.fSubjectLine = new MJTextField(DEFAULT_SUBJECT, 80);
        mJPanel.add((Component)mJLabel, (Object)"North");
        mJPanel.add((Component)this.fSubjectLine, (Object)"South");
        MJPanel mJPanel2 = new MJPanel((LayoutManager)new BorderLayout(0, 0));
        mJPanel2.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        MJLabel mJLabel2 = new MJLabel(FEEDBACK_LABEL);
        this.fFeedbackField = new MJTextPane();
        MJScrollPane mJScrollPane = new MJScrollPane((Component)this.fFeedbackField);
        mJPanel2.add((Component)mJLabel2, (Object)"North");
        mJPanel2.add((Component)mJScrollPane, (Object)"Center");
        MJLabel mJLabel3 = new MJLabel(EMAIL_LABEL);
        String string = Prefs.getStringPref((String)EMAIL_PREF_KEY, (String)"");
        if (string.isEmpty()) {
            string = System.getProperty("user.name");
        }
        int n = 10;
        this.fEmailAddress = new MJTextField(string, n);
        MJLabel mJLabel4 = new MJLabel("@mathworks.com   ");
        HyperlinkTextLabel hyperlinkTextLabel = new HyperlinkTextLabel(BETA_SHAREPOINT_PAGE, new HyperlinkTextLabel.HyperlinkHandler(){

            public void processHyperlink(String string) {
                MJDialog mJDialog = new MJDialog(sParentFrame, "Toolstrip Beta SharePoint page", false);
                HtmlPanel htmlPanel = new HtmlPanel();
                htmlPanel.setCurrentLocation(FeedbackDialog.BETA_SHAREPOINT_LINK);
                mJDialog.add((Component)htmlPanel.getComponent());
                mJDialog.setSize(900, 600);
                mJDialog.setVisible(true);
            }
        }, false, "betaPageLink", "Link to beta SharePoint page.");
        final MJCheckBox mJCheckBox = new MJCheckBox(CHECKBOX_LABEL, true);
        MJPanel mJPanel3 = new MJPanel((LayoutManager)new FlowLayout(0));
        mJPanel3.setBorder(BorderFactory.createEmptyBorder(0, -5, 0, 0));
        mJPanel3.add((Component)mJLabel3);
        mJPanel3.add((Component)this.fEmailAddress);
        mJPanel3.add((Component)mJLabel4);
        mJPanel3.add((Component)hyperlinkTextLabel.getComponent());
        MJPanel mJPanel4 = new MJPanel((LayoutManager)new BorderLayout());
        mJPanel4.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        mJPanel4.add((Component)new MJLabel(INFO_PANEL_LABEL), (Object)"North");
        if (PlatformInfo.isWindows()) {
            mJPanel4.add((Component)mJPanel3, (Object)"Center");
            mJPanel4.add((Component)mJCheckBox, (Object)"South");
        } else {
            mJPanel4.add((Component)mJPanel3, (Object)"South");
        }
        MJButton mJButton = new MJButton(SEND_BUTTON_LABEL);
        mJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (FeedbackDialog.this.fFeedbackField.getText().trim().isEmpty()) {
                    MJOptionPane.showMessageDialog((Component)sParentFrame, (Object)FeedbackDialog.ERR_BLANK_FEEDBACK, (String)FeedbackDialog.BLANK_FEEDBACK_LABEL, (int)2);
                    FeedbackDialog.this.fFeedbackField.setText("");
                    FeedbackDialog.this.fFeedbackField.grabFocus();
                    FeedbackDialog.this.fFeedbackField.requestFocus();
                    return;
                }
                String string = FeedbackDialog.this.fEmailAddress.getText().trim();
                if (string.isEmpty()) {
                    MJOptionPane.showMessageDialog((Component)sParentFrame, (Object)FeedbackDialog.ERR_BLANK_EMAIL, (String)FeedbackDialog.BLANK_EMAIL_LABEL, (int)2);
                    FeedbackDialog.this.fEmailAddress.setText("");
                    FeedbackDialog.this.fEmailAddress.grabFocus();
                    FeedbackDialog.this.fEmailAddress.requestFocus();
                    return;
                }
                Prefs.setStringPref((String)FeedbackDialog.EMAIL_PREF_KEY, (String)string);
                FeedbackDialog.this.hide();
                String string2 = FeedbackDialog.this.fEmailAddress.getText().trim();
                String string3 = FeedbackDialog.this.fSubjectLine.getText().trim();
                String string4 = FeedbackDialog.this.fFeedbackField.getText().trim();
                FeedbackDialog.doSendFeedback(FeedbackDialog.EMAIL_TO, string3, string4, string2, mJCheckBox.isSelected());
            }
        });
        MJButton mJButton2 = new MJButton(CANCEL_BUTTON_LABEL);
        mJButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FeedbackDialog.this.hide();
            }
        });
        MJPanel mJPanel5 = new MJPanel((LayoutManager)new FlowLayout(1));
        mJPanel5.add((Component)mJButton);
        mJPanel5.add((Component)mJButton2);
        MJPanel mJPanel6 = new MJPanel((LayoutManager)new BorderLayout(0, 0));
        mJPanel6.add((Component)mJPanel, (Object)"North");
        mJPanel6.add((Component)mJPanel2, (Object)"Center");
        mJPanel6.add((Component)mJPanel4, (Object)"South");
        MJPanel mJPanel7 = new MJPanel((LayoutManager)new FlowLayout(1));
        mJPanel7.add((Component)mJButton);
        mJPanel7.add((Component)mJButton2);
        MJPanel mJPanel8 = new MJPanel((LayoutManager)new BorderLayout(0, 0));
        mJPanel8.add((Component)mJPanel6, (Object)"Center");
        mJPanel8.add((Component)mJPanel7, (Object)"South");
        this.getContentPane().add((Component)mJPanel8, "Center");
        this.setSize(450, 400);
        this.setResizable(true);
        this.setLocationRelativeTo(sParentFrame);
        this.setCloseOnEscapeEnabled(true);
    }

    public static synchronized FeedbackDialog getInstance() {
        if (sDialog == null) {
            sDialog = new FeedbackDialog();
        }
        if (!sDialog.isVisible()) {
            FeedbackDialog.sDialog.fFeedbackField.setText("");
            FeedbackDialog.sDialog.fSubjectLine.setText(DEFAULT_SUBJECT);
            sDialog.setVisible(true);
        }
        return sDialog;
    }

    public static String adjustedFeedbackForMATLAB(String string) {
        String string2 = "['" + StringUtils.quoteSingleQuotes((String)string) + "']";
        return string2.replaceAll(SystemUtils.LINE_SEPARATOR, "' 10 '");
    }

    private static void doSendFeedback(String string, String string2, String string3, String string4, boolean bl) {
        String string5 = "sendToolstripFeedback('" + StringUtils.quoteSingleQuotes((String)string) + "', " + "'" + StringUtils.quoteSingleQuotes((String)string2) + "', " + FeedbackDialog.adjustedFeedbackForMATLAB(string3) + ", " + "'" + StringUtils.quoteSingleQuotes((String)string4) + "', " + (bl ? "1" : "0") + ")";
        MATLABMCR.evalNoOutput(string5);
    }

    public static String getUniqueFile(String string) {
        File file;
        File file2 = new File(string + File.separatorChar);
        try {
            file = File.createTempFile("beta", "matlab.jpg", file2);
        }
        catch (IOException iOException) {
            return null;
        }
        if (file == null) {
            return null;
        }
        return file.getAbsolutePath();
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FeedbackDialog.getInstance();
            }
        });
    }

    static {
        sDialog = null;
        MATLABMCR = new MatlabMCR("SendFeedbackDialog");
    }
}

