/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.array;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabWorker;
import com.mathworks.jmi.mdt.MatlabCallable;
import com.mathworks.jmi.mdt.MatlabEventQueue;
import com.mathworks.mlservices.MLArrayEditorServices;
import com.mathworks.mlservices.WorkspaceVariable;
import com.mathworks.mlwidgets.array.ArrayUtils;
import com.mathworks.mlwidgets.array.GroupHeaderUI;
import com.mathworks.mlwidgets.array.INewVariableProvider;
import com.mathworks.mlwidgets.array.ObjectIdentifier;
import com.mathworks.mlwidgets.array.RefreshableObjectVariableLiteral;
import com.mathworks.mlwidgets.array.StructArrayDataProxy;
import com.mathworks.mlwidgets.array.StructArrayHeaderRenderer;
import com.mathworks.mlwidgets.array.TabularObjectColumnModel;
import com.mathworks.mlwidgets.array.TabularObjectHeaderRenderer;
import com.mathworks.mlwidgets.array.TabularObjectTable;
import com.mathworks.mlwidgets.array.TabularObjectTableModel;
import com.mathworks.mlwidgets.array.ValueDataSection;
import com.mathworks.mlwidgets.array.VarEditorDataProxy;
import com.mathworks.mlwidgets.array.VarEditorDataProxyAdapter;
import com.mathworks.mlwidgets.array.WorkspaceUndoManager;
import com.mathworks.mlwidgets.workspace.WorkspaceMCRProvider;
import com.mathworks.mlwidgets.workspace.graphics.GraphingActionFactory;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJMenu;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.datatransfer.MJClipboard;
import com.mathworks.util.Log;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.datatransfer.MLDataFlavor;
import com.mathworks.widgets.datatransfer.SimpleVariableDefinition;
import com.mathworks.widgets.spreadsheet.AbstractSpreadsheetTable;
import com.mathworks.widgets.spreadsheet.IHeaderRenderer;
import com.mathworks.widgets.spreadsheet.IReadOnlyData;
import com.mathworks.widgets.spreadsheet.IUndoManagerProvider;
import com.mathworks.widgets.spreadsheet.SpreadsheetUtils;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.swing.Action;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableColumnModel;
import org.jetbrains.annotations.Nullable;

public class StructArrayTable
extends TabularObjectTable {
    private MJMenu fExtractMenu;
    private MJAbstractAction fExtractStructArrayAction;
    private final ExtractSeparateVarsAction fExtractSeparateVarsAction;
    private final ExtractVariableArrayAction fExtractVariableArrayAction;
    private MJAbstractAction fExtractTableAction = null;
    private static final int STRUCT_ARRAY_MAX_PLOT_NUM = 10000;

    public StructArrayTable(TabularObjectTableModel tabularObjectTableModel) {
        this(tabularObjectTableModel, new StructArrayDataProxy());
    }

    public StructArrayTable(TabularObjectTableModel tabularObjectTableModel, VarEditorDataProxy varEditorDataProxy) {
        super(tabularObjectTableModel);
        this.fDataProxy = varEditorDataProxy;
        this.setName("StructArrayVariableTable");
        this.fBorderRenderer = new TabularObjectTable.BorderedCellRenderer(this, this);
        this.fExtractStructArrayAction = new ExtractStructArrayAction();
        this.fExtractStructArrayAction.setComponentName("ExtractStructArray");
        this.fExtractVariableArrayAction = new ExtractVariableArrayAction();
        this.fExtractVariableArrayAction.setComponentName("ExtractMatlabArrays");
        this.fExtractSeparateVarsAction = new ExtractSeparateVarsAction();
        this.fExtractSeparateVarsAction.setComponentName("ExtractSeparateArrays");
        this.fExtractTableAction = new ExtractTableAction();
        this.fExtractTableAction.setComponentName("ExtractTableFromStruct");
        GraphingActionFactory.addGraphingActionListener(this);
        this.setupDeleteActions("structureArray");
        this.updateForSelectionChange(null);
        this.setupTableHeader("StructArrayTableHeader");
        this.setColumnModel(new TabularObjectColumnModel(this.getColumnCount(), this.getVariableName(), this.fDataProxy));
        this.getTableHeader().setUI(new GroupHeaderUI());
        this.setupColumnModelListener();
        this.getInsertAction().setEnabled(false);
        this.setupCellEditorListener();
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
    }

    @Override
    public void adjustVisibleColumnWidths() {
    }

    private static Object[][] removeEmptyRowsFromData(Object[][] objectArray) {
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        for (Object[] objectArray2 : objectArray) {
            boolean bl = false;
            for (Object object : objectArray2) {
                try {
                    String string = (String)object;
                    if (!string.trim().isEmpty()) break;
                    bl = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (bl) continue;
            arrayList.add(objectArray2);
        }
        if (arrayList.size() >= 1) {
            Object[][] objectArray3 = new Object[arrayList.size()][((Object[])arrayList.get(0)).length];
            int n = 0;
            for (Object[] objectArray2 : arrayList) {
                objectArray3[n++] = objectArray2;
            }
            return objectArray3;
        }
        return new Object[0][0];
    }

    protected Object getDataToPaste() {
        MJClipboard mJClipboard = MJClipboard.getMJClipboard();
        try {
            List list;
            SimpleVariableDefinition simpleVariableDefinition;
            if (mJClipboard != null && mJClipboard.isDataFlavorAvailable(MLDataFlavor.simpleVariableListFlavor) && (simpleVariableDefinition = (SimpleVariableDefinition)(list = (List)mJClipboard.getData(MLDataFlavor.simpleVariableListFlavor)).get(0)) instanceof RefreshableObjectVariableLiteral.ObjectVariableDefinition) {
                return ((RefreshableObjectVariableLiteral.ObjectVariableDefinition)simpleVariableDefinition).getObjectIdentifier();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.getDataToPaste();
    }

    protected void doPaste(int n) {
        try {
            Object object = this.getDataToPaste();
            if (object != null) {
                String string;
                boolean bl = false;
                if (object instanceof ObjectIdentifier) {
                    string = ((ObjectIdentifier)((Object)object)).getKey();
                } else {
                    Object[][] objectArray = StructArrayTable.removeEmptyRowsFromData(SpreadsheetUtils.tabbedValuesToArray((String)((String)object)));
                    if (objectArray.length == 1 && PlatformInfo.isXWindows()) {
                        objectArray = StructArrayTable.getTabbedObjIgnoreExc();
                    }
                    bl = true;
                    string = this.storeDataForPaste(objectArray);
                }
                if (string != null) {
                    int n2 = this.getSelectedRow() + 1;
                    int n3 = this.getSelectedColumn() + 1;
                    Cursor cursor = this.getCursor();
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    if (this.getVariable().isDefaultWorkspace()) {
                        String string2 = "internal.matlab.array.StructArrayVariableEditorAdapter.variableEditorPaste(" + this.getVariableName() + ", '" + this.getVariableName() + "', " + n2 + ", " + n3 + ", arrayviewfunc('retrieveValue', '" + string + "'), " + bl + ");";
                        ((TabularObjectTableModel)((Object)this.getModel())).evalMatlabString(string2, false, new CursorResetRunnable(cursor, (Component)((Object)this)));
                    } else {
                        String string3 = "internal.matlab.array.StructArrayVariableEditorAdapter.variableEditorPasteWorkspace(" + this.getVariable().getWorkspaceID() + ", '" + this.getVariableName() + "', " + n2 + ", " + n3 + ", arrayviewfunc('retrieveValue', '" + string + "'), " + bl + ");";
                        WorkspaceMCRProvider.getMCRForUserActions().evalNoOutput(string3);
                        this.setCursor(Cursor.getDefaultCursor());
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.showPasteIncompatibilityMsg();
        }
    }

    @Override
    void doColumnInsert(TabularObjectTableModel.PasteType pasteType) {
        Object object = this.getDataToPaste();
        try {
            String string;
            boolean bl = false;
            if (object instanceof ObjectIdentifier) {
                string = ((ObjectIdentifier)((Object)object)).getKey();
            } else {
                Object[][] objectArray = StructArrayTable.removeEmptyRowsFromData(SpreadsheetUtils.tabbedValuesToArray((String)((String)object)));
                if (objectArray.length == 1 && PlatformInfo.isXWindows()) {
                    objectArray = StructArrayTable.getTabbedObjIgnoreExc();
                }
                bl = true;
                string = this.storeDataForPaste(objectArray);
            }
            if (string != null) {
                int n = this.getSelectedColumn() + 1;
                if (pasteType == TabularObjectTableModel.PasteType.INSERTCOLUMNS_RIGHT) {
                    ++n;
                }
                Cursor cursor = this.getCursor();
                this.setCursor(Cursor.getPredefinedCursor(3));
                if (this.getVariable().isDefaultWorkspace()) {
                    String string2 = "internal.matlab.array.StructArrayVariableEditorAdapter.variableEditorInsert(" + this.getVariableName() + ", '" + this.getVariableName() + "', 'columns', 1, " + n + ", " + "arrayviewfunc('retrieveValue', '" + string + "'), " + bl + ");";
                    ((TabularObjectTableModel)((Object)this.getModel())).evalMatlabString(string2, false, new CursorResetRunnable(cursor, (Component)((Object)this)));
                } else {
                    String string3 = "internal.matlab.array.StructArrayVariableEditorAdapter.variableEditorInsertWorkspace(" + this.getVariable().getWorkspaceID() + ", '" + this.getVariableName() + "', " + "'columns', 1, " + n + ", " + "arrayviewfunc('retrieveValue', '" + string + "'), " + bl + ");";
                    WorkspaceMCRProvider.getMCRForUserActions().evalNoOutput(string3);
                    this.setCursor(Cursor.getDefaultCursor());
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.showPasteIncompatibilityMsg();
        }
    }

    private static Object[][] getTabbedObjIgnoreExc() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Object[][] objectArray = null;
        try {
            Object object;
            if (clipboard.isDataFlavorAvailable(DataFlavor.stringFlavor) && (object = clipboard.getData(DataFlavor.stringFlavor)) != null) {
                objectArray = StructArrayTable.removeEmptyRowsFromData(SpreadsheetUtils.tabbedValuesToArray((String)((String)object)));
            }
        }
        catch (Exception exception) {
            objectArray = new Object[0][0];
        }
        return objectArray;
    }

    @Override
    void doRowInsert(TabularObjectTableModel.PasteType pasteType) {
        try {
            String string;
            Object object = this.getDataToPaste();
            boolean bl = false;
            if (object instanceof ObjectIdentifier) {
                string = ((ObjectIdentifier)((Object)object)).getKey();
            } else {
                Object[][] objectArray = StructArrayTable.removeEmptyRowsFromData(SpreadsheetUtils.tabbedValuesToArray((String)((String)object)));
                if (objectArray.length == 1 && PlatformInfo.isXWindows()) {
                    objectArray = StructArrayTable.getTabbedObjIgnoreExc();
                }
                bl = true;
                string = this.storeDataForPaste(objectArray);
            }
            if (string != null) {
                int n = this.getSelectedRow() + 1;
                if (pasteType == TabularObjectTableModel.PasteType.INSERTROWS_BELOW) {
                    ++n;
                }
                Cursor cursor = this.getCursor();
                this.setCursor(Cursor.getPredefinedCursor(3));
                if (this.getVariable().isDefaultWorkspace()) {
                    String string2 = "internal.matlab.array.StructArrayVariableEditorAdapter.variableEditorInsert(" + this.getVariableName() + ", '" + this.getVariableName() + "', 'rows', " + n + ", 1, arrayviewfunc('retrieveValue', '" + string + "'), " + bl + ");";
                    ((TabularObjectTableModel)((Object)this.getModel())).evalMatlabString(string2, false, new CursorResetRunnable(cursor, (Component)((Object)this)));
                } else {
                    String string3 = "internal.matlab.array.StructArrayVariableEditorAdapter.variableEditorInsertWorkspace(" + this.getVariable().getWorkspaceID() + ", '" + this.getVariableName() + "', " + "'rows', " + n + ", 1, arrayviewfunc('retrieveValue', '" + string + "'), " + bl + ");";
                    WorkspaceMCRProvider.getMCRForUserActions().evalNoOutput(string3);
                    this.setCursor(Cursor.getDefaultCursor());
                }
            }
        }
        catch (Exception exception) {
            this.showPasteIncompatibilityMsg();
        }
    }

    private String storeDataForPaste(Object[][] objectArray) {
        String string = (this.getVariableName() + "_paste").replace('.', '_');
        if (string.contains("{")) {
            string = string.replaceAll("\\{.*\\}", "");
        }
        if (Matlab.isMatlabAvailable()) {
            Object[] objectArray2 = new Object[]{"storeValue", string, objectArray};
            WorkspaceMCRProvider.getMCRForUserActions().fevalNoOutput("arrayviewfunc", objectArray2);
        }
        return string;
    }

    private void showPasteIncompatibilityMsg() {
        this.setCursor(Cursor.getDefaultCursor());
        if (Matlab.isMatlabAvailable()) {
            MJOptionPane.showMessageDialog((Component)MJOptionPane.getFrameForComponent((Component)((Object)this)), (Object)ArrayUtils.getResource("structArray.PasteGeneralIncompatability"), (String)ArrayUtils.getResource("alert.Title"), (int)0);
        }
    }

    public void setColumnModel(TableColumnModel tableColumnModel) {
        super.setColumnModel(tableColumnModel);
        if (tableColumnModel instanceof TabularObjectColumnModel) {
            this.fTabularObjectColumnModel = (TabularObjectColumnModel)tableColumnModel;
            this.fTabularObjectColumnModel.getSelectionModel().addListSelectionListener(this.fLSL);
            if (Matlab.isMatlabAvailable()) {
                this.fTabularObjectColumnModel.updateData();
            }
        }
    }

    public boolean editCellAt(int n, int n2, EventObject eventObject) {
        Object object = this.getValueAt(n, n2);
        if (object instanceof ValueDataSection && ((IReadOnlyData)object).isReadOnly() && eventObject instanceof MouseEvent && ((MouseEvent)eventObject).getClickCount() == 2 && ((InputEvent)eventObject).getModifiers() == 16) {
            int n3 = this.getTabularObjectColumnModel().getGroupIndex(n2);
            String string = this.getTabularObjectColumnModel().getVariableName(n3);
            final String string2 = this.getVariableName() + "(" + (n + 1) + ")." + string;
            Matlab.whenMatlabIdle((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        WorkspaceVariable workspaceVariable = new WorkspaceVariable(string2, StructArrayTable.this.getVariable().getWorkspaceID());
                        if (StructArrayTable.this.getVariable().isDefaultWorkspace()) {
                            MLArrayEditorServices.openVariableLater((WorkspaceVariable)workspaceVariable);
                        } else if (!((TabularObjectTableModel)((Object)StructArrayTable.this.getModel())).openVariable(string2)) {
                            MLArrayEditorServices.openVariableLater((WorkspaceVariable)workspaceVariable);
                        }
                    }
                    catch (Exception exception) {
                        Log.log((String)exception.toString());
                    }
                }
            });
            return false;
        }
        return super.editCellAt(n, n2, eventObject);
    }

    protected void setupContextMenu() {
        this.fSelectionPopupMenu = new MJPopupMenu();
        this.fSelectionPopupMenu.add(this.getCutAction());
        this.fSelectionPopupMenu.add(this.getCopyAction());
        this.fSelectionPopupMenu.add(this.getPasteAction());
        this.fExtractMenu = new MJMenu(ArrayUtils.getResource("dataset.createfromselect"));
        this.fExtractMenu.setName("ExtractParent");
        this.setupInsertActions("structureArray");
        this.fInsertColumnAction.setComponentName("InsertAsNewField");
        this.fInsertColumnRightAction.setComponentName("InsertAsNewFieldRight");
        this.fInsertRowAction.setComponentName("InsertAsNewElement");
        this.fInsertRowBelowAction.setComponentName("InsertAsNewElementBelow");
        this.addContextMenuMouseListener();
    }

    @Override
    protected void updateForSelectionChange(@Nullable String[] stringArray) {
        int n;
        boolean bl = stringArray != null && stringArray.length > 0;
        this.fExtractStructArrayAction.setEnabled(bl);
        this.fExtractVariableArrayAction.setEnabled(bl);
        this.fExtractSeparateVarsAction.setEnabled(bl);
        this.fExtractTableAction.setEnabled(bl);
        if (this.fSelectionPopupMenu == null) {
            return;
        }
        for (n = 0; n < this.fSPItemsAddedCount; ++n) {
            this.fSelectionPopupMenu.remove(this.fSelectionPopupMenu.getComponentCount() - 1);
        }
        this.fSPItemsAddedCount = 0;
        n = this.getSelectedColumnCount();
        int n2 = this.getSelectedRowCount();
        if (n > 0 && n2 > 0) {
            boolean bl2 = this.isAllTabularObjectColumnsSelected();
            boolean bl3 = this.isAllTabularObjectRowsSelected();
            int[] nArray = this.restrictRowColumnSpecToValidRegion(this.getSelectedRows(), 0);
            int[] nArray2 = this.restrictRowColumnSpecToValidRegion(this.getSelectedColumns(), 1);
            this.refreshObjectSpecificPopup(this.fSelectionPopupMenu, bl3, bl2, nArray.length, nArray2.length, stringArray);
        }
    }

    private void refreshObjectSpecificPopup(MJPopupMenu mJPopupMenu, boolean bl, boolean bl2, int n, int n2, String[] stringArray) {
        if (!(!bl2 && !bl || bl2 && bl)) {
            if (bl) {
                mJPopupMenu.add((Action)this.fInsertColumnAction);
                mJPopupMenu.add((Action)this.fInsertColumnRightAction);
            } else {
                mJPopupMenu.add((Action)this.fInsertRowAction);
                mJPopupMenu.add((Action)this.fInsertRowBelowAction);
            }
            this.fSPItemsAddedCount += 2;
            mJPopupMenu.addSeparator();
            ++this.fSPItemsAddedCount;
            if (bl) {
                mJPopupMenu.add((Action)this.fDeleteColumnAction);
                ++this.fSPItemsAddedCount;
            }
            if (!bl) {
                mJPopupMenu.add((Action)this.fDeleteRowAction);
                ++this.fSPItemsAddedCount;
            }
        }
        if (n > 0 && n2 > 0) {
            mJPopupMenu.addSeparator();
            mJPopupMenu.add(this.getClearContentsAction());
            this.fSPItemsAddedCount += 2;
            if (bl && this.isSortEnabled()) {
                mJPopupMenu.addSeparator();
                mJPopupMenu.add((Action)this.fSortAscendingAction);
                mJPopupMenu.add((Action)this.fSortDescendingAction);
                this.fSPItemsAddedCount += 3;
            }
            if (!this.useMinimalMenus()) {
                mJPopupMenu.addSeparator();
                mJPopupMenu.add((JMenuItem)this.fExtractMenu);
                this.fSPItemsAddedCount += 2;
                if (Matlab.isMatlabAvailable() && stringArray != null && stringArray.length > 0) {
                    boolean bl3 = stringArray[0].startsWith("[");
                    this.configureExtractMenu(bl3, n, n2);
                }
            }
        }
    }

    private void configureExtractMenu(Boolean bl, int n, int n2) {
        this.fExtractMenu.removeAll();
        if (n == 1) {
            this.fExtractStructArrayAction.setName(ArrayUtils.getResource("structureArray.newstruct"));
        } else {
            this.fExtractStructArrayAction.setName(ArrayUtils.getResource("structureArray.newstructarray"));
        }
        this.fExtractMenu.add((Action)this.fExtractStructArrayAction);
        if (n2 > 1) {
            TabularObjectColumnModel tabularObjectColumnModel = this.getTabularObjectColumnModel();
            int n3 = tabularObjectColumnModel.getGroupIndex(tabularObjectColumnModel.getSelectionModel().getMinSelectionIndex());
            int n4 = tabularObjectColumnModel.getGroupIndex(tabularObjectColumnModel.getSelectionModel().getMaxSelectionIndex());
            if (n4 >= n3) {
                this.fExtractMenu.add((Action)((Object)this.fExtractSeparateVarsAction));
            }
        }
        this.fExtractVariableArrayAction.setIsNumeric(bl);
        this.fExtractMenu.add((Action)((Object)this.fExtractVariableArrayAction));
        this.fExtractMenu.add((Action)this.fExtractTableAction);
    }

    @Override
    public boolean isSortEnabled() {
        int[] nArray = this.restrictRowColumnSpecToValidRegion(this.getSelectedColumns(), 1);
        if (nArray == null || nArray.length == 0) {
            return false;
        }
        for (int n : nArray) {
            String string = this.getVariableMatlabClass(n);
            if (string != null && (string.equals("double") || string.equals("char") || string.equals("logical"))) continue;
            return false;
        }
        return true;
    }

    private String[] getSelectionExpression(boolean bl) {
        int[] nArray = this.restrictRowColumnSpecToValidRegion(this.getSelectedRows(), 0);
        List<TabularObjectColumnModel.VariableInfo> list = this.getTabularObjectColumnModel().getSelectedVariableInfo(this.getSelectedColumns());
        if (list == null || nArray == null || nArray.length == 0) {
            return null;
        }
        String[] stringArray = new String[list.size()];
        int[] nArray2 = ((TabularObjectTableModel)((Object)this.getModel())).getVariableGridSize();
        char c = bl ? (char)'[' : '{';
        char c2 = bl ? (char)']' : '}';
        String string = StructArrayTable.arrayToMatlabString(nArray, nArray2[0]);
        for (int i = 0; i < list.size(); ++i) {
            String string2 = list.get(i).getVarName();
            stringArray[i] = string.isEmpty() ? c + this.getVariableName() + "." + string2 + c2 : (string.contains(",") ? c + this.getVariableName() + "([" + string + "])." + string2 + c2 : c + this.getVariableName() + "(" + string + ")." + string2 + c2);
        }
        return stringArray;
    }

    @Override
    protected String[] getSelectionVariableStrings() {
        int[] nArray = this.getSelectedRows();
        int[] nArray2 = this.getSelectedColumns();
        if (nArray.length > 0 && nArray2.length > 0) {
            List list = StructArrayTable.getSelectionIntervals((int[])this.restrictRowColumnSpecToValidRegion(nArray, 0));
            List list2 = StructArrayTable.getSelectionIntervals((int[])this.restrictRowColumnSpecToValidRegion(nArray2, 1));
            if (list2.isEmpty() || list.isEmpty()) {
                return null;
            }
            String string = VarEditorDataProxyAdapter.getMatlabIntervalArrayString(list);
            String string2 = VarEditorDataProxyAdapter.getMatlabIntervalArrayString(list2);
            boolean bl = StructArrayTable.synchronousMatlabEval(string, string2, this.getVariableName());
            return this.getSelectionExpression(bl);
        }
        return null;
    }

    private static boolean synchronousMatlabEval(final String string, final String string2, final String string3) {
        if (Matlab.isMatlabAvailable()) {
            Future future = MatlabEventQueue.invoke((MatlabCallable)new MatlabCallable<Boolean>(){

                public void callOnEdt(Boolean bl, boolean bl2) {
                }

                public Boolean call() {
                    boolean bl = false;
                    try {
                        String string4 = "internal.matlab.array.StructArrayVariableEditorAdapter.variableEditorIsScalarNumericSelection(" + string3 + ", " + string + ", " + string2 + ");";
                        boolean[] blArray = (boolean[])Matlab.mtEval((String)string4, (int)1);
                        if (blArray.length == 1) {
                            bl = blArray[0];
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return bl;
                }
            });
            try {
                return (Boolean)future.get(5000L, TimeUnit.MILLISECONDS);
            }
            catch (Exception exception) {
                return false;
            }
        }
        return false;
    }

    protected void doRegionCopy(ActionEvent actionEvent) {
        String[] stringArray = this.getSelectionVariableStrings();
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        String string = StructArrayTable.getFullSelectionVariableStrings(stringArray);
        this.fLastCopyKey = this.getVariableName() + "_copy";
        this.populateClipboardFromIdentifier(new ObjectIdentifier(this.getVariableName(), string, this.fLastCopyKey, this.getVariable().getWorkspaceID()));
    }

    protected void doRegionCut(ActionEvent actionEvent) {
        List list = StructArrayTable.getSelectionIntervals((int[])this.restrictRowColumnSpecToValidRegion(this.getSelectedColumns(), 1));
        List list2 = StructArrayTable.getSelectionIntervals((int[])this.restrictRowColumnSpecToValidRegion(this.getSelectedRows(), 0));
        if (list.isEmpty() || list2.isEmpty()) {
            return;
        }
        this.doRegionCopy(actionEvent);
        if (this.isAllTabularObjectRowsSelected()) {
            MatlabWorker<String> matlabWorker = this.createWorker(this.getVariableName(), StructArrayCutType.DELETE_COLUMN, list);
            matlabWorker.start();
        } else if (this.isAllTabularObjectColumnsSelected()) {
            MatlabWorker<String> matlabWorker = this.createWorker(this.getVariableName(), StructArrayCutType.DELETE_ROW, list2);
            matlabWorker.start();
        }
    }

    private MatlabWorker<String> createWorker(String string, StructArrayCutType structArrayCutType, List<int[]> list) {
        return new MatlabDeleteWorker(string, structArrayCutType, list);
    }

    private static String getFullSelectionVariableStrings(String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder("[ ");
        for (String string : stringArray) {
            stringBuilder.append(string);
            stringBuilder.append(";");
        }
        stringBuilder.append(" ].'");
        return stringBuilder.toString();
    }

    @Override
    public String getSelectionNameString() {
        return null;
    }

    private void createVariables(final INewVariableProvider.CreationParams creationParams) {
        TabularObjectColumnModel tabularObjectColumnModel = this.getTabularObjectColumnModel();
        if (tabularObjectColumnModel == null) {
            return;
        }
        if (this.getSelectedRowCount() == 0 || this.getSelectedColumnCount() == 0) {
            return;
        }
        final ListSelectionModel listSelectionModel = tabularObjectColumnModel.getSelectionModel();
        tabularObjectColumnModel.setSelectionModel(new DefaultListSelectionModel(){

            @Override
            public int getMinSelectionIndex() {
                return listSelectionModel.getMinSelectionIndex();
            }

            @Override
            public int getMaxSelectionIndex() {
                return listSelectionModel.getMaxSelectionIndex();
            }

            @Override
            public boolean isSelectedIndex(int n) {
                return listSelectionModel.isSelectedIndex(n);
            }
        });
        String[] stringArray = this.getSelectedVariableNameArray();
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        tabularObjectColumnModel.setSelectionModel(listSelectionModel);
        Matlab.whenMatlabIdle((Runnable)new Runnable(){

            @Override
            public void run() {
                List list = AbstractSpreadsheetTable.getSelectionIntervals((int[])StructArrayTable.this.restrictRowColumnSpecToValidRegion(StructArrayTable.this.getSelectedRows(), 0));
                List list2 = AbstractSpreadsheetTable.getSelectionIntervals((int[])StructArrayTable.this.restrictRowColumnSpecToValidRegion(StructArrayTable.this.getSelectedColumns(), 1));
                if (list.isEmpty() || list2.isEmpty()) {
                    return;
                }
                WorkspaceUndoManager workspaceUndoManager = (WorkspaceUndoManager)((IUndoManagerProvider)StructArrayTable.this.getModel()).getUndoManager();
                StructArrayTable.this.fDataProxy.createNewVariable(StructArrayTable.this.getVariable(), creationParams, list, list2, workspaceUndoManager);
            }
        });
    }

    @Override
    public Map<INewVariableProvider.CreationParams, MJAbstractAction> getCreationActions() {
        EnumMap<INewVariableProvider.CreationParams, MJAbstractAction> enumMap = new EnumMap<INewVariableProvider.CreationParams, MJAbstractAction>(INewVariableProvider.CreationParams.class);
        enumMap.put(INewVariableProvider.CreationParams.STRUCTURE, this.fExtractStructArrayAction);
        TabularObjectColumnModel tabularObjectColumnModel = this.getTabularObjectColumnModel();
        int n = tabularObjectColumnModel.getGroupIndex(tabularObjectColumnModel.getSelectionModel().getMinSelectionIndex());
        int n2 = tabularObjectColumnModel.getGroupIndex(tabularObjectColumnModel.getSelectionModel().getMaxSelectionIndex());
        if (n2 >= n) {
            enumMap.put(INewVariableProvider.CreationParams.SEPARATE_VARS, this.fExtractSeparateVarsAction);
        }
        if (tabularObjectColumnModel.isNumericSelection()) {
            this.fExtractVariableArrayAction.setName(ArrayUtils.getResource("dataset.newnumeric"));
        } else {
            this.fExtractVariableArrayAction.setName(ArrayUtils.getResource("dataset.newcell"));
        }
        enumMap.put(INewVariableProvider.CreationParams.NUMERIC_ARRAY, this.fExtractVariableArrayAction);
        enumMap.put(INewVariableProvider.CreationParams.TABLE, this.fExtractTableAction);
        return enumMap;
    }

    @Override
    protected void showMetadataPopup(int n) {
    }

    @Override
    public void cleanup() {
        super.cleanup();
        this.fExtractStructArrayAction = null;
    }

    @Override
    public IHeaderRenderer createColumnHeaderRenderer(JTable jTable) {
        this.fHeaderRenderer = new StructArrayHeaderRenderer((TabularObjectTable)((Object)jTable), TabularObjectHeaderRenderer.Alignment.COLUMNS);
        return this.fHeaderRenderer;
    }

    @Override
    public IHeaderRenderer createRowHeaderRenderer(JTable jTable) {
        return new TabularObjectHeaderRenderer(jTable, TabularObjectHeaderRenderer.Alignment.ROWS, false, true);
    }

    protected String getVariableMatlabClass(int n) {
        return this.getTabularObjectColumnModel().getVariableMatlabClass(n);
    }

    @Override
    protected void reexamineEditingActions() {
        super.reexamineEditingActions();
        this.getClearContentsAction().setEnabled(true);
    }

    @Override
    public String[] getGraphableNames() {
        if (this.useMinimalMenus()) {
            return STRINGS;
        }
        int[] nArray = this.restrictRowColumnSpecToValidRegion(this.getSelectedRows(), 0);
        if (nArray.length > 10000) {
            return STRINGS;
        }
        return this.getSelectionVariableStrings();
    }

    @Override
    protected void modifyTableCellRendererComponent(int n, JComponent jComponent) {
        super.modifyTableCellRendererComponent(n, jComponent);
        if (jComponent instanceof JLabel) {
            JLabel jLabel = (JLabel)jComponent;
            String string = this.getVariableMatlabClass(n);
            if (string != null && (string.equals("double") || string.equals("logical"))) {
                jLabel.setHorizontalAlignment(4);
            } else {
                jLabel.setHorizontalAlignment(2);
            }
        }
    }

    private class ExtractSeparateVarsAction
    extends MJAbstractAction {
        ExtractSeparateVarsAction() {
            super(ArrayUtils.getResource("dataset.separatevars"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            StructArrayTable.this.createVariables(INewVariableProvider.CreationParams.SEPARATE_VARS);
        }
    }

    private class ExtractVariableArrayAction
    extends MJAbstractAction {
        private boolean fIsNumeric = true;

        private ExtractVariableArrayAction() {
        }

        void setIsNumeric(boolean bl) {
            this.fIsNumeric = bl;
            if (bl) {
                this.setName(ArrayUtils.getResource("dataset.newnumeric"));
            } else {
                this.setName(ArrayUtils.getResource("dataset.newcell"));
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.fIsNumeric) {
                StructArrayTable.this.createVariables(INewVariableProvider.CreationParams.NUMERIC_ARRAY);
            } else {
                StructArrayTable.this.createVariables(INewVariableProvider.CreationParams.CELL_ARRAY);
            }
        }
    }

    private class ExtractTableAction
    extends MJAbstractAction {
        ExtractTableAction() {
            super(ArrayUtils.getResource("table.newdataset"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            StructArrayTable.this.createVariables(INewVariableProvider.CreationParams.TABLE);
        }
    }

    private class ExtractStructArrayAction
    extends MJAbstractAction {
        ExtractStructArrayAction() {
            super(ArrayUtils.getResource("structureArray.newstructarray"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            StructArrayTable.this.createVariables(INewVariableProvider.CreationParams.STRUCTURE);
        }
    }

    private class MatlabDeleteWorker
    extends MatlabWorker<String> {
        private final String fVariableName;
        private final String fIntervalArrayString;
        private final StructArrayCutType fCutType;

        MatlabDeleteWorker(String string, StructArrayCutType structArrayCutType, List<int[]> list) {
            this.fVariableName = string;
            this.fCutType = structArrayCutType;
            this.fIntervalArrayString = VarEditorDataProxyAdapter.getMatlabIntervalArrayString(list);
        }

        public String runOnMatlabThread() {
            String string = this.fCutType == StructArrayCutType.DELETE_COLUMN ? "variableEditorColumnDeleteCode" : "variableEditorRowDeleteCode";
            String string2 = "internal.matlab.array.StructArrayVariableEditorAdapter." + string + "(" + this.fVariableName + ",'" + this.fVariableName + "'," + this.fIntervalArrayString + ")";
            String string3 = null;
            try {
                string3 = (String)Matlab.mtFeval((String)"eval", (Object[])new Object[]{string2}, (int)1);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return string3;
        }

        public void runOnAWTEventDispatchThread(String string) {
            ((TabularObjectTableModel)((Object)StructArrayTable.this.getModel())).evalMatlabString(string, false);
        }
    }

    private static enum StructArrayCutType {
        DELETE_COLUMN,
        DELETE_ROW;

    }

    private class CursorResetRunnable
    implements Runnable {
        private Cursor fCursor = null;
        private Component fComponent = null;

        CursorResetRunnable(Cursor cursor, Component component) {
            this.fCursor = cursor;
            this.fComponent = component;
        }

        @Override
        public void run() {
            this.fComponent.setCursor(this.fCursor);
        }
    }
}

