/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.array;

import com.mathworks.jmi.Matlab;
import com.mathworks.mlwidgets.array.AbstractTabularObjectTable;
import com.mathworks.mlwidgets.array.ColumnDragWindow;
import com.mathworks.mlwidgets.array.ObjectIdentifier;
import com.mathworks.mlwidgets.array.RefreshableObjectVariableLiteral;
import com.mathworks.mlwidgets.array.TabularObjectColumnModel;
import com.mathworks.mlwidgets.array.TabularObjectHeaderRenderer;
import com.mathworks.mlwidgets.array.TabularObjectTableModel;
import com.mathworks.mlwidgets.array.VarEditorDataProxy;
import com.mathworks.mlwidgets.array.WorkspaceUndoManager;
import com.mathworks.mlwidgets.workspace.WorkspaceMCRProvider;
import com.mathworks.mwswing.datatransfer.MJClipboard;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.datatransfer.MLDataFlavor;
import com.mathworks.widgets.datatransfer.SimpleVariableDefinition;
import com.mathworks.widgets.datatransfer.VariableIdentifier;
import com.mathworks.widgets.spreadsheet.CellLocation;
import com.mathworks.widgets.spreadsheet.IHeaderRenderer;
import com.mathworks.widgets.spreadsheet.IHeaderRendererProvider;
import com.mathworks.widgets.spreadsheet.IUndoManagerProvider;
import com.mathworks.widgets.spreadsheet.SpreadsheetCellBorder;
import com.mathworks.widgets.spreadsheet.SpreadsheetCellRenderer;
import com.mathworks.widgets.spreadsheet.SpreadsheetTable;
import com.mathworks.widgets.spreadsheet.format.FormatIdentifier;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.CellEditor;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;

public abstract class TabularObjectTable
extends AbstractTabularObjectTable
implements IHeaderRendererProvider {
    protected TabularObjectColumnModel fTabularObjectColumnModel;
    protected String fLastCopyKey;
    private TabularObjectMouseAdapter fTabularObjectMouseAdapter = null;
    private boolean fMovingColumns = false;
    private int fMoveColumn = -1;
    private ColumnDragWindow fMoveWindow = null;
    protected BorderedCellRenderer fBorderRenderer = null;
    private final Map<String, Integer> fColumnWidths = new HashMap<String, Integer>();
    protected VarEditorDataProxy fDataProxy;
    private boolean fResizingColumns = false;
    private int fResizeColumn = -1;
    private AWTEventListener fAWTListener = null;

    public TabularObjectTable(TabularObjectTableModel tabularObjectTableModel) {
        super(tabularObjectTableModel);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27 && TabularObjectTable.this.fMovingColumns) {
                    TabularObjectTable.this.cleanupMoveWindow();
                }
            }
        });
    }

    public int[] getSelectedColumns() {
        if (this.fTabularObjectColumnModel != null) {
            return this.fTabularObjectColumnModel.getOrderedSelection();
        }
        return super.getSelectedColumns();
    }

    public void setFormat(FormatIdentifier formatIdentifier) {
        super.setFormat(formatIdentifier);
        this.fBorderRenderer = new BorderedCellRenderer(this);
    }

    public TableCellRenderer getCellRenderer(int n, int n2) {
        return this.fBorderRenderer;
    }

    void restoreWidths() {
        if (this.getColumnModel() instanceof TabularObjectColumnModel) {
            TabularObjectColumnModel tabularObjectColumnModel = (TabularObjectColumnModel)this.getColumnModel();
            tabularObjectColumnModel.restoreWidths(this.fColumnWidths);
        } else {
            int n = this.getColumnModel().getColumnCount();
            for (int i = 0; i < n; ++i) {
                String string;
                Object object = this.getColumnModel().getColumn(i).getHeaderValue();
                if (!(object instanceof TabularObjectHeaderRenderer.NamedHeaderContent) || !this.fColumnWidths.containsKey(string = ((TabularObjectHeaderRenderer.NamedHeaderContent)object).getName())) continue;
                int n2 = this.fColumnWidths.get(string);
                this.getColumnModel().getColumn(i).setPreferredWidth(n2);
            }
        }
    }

    protected void restoreSelection(int[] nArray, int[] nArray2) {
        List list = TabularObjectTable.getSelectionIntervals((int[])nArray);
        for (int[] nArray3 : list) {
            this.addRowSelectionInterval(nArray3[0], nArray3[1]);
        }
        List list2 = TabularObjectTable.getSelectionIntervals((int[])nArray2);
        int n = this.getModel().getColumnCount() < this.getColumnCount() ? this.getModel().getColumnCount() : this.getColumnCount();
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            int[] nArray4 = (int[])iterator.next();
            if (nArray4[0] >= n) continue;
            this.addColumnSelectionInterval(nArray4[0], nArray4[1] < n ? nArray4[1] : n - 1);
        }
        this.restoreWidths();
    }

    @Override
    public void updateData() {
        super.updateData();
        this.fTabularObjectColumnModel.updateData();
        if (!this.fMovingColumns) {
            this.getTableHeader().setCursor(new Cursor(0));
            this.cleanupMoveWindow();
        }
    }

    public TabularObjectColumnModel getTabularObjectColumnModel() {
        return (TabularObjectColumnModel)this.getColumnModel();
    }

    @Override
    void sortAscending() {
        String[] stringArray = this.getSelectedVariableNameArray();
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        ((TabularObjectTableModel)((Object)this.getModel())).sortAscending(stringArray);
    }

    @Override
    void sortDescending() {
        String[] stringArray = this.getSelectedVariableNameArray();
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        ((TabularObjectTableModel)((Object)this.getModel())).sortDescending(stringArray);
    }

    protected void setupTableHeader(String string) {
        JTableHeader jTableHeader = new JTableHeader();
        jTableHeader.setName(string);
        this.setTableHeader(jTableHeader);
        this.fHeaderRenderer = this.createColumnHeaderRenderer((JTable)((Object)this));
        jTableHeader.setDefaultRenderer((TableCellRenderer)this.fHeaderRenderer);
        jTableHeader.setReorderingAllowed(false);
        jTableHeader.setResizingAllowed(false);
        MouseMotionListener[] mouseMotionListenerArray = this.getTableHeader().getMouseMotionListeners();
        MouseMotionListener mouseMotionListener = null;
        if (mouseMotionListenerArray != null) {
            for (MouseMotionListener mouseMotionListener2 : mouseMotionListenerArray) {
                if (!(mouseMotionListener2 instanceof SpreadsheetTable.TableHeaderMouseEventListener)) continue;
                mouseMotionListener = mouseMotionListener2;
                this.getTableHeader().removeMouseMotionListener(mouseMotionListener2);
                break;
            }
        }
        this.fTabularObjectMouseAdapter = new TabularObjectMouseAdapter();
        this.getTableHeader().addMouseListener(this.fTabularObjectMouseAdapter);
        this.getTableHeader().addMouseMotionListener(this.fTabularObjectMouseAdapter);
        if (mouseMotionListener != null) {
            this.getTableHeader().addMouseMotionListener(mouseMotionListener);
        }
    }

    protected void setupColumnModelListener() {
        this.fTabularObjectColumnModel.addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
                if (TabularObjectTable.this.fHeaderRenderer instanceof CellEditor) {
                    ((CellEditor)TabularObjectTable.this.fHeaderRenderer).cancelCellEditing();
                }
            }

            @Override
            public void columnMarginChanged(ChangeEvent changeEvent) {
            }

            @Override
            public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
            }

            @Override
            public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
                if (TabularObjectTable.this.fHeaderRenderer instanceof CellEditor) {
                    ((CellEditor)TabularObjectTable.this.fHeaderRenderer).cancelCellEditing();
                }
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
            }
        });
    }

    protected void setupCellEditorListener() {
        if (this.fHeaderRenderer instanceof CellEditor) {
            ((CellEditor)this.fHeaderRenderer).addCellEditorListener(new CellEditorListener(){

                @Override
                public void editingCanceled(ChangeEvent changeEvent) {
                }

                @Override
                public void editingStopped(ChangeEvent changeEvent) {
                    if (TabularObjectTable.this.fHeaderRenderer == null) {
                        return;
                    }
                    Object object = ((CellEditor)TabularObjectTable.this.fHeaderRenderer).getCellEditorValue();
                    if (object instanceof TabularObjectHeaderRenderer.NamedHeaderContent) {
                        int n = ((TabularObjectHeaderRenderer.NamedHeaderContent)object).getRow() - 1;
                        int n2 = TabularObjectTable.this.getTabularObjectColumnModel().getStartColumn(n);
                        int n3 = -1;
                        String string = TabularObjectTable.this.getTabularObjectColumnModel().getVariableName(n2);
                        if (TabularObjectTable.this.fColumnWidths.containsKey(string)) {
                            n3 = (Integer)TabularObjectTable.this.fColumnWidths.get(string);
                        }
                        if (n2 < 0 || TabularObjectTable.this.getColumnModel().getColumn(n2).getHeaderValue().equals(object)) {
                            return;
                        }
                        String string2 = ((TabularObjectHeaderRenderer.NamedHeaderContent)object).getName();
                        int n4 = ((TabularObjectHeaderRenderer.NamedHeaderContent)object).getRow();
                        TabularObjectTable.this.fDataProxy.renameColumn(TabularObjectTable.this.getVariable(), n4, string2, (WorkspaceUndoManager)((IUndoManagerProvider)TabularObjectTable.this.getModel()).getUndoManager());
                        if (n3 != -1) {
                            TabularObjectTable.this.fColumnWidths.put(string2, n3);
                        }
                        TabularObjectTable.this.getTabularObjectColumnModel().setNamedHeaderContentForColumn(n2, (TabularObjectHeaderRenderer.NamedHeaderContent)object);
                    }
                }
            });
        }
    }

    public void selectEntireColumns() {
        int[] nArray = this.getSelectedColumns();
        if (nArray.length == 0) {
            return;
        }
        int n = this.getRowCount();
        if (n != 0) {
            if (this.isSelectionModeByHeader()) {
                this.setColumnSelectionAllowed(true);
                this.setRowSelectionAllowed(false);
            }
            CellLocation cellLocation = this.getAnchorLocation();
            List list = TabularObjectTable.getSelectionIntervals((int[])nArray);
            for (int[] nArray2 : list) {
                this.addColumnSelectionInterval(nArray2[0], nArray2[1]);
            }
            this.setAnchorLocation(cellLocation);
            this.setRowSelectionInterval(n - 1, 0);
        }
        this.setSelectedRowsFullySelected(false);
        this.setSelectedColumnsFullySelected(true);
    }

    public void selectEntireRows() {
        if (this.getSelectedRowsFullySelected()) {
            return;
        }
        int[] nArray = this.getSelectedRows();
        if (nArray.length == 0) {
            return;
        }
        int n = this.getColumnCount();
        if (n != 0) {
            if (this.isSelectionModeByHeader()) {
                this.setColumnSelectionAllowed(false);
                this.setRowSelectionAllowed(true);
            }
            CellLocation cellLocation = this.getAnchorLocation();
            List list = TabularObjectTable.getSelectionIntervals((int[])nArray);
            for (int[] nArray2 : list) {
                this.addRowSelectionInterval(nArray2[0], nArray2[1]);
            }
            this.setAnchorLocation(cellLocation);
            this.setColumnSelectionInterval(0, n - 1);
        }
        this.setSelectedRowsFullySelected(true);
        this.setSelectedColumnsFullySelected(false);
    }

    public void setHeaderRenderer(int n) {
        if (this.fHeaderRenderer == null) {
            this.fHeaderRenderer = this.createColumnHeaderRenderer((JTable)((Object)this));
        }
        this.tableHeader.setDefaultRenderer((TableCellRenderer)this.fHeaderRenderer);
    }

    @Override
    public void cleanup() {
        this.fTabularObjectMouseAdapter = null;
        this.cleanupMoveWindow();
        String string = this.getVariableName() + "_copy";
        boolean bl = false;
        MJClipboard mJClipboard = MJClipboard.getMJClipboard();
        try {
            List list = (List)mJClipboard.getData(MLDataFlavor.simpleVariableListFlavor);
            SimpleVariableDefinition simpleVariableDefinition = (SimpleVariableDefinition)list.get(0);
            if (simpleVariableDefinition instanceof RefreshableObjectVariableLiteral.ObjectVariableDefinition) {
                bl = string.equals(((RefreshableObjectVariableLiteral.ObjectVariableDefinition)simpleVariableDefinition).getObjectIdentifier().getKey());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (Matlab.isMatlabAvailable() && !bl) {
            WorkspaceMCRProvider.getMCRForUserActions().feval("arrayviewfunc", new Object[]{"clearValueSafely", this.fLastCopyKey}, null);
        }
        super.cleanup();
    }

    protected String[] getSelectedVariableNameArray() {
        List<TabularObjectColumnModel.VariableInfo> list;
        TabularObjectColumnModel tabularObjectColumnModel = this.getTabularObjectColumnModel();
        if (tabularObjectColumnModel != null && (list = this.getTabularObjectColumnModel().getSelectedVariableInfo()) != null) {
            String[] stringArray = new String[list.size()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = list.get(i).getVarName();
            }
            return stringArray;
        }
        return null;
    }

    @Override
    protected void populateClipboardFromIdentifier(VariableIdentifier variableIdentifier) {
        if (variableIdentifier.getVariable() != null || variableIdentifier.getExpression() != null) {
            Cursor cursor = this.getCursor();
            this.setCursor(Cursor.getPredefinedCursor(3));
            RefreshableObjectVariableLiteral.populateClipboardFromObjectIdentifier((ObjectIdentifier)variableIdentifier, (ChangeListener)new SpreadsheetTable.CopyChangeListener((SpreadsheetTable)this, cursor));
        }
    }

    protected void modifyTableCellRendererComponent(int n, JComponent jComponent) {
        String string;
        Border border = jComponent.getBorder();
        if (((TabularObjectHeaderRenderer)((Object)this.getTableHeader().getDefaultRenderer())).getHoverColumn() == n) {
            if (border instanceof SpreadsheetCellBorder) {
                jComponent.setBorder((Border)new SpreadsheetCellBorder(null, Color.BLACK, null, null, null));
            } else {
                jComponent.setBorder(BorderFactory.createMatteBorder(0, 2, 0, 0, Color.BLACK));
            }
        }
        if ((string = this.getTabularObjectColumnModel().getVariableMatlabClass(n)) != null && (string.equals("datetime") || string.equals("duration") || string.equals("calendarDuration")) && jComponent instanceof JLabel) {
            JLabel jLabel = (JLabel)jComponent;
            jLabel.setHorizontalAlignment(4);
        }
    }

    protected void cleanupMoveWindow() {
        if (this.fMoveWindow != null) {
            this.fMoveWindow.setVisible(false);
            this.fMoveWindow.dispose();
            this.fMoveWindow = null;
            this.fMovingColumns = false;
            this.fMoveColumn = -1;
            this.getTableHeader().repaint();
            this.getTableHeader().getTable().requestFocus();
            this.getTableHeader().getTable().requestFocusInWindow();
        }
        if (this.fAWTListener != null) {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this.fAWTListener);
            this.fAWTListener = null;
        }
    }

    public IHeaderRenderer createRowHeaderRenderer(JTable jTable) {
        return new TabularObjectHeaderRenderer(jTable, TabularObjectHeaderRenderer.Alignment.ROWS);
    }

    public IHeaderRenderer createColumnHeaderRenderer(JTable jTable) {
        this.fHeaderRenderer = new TabularObjectHeaderRenderer(jTable, TabularObjectHeaderRenderer.Alignment.COLUMNS);
        return this.fHeaderRenderer;
    }

    int getNumVariableColumns() {
        int[] nArray = ((TabularObjectTableModel)((Object)this.getModel())).getVariableGridSize();
        if (nArray == null || nArray.length < 2) {
            return -1;
        }
        return nArray[1];
    }

    abstract void adjustVisibleColumnWidths();

    protected abstract void showMetadataPopup(int var1);

    private class TabularObjectMouseAdapter
    extends MouseAdapter {
        private TabularObjectMouseAdapter() {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (TabularObjectTable.this.fHeaderRenderer instanceof TabularObjectHeaderRenderer && ((TabularObjectHeaderRenderer)TabularObjectTable.this.fHeaderRenderer).isHeaderEditing()) {
                ((TabularObjectHeaderRenderer)TabularObjectTable.this.fHeaderRenderer).fireEditingStopped();
            }
            if (TabularObjectTable.this.getTableHeader().getTable().isEditing() && TabularObjectTable.this.getTableHeader().getTable().getCellEditor() != null) {
                TabularObjectTable.this.getTableHeader().getTable().getCellEditor().cancelCellEditing();
            }
            super.mouseReleased(mouseEvent);
            Point point = mouseEvent.getPoint();
            int n = TabularObjectTable.this.getTabularObjectColumnModel().getVariableCount();
            TabularObjectTable.this.adjustVisibleColumnWidths();
            int n2 = TabularObjectTable.this.getTableHeader().columnAtPoint(new Point(point.x - 4, point.y));
            int n3 = TabularObjectTable.this.getTabularObjectColumnModel().getColumn(n2).getPreferredWidth();
            if (n2 < n && n2 >= 0) {
                String string = ((TabularObjectHeaderRenderer.NamedHeaderContent)TabularObjectTable.this.getTabularObjectColumnModel().getColumn(n2).getHeaderValue()).getName();
                TabularObjectTable.this.fColumnWidths.remove(string);
                TabularObjectTable.this.fColumnWidths.put(string, n3);
            }
            TabularObjectTable.this.getTableHeader().setCursor(new Cursor(0));
            if (TabularObjectTable.this.fMovingColumns) {
                int n4 = TabularObjectTable.this.getTableHeader().columnAtPoint(point);
                if (n4 < 0) {
                    n4 = 0;
                }
                this.handleMovingColumns(mouseEvent, n4);
            }
            TabularObjectTable.this.fMovingColumns = false;
            TabularObjectTable.this.fMoveColumn = -1;
            TabularObjectTable.this.fResizingColumns = false;
            TabularObjectTable.this.fResizeColumn = -1;
            TabularObjectTable.this.getTabularObjectColumnModel().setTableIsAdjusting(false);
            TabularObjectTable.this.setDragSelectionEnabled(true);
            ((TabularObjectHeaderRenderer)TabularObjectTable.this.fHeaderRenderer).setHoverColumn(-1);
            TabularObjectTable.this.getTableHeader().getTable().repaint();
        }

        private void handleMovingColumns(MouseEvent mouseEvent, int n) {
            int n2 = TabularObjectTable.this.getTabularObjectColumnModel().getVariableCount();
            int[] nArray = TabularObjectTable.this.getTabularObjectColumnModel().getGroupColumnInterval(TabularObjectTable.this.fMoveColumn);
            int n3 = nArray[0];
            int n4 = nArray[1] - 1;
            int n5 = nArray[1] - nArray[0];
            int n6 = TabularObjectTable.this.getTabularObjectColumnModel().getGroupColumnWidth(n);
            int[] nArray2 = TabularObjectTable.this.getTabularObjectColumnModel().getGroupColumnInterval(n);
            int n7 = nArray2[0];
            int n8 = nArray2[1] - 1;
            int n9 = TabularObjectTable.this.getTableHeader().columnAtPoint(new Point(mouseEvent.getX() + n6 / 2, mouseEvent.getY()));
            int n10 = n7;
            if (n8 < n9) {
                n10 = n8 + 1;
            }
            int n11 = n10;
            if (TabularObjectTable.this.fMoveColumn < n10) {
                n11 -= n5;
            }
            if (n11 < 0) {
                n11 = 0;
            }
            if (n11 >= n2) {
                n11 = n2;
            }
            if (n11 != TabularObjectTable.this.fMoveColumn && n2 != 1) {
                int n12 = n3;
                int n13 = 0;
                while (n12 <= n4) {
                    ((TabularObjectColumnModel.TabularObjectColumnSelectionModel)TabularObjectTable.this.getTabularObjectColumnModel().getSelectionModel()).setRealSelectionInterval(n11 + n13, n11 + n13);
                    ++n12;
                    ++n13;
                }
                if (n10 < n3 || n10 > n4) {
                    ((TabularObjectTableModel)((Object)TabularObjectTable.this.getTableHeader().getTable().getModel())).move(TabularObjectTable.this.fMoveColumn, n10);
                    TabularObjectTable.this.getTableHeader().setCursor(ColumnDragWindow.openHandCursor);
                    TabularObjectTable.this.fMoveWindow.setCursor(ColumnDragWindow.openHandCursor);
                } else {
                    TabularObjectTable.this.cleanupMoveWindow();
                    TabularObjectTable.this.getTableHeader().repaint();
                }
            } else {
                TabularObjectTable.this.cleanupMoveWindow();
                TabularObjectTable.this.getTableHeader().repaint();
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            TabularObjectTable.this.getTabularObjectColumnModel().setTableIsAdjusting(true);
            if (TabularObjectTable.this.fHeaderRenderer instanceof TabularObjectHeaderRenderer && ((TabularObjectHeaderRenderer)TabularObjectTable.this.fHeaderRenderer).isHeaderEditing()) {
                ((TabularObjectHeaderRenderer)TabularObjectTable.this.fHeaderRenderer).fireEditingStopped();
            }
            if (TabularObjectTable.this.getTableHeader().getTable().isEditing() && TabularObjectTable.this.getTableHeader().getTable().getCellEditor() != null) {
                TabularObjectTable.this.getTableHeader().getTable().getCellEditor().stopCellEditing();
            }
            if (mouseEvent.getButton() != 1) {
                return;
            }
            Point point = mouseEvent.getPoint();
            int n = TabularObjectTable.this.getTableHeader().columnAtPoint(point);
            Rectangle rectangle = TabularObjectTable.this.getTableHeader().getHeaderRect(n);
            int[] nArray = TabularObjectTable.this.getTabularObjectColumnModel().getGroupColumnInterval(n);
            int n2 = nArray[0];
            int n3 = nArray[1] - 1;
            if (point.x - rectangle.x <= 2 || rectangle.x + rectangle.width - point.x <= 2) {
                TabularObjectTable.this.fResizingColumns = true;
                TabularObjectTable.this.fResizeColumn = n;
                if (point.x - rectangle.x <= 2) {
                    TabularObjectTable.this.fResizeColumn = n - 1;
                }
            } else if (point.x - rectangle.x < ((TabularObjectHeaderRenderer)TabularObjectTable.this.fHeaderRenderer).getGripIconWidth() && n < TabularObjectTable.this.getNumVariableColumns() && n >= 0 && n == n2) {
                TabularObjectTable.this.fMovingColumns = true;
                TabularObjectTable.this.setDragSelectionEnabled(false);
                TabularObjectTable.this.fMoveColumn = n;
                TabularObjectTable.this.fMoveWindow = new ColumnDragWindow(TabularObjectTable.this.getTableHeader().getTable(), n2, n3);
                TabularObjectTable.this.fMoveWindow.setLocation(mouseEvent.getLocationOnScreen());
                this.addTableListener();
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger() || mouseEvent.getButton() != 1) {
                return;
            }
            if (TabularObjectTable.this.fHeaderRenderer instanceof TabularObjectHeaderRenderer) {
                Point point = mouseEvent.getPoint();
                int n = TabularObjectTable.this.getTableHeader().columnAtPoint(point);
                int[] nArray = TabularObjectTable.this.getTabularObjectColumnModel().getGroupColumnInterval(n);
                int n2 = nArray[0];
                int n3 = nArray[1] - 1;
                Rectangle rectangle = TabularObjectTable.this.getTableHeader().getHeaderRect(n2).union(TabularObjectTable.this.getTableHeader().getHeaderRect(n3));
                point.x -= rectangle.x;
                point.y -= rectangle.y;
                if (point.x > (int)rectangle.getWidth() - TabularObjectHeaderRenderer.DropDownPanel.getArrowButtonWidth() && n2 < TabularObjectTable.this.getTabularObjectColumnModel().getVariableColumnCount()) {
                    if (mouseEvent.getClickCount() == 2) {
                        this.autoResize(n2);
                    } else if (mouseEvent.getClickCount() == 1 && TabularObjectTable.this.getCursor().getType() != 13) {
                        TabularObjectTable.this.showMetadataPopup(n2);
                    }
                } else if (mouseEvent.getClickCount() == 2 && point.x < ((TabularObjectHeaderRenderer)TabularObjectTable.this.fHeaderRenderer).getGripIconWidth() && TabularObjectTable.this.getCursor().getType() != 13) {
                    if (n2 > 0) {
                        this.autoResize(n2 - 1);
                    }
                } else if (mouseEvent.getClickCount() == 2 && ((TabularObjectHeaderRenderer)TabularObjectTable.this.fHeaderRenderer).isEditableAtPoint(point, n2, TabularObjectTable.this.fTabularObjectColumnModel.getColumn(n2).getHeaderValue())) {
                    ((TabularObjectHeaderRenderer)TabularObjectTable.this.fHeaderRenderer).editColumnHeaderCellAt((JTable)((Object)TabularObjectTable.this), n2);
                }
            }
        }

        private void autoResize(int n) {
            if (TabularObjectTable.this.getTabularObjectColumnModel().isSpanningColumn(n)) {
                return;
            }
            this.updateColWidth(n);
            TabularObjectTable.this.handleAutoResize(n);
        }

        private void updateColWidth(int n) {
            int n2 = TabularObjectTable.this.getColumnAutoSize(n);
            String string = ((TabularObjectHeaderRenderer.NamedHeaderContent)TabularObjectTable.this.getTabularObjectColumnModel().getColumn(n).getHeaderValue()).getName();
            TabularObjectTable.this.fColumnWidths.remove(string);
            TabularObjectTable.this.fColumnWidths.put(string, n2);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (!TabularObjectTable.this.fMovingColumns) {
                TabularObjectTable.this.getTableHeader().setCursor(new Cursor(0));
            }
            ((TabularObjectHeaderRenderer)TabularObjectTable.this.fHeaderRenderer).setDropArrowColumn(-1);
            TabularObjectTable.this.getTableHeader().repaint();
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            int n = TabularObjectTable.this.getTableHeader().columnAtPoint(point);
            if (n < 0) {
                if (!TabularObjectTable.this.fMovingColumns) {
                    TabularObjectTable.this.getTableHeader().setCursor(new Cursor(0));
                }
                ((TabularObjectHeaderRenderer)TabularObjectTable.this.fHeaderRenderer).setDropArrowColumn(-1);
                TabularObjectTable.this.getTableHeader().repaint();
                return;
            }
            int[] nArray = TabularObjectTable.this.getTabularObjectColumnModel().getGroupColumnInterval(n);
            int n2 = nArray[0];
            int n3 = nArray[1] - 1;
            Rectangle rectangle = TabularObjectTable.this.getTableHeader().getHeaderRect(n2).union(TabularObjectTable.this.getTableHeader().getHeaderRect(n3));
            point.x -= rectangle.x;
            point.y -= rectangle.y;
            if (point.x <= 2 && n > 0 || point.x >= rectangle.width - 2) {
                TabularObjectTable.this.getTableHeader().setCursor(new Cursor(10));
            } else if (point.x > 2 && point.x < ((TabularObjectHeaderRenderer)TabularObjectTable.this.fHeaderRenderer).getGripIconWidth() && n < TabularObjectTable.this.getNumVariableColumns() && !((TabularObjectHeaderRenderer)TabularObjectTable.this.fHeaderRenderer).isHeaderEditing() && !TabularObjectTable.this.getTableHeader().getTable().isEditing()) {
                if (!TabularObjectTable.this.fMovingColumns) {
                    TabularObjectTable.this.getTableHeader().setCursor(ColumnDragWindow.openHandCursor);
                }
            } else if (((TabularObjectHeaderRenderer)TabularObjectTable.this.fHeaderRenderer).isEditableAtPoint(point, n, TabularObjectTable.this.fTabularObjectColumnModel.getColumn(n).getHeaderValue()) && point.x < (int)rectangle.getWidth() - TabularObjectHeaderRenderer.DropDownPanel.getArrowButtonWidth() && n < TabularObjectTable.this.getNumVariableColumns()) {
                TabularObjectTable.this.getTableHeader().setCursor(new Cursor(2));
            } else {
                TabularObjectTable.this.getTableHeader().setCursor(new Cursor(0));
            }
            int n4 = ((TabularObjectHeaderRenderer)TabularObjectTable.this.fHeaderRenderer).getDropArrowColumn();
            if (n4 != nArray[0]) {
                ((TabularObjectHeaderRenderer)TabularObjectTable.this.fHeaderRenderer).setDropArrowColumn(nArray[0]);
                TabularObjectTable.this.getTableHeader().repaint();
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            int n;
            int n2;
            int n3;
            Rectangle rectangle;
            TabularObjectTable.this.getTabularObjectColumnModel().setTableIsAdjusting(true);
            if (TabularObjectTable.this.fHeaderRenderer instanceof TabularObjectHeaderRenderer && ((TabularObjectHeaderRenderer)TabularObjectTable.this.fHeaderRenderer).isHeaderEditing()) {
                ((TabularObjectHeaderRenderer)TabularObjectTable.this.fHeaderRenderer).fireEditingStopped();
            }
            if (TabularObjectTable.this.getTableHeader().getTable().isEditing() && TabularObjectTable.this.getTableHeader().getTable().getCellEditor() != null) {
                TabularObjectTable.this.getTableHeader().getTable().getCellEditor().stopCellEditing();
            }
            if (TabularObjectTable.this.fMovingColumns || TabularObjectTable.this.fResizingColumns) {
                mouseEvent.consume();
            }
            super.mouseDragged(mouseEvent);
            Point point = mouseEvent.getPoint();
            int n4 = TabularObjectTable.this.getTableHeader().columnAtPoint(point);
            if (TabularObjectTable.this.fResizingColumns && TabularObjectTable.this.fResizeColumn != -1) {
                rectangle = TabularObjectTable.this.getCellRect(0, TabularObjectTable.this.fResizeColumn, true);
                n3 = rectangle.x + rectangle.width - point.x;
                TabularObjectTable.this.getColumnModel().getColumn(TabularObjectTable.this.fResizeColumn).setPreferredWidth(rectangle.width - n3);
                TabularObjectTable.this.getColumnModel().getColumn(TabularObjectTable.this.fResizeColumn).setWidth(rectangle.width - n3);
                TabularObjectTable.this.adjustVisibleColumnWidths();
            }
            if (TabularObjectTable.this.fMovingColumns && !(rectangle = TabularObjectTable.this.getVisibleRect()).contains(point) && (n3 = TabularObjectTable.this.getColumnModel().getColumnIndexAtX(point.x)) >= 0) {
                n2 = 1;
                if (TabularObjectTable.this.fMovingColumns) {
                    n = TabularObjectTable.this.getNumVariableColumns();
                    if (n4 < 0 || n4 >= n) {
                        n2 = 0;
                    }
                }
                if (n2 != 0) {
                    Rectangle rectangle2 = TabularObjectTable.this.getCellRect(0, n3, true);
                    TabularObjectTable.this.scrollRectToVisible(rectangle2);
                }
            }
            if (TabularObjectTable.this.fMovingColumns && TabularObjectTable.this.fMoveWindow != null) {
                TabularObjectTable.this.getTableHeader().setCursor(ColumnDragWindow.closedHandCursor);
                int n5 = TabularObjectTable.this.getNumVariableColumns();
                if (n4 >= 0 && n4 < n5) {
                    if (!TabularObjectTable.this.fMoveWindow.isVisible()) {
                        TabularObjectTable.this.fMoveWindow.setVisible(true);
                    }
                    TabularObjectTable.this.fMoveWindow.setLocation(new Point(mouseEvent.getLocationOnScreen().x, TabularObjectTable.this.getTableHeader().getLocationOnScreen().y));
                    int[] nArray = TabularObjectTable.this.getTabularObjectColumnModel().getGroupColumnInterval(TabularObjectTable.this.fMoveColumn);
                    n2 = nArray[0];
                    n = nArray[1] - 1;
                    int n6 = TabularObjectTable.this.getTabularObjectColumnModel().getGroupColumnWidth(n4);
                    int[] nArray2 = TabularObjectTable.this.getTabularObjectColumnModel().getGroupColumnInterval(n4);
                    int n7 = nArray2[0];
                    int n8 = nArray2[1] - 1;
                    int n9 = TabularObjectTable.this.getTableHeader().columnAtPoint(new Point(mouseEvent.getX() + n6 / 2, mouseEvent.getY()));
                    int n10 = n7;
                    if (n8 < n9) {
                        n10 = n8 + 1;
                    }
                    if (n10 < n2 || n10 > n) {
                        if (n10 != n2 && n10 != n + 1) {
                            ((TabularObjectHeaderRenderer)TabularObjectTable.this.fHeaderRenderer).setHoverColumn(n10);
                        }
                    } else {
                        ((TabularObjectHeaderRenderer)TabularObjectTable.this.fHeaderRenderer).setHoverColumn(-1);
                    }
                }
                TabularObjectTable.this.getTableHeader().repaint();
                TabularObjectTable.this.getTableHeader().getTable().repaint();
            }
        }

        private void processColumnMove(MouseEvent mouseEvent) {
            int n = ((TabularObjectHeaderRenderer)TabularObjectTable.this.fHeaderRenderer).getHoverColumn();
            if (n >= 0) {
                this.handleMovingColumns(mouseEvent, n);
            }
            TabularObjectTable.this.cleanupMoveWindow();
            TabularObjectTable.this.getTableHeader().repaint();
            ((TabularObjectHeaderRenderer)TabularObjectTable.this.fHeaderRenderer).setHoverColumn(-1);
            TabularObjectTable.this.getTableHeader().getTable().repaint();
        }

        private void addTableListener() {
            if (PlatformInfo.isMacintosh()) {
                TabularObjectTable.this.fAWTListener = new AWTEventListener(){

                    @Override
                    public void eventDispatched(AWTEvent aWTEvent) {
                        if (TabularObjectTable.this.fMovingColumns && aWTEvent instanceof MouseEvent) {
                            MouseEvent mouseEvent = (MouseEvent)aWTEvent;
                            if (mouseEvent.getID() == 503 && mouseEvent.getButton() == 0) {
                                TabularObjectMouseAdapter.this.processColumnMove(mouseEvent);
                            } else if (mouseEvent.getID() == 502) {
                                TabularObjectMouseAdapter.this.processColumnMove(mouseEvent);
                            }
                        }
                    }
                };
                Toolkit.getDefaultToolkit().addAWTEventListener(TabularObjectTable.this.fAWTListener, 48L);
            }
        }
    }

    public class BorderedCellRenderer
    extends SpreadsheetCellRenderer {
        public BorderedCellRenderer(SpreadsheetTable spreadsheetTable) {
            super(spreadsheetTable.getFormat());
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            TabularObjectTable.this.modifyTableCellRendererComponent(n2, (JComponent)component);
            return component;
        }
    }
}

