/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.array.editors;

import com.mathworks.mlservices.WorkspaceVariable;
import com.mathworks.mlwidgets.array.ArrayUtils;
import com.mathworks.mlwidgets.array.UpdatableData;
import com.mathworks.mlwidgets.array.editors.StructureEditorProvider;
import com.mathworks.mlwidgets.graphics.IPlotPickerDisplayTrigger;
import com.mathworks.mlwidgets.graphics.PlotPickerOpener;
import com.mathworks.mlwidgets.workspace.ActionUtils;
import com.mathworks.mlwidgets.workspace.IWorkspaceActionProvider;
import com.mathworks.mlwidgets.workspace.MatlabClassActionFactory;
import com.mathworks.mlwidgets.workspace.VariableRecordlistModel;
import com.mathworks.mlwidgets.workspace.WorkspaceDnDListener;
import com.mathworks.mlwidgets.workspace.WorkspacePrinter;
import com.mathworks.mlwidgets.workspace.WorkspaceResources;
import com.mathworks.mlwidgets.workspace.WorkspaceSelectionPopupMenu;
import com.mathworks.mlwidgets.workspace.graphics.GraphingActionFactory;
import com.mathworks.mlwidgets.workspace.graphics.IGraphableInfoProvider;
import com.mathworks.mlwidgets.workspace.graphics.IGraphingActionListener;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.util.ArrayUtils;
import com.mathworks.widgets.recordlist.IRecordlistModel;
import com.mathworks.widgets.recordlist.RecordlistTable;
import com.mathworks.widgets.spreadsheet.IClipboardOpProvider;
import com.mathworks.widgets.spreadsheet.IPrintingOpProvider;
import com.mathworks.widgets.spreadsheet.IReadOnlyData;
import com.mathworks.widgets.spreadsheet.IRegionOpProvider;
import com.mathworks.widgets.spreadsheet.ISaveOpProvider;
import com.mathworks.widgets.spreadsheet.format.FormatIdentifier;
import com.mathworks.widgets.spreadsheet.format.Formatter;
import com.mathworks.widgets.text.print.PrintUtils;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;

public class WorkspaceLikeTable
extends RecordlistTable
implements IWorkspaceActionProvider,
IGraphableInfoProvider,
IGraphingActionListener,
UpdatableData,
ISaveOpProvider,
IPrintingOpProvider,
IClipboardOpProvider,
IPlotPickerDisplayTrigger {
    private static final FormatIdentifier DEFAULT_FORMAT_ID = FormatIdentifier.getDefaultInstance();
    private MJAbstractAction fSaveAsAction = null;
    private MJAbstractAction fImportClipboardAction = null;
    private MJAbstractAction fImportFileAction = null;
    private MJAbstractAction fSaveAction = null;
    private MJAbstractAction fPageSetupAction = null;
    private MJAbstractAction fPrintAction = null;
    private MJAbstractAction[] fObjectActions = null;
    private MJAbstractAction fMorePlotsAction = null;
    private DropTargetListener fDropTargetListener = null;
    private final List<ListSelectionListener> fGraphicListener;
    private UpdatableData fUpdatableData = null;
    private final WorkspaceVariable fVariable;
    private static final MJAbstractAction[] EMPTY_ABSTRACT_ACTION = new MJAbstractAction[0];
    private MJAbstractAction fPlotPickerAction = null;
    private final List<PlotPickerOpener> fPlotPickerOpeners = new ArrayList<PlotPickerOpener>();
    private boolean fUseMinimalMenus = false;
    private StructureEditorProvider fProvider;
    private static final String[] ESA = new String[0];

    public WorkspaceLikeTable(IRecordlistModel iRecordlistModel, WorkspaceVariable workspaceVariable, String string) {
        super(iRecordlistModel, string);
        this.setAutoSaveColumnPrefs(true);
        this.fVariable = workspaceVariable;
        this.fGraphicListener = new Vector<ListSelectionListener>();
        ActionUtils.changePreexistingActions(this.fCreationAction, this.fOpeningAction, this.fDeletionAction);
        this.createWorkspaceActions();
        this.setFormat(DEFAULT_FORMAT_ID);
        WorkspaceSelectionPopupMenu workspaceSelectionPopupMenu = new WorkspaceSelectionPopupMenu(this);
        workspaceSelectionPopupMenu.addSeparator();
        this.setSelectionPopupMenu(workspaceSelectionPopupMenu);
        this.fDropTargetListener = new WorkspaceDnDListener((Component)((Object)this), this);
        new DropTarget((Component)((Object)this), new WorkspaceDnDListener((Component)((Object)this), this));
        this.enableDragHandling(true);
        if (iRecordlistModel instanceof UpdatableData) {
            this.fUpdatableData = (UpdatableData)iRecordlistModel;
        }
        GraphingActionFactory.addGraphingActionListener(this);
        this.setName("WorkspaceLikeTable");
        if (iRecordlistModel instanceof VariableRecordlistModel) {
            this.setColumnComparator(((VariableRecordlistModel)iRecordlistModel).SIZE(), new VariableRecordlistModel.SizeStringComparator());
            this.setColumnComparator(((VariableRecordlistModel)iRecordlistModel).NAME(), new Comparator<String>(){

                @Override
                public int compare(String string, String string2) {
                    return string.compareToIgnoreCase(string2);
                }
            });
        }
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        String string = null;
        Point point = mouseEvent.getPoint();
        int n = this.rowAtPoint(point);
        int n2 = this.columnAtPoint(point);
        boolean bl = this.getColumnName(n2).equals(ArrayUtils.getResource("fieldname.value"));
        boolean bl2 = this.getColumnName(n2).equals(ArrayUtils.getResource("fieldname.field"));
        boolean bl3 = this.getColumnName(n2).equals(ArrayUtils.getResource("fieldname.property"));
        if (bl2 || bl || bl3) {
            int[] nArray = new int[]{n};
            String[] stringArray = this.getVariableClasses(nArray);
            String[] stringArray2 = this.getVariableDims(nArray);
            string = stringArray2[0] + " " + stringArray[0];
        }
        return string;
    }

    public void setProvider(StructureEditorProvider structureEditorProvider) {
        this.fProvider = structureEditorProvider;
    }

    private void firePlotPickerRequested() {
        for (PlotPickerOpener plotPickerOpener : this.fPlotPickerOpeners) {
            plotPickerOpener.openPlotPicker();
        }
    }

    public void rename(String string) {
        this.fVariable.setVariableName(string);
    }

    public void setUseMinimalMenus(boolean bl) {
        this.fUseMinimalMenus = bl;
    }

    boolean useMinimalMenus() {
        return this.fUseMinimalMenus;
    }

    public void cleanup() {
        super.cleanup();
        GraphingActionFactory.removeGraphingActionListener(this);
    }

    @Override
    public void addPlotPickerOpener(PlotPickerOpener plotPickerOpener) {
        this.fPlotPickerOpeners.add(plotPickerOpener);
        if (this.fPlotPickerAction == null) {
            this.fPlotPickerAction = new MJAbstractAction(ArrayUtils.getResource("menu.picker")){

                public void actionPerformed(ActionEvent actionEvent) {
                    WorkspaceLikeTable.this.firePlotPickerRequested();
                }
            };
        }
    }

    @Override
    public void removePlotPickerOpener(PlotPickerOpener plotPickerOpener) {
        this.fPlotPickerOpeners.remove(plotPickerOpener);
    }

    private void setValueColumnRenderer(ItTableCellRenderer itTableCellRenderer) {
        try {
            this.getColumn(WorkspaceResources.getBundle().getString("fieldname.value")).setCellRenderer(itTableCellRenderer);
            this.repaint();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void refreshObjectSpecificPopup() {
        MJPopupMenu mJPopupMenu = this.getSelectionPopupMenu();
        if (mJPopupMenu == null || !(mJPopupMenu instanceof WorkspaceSelectionPopupMenu)) {
            return;
        }
        WorkspaceSelectionPopupMenu workspaceSelectionPopupMenu = (WorkspaceSelectionPopupMenu)mJPopupMenu;
        workspaceSelectionPopupMenu.reinitialize(this);
        if (this.fObjectActions != null && this.fObjectActions.length > 0) {
            workspaceSelectionPopupMenu.addSeparator();
            for (MJAbstractAction mJAbstractAction : this.fObjectActions) {
                if (mJAbstractAction.getName().equals("-")) {
                    workspaceSelectionPopupMenu.addSeparator();
                    continue;
                }
                workspaceSelectionPopupMenu.add((Action)mJAbstractAction);
            }
        }
    }

    public void setDefaultAction(MJAbstractAction mJAbstractAction) {
        super.setDefaultAction(mJAbstractAction);
        WorkspaceSelectionPopupMenu workspaceSelectionPopupMenu = new WorkspaceSelectionPopupMenu(this);
        workspaceSelectionPopupMenu.addSeparator();
        this.setSelectionPopupMenu(workspaceSelectionPopupMenu);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        super.valueChanged(listSelectionEvent);
        if (!listSelectionEvent.getValueIsAdjusting()) {
            int[] nArray = this.getSelectedRowsChron();
            this.fObjectActions = MatlabClassActionFactory.getClassActions(this.getVariableNames(nArray), this.getVariableClasses(nArray));
            this.refreshObjectSpecificPopup();
            if (this.fGraphicListener != null) {
                for (ListSelectionListener listSelectionListener : this.fGraphicListener) {
                    listSelectionListener.valueChanged(listSelectionEvent);
                }
            }
        }
    }

    @Override
    public void graphingActionsChanged() {
        for (ListSelectionListener listSelectionListener : this.fGraphicListener) {
            listSelectionListener.valueChanged(new ListSelectionEvent(this, 0, this.getRowCount() - 1, false));
        }
    }

    public MJAbstractAction getAction(int n) {
        MJAbstractAction mJAbstractAction = super.getAction(n);
        if (mJAbstractAction == null) {
            switch (n) {
                case 100: {
                    if (this.useMinimalMenus()) {
                        mJAbstractAction = null;
                        break;
                    }
                    mJAbstractAction = this.fSaveAsAction;
                    break;
                }
                case 200: {
                    mJAbstractAction = this.fImportClipboardAction;
                    break;
                }
                case 110: {
                    mJAbstractAction = this.fImportFileAction;
                    break;
                }
                case 120: {
                    mJAbstractAction = this.fSaveAction;
                    break;
                }
                case 130: {
                    mJAbstractAction = this.fPageSetupAction;
                    break;
                }
                case 140: {
                    mJAbstractAction = this.fPrintAction;
                }
            }
        }
        return mJAbstractAction;
    }

    private String[] getVariableNames(int[] nArray) {
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            if (this.fRLTM.blockCalculation(this.convertRowIndexToUnderlyingModel(nArray[i]))) {
                return ArrayUtils.EmptyObjects.STRING;
            }
            stringArray[i] = this.fVariable.getVariableName() + '.' + this.getModel().getValueAt(nArray[i], this.getPrimaryFieldIndex());
        }
        if (stringArray.length > 0 && stringArray[0] == null) {
            return ArrayUtils.EmptyObjects.STRING;
        }
        return stringArray;
    }

    public MJAbstractAction[] getAdditionalOpeningActions() {
        return EMPTY_ABSTRACT_ACTION;
    }

    private void createWorkspaceActions() {
        WorkspaceTableActionProvider workspaceTableActionProvider = new WorkspaceTableActionProvider();
        this.fSaveAsAction = new ActionUtils.SaveAsAction(workspaceTableActionProvider);
        this.fImportClipboardAction = new ActionUtils.ImportClipboardAction(workspaceTableActionProvider);
        this.fImportFileAction = new ActionUtils.ImportFileAction(workspaceTableActionProvider);
        this.fMorePlotsAction = new ActionUtils.MorePlotsAction(workspaceTableActionProvider);
        this.fSaveAction = ArrayUtils.getSaveAction(this.fVariable.getWorkspaceVariableNameTemp(), workspaceTableActionProvider);
        this.fPrintAction = new ArrayUtils.PrintAction(workspaceTableActionProvider);
        this.fPageSetupAction = new ArrayUtils.PageSetupAction(workspaceTableActionProvider);
    }

    public Action getSaveAction() {
        return this.fSaveAction;
    }

    protected String[] getVariableDims(int[] nArray) {
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            stringArray[i] = (String)this.getModel().getValueAt(nArray[i], 2);
        }
        return stringArray;
    }

    protected String[] getVariableClasses(int[] nArray) {
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            stringArray[i] = (String)this.getModel().getValueAt(nArray[i], 3);
        }
        return stringArray;
    }

    @Override
    public String[] getGraphableNames() {
        if (this.useMinimalMenus()) {
            return ESA;
        }
        return this.getVariableNames(this.getSelectedRowsChron());
    }

    @Override
    public String[] getGraphableClasses() {
        return this.getVariableClasses(this.getSelectedRowsChron());
    }

    @Override
    public Action getPlotPickerAction() {
        return this.fPlotPickerAction;
    }

    @Override
    public String[] getGraphableSizes() {
        return this.getVariableDims(this.getSelectedRowsChron());
    }

    @Override
    public Action getMorePlotsAction() {
        return this.fMorePlotsAction;
    }

    @Override
    public void addGraphableSelectionListener(ListSelectionListener listSelectionListener) {
        this.fGraphicListener.add(listSelectionListener);
    }

    @Override
    public void removeGraphableSelectionListener(ListSelectionListener listSelectionListener) {
        this.fGraphicListener.remove(listSelectionListener);
    }

    @Override
    public void updateData() {
        if (this.fUpdatableData != null) {
            this.fUpdatableData.updateData();
        }
    }

    void setFormat(FormatIdentifier formatIdentifier) {
        this.setValueColumnRenderer(new ItTableCellRenderer(formatIdentifier));
    }

    public Action getPrintAction() {
        return this.fPrintAction;
    }

    public Action getPrintSelectionAction() {
        return null;
    }

    public Action getPageSetupAction() {
        return this.fPageSetupAction;
    }

    public Action getCopyAction() {
        return this.fCopyingAction;
    }

    public Action getCutAction() {
        return null;
    }

    public Action getPasteAction() {
        return null;
    }

    public Action getExcelPasteAction() {
        return null;
    }

    public MJAbstractAction[] getInsertActions() {
        if (this.fProvider != null) {
            MJAbstractAction mJAbstractAction = (MJAbstractAction)this.fProvider.getInsertAction(IRegionOpProvider.Scope.ROWS, 0);
            mJAbstractAction.setName(ArrayUtils.getResource("insert.Title"));
            return new MJAbstractAction[]{mJAbstractAction};
        }
        return null;
    }

    private class WorkspaceTableActionProvider
    implements ActionUtils.ActionProvider,
    ArrayUtils.PrintActionProvider,
    ArrayUtils.SaveActionProvider {
        private WorkspaceTableActionProvider() {
        }

        @Override
        public void registerWithInputAndActionMaps(MJAbstractAction mJAbstractAction) {
            WorkspaceLikeTable.this.registerWithInputAndActionMaps(mJAbstractAction);
        }

        @Override
        public JTable getTable() {
            return WorkspaceLikeTable.this;
        }

        @Override
        public void print() {
            WorkspacePrinter.print(WorkspaceLikeTable.this, ArrayUtils.getResource("printing.pageTitle", WorkspaceLikeTable.this.fVariable.getVariableName()) + "\t" + ArrayUtils.getResource("printing.header.pg") + " ");
        }

        @Override
        public void pageSetup() {
            PrintUtils.showPageSetupDialog((String)ArrayUtils.getResource("printing.pageTitle"));
        }

        @Override
        public void printSelection() {
            assert (false) : "WorkspaceLikeTable does not support print selection-- the action should not be enabled.";
        }

        @Override
        public Component getComponentForDialog() {
            return this.getTable();
        }

        @Override
        public String[] getVariableNamesForSelectedRows() {
            return WorkspaceLikeTable.this.getVariableNames(WorkspaceLikeTable.this.getSelectedRowsChron());
        }
    }

    private static class ItTableCellRenderer
    extends DefaultTableCellRenderer {
        private final Formatter iFormatter;

        ItTableCellRenderer(FormatIdentifier formatIdentifier) {
            this.iFormatter = formatIdentifier.getFormatter();
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Object object2 = object instanceof IReadOnlyData && ((IReadOnlyData)object).isReadOnly() ? object : this.iFormatter.format(object);
            Component component = jTable.getDefaultRenderer(Object.class).getTableCellRendererComponent(jTable, object2, bl, bl2, n, n2);
            if (object instanceof IReadOnlyData && ((IReadOnlyData)object).isReadOnly()) {
                Font font = component.getFont();
                if (!font.isBold()) {
                    component.setFont(font.deriveFont(2));
                } else {
                    component.setFont(font.deriveFont(3));
                }
            }
            return component;
        }
    }
}

