/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.configeditor.plugin;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import com.mathworks.common.icons.FileTypeIcon;
import com.mathworks.mlservices.MLExecuteServices;
import com.mathworks.mlservices.MatlabExecutionErrorHandler;
import com.mathworks.mlwidgets.configeditor.ConfigurationUtils;
import com.mathworks.mlwidgets.configeditor.data.RunConfiguration;
import com.mathworks.mlwidgets.configeditor.plugin.ConfigurationPlugin;
import com.mathworks.mlwidgets.configeditor.plugin.PersistenceUtils;
import com.mathworks.mlwidgets.configeditor.ui.ComponentDetailsEditor;
import com.mathworks.mlwidgets.configeditor.ui.RunConfigurationDetailsEditor;
import com.mathworks.mlwidgets.configeditor.ui.UiSupport;
import com.mathworks.services.Prefs;
import java.awt.Component;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class RunConfigurationPlugin
extends ConfigurationPlugin<RunConfiguration> {
    public RunConfigurationPlugin() {
        super(RunConfiguration.TYPE, ConfigurationUtils.lookup("runConfiguration.name"), 50);
    }

    @Override
    public ConfigurationPlugin.LoadBundle<RunConfiguration> pluginsFirstLoad() {
        return new ConfigurationPlugin.LoadBundle<RunConfiguration>((EventList<RunConfiguration>)new BasicEventList(), new HashMap());
    }

    @Override
    public void doConfigurationAction(RunConfiguration runConfiguration, Component component, @Nullable MatlabExecutionErrorHandler matlabExecutionErrorHandler) {
        if (matlabExecutionErrorHandler == null) {
            MLExecuteServices.executeCommand((String)runConfiguration.getMatlabExpressionToRun());
        } else {
            MLExecuteServices.executeCommand((String)runConfiguration.getMatlabExpressionToRun(), (MatlabExecutionErrorHandler)matlabExecutionErrorHandler);
        }
    }

    public RunConfigurationUiSupport createUISupport() {
        return new RunConfigurationUiSupport();
    }

    public PersistenceSupport createPersistenceSupport() {
        return new PersistenceSupport();
    }

    private static class PersistenceSupport
    extends ConfigurationPlugin.PersistenceSupport<RunConfiguration> {
        private PersistenceSupport() {
            super(new File(Prefs.getPropertyDirectory(), "run_commands.m"));
        }

        @Override
        protected ConfigurationPlugin.LoadBundle<RunConfiguration> retrieve(FileReader fileReader) throws Exception {
            BasicEventList basicEventList = new BasicEventList();
            HashMap<File, RunConfiguration> hashMap = new HashMap<File, RunConfiguration>();
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            PersistenceUtils.readOverFileHeader(bufferedReader);
            while (bufferedReader.ready()) {
                try {
                    Map<PersistenceUtils.Annotation, String> map = PersistenceUtils.readConfigurationHeader(bufferedReader);
                    String string = map.get((Object)PersistenceUtils.Annotation.NAME);
                    File file = new File(map.get((Object)PersistenceUtils.Annotation.ASSOCIATED_FILE));
                    Boolean bl = Boolean.valueOf(map.get((Object)PersistenceUtils.Annotation.MOST_RECENTLY_ACTIONED_ANNOTATION));
                    String string2 = map.get((Object)PersistenceUtils.Annotation.UNIQUE_ID);
                    if (string == null || file == null || bl == null || string2 == null) {
                        throw new Exception("Annotations were missing from the configuration's header.");
                    }
                    String string3 = PersistenceUtils.readInMatlabExpression(bufferedReader);
                    RunConfiguration runConfiguration = new RunConfiguration(string, file, string3, string2);
                    basicEventList.add((Object)runConfiguration);
                    if (!bl.booleanValue()) continue;
                    hashMap.put(file, runConfiguration);
                }
                catch (Exception exception) {
                    PersistenceUtils.readUntilStartOfConfiguration(bufferedReader);
                }
            }
            return new ConfigurationPlugin.LoadBundle<RunConfiguration>((EventList<RunConfiguration>)basicEventList, (Map<File, RunConfiguration>)hashMap);
        }

        @Override
        protected void persist(EventList<RunConfiguration> eventList, Map<File, RunConfiguration> map, FileWriter fileWriter) throws Exception {
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            PersistenceUtils.writePlainCommentAndNewLine(bufferedWriter, ConfigurationUtils.lookup("runConfigurations.storage.file.header"));
            PersistenceUtils.writePlainCommentAndNewLine(bufferedWriter, (Object)((Object)PersistenceUtils.Annotation.VERSION) + " 3");
            PersistenceUtils.writePlainCommentAndNewLine(bufferedWriter, ConfigurationUtils.lookup("run.storage.file.disclaimer.1"));
            PersistenceUtils.writePlainCommentAndNewLine(bufferedWriter, ConfigurationUtils.lookup("run.storage.file.disclaimer.2"));
            PersistenceUtils.writePlainCommentAndNewLine(bufferedWriter, ConfigurationUtils.lookup("run.storage.file.disclaimer.3"));
            bufferedWriter.newLine();
            for (RunConfiguration runConfiguration : eventList) {
                Boolean bl = runConfiguration.equals(map.get(runConfiguration.getAssociatedFile()));
                PersistenceUtils.writeOutRunConfigurationHeader(bufferedWriter, runConfiguration, bl);
                bufferedWriter.newLine();
                bufferedWriter.write(runConfiguration.getMatlabExpression());
                bufferedWriter.newLine();
                bufferedWriter.newLine();
            }
            bufferedWriter.close();
        }
    }

    public static class RunConfigurationUiSupport
    implements UiSupport<RunConfiguration> {
        @Override
        public String getDisplayName(RunConfiguration runConfiguration) {
            return runConfiguration.getName();
        }

        @Override
        public Icon getIcon(RunConfiguration runConfiguration) {
            return FileTypeIcon.RUN_CONFIGURATION.getIcon();
        }

        @Override
        public Font getFont(Font font, RunConfiguration runConfiguration) {
            return font;
        }

        @Override
        public String getActionString() {
            return ConfigurationUtils.lookup("edit.configurations.dynamicMenuitem.run");
        }

        @Override
        public String getActionName() {
            return ConfigurationUtils.lookup("run.button");
        }

        @Override
        public String getIncorrectExtensionErrorMessage() {
            return ConfigurationUtils.lookup("run.language.error");
        }

        @Override
        public String getTooltip(RunConfiguration runConfiguration) {
            return "<html><div style=\"margin: 2px;\"><b>" + ConfigurationUtils.lookup("matlabExpression.tooltip.title") + "</b><br>" + "<div style=\"margin: 3px;\">" + "<pre style=\"margin: 0px;\">" + runConfiguration.getMatlabExpression() + "</pre></div></div></html>";
        }

        @Override
        public ComponentDetailsEditor<RunConfiguration> createEditorComponent() {
            return new RunConfigurationDetailsEditor();
        }

        @Override
        public String getHelpKey() {
            return "desktop_run_config";
        }
    }
}

