/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.extensions.basic;

import com.mathworks.common.icons.FileTypeIcon;
import com.mathworks.jmi.MLFileIconUtils;
import com.mathworks.jmi.Matlab;
import com.mathworks.matlab.api.explorer.CoreFileDecoration;
import com.mathworks.matlab.api.explorer.FileDecorations;
import com.mathworks.matlab.api.explorer.FileDecorators;
import com.mathworks.matlab.api.explorer.FileInfoProvider;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.mlwidgets.explorer.model.editorfs.EditorFileSystem;
import com.mathworks.mlwidgets.explorer.util.MLFileSystemUtils;
import com.mathworks.services.SystemServices;
import com.mathworks.util.DeferrableRetriever;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.util.PlatformInfo;
import java.io.File;
import java.util.Date;
import javax.swing.Icon;

public final class DefaultFileInfoProvider
implements FileInfoProvider {
    private static final Icon sDefaultFolderIcon = Matlab.isMatlabAvailable() ? MLFileIconUtils.getFileIcon((File)new File(new File(Matlab.matlabRoot()), "toolbox"), (boolean)true) : MLFileIconUtils.getFileIcon((File)new File(System.getProperty("user.dir")), (boolean)true);

    public boolean isApplicable(FileSystemEntry fileSystemEntry) {
        return true;
    }

    public void configureDecorations(final FileSystemEntry fileSystemEntry, FileDecorators fileDecorators, final FileDecorations fileDecorations) {
        if (!fileSystemEntry.isFolder()) {
            fileDecorators.setPreliminary(CoreFileDecoration.ICON, (Object)FileTypeIcon.DOCUMENT.getIcon());
        } else {
            fileDecorators.setPreliminary(CoreFileDecoration.ICON, (Object)sDefaultFolderIcon);
        }
        fileDecorators.setPreliminary(CoreFileDecoration.DESCRIPTION, (Object)"");
        fileDecorators.setPreliminary(CoreFileDecoration.TYPE_NAME, (Object)"");
        fileDecorators.set(CoreFileDecoration.ICON, (DeferrableRetriever)new DeferrableRetriever<Icon>(){

            public void run(ParameterRunnable<Icon> parameterRunnable, Runnable runnable) {
                parameterRunnable.run((Object)MLFileIconUtils.getFileIcon((File)fileSystemEntry.getLocation().toFile(), (boolean)fileSystemEntry.isFolder()));
            }
        });
        fileDecorators.set(CoreFileDecoration.OPEN_ICON, (DeferrableRetriever)new DeferrableRetriever<Icon>(){

            public void run(ParameterRunnable<Icon> parameterRunnable, Runnable runnable) {
                if (fileSystemEntry.isFolder() && PlatformInfo.isWindows()) {
                    parameterRunnable.run((Object)MLFileIconUtils.getWindowsOpenIcon((File)fileSystemEntry.getLocation().toFile()));
                } else {
                    fileDecorations.get(CoreFileDecoration.ICON, false, parameterRunnable);
                }
            }
        });
        fileDecorators.set(CoreFileDecoration.TYPE_NAME, (DeferrableRetriever)new DeferrableRetriever<String>(){

            public void run(ParameterRunnable<String> parameterRunnable, Runnable runnable) {
                parameterRunnable.run((Object)MLFileSystemUtils.getDefaultTypeName(fileSystemEntry));
            }
        });
        fileDecorators.set(CoreFileDecoration.IS_DIRTY_FLAG, (DeferrableRetriever)new DeferrableRetriever<Boolean>(){

            public void run(ParameterRunnable<Boolean> parameterRunnable, Runnable runnable) {
                parameterRunnable.run((Object)EditorFileSystem.getInstance().isDirty(fileSystemEntry.getLocation()));
            }
        });
        fileDecorators.set(CoreFileDecoration.DISPLAY_SIZE, (Object)fileSystemEntry.getSize());
        fileDecorators.set(CoreFileDecoration.DISPLAY_DATE, (DeferrableRetriever)new DeferrableRetriever<String>(){

            public void run(ParameterRunnable<String> parameterRunnable, Runnable runnable) {
                parameterRunnable.run((Object)SystemServices.formatDateTime((Date)fileSystemEntry.getDateModified()));
            }
        });
    }
}

