/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.model.table;

import com.mathworks.matlab.api.explorer.CoreFileDecoration;
import com.mathworks.matlab.api.explorer.ExtensionRegistry;
import com.mathworks.matlab.api.explorer.FileList;
import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.mlwidgets.explorer.model.table.RefreshDaemon;
import com.mathworks.mlwidgets.explorer.model.table.UiFileList;
import com.mathworks.mlwidgets.explorer.util.UiFileSystemUtils;
import com.mathworks.util.AsyncReceiver;
import com.mathworks.util.RequestQueue;
import com.mathworks.widgets.grouptable.ExpansionChangeListener;
import com.mathworks.widgets.grouptable.ExpansionContext;
import javax.swing.Icon;

public class FileListExpansionContext
implements ExpansionContext<FileSystemEntry> {
    private final UiFileList fList;
    private final ExtensionRegistry fExtensions;
    private final boolean fIsSearchList;
    private volatile boolean fClosed;

    public FileListExpansionContext(RequestQueue requestQueue, FileList fileList, ExtensionRegistry extensionRegistry, boolean bl, RefreshDaemon refreshDaemon) {
        this.fList = new UiFileList(requestQueue, fileList, !bl, false, refreshDaemon);
        this.fIsSearchList = bl;
        this.fExtensions = extensionRegistry;
    }

    public UiFileList getList() {
        return this.fList;
    }

    public FileSystemEntry getItem() {
        return this.fList.getLocationEntry();
    }

    public FileSystemEntry createChildPlaceholder() {
        FileSystemEntry fileSystemEntry = this.fList.getLocationEntry();
        return new FileSystemEntry(fileSystemEntry.getSystem(), new FileLocation(fileSystemEntry.getLocation(), "_child"), false, false, 0L, 0L, 0L);
    }

    public Icon getOpenIcon(FileSystemEntry fileSystemEntry) {
        Icon icon = (Icon)UiFileSystemUtils.getDecorationSynchronously(this.fList, fileSystemEntry, CoreFileDecoration.OPEN_ICON, false, this.fExtensions);
        if (icon == null) {
            icon = (Icon)UiFileSystemUtils.getDecorationSynchronously(this.fList, fileSystemEntry, CoreFileDecoration.ICON, false, this.fExtensions);
        }
        return icon;
    }

    public boolean hasChildren() {
        return this.fIsSearchList || !this.fList.isEmpty();
    }

    public void getChildrenAsynchronously(AsyncReceiver<FileSystemEntry> asyncReceiver) {
        this.fList.read(asyncReceiver);
    }

    public void addListener(ExpansionChangeListener<FileSystemEntry> expansionChangeListener) {
        this.fList.addListener(expansionChangeListener);
    }

    public void removeListener(ExpansionChangeListener<FileSystemEntry> expansionChangeListener) {
        this.fList.removeListener(expansionChangeListener);
    }

    public void close() {
        this.fClosed = true;
        this.fList.close();
    }

    public boolean isClosed() {
        return this.fClosed;
    }

    public void refresh() {
        this.fList.refresh();
    }

    public String toString() {
        return this.fClosed ? "closed" : "open list: " + this.fList;
    }
}

