/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.widgets.address;

import com.mathworks.common.icons.DocumentIcon;
import com.mathworks.mlwidgets.explorer.widgets.address.PaintingUtils;
import com.mathworks.mwswing.IconUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;

final class AddressBarIcon {
    private static final Icon HIGH_CONTRAST_RIGHT_ARROW = IconUtils.changeIconColor((ImageIcon)DocumentIcon.BLACK_RIGHT_ARROW.getIcon(), (Color)Color.WHITE);
    private static final Icon HIGH_CONTRAST_DOWN_ARROW = IconUtils.changeIconColor((ImageIcon)DocumentIcon.BLACK_DOWN_ARROW.getIcon(), (Color)Color.WHITE);
    private static final Icon HIGH_CONTRAST_LEFT_ARROW = IconUtils.changeIconColor((ImageIcon)DocumentIcon.LEFT_ARROW.getIcon(), (Color)Color.WHITE);
    private static final Icon sPauseIcon;

    private AddressBarIcon() {
    }

    static Icon getLeftArrow() {
        return PaintingUtils.isBlackBackground() ? HIGH_CONTRAST_LEFT_ARROW : DocumentIcon.LEFT_ARROW.getIcon();
    }

    static Icon getRightArrow() {
        return PaintingUtils.isBlackBackground() ? HIGH_CONTRAST_RIGHT_ARROW : DocumentIcon.BLACK_RIGHT_ARROW.getIcon();
    }

    static Icon getDownArrow() {
        return PaintingUtils.isBlackBackground() ? HIGH_CONTRAST_DOWN_ARROW : DocumentIcon.BLACK_DOWN_ARROW.getIcon();
    }

    static Icon getPauseIcon() {
        return sPauseIcon;
    }

    static {
        BufferedImage bufferedImage = new BufferedImage(16, 16, 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setColor(Color.BLACK);
        graphics2D.setStroke(new BasicStroke(1.7f));
        graphics2D.draw(new Line2D.Double(6.0, 4.0, 6.0, bufferedImage.getHeight() - 4));
        graphics2D.draw(new Line2D.Double(bufferedImage.getWidth() - 6, 4.0, bufferedImage.getWidth() - 6, bufferedImage.getHeight() - 4));
        graphics2D.dispose();
        sPauseIcon = new ImageIcon(bufferedImage);
    }
}

