/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.help;

import com.mathworks.help.helpui.DocConfig;
import com.mathworks.helpsearch.SearchConfig;
import com.mathworks.helpsearch.SearchExpressionFilter;
import com.mathworks.helpsearch.reference.ReferenceData;
import com.mathworks.helpsearch.reference.ReferenceDataRetriever;
import com.mathworks.helpsearch.reference.ReferenceRequest;
import com.mathworks.helpsearch.reference.ReferenceRetrievalStrategy;
import com.mathworks.helpsearch.reference.SearchEngineReferenceStrategy;
import com.mathworks.html.Url;
import com.mathworks.mlwidgets.help.DocCenterDocConfig;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public class DocCenterReferenceRetrievalStrategy
implements ReferenceRetrievalStrategy {
    private final ReferenceRetrievalStrategy fRealStrategy;

    private DocCenterReferenceRetrievalStrategy(ReferenceRetrievalStrategy referenceRetrievalStrategy) {
        this.fRealStrategy = referenceRetrievalStrategy;
    }

    public static DocCenterReferenceRetrievalStrategy getInstance() {
        DocCenterDocConfig<Url> docCenterDocConfig = DocCenterDocConfig.getInstance();
        return DocCenterReferenceRetrievalStrategy.getInstance(docCenterDocConfig);
    }

    public static DocCenterReferenceRetrievalStrategy getInstance(DocConfig docConfig) {
        EmptyReferenceRetrievalStrategy emptyReferenceRetrievalStrategy = DocCenterReferenceRetrievalStrategy.isDocConfigValid((DocConfig<? extends Url>)docConfig) ? new SearchEngineReferenceStrategy(docConfig.getSearchConfig(), docConfig.getDocumentationSet(), (SearchExpressionFilter)docConfig.getProductFilter()) : new EmptyReferenceRetrievalStrategy();
        return new DocCenterReferenceRetrievalStrategy(emptyReferenceRetrievalStrategy);
    }

    public static ReferenceDataRetriever createDataRetriever() {
        return new ReferenceDataRetriever((ReferenceRetrievalStrategy)DocCenterReferenceRetrievalStrategy.getInstance());
    }

    public static ReferenceDataRetriever createDataRetriever(DocConfig docConfig) {
        return new ReferenceDataRetriever((ReferenceRetrievalStrategy)DocCenterReferenceRetrievalStrategy.getInstance(docConfig));
    }

    public List<ReferenceData> getReferenceData(ReferenceRequest referenceRequest) {
        return this.fRealStrategy.getReferenceData(referenceRequest);
    }

    public void close() throws IOException {
        this.fRealStrategy.close();
    }

    private static boolean isDocConfigValid(DocConfig<? extends Url> docConfig) {
        if (docConfig.getDocumentationSet() == null) {
            return false;
        }
        SearchConfig searchConfig = docConfig.getSearchConfig();
        return searchConfig != null;
    }

    private static class EmptyReferenceRetrievalStrategy
    implements ReferenceRetrievalStrategy {
        private EmptyReferenceRetrievalStrategy() {
        }

        public List<ReferenceData> getReferenceData(ReferenceRequest referenceRequest) {
            return Collections.emptyList();
        }

        public void close() throws IOException {
        }
    }
}

